/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.math.spectra.wavelet;

import io.fair_acc.math.spectra.wavelet.WaveletCoefficients;

public class WaveletTransform
extends WaveletCoefficients {
    private final WaveletCoefficients.Wavelet fwavelet = WaveletCoefficients.Wavelet.Daubechies2;
    protected final double sqrt_3 = Math.sqrt(3.0);
    protected final double denom = 4.0 * Math.sqrt(2.0);
    protected final double h0 = (1.0 + this.sqrt_3) / this.denom;
    protected final double h1 = (3.0 + this.sqrt_3) / this.denom;
    protected final double h2 = (3.0 - this.sqrt_3) / this.denom;
    protected final double h3;
    protected final double g0 = this.h3 = (1.0 - this.sqrt_3) / this.denom;
    protected final double g1 = -this.h2;
    protected final double g2 = this.h1;
    protected final double g3 = -this.h0;
    protected final double Ih0 = this.h2;
    protected final double Ih1 = this.g2;
    protected final double Ih2 = this.h0;
    protected final double Ih3 = this.g0;
    protected final double Ig0 = this.h3;
    protected final double Ig1 = this.g3;
    protected final double Ig2 = this.h1;
    protected final double Ig3 = this.g1;

    int allocating_downsampling_convolution(double[] dArray, int n2, double[] dArray2, int n3, double[] dArray3, int n4, WaveletCoefficients.MODE mODE) {
        int n5;
        int n6;
        int n7;
        double[] dArray4;
        int n8;
        int n9 = 0;
        int n10 = n3 - 1;
        int n11 = n10 + n4 - 1;
        if (mODE != WaveletCoefficients.MODE.MODE_PERIODIZATION) {
            var11_11 = n2 + 2 * n10;
            n8 = n2 + n10;
            dArray4 = new double[var11_11];
            System.arraycopy(dArray, n10, dArray4, 0, n2);
            n7 = var11_11;
        } else {
            var11_11 = n2 + n3 - 1;
            n8 = n2 - 1 + n3 / 2;
            dArray4 = new double[var11_11];
            System.arraycopy(dArray, n3 / 2 - 1, dArray4, 0, n2);
            --n11;
            n7 = n4 == 1 ? var11_11 - 1 : var11_11;
        }
        switch (mODE) {
            case MODE_PERIODIZATION: {
                if (n2 % 2 > 0) {
                    dArray4[n8] = dArray[n2 - 1];
                    for (n6 = 1; n6 < n3 / 2; ++n6) {
                        dArray4[n8 + n6] = dArray4[n3 / 2 - 2 + n6];
                    }
                    for (n6 = 0; n6 < n3 / 2 - 1; ++n6) {
                        dArray4[n3 / 2 - 2 - n6] = dArray4[n8 - n6];
                    }
                } else {
                    for (n6 = 0; n6 < n3 / 2; ++n6) {
                        dArray4[n8 + n6] = dArray[n6 % n2];
                    }
                    for (n6 = 0; n6 < n3 / 2 - 1; ++n6) {
                        dArray4[n3 / 2 - 2 - n6] = dArray4[n8 - 1 - n6];
                    }
                }
                break;
            }
            case MODE_SYMMETRIC: {
                for (n6 = 0; n6 < n2; ++n6) {
                    dArray4[n10 - 1 - n6] = dArray[n6 % n2];
                    dArray4[n8 + n6] = dArray[n2 - 1 - n6 % n2];
                }
                n5 = n6;
                while (n6 < n10) {
                    dArray4[n10 - 1 - n6] = dArray4[n8 - 1 + n5 - n6];
                    dArray4[n8 + n6] = dArray4[n10 + n6 - n5];
                    ++n6;
                }
                break;
            }
            case MODE_ASYMMETRIC: {
                for (n6 = 0; n6 < n2; ++n6) {
                    dArray4[n10 - 1 - n6] = dArray[0] - dArray[n6 % n2];
                    dArray4[n8 + n6] = dArray[n2 - 1] - dArray[n2 - 1 - n6 % n2];
                }
                n5 = n6;
                while (n6 < n10) {
                    dArray4[n10 - 1 - n6] = dArray4[n8 - 1 + n5 - n6];
                    dArray4[n8 + n6] = dArray4[n10 + n6 - n5];
                    ++n6;
                }
                break;
            }
            case MODE_SMOOTH: {
                if (n2 > 1) {
                    double d2 = dArray[0] - dArray[1];
                    for (n6 = 0; n6 < n10; ++n6) {
                        dArray4[n6] = dArray[0] + d2 * (double)(n10 - n6);
                    }
                    d2 = dArray[n2 - 1] - dArray[n2 - 2];
                    for (n6 = 0; n6 < n10; ++n6) {
                        dArray4[n8 + n6] = dArray[n2 - 1] + d2 * (double)n6;
                    }
                    break;
                }
            }
            case MODE_CONSTANT_EDGE: {
                for (n6 = 0; n6 < n10; ++n6) {
                    dArray4[n6] = dArray[0];
                    dArray4[n8 + n6] = dArray[n2 - 1];
                }
                break;
            }
            case MODE_PERIODIC: {
                for (n6 = 0; n6 < n10; ++n6) {
                    dArray4[n8 + n6] = dArray[n6 % n2];
                }
                for (n6 = 0; n6 < n10; ++n6) {
                    dArray4[n10 - 1 - n6] = dArray4[n8 - 1 - n6];
                }
                break;
            }
        }
        for (n5 = n11; n5 < n7; n5 += n4) {
            double d3 = 0.0;
            for (n6 = 0; n6 < n3; ++n6) {
                d3 += dArray4[n5 - n6] * dArray2[n6];
            }
            dArray3[n9++] = d3;
        }
        return 0;
    }

    int d_dec_a(double[] dArray, int n2, WaveletCoefficients.Wavelet wavelet, double[] dArray2, int n3, WaveletCoefficients.MODE mODE) {
        if (n3 != this.dwt_buffer_length(n2, wavelet.getDecompHP().length, mODE)) {
            return -1;
        }
        return this.downsampling_convolution(dArray, n2, wavelet.getDecompLP(), wavelet.getDecompLP().length, dArray2, 2, mODE);
    }

    int d_dec_d(double[] dArray, int n2, WaveletCoefficients.Wavelet wavelet, double[] dArray2, int n3, WaveletCoefficients.MODE mODE) {
        if (n3 != this.dwt_buffer_length(n2, wavelet.getDecompHP().length, mODE)) {
            return -1;
        }
        return this.downsampling_convolution(dArray, n2, wavelet.getDecompHP(), wavelet.getDecompHP().length, dArray2, 2, mODE);
    }

    int d_idwt(double[] dArray, int n2, double[] dArray2, int n3, WaveletCoefficients.Wavelet wavelet, double[] dArray3, int n4, WaveletCoefficients.MODE mODE, int n5) {
        int n6;
        if (dArray != null && dArray2 != null) {
            if (n5 > 0) {
                if ((n2 > n3 ? n2 - n3 : n3 - n2) > 1) {
                    return -1;
                }
                n6 = n2 > n3 ? n3 : n2;
            } else {
                if (n2 != n3) {
                    return -1;
                }
                n6 = n2;
            }
        } else if (dArray != null) {
            n6 = n2;
        } else if (dArray2 != null) {
            n6 = n3;
        } else {
            return -1;
        }
        if (n4 != this.idwt_buffer_length(n6, wavelet.getReconLP().length, mODE)) {
            return -1;
        }
        if (dArray != null && this.upsampling_convolution_valid_sf(dArray, n6, wavelet.getReconLP(), wavelet.getReconLP().length, dArray3, n4, mODE) < 0) {
            return -1;
        }
        if (dArray2 != null && this.upsampling_convolution_valid_sf(dArray2, n6, wavelet.getReconHP(), wavelet.getReconHP().length, dArray3, n4, mODE) < 0) {
            return -1;
        }
        return 0;
    }

    int d_rec_a(double[] dArray, int n2, WaveletCoefficients.Wavelet wavelet, double[] dArray2, int n3) {
        if (n3 != this.reconstruction_buffer_length(n2, wavelet.getReconLP().length)) {
            return -1;
        }
        return this.upsampling_convolution_full(dArray, n2, wavelet.getReconLP(), wavelet.getReconLP().length, dArray2, n3);
    }

    int d_rec_d(double[] dArray, int n2, WaveletCoefficients.Wavelet wavelet, double[] dArray2, int n3) {
        if (n3 != this.reconstruction_buffer_length(n2, wavelet.getReconHP().length)) {
            return -1;
        }
        return this.upsampling_convolution_full(dArray, n2, wavelet.getReconHP(), wavelet.getReconHP().length, dArray2, n3);
    }

    int d_swt_(double[] dArray, int n2, double[] dArray2, int n3, double[] dArray3, int n4, int n5) {
        if (n5 < 1) {
            return -1;
        }
        if (n5 > this.swt_max_level(n2)) {
            return -2;
        }
        if (n4 != this.swt_buffer_length(n2)) {
            return -1;
        }
        if (n5 > 1) {
            int n6;
            int n7 = n3 << n5 - 1;
            if (n7 <= 0) {
                return -1;
            }
            double[] dArray4 = new double[n7];
            for (n6 = 0; n6 < n3; ++n6) {
                dArray4[n6 << n5 - 1] = dArray2[n6];
            }
            n6 = this.downsampling_convolution(dArray, n2, dArray4, n7, dArray3, 1, WaveletCoefficients.MODE.MODE_PERIODIZATION);
            return n6;
        }
        return this.downsampling_convolution(dArray, n2, dArray2, n3, dArray3, 1, WaveletCoefficients.MODE.MODE_PERIODIZATION);
    }

    int d_swt_a(double[] dArray, int n2, WaveletCoefficients.Wavelet wavelet, double[] dArray2, int n3, int n4) {
        return this.d_swt_(dArray, n2, wavelet.getDecompLP(), wavelet.getDecompLP().length, dArray2, n3, n4);
    }

    int d_swt_d(double[] dArray, int n2, WaveletCoefficients.Wavelet wavelet, double[] dArray2, int n3, int n4) {
        return this.d_swt_(dArray, n2, wavelet.getDecompHP(), wavelet.getDecompHP().length, dArray2, n3, n4);
    }

    public void daubTrans(double[] dArray) {
        int n2;
        for (int i2 = n2 = dArray.length; i2 >= this.fwavelet.getLength(); i2 >>= 1) {
            this.transform(dArray, i2);
        }
    }

    int downsampling_convolution(double[] dArray, int n2, double[] dArray2, int n3, double[] dArray3, int n4, WaveletCoefficients.MODE mODE) {
        int n5;
        int n6 = 0;
        int n7 = n5 = n4 - 1;
        if (n3 <= n2) {
            double d2;
            int n8;
            int n9;
            double d3;
            switch (mODE) {
                case MODE_SYMMETRIC: {
                    for (n7 = n5; n7 < n3; n7 += n4) {
                        d3 = 0.0;
                        for (n9 = 0; n9 <= n7; ++n9) {
                            d3 += dArray2[n9] * dArray[n7 - n9];
                        }
                        n8 = n7 + 1;
                        for (n9 = n7 + 1; n9 < n3; ++n9) {
                            d3 += dArray2[n9] * dArray[n9 - n8];
                        }
                        dArray3[n6++] = d3;
                    }
                    break;
                }
                case MODE_ASYMMETRIC: {
                    for (n7 = n5; n7 < n3; n7 += n4) {
                        d3 = 0.0;
                        for (n9 = 0; n9 <= n7; ++n9) {
                            d3 += dArray2[n9] * dArray[n7 - n9];
                        }
                        n8 = n7 + 1;
                        for (n9 = n7 + 1; n9 < n3; ++n9) {
                            d3 += dArray2[n9] * (dArray[0] - dArray[n9 - n8]);
                        }
                        dArray3[n6++] = d3;
                    }
                    break;
                }
                case MODE_CONSTANT_EDGE: {
                    for (n7 = n5; n7 < n3; n7 += n4) {
                        d3 = 0.0;
                        for (n9 = 0; n9 <= n7; ++n9) {
                            d3 += dArray2[n9] * dArray[n7 - n9];
                        }
                        for (n9 = n7 + 1; n9 < n3; ++n9) {
                            d3 += dArray2[n9] * dArray[0];
                        }
                        dArray3[n6++] = d3;
                    }
                    break;
                }
                case MODE_SMOOTH: {
                    for (n7 = n5; n7 < n3; n7 += n4) {
                        d3 = 0.0;
                        for (n9 = 0; n9 <= n7; ++n9) {
                            d3 += dArray2[n9] * dArray[n7 - n9];
                        }
                        d2 = dArray[0] - dArray[1];
                        for (n9 = n7 + 1; n9 < n3; ++n9) {
                            d3 += dArray2[n9] * (dArray[0] + d2 * (double)(n9 - n7));
                        }
                        dArray3[n6++] = d3;
                    }
                    break;
                }
                case MODE_PERIODIC: {
                    for (n7 = n5; n7 < n3; n7 += n4) {
                        d3 = 0.0;
                        for (n9 = 0; n9 <= n7; ++n9) {
                            d3 += dArray2[n9] * dArray[n7 - n9];
                        }
                        n8 = n2 + n7;
                        for (n9 = n7 + 1; n9 < n3; ++n9) {
                            d3 += dArray2[n9] * dArray[n8 - n9];
                        }
                        dArray3[n6++] = d3;
                    }
                    break;
                }
                case MODE_PERIODIZATION: {
                    n5 = n3 / 2;
                    int n10 = n3 / 2;
                    int n11 = 0;
                    for (n7 = n5; n7 < n3; n7 += n4) {
                        d3 = 0.0;
                        for (n9 = 0; n9 < n7 + 1 - n11; ++n9) {
                            d3 += dArray2[n9] * dArray[n7 - n9 - n11];
                        }
                        if (n2 % 2 > 0) {
                            if (n3 - n9 > 0) {
                                d3 += dArray2[n9] * dArray[n2 - 1];
                                if (n3 - n9 > 0) {
                                    for (n8 = 2 - n11; n8 <= n3 - n9; ++n8) {
                                        d3 += dArray2[n9 - 1 + n8] * dArray[n2 - n8 + 1];
                                    }
                                }
                            }
                        } else {
                            for (n8 = 1; n8 <= n3 - n9; ++n8) {
                                d3 += dArray2[n9 - 1 + n8] * dArray[n2 - n8];
                            }
                        }
                        dArray3[n6++] = d3;
                    }
                    break;
                }
                default: {
                    for (n7 = n5; n7 < n3; n7 += n4) {
                        d3 = 0.0;
                        for (n9 = 0; n9 <= n7; ++n9) {
                            d3 += dArray2[n9] * dArray[n7 - n9];
                        }
                        dArray3[n6++] = d3;
                    }
                }
            }
            while (n7 < n2) {
                d3 = 0.0;
                for (n9 = 0; n9 < n3; ++n9) {
                    d3 += dArray[n7 - n9] * dArray2[n9];
                }
                dArray3[n6++] = d3;
                n7 += n4;
            }
            switch (mODE) {
                case MODE_SYMMETRIC: {
                    while (n7 < n2 + n3 - 1) {
                        d3 = 0.0;
                        for (n9 = n8 = n7 - n2 + 1; n9 < n3; ++n9) {
                            d3 += dArray2[n9] * dArray[n7 - n9];
                        }
                        for (n9 = 0; n9 < n8; ++n9) {
                            d3 += dArray2[n9] * dArray[n2 - n8 + n9];
                        }
                        dArray3[n6++] = d3;
                        n7 += n4;
                    }
                    break;
                }
                case MODE_ASYMMETRIC: {
                    while (n7 < n2 + n3 - 1) {
                        d3 = 0.0;
                        for (n9 = n8 = n7 - n2 + 1; n9 < n3; ++n9) {
                            d3 += dArray2[n9] * dArray[n7 - n9];
                        }
                        for (n9 = 0; n9 < n8; ++n9) {
                            d3 += dArray2[n9] * (dArray[n2 - 1] - dArray[n2 - n8 - 1 + n9]);
                        }
                        dArray3[n6++] = d3;
                        n7 += n4;
                    }
                    break;
                }
                case MODE_CONSTANT_EDGE: {
                    while (n7 < n2 + n3 - 1) {
                        d3 = 0.0;
                        for (n9 = n8 = n7 - n2 + 1; n9 < n3; ++n9) {
                            d3 += dArray2[n9] * dArray[n7 - n9];
                        }
                        for (n9 = 0; n9 < n8; ++n9) {
                            d3 += dArray2[n9] * dArray[n2 - 1];
                        }
                        dArray3[n6++] = d3;
                        n7 += n4;
                    }
                    break;
                }
                case MODE_SMOOTH: {
                    while (n7 < n2 + n3 - 1) {
                        d3 = 0.0;
                        for (n9 = n8 = n7 - n2 + 1; n9 < n3; ++n9) {
                            d3 += dArray2[n9] * dArray[n7 - n9];
                        }
                        d2 = dArray[n2 - 1] - dArray[n2 - 2];
                        for (n9 = 0; n9 < n8; ++n9) {
                            d3 += dArray2[n9] * (dArray[n2 - 1] + d2 * (double)(n8 - n9));
                        }
                        dArray3[n6++] = d3;
                        n7 += n4;
                    }
                    break;
                }
                case MODE_PERIODIC: {
                    while (n7 < n2 + n3 - 1) {
                        d3 = 0.0;
                        for (n9 = n8 = n7 - n2 + 1; n9 < n3; ++n9) {
                            d3 += dArray2[n9] * dArray[n7 - n9];
                        }
                        for (n9 = 0; n9 < n8; ++n9) {
                            d3 += dArray2[n9] * dArray[n8 - 1 - n9];
                        }
                        dArray3[n6++] = d3;
                        n7 += n4;
                    }
                    break;
                }
                case MODE_PERIODIZATION: {
                    while (n7 < n2 - n4 + n3 / 2 + 1 + n2 % 2) {
                        d3 = 0.0;
                        for (n9 = n8 = n7 - n2 + 1; n9 < n3; ++n9) {
                            d3 += dArray2[n9] * dArray[n7 - n9];
                        }
                        if (n2 % 2 == 0) {
                            for (n9 = 0; n9 < n8; ++n9) {
                                d3 += dArray2[n9] * dArray[n8 - 1 - n9];
                            }
                        } else {
                            for (n9 = 0; n9 < n8 - 1; ++n9) {
                                d3 += dArray2[n9] * dArray[n8 - 2 - n9];
                            }
                            d3 += dArray2[n8 - 1] * dArray[n2 - 1];
                        }
                        dArray3[n6++] = d3;
                        n7 += n4;
                    }
                    break;
                }
                default: {
                    while (n7 < n2 + n3 - 1) {
                        d3 = 0.0;
                        for (n9 = n7 - (n2 - 1); n9 < n3; ++n9) {
                            d3 += dArray[n7 - n9] * dArray2[n9];
                        }
                        dArray3[n6++] = d3;
                        n7 += n4;
                    }
                    break block8;
                }
            }
            return 0;
        }
        return this.allocating_downsampling_convolution(dArray, n2, dArray2, n3, dArray3, n4, mODE);
    }

    int dwt_buffer_length(int n2, int n3, WaveletCoefficients.MODE mODE) {
        if (n2 < 1 || n3 < 1) {
            return 0;
        }
        if (mODE == WaveletCoefficients.MODE.MODE_PERIODIZATION) {
            return (int)Math.ceil((double)n2 / 2.0);
        }
        return (int)Math.floor((double)(n2 + n3 - 1) / 2.0);
    }

    int dwt_max_level(int n2, int n3) {
        if (n2 < 1 || n3 < 2) {
            return 0;
        }
        return (int)Math.floor(Math.log((double)n2 / (double)(n3 - 1)) / Math.log(2.0));
    }

    int idwt_buffer_length(int n2, int n3, WaveletCoefficients.MODE mODE) {
        if (n2 < 0 || n3 < 0) {
            return 0;
        }
        if (mODE == WaveletCoefficients.MODE.MODE_PERIODIZATION) {
            return 2 * n2;
        }
        return 2 * n2 - n3 + 2;
    }

    public void invDaubTrans(double[] dArray) {
        int n2 = dArray.length;
        for (int i2 = this.fwavelet.getLength(); i2 <= n2; i2 <<= 1) {
            this.invTransform(dArray, i2);
        }
    }

    public double[] invoke(double[] dArray) {
        int n2 = this.fwavelet.getLength();
        double[] dArray2 = this.fwavelet.getDecompHP();
        double[] dArray3 = this.fwavelet.getDecompLP();
        double[] dArray4 = new double[dArray.length];
        int n3 = dArray.length >> 1;
        while (true) {
            for (int i2 = 0; i2 < n3 - n2; ++i2) {
                double d2 = 0.0;
                double d3 = 0.0;
                int n4 = i2 * 2;
                for (int i3 = 0; i3 < n2; ++i3) {
                    d2 += dArray[n4 + i3] * dArray3[i3];
                    d3 += dArray[n4 + i3] * dArray2[i3];
                }
                dArray4[i2] = d2;
                dArray4[n3 + i2] = d3;
            }
            if (n3 == 1) {
                return dArray4;
            }
            System.arraycopy(dArray4, 0, dArray, 0, n3 << 1);
            n3 >>= 1;
        }
    }

    protected void invTransform(double[] dArray, int n2) {
        if (n2 >= 4) {
            int n3;
            int n4 = n2 >> 1;
            int n5 = n4 + 1;
            double[] dArray2 = new double[n2];
            dArray2[0] = dArray[n4 - 1] * this.Ih0 + dArray[n2 - 1] * this.Ih1 + dArray[0] * this.Ih2 + dArray[n4] * this.Ih3;
            dArray2[1] = dArray[n4 - 1] * this.Ig0 + dArray[n2 - 1] * this.Ig1 + dArray[0] * this.Ig2 + dArray[n4] * this.Ig3;
            int n6 = 2;
            for (n3 = 0; n3 < n4 - 1; ++n3) {
                dArray2[n6++] = dArray[n3] * this.Ih0 + dArray[n3 + n4] * this.Ih1 + dArray[n3 + 1] * this.Ih2 + dArray[n3 + n5] * this.Ih3;
                dArray2[n6++] = dArray[n3] * this.Ig0 + dArray[n3 + n4] * this.Ig1 + dArray[n3 + 1] * this.Ig2 + dArray[n3 + n5] * this.Ig3;
            }
            for (n3 = 0; n3 < n2; ++n3) {
                dArray[n3] = dArray2[n3];
            }
        }
    }

    int reconstruction_buffer_length(int n2, int n3) {
        if (n2 < 1 || n3 < 1) {
            return 0;
        }
        return 2 * n2 + n3 - 2;
    }

    int swt_buffer_length(int n2) {
        if (n2 < 0) {
            return 0;
        }
        return n2;
    }

    int swt_max_level(int n2) {
        int n3 = (int)Math.floor(Math.log(n2) / Math.log(2.0));
        for (int i2 = 0; i2 <= n3; ++i2) {
            if ((n2 & 1) == 1) {
                return i2;
            }
            n2 >>= 1;
        }
        return n3;
    }

    protected void transform(double[] dArray, int n2) {
        int n3 = this.fwavelet.getLength();
        double[] dArray2 = this.fwavelet.getDecompHP();
        double[] dArray3 = this.fwavelet.getDecompLP();
        System.err.printf("dim %d %d\n", dArray2.length, dArray3.length);
        System.err.printf("A h0 = %f h1 = %f h2 = %f h3= %f\n", this.h0, this.h1, this.h2, this.h3);
        System.err.printf("B h0 = %f h1 = %f h2 = %f h3= %f\n", dArray2[0], dArray2[1], dArray2[2], dArray2[3]);
        if (n2 >= n3) {
            int n4 = n2 >> 1;
            double[] dArray4 = new double[n2];
            int n5 = 0;
            for (int i2 = 0; i2 < n2 - n3 - 1; i2 += 2) {
                dArray4[n5] = 0.0;
                dArray4[n5 + n4] = 0.0;
                for (int i3 = 0; i3 < n3; ++i3) {
                    int n6 = n5;
                    dArray4[n6] = dArray4[n6] + dArray[i2 + i3] * dArray2[i3];
                    dArray4[n5 + n4] = dArray[i2 + i3] * dArray3[i3];
                }
                ++n5;
            }
            dArray4[n5] = dArray[n2 - 2] * dArray2[0] + dArray[n2 - 1] * dArray2[1] + dArray[0] * dArray2[2] + dArray[1] * dArray2[3];
            dArray4[n5 + n4] = dArray[n2 - 2] * dArray3[0] + dArray[n2 - 1] * dArray3[1] + dArray[0] * dArray3[2] + dArray[1] * dArray3[3];
            for (n5 = 0; n5 < n2; ++n5) {
                dArray[n5] = dArray4[n5];
            }
        }
    }

    int upsampled_filter_convolution(double[] dArray, int n2, double[] dArray2, int n3, double[] dArray3, int n4, WaveletCoefficients.MODE mODE) {
        return -1;
    }

    int upsampling_convolution_full(double[] dArray, int n2, double[] dArray2, int n3, double[] dArray3, int n4) {
        if (n3 < 2) {
            return -1;
        }
        int n5 = n2 - 1 << 1;
        for (int i2 = n2 - 1; i2 >= 0; --i2) {
            for (int i3 = 0; i3 < n3; ++i3) {
                int n6 = i3 + n5;
                dArray3[n6] = dArray3[n6] + dArray[i2] * dArray2[i3];
            }
            n5 -= 2;
        }
        return 0;
    }

    int upsampling_convolution_valid_sf(double[] dArray, int n2, double[] dArray2, int n3, double[] dArray3, int n4, WaveletCoefficients.MODE mODE) {
        double[] dArray4 = null;
        int n5 = 0;
        int n6 = n3 / 2;
        if (n3 % 2 > 0) {
            return -3;
        }
        if (n2 < n6) {
            int n7;
            int n8;
            if (mODE != WaveletCoefficients.MODE.MODE_PERIODIZATION) {
                return -2;
            }
            n5 = n6 - 1 + n2;
            dArray4 = new double[n5];
            for (n8 = n7 = (n6 - 1) / 2; n8 < n7 + n2; ++n8) {
                dArray4[n8] = dArray[(n8 - n7) % n2];
            }
            int n9 = n8 - 1;
            int n10 = n8 - n7;
            while (n8 < n5) {
                dArray4[n8] = dArray4[n8 - n10];
                ++n8;
            }
            n10 = 0;
            for (n8 = n7 - 1; n8 >= 0; --n8) {
                dArray4[n8] = dArray4[n9 + n10];
                --n10;
            }
            if (n6 % 2 > 0) {
                this.upsampling_convolution_valid_sf(dArray4, n5, dArray2, n3, dArray3, n4, WaveletCoefficients.MODE.MODE_ZEROPAD);
            } else {
                double[] dArray5 = new double[this.idwt_buffer_length(n2, n3, WaveletCoefficients.MODE.MODE_PERIODIZATION)];
                this.upsampling_convolution_valid_sf(dArray4, n5, dArray2, n3, dArray5, n4, WaveletCoefficients.MODE.MODE_ZEROPAD);
                for (n8 = 2 * n2 - 1; n8 > 0; --n8) {
                    int n11 = n8;
                    dArray3[n11] = dArray3[n11] + dArray5[n8 - 1];
                }
                dArray3[0] = dArray3[0] + dArray5[2 * n2 - 1];
            }
            return 0;
        }
        double[] dArray6 = new double[n6];
        double[] dArray7 = new double[n6];
        for (int i2 = 0; i2 < n6; ++i2) {
            dArray6[i2] = dArray2[i2 << 1];
            dArray7[i2] = dArray2[(i2 << 1) + 1];
        }
        if (mODE == WaveletCoefficients.MODE.MODE_PERIODIZATION) {
            int n12 = n6 - 1;
            n5 = n6 - 1 + (int)Math.ceil((double)n12 / 2.0);
        }
        return 0;
    }
}

