/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.math.spectra.wavelet;

public class DaubechiesWavelet {
    protected final double sqrt_3 = Math.sqrt(3.0);
    protected final double denom = 4.0 * Math.sqrt(2.0);
    protected final double h0 = (1.0 + this.sqrt_3) / this.denom;
    protected final double h1 = (3.0 + this.sqrt_3) / this.denom;
    protected final double h2 = (3.0 - this.sqrt_3) / this.denom;
    protected final double h3;
    protected final double g0 = this.h3 = (1.0 - this.sqrt_3) / this.denom;
    protected final double g1 = -this.h2;
    protected final double g2 = this.h1;
    protected final double g3 = -this.h0;
    protected final double Ih0 = this.h2;
    protected final double Ih1 = this.g2;
    protected final double Ih2 = this.h0;
    protected final double Ih3 = this.g0;
    protected final double Ig0 = this.h3;
    protected final double Ig1 = this.g3;
    protected final double Ig2 = this.h1;
    protected final double Ig3 = this.g1;

    public void daubTrans(double[] dArray) {
        int n2;
        for (int i2 = n2 = dArray.length; i2 >= 4; i2 >>= 1) {
            this.transform(dArray, i2);
        }
    }

    public void invDaubTrans(double[] dArray) {
        int n2 = dArray.length;
        for (int i2 = 4; i2 <= n2; i2 <<= 1) {
            this.invTransform(dArray, i2);
        }
    }

    protected void invTransform(double[] dArray, int n2) {
        if (n2 >= 4) {
            int n3;
            int n4 = n2 >> 1;
            int n5 = n4 + 1;
            double[] dArray2 = new double[n2];
            dArray2[0] = dArray[n4 - 1] * this.Ih0 + dArray[n2 - 1] * this.Ih1 + dArray[0] * this.Ih2 + dArray[n4] * this.Ih3;
            dArray2[1] = dArray[n4 - 1] * this.Ig0 + dArray[n2 - 1] * this.Ig1 + dArray[0] * this.Ig2 + dArray[n4] * this.Ig3;
            int n6 = 2;
            for (n3 = 0; n3 < n4 - 1; ++n3) {
                dArray2[n6++] = dArray[n3] * this.Ih0 + dArray[n3 + n4] * this.Ih1 + dArray[n3 + 1] * this.Ih2 + dArray[n3 + n5] * this.Ih3;
                dArray2[n6++] = dArray[n3] * this.Ig0 + dArray[n3 + n4] * this.Ig1 + dArray[n3 + 1] * this.Ig2 + dArray[n3 + n5] * this.Ig3;
            }
            for (n3 = 0; n3 < n2; ++n3) {
                dArray[n3] = dArray2[n3];
            }
        }
    }

    protected void transform(double[] dArray, int n2) {
        if (n2 >= 4) {
            int n3 = n2 >> 1;
            double[] dArray2 = new double[n2];
            System.err.printf("h0 = %f h1 = %f h2 = %f h3= %f\n", this.h0, this.h1, this.h2, this.h3);
            int n4 = 0;
            for (int i2 = 0; i2 < n2 - 3; i2 += 2) {
                dArray2[n4] = dArray[i2] * this.h0 + dArray[i2 + 1] * this.h1 + dArray[i2 + 2] * this.h2 + dArray[i2 + 3] * this.h3;
                dArray2[n4 + n3] = dArray[i2] * this.g0 + dArray[i2 + 1] * this.g1 + dArray[i2 + 2] * this.g2 + dArray[i2 + 3] * this.g3;
                ++n4;
            }
            dArray2[n4] = dArray[n2 - 2] * this.h0 + dArray[n2 - 1] * this.h1 + dArray[0] * this.h2 + dArray[1] * this.h3;
            dArray2[n4 + n3] = dArray[n2 - 2] * this.g0 + dArray[n2 - 1] * this.g1 + dArray[0] * this.g2 + dArray[1] * this.g3;
            for (n4 = 0; n4 < n2; ++n4) {
                dArray[n4] = dArray2[n4];
            }
        }
    }
}

