/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.math.spectra.lomb;

import io.fair_acc.math.Math;
import io.fair_acc.math.MathBase;
import io.fair_acc.math.utils.ConcurrencyUtils;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LombPeriodogram {
    private static final Logger LOGGER = LoggerFactory.getLogger(LombPeriodogram.class);
    protected static final int START_THREADS = 256;

    private LombPeriodogram() {
    }

    public static double[] computeFrequencyRange(double[] dArray) {
        double d2 = Math.maximum(dArray) - Math.minimum(dArray);
        double d3 = Double.MAX_VALUE;
        for (int i2 = 1; i2 < dArray.length; ++i2) {
            double d4 = MathBase.abs(dArray[i2] - dArray[i2 - 1]);
            if (!(d3 > d4) || !(d3 > 0.0)) continue;
            d3 = d4;
        }
        double d5 = 1.0 / d3;
        int n2 = (int)(d2 / d3);
        double[] dArray2 = new double[n2];
        double d6 = 0.5 / (double)n2 * d5;
        for (int i3 = 0; i3 < n2; ++i3) {
            dArray2[i3] = (double)i3 * d6;
        }
        return dArray2;
    }

    public static double[] computePeridodogram(double[] dArray, double[] dArray2) {
        return LombPeriodogram.computePeridodogram(dArray, dArray2, LombPeriodogram.computeFrequencyRange(dArray));
    }

    public static double[] computePeridodogram(double[] dArray, double[] dArray2, double[] dArray3) {
        int n2 = dArray3.length;
        double[] dArray4 = new double[n2];
        long l2 = System.nanoTime();
        double d2 = 0.0;
        double d3 = 0.0;
        for (int i2 = 0; i2 < dArray.length; ++i2) {
            d2 += MathBase.sin(java.lang.Math.PI * 2 * dArray[i2]);
            d3 += MathBase.cos(java.lang.Math.PI * 2 * dArray[i2]);
        }
        double d4 = MathBase.aTan2(d2, d3) / (java.lang.Math.PI * 2);
        int n3 = ConcurrencyUtils.getNumberOfThreads();
        if (n3 > 1 && n2 > 256) {
            Future[] futureArray = new Future[n3];
            int n4 = n2 / n3;
            for (int i3 = 0; i3 < n3; ++i3) {
                int n5 = i3 * n4;
                int n6 = i3 == n3 - 1 ? n2 : n5 + n4;
                futureArray[i3] = ConcurrencyUtils.submit(() -> {
                    for (int i2 = n5; i2 < n6; ++i2) {
                        double d3 = java.lang.Math.PI * 2 * dArray3[i2];
                        double d4 = 0.0;
                        double d5 = 0.0;
                        double d6 = 0.0;
                        double d7 = 0.0;
                        for (int i3 = 0; i3 < dArray.length; ++i3) {
                            d4 += dArray2[i3] * MathBase.cos(d3 * (dArray[i3] - d4));
                            d6 += dArray2[i3] * MathBase.sin(d3 * (dArray[i3] - d4));
                            d5 += MathBase.sqr(MathBase.cos(d3 * (dArray[i3] - d4)));
                            d7 += MathBase.sqr(MathBase.sin(d3 * (dArray[i3] - d4)));
                        }
                        dArray4[i2] = d5 <= 0.0 || d7 <= 0.0 ? 0.0 : MathBase.sqrt(2.0 * (MathBase.sqr(d4) / d5 + MathBase.sqr(d6) / d7) / (double)dArray.length);
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i4 = 0; i4 < n2; ++i4) {
                double d5 = java.lang.Math.PI * 2 * dArray3[i4];
                double d6 = 0.0;
                double d7 = 0.0;
                double d8 = 0.0;
                double d9 = 0.0;
                for (int i5 = 0; i5 < dArray.length; ++i5) {
                    d6 += dArray2[i5] * MathBase.cos(d5 * (dArray[i5] - d4));
                    d8 += dArray2[i5] * MathBase.sin(d5 * (dArray[i5] - d4));
                    d7 += MathBase.sqr(MathBase.cos(d5 * (dArray[i5] - d4)));
                    d9 += MathBase.sqr(MathBase.sin(d5 * (dArray[i5] - d4)));
                }
                dArray4[i4] = d7 <= 0.0 || d9 <= 0.0 ? 0.0 : MathBase.sqrt(2.0 * (MathBase.sqr(d6) / d7 + MathBase.sqr(d8) / d9) / (double)dArray.length);
            }
        }
        long l3 = System.nanoTime();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.atDebug().addArgument((double)(l3 - l2) * 1.0E-6).log("LombPeriodogram(double[], double[], double[]) - took {} ms");
        }
        return dArray4;
    }
}

