/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.math.spectra;

import io.fair_acc.dataset.spi.utils.DoublePoint;
import io.fair_acc.dataset.utils.ArrayCache;
import io.fair_acc.dataset.utils.AssertUtils;
import io.fair_acc.math.ArrayMath;
import io.fair_acc.math.ArrayUtils;
import io.fair_acc.math.Math;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TSpectrum {
    private static final Logger LOGGER = LoggerFactory.getLogger(TSpectrum.class);
    private static final String CACHED_ARRAY_BACKGROUND = "TSpectrum::background:workingSpace";
    private static final String CACHED_ARRAY_SMOOTH_MARKOV = "TSpectrum::smoothMarkov:workingSpace";
    private static final String CACHED_ARRAY_SEARCH = "TSpectrum::search:workingSpace";
    private static final String CACHED_ARRAY_DECONVOLUTION = "TSpectrum::deconvolution:workingSpace";
    private static final String CACHED_ARRAY_DECONVOLUTION_RL = "TSpectrum::deconvolutionLR:workingSpace";
    private static final String CACHED_ARRAY_UNFOLDING = "TSpectrum::unfolding:workingSpace";
    private static final int PEAK_WINDOW = 1024;

    private TSpectrum() {
    }

    public static double[] background(double[] dArray, double[] dArray2, int n2, int n3, Direction direction, FilterOrder filterOrder, SmoothWindow smoothWindow, boolean bl2) {
        if (dArray == null || n2 <= 0 || dArray.length < n2) {
            throw new InvalidParameterException("input spectrum null or invalid vector size");
        }
        AssertUtils.gtOrEqual("numberIterations", 1, n3);
        if (n2 < 2 * n3 + 1) {
            throw new InvalidParameterException("clipping window is too large (length < 2 * numberIterations + 1) -> " + n2 + "< " + (2 * n3 + 1));
        }
        AssertUtils.notNull("filterOrder", filterOrder);
        AssertUtils.notNull("smoothing", smoothWindow);
        double[] dArray3 = ArrayCache.getCachedDoubleArray(CACHED_ARRAY_BACKGROUND, 2 * n2);
        System.arraycopy(dArray, 0, dArray3, 0, n2);
        System.arraycopy(dArray, 0, dArray3, n2, n2);
        switch (filterOrder) {
            case ORDER_2: {
                TSpectrum.filterBackgroundOrder2(dArray3, n2, n3, direction, smoothWindow);
                break;
            }
            case ORDER_4: {
                TSpectrum.filterBackgroundOrder4(dArray3, n2, n3, direction, smoothWindow);
                break;
            }
            case ORDER_6: {
                TSpectrum.filterBackgroundOrder6(dArray3, n2, n3, direction, smoothWindow);
                break;
            }
            default: {
                TSpectrum.filterBackgroundOrder8(dArray3, n2, n3, direction, smoothWindow);
            }
        }
        if (bl2) {
            for (int i2 = 0; i2 < n2; ++i2) {
                double d2;
                int n4;
                double d3 = dArray3[i2];
                double d4 = dArray[i2];
                if (!(Math.abs(d3 - d4) >= 1.0)) continue;
                int n5 = i2 - 1;
                if (n5 < 0) {
                    n5 = 0;
                }
                double d5 = dArray3[n5];
                double d6 = 0.0;
                boolean bl3 = false;
                for (n4 = n5 + 1; !bl3 && n4 < n2; ++n4) {
                    d3 = dArray3[n4];
                    d4 = dArray[n4];
                    d6 = d6 + d4 - d5;
                    if (!(Math.abs(d3 - d4) < 1.0)) continue;
                    bl3 = true;
                }
                if (n4 == n2) {
                    --n4;
                }
                if (d5 <= (d2 = dArray3[n4])) {
                    d6 = 0.0;
                    for (int i3 = n5; i3 <= n4; ++i3) {
                        d4 = dArray[i3];
                        d6 = d6 + d4 - d5;
                    }
                    if (d6 > 1.0) {
                        d6 = (d2 - d5) / d6;
                        double d7 = 0.0;
                        for (var25_23 = n5; var25_23 <= n4 && var25_23 < n2; ++var25_23) {
                            d4 = dArray[var25_23];
                            d7 = d7 + d4 - d5;
                            dArray3[n2 + var25_23] = d3 = d6 * d7 + d5;
                        }
                    }
                } else {
                    d6 = 0.0;
                    for (int i4 = n4; i4 >= n5; --i4) {
                        d4 = dArray[i4];
                        d6 = d6 + d4 - d2;
                    }
                    if (d6 > 1.0) {
                        d6 = (d5 - d2) / d6;
                        double d8 = 0.0;
                        for (var25_23 = n4; var25_23 >= n5; --var25_23) {
                            d4 = dArray[var25_23];
                            d8 = d8 + d4 - d2;
                            dArray3[n2 + var25_23] = d3 = d6 * d8 + d2;
                        }
                    }
                }
                i2 = n4;
            }
        }
        double[] dArray4 = dArray2 == null || dArray2.length < n2 ? new double[n2] : dArray2;
        System.arraycopy(dArray3, 0, dArray4, 0, n2);
        ArrayCache.release(CACHED_ARRAY_BACKGROUND, dArray3);
        return dArray4;
    }

    public static double[] deconvolution(double[] dArray, double[] dArray2, double[] dArray3, int n2, int n3, int n4, double d2) {
        int n5;
        int n6;
        double d3;
        int n7;
        AssertUtils.gtThanZero("length", n2);
        AssertUtils.gtThanZero("numberRepetitions", n4);
        double[] dArray4 = ArrayCache.getCachedDoubleArray(CACHED_ARRAY_DECONVOLUTION, 4 * n2);
        double d4 = 0.0;
        double d5 = 0.0;
        int n8 = -1;
        int n9 = 0;
        for (n7 = 0; n7 < n2; ++n7) {
            d3 = dArray2[n7];
            if (d3 != 0.0) {
                n8 = n7 + 1;
            }
            dArray4[n7] = d3;
            d5 += d3;
            if (!(d3 > d4)) continue;
            d4 = d3;
            n9 = n7;
        }
        if (n8 == -1) {
            throw new IllegalArgumentException("ZERO RESPONSE VECTOR");
        }
        System.arraycopy(dArray, 0, dArray4, 2 * n2 + 0, n2);
        for (n7 = 0; n7 < n2; ++n7) {
            double d6;
            d3 = 0.0;
            for (n6 = 0; n6 < n2; ++n6) {
                double d7 = dArray4[n6];
                int n10 = n7 + n6;
                if (n10 >= n2) continue;
                d6 = dArray4[n10];
                d3 += d7 * d6;
            }
            dArray4[n2 + n7] = d3;
            d3 = 0.0;
            for (n6 = 0; n6 < n2; ++n6) {
                int n11 = n6 - n7;
                if (n11 < 0) continue;
                double d8 = dArray4[n11];
                d6 = dArray4[2 * n2 + n6];
                d3 += d8 * d6;
            }
            dArray4[3 * n2 + n7] = d3;
        }
        System.arraycopy(dArray4, 3 * n2 + 0, dArray4, 2 * n2 + 0, n2);
        for (n7 = 0; n7 < n2; ++n7) {
            dArray4[n7] = 1.0;
        }
        for (n5 = 0; n5 < n4; ++n5) {
            int n12;
            if (n5 != 0) {
                for (n12 = 0; n12 < n2; ++n12) {
                    dArray4[n12] = Math.pow(dArray4[n12], d2);
                }
            }
            for (n12 = 0; n12 < n3; ++n12) {
                for (n6 = 0; n6 < n2; ++n6) {
                    double d9;
                    if (!(dArray4[2 * n2 + n6] > 1.0E-6) || !(dArray4[n6] > 1.0E-6)) continue;
                    double d10 = 0.0;
                    for (n7 = 0; n7 < n8; ++n7) {
                        double d11;
                        d9 = dArray4[n7 + n2];
                        if (n7 == 0) {
                            d11 = dArray4[n6];
                        } else {
                            int n13 = n6 + n7;
                            d11 = 0.0;
                            if (n13 < n2) {
                                d11 = dArray4[n13];
                            }
                            if ((n13 = n6 - n7) >= 0) {
                                d11 += dArray4[n13];
                            }
                        }
                        d10 += d9 * d11;
                    }
                    d9 = dArray4[2 * n2 + n6];
                    if (d10 != 0.0) {
                        d10 = d9 / d10;
                    }
                    d9 = dArray4[n6];
                    dArray4[3 * n2 + n6] = d10 *= d9;
                }
                System.arraycopy(dArray4, 3 * n2 + 0, dArray4, 0, n2);
            }
        }
        for (n5 = 0; n5 < n2; ++n5) {
            double d12 = dArray4[n5];
            n7 = n5 + n9;
            dArray4[n2 + (n7 %= n2)] = d12;
        }
        double[] dArray5 = dArray3 == null || dArray3.length < n2 ? new double[n2] : dArray3;
        System.arraycopy(dArray4, 0, dArray5, 0, n2);
        ArrayMath.multiplyInPlace(dArray5, d5);
        ArrayCache.release(CACHED_ARRAY_DECONVOLUTION, dArray4);
        return dArray5;
    }

    public static double[] deconvolutionRL(double[] dArray, double[] dArray2, double[] dArray3, int n2, int n3, int n4, double d2) {
        int n5;
        int n6;
        AssertUtils.gtThanZero("length", n2);
        AssertUtils.gtThanZero("numberRepetitions", n4);
        double[] dArray4 = ArrayCache.getCachedDoubleArray(CACHED_ARRAY_DECONVOLUTION_RL, 4 * n2);
        int n7 = 0;
        int n8 = -1;
        double d3 = 0.0;
        for (n6 = 0; n6 < n2; ++n6) {
            double d4 = dArray2[n6];
            if (d4 != 0.0) {
                n8 = n6 + 1;
            }
            dArray4[n2 + n6] = d4;
            if (!(d4 > d3)) continue;
            d3 = d4;
            n7 = n6;
        }
        if (n8 == -1) {
            throw new IllegalArgumentException("ZERO RESPONSE VECTOR");
        }
        System.arraycopy(dArray, 0, dArray4, 2 * n2 + 0, n2);
        for (n6 = 0; n6 < n2; ++n6) {
            dArray4[n6] = n6 <= n2 - n8 ? 1.0 : 0.0;
        }
        for (n5 = 0; n5 < n4; ++n5) {
            int n9;
            if (n5 != 0) {
                for (n9 = 0; n9 < n2; ++n9) {
                    dArray4[n9] = Math.pow(dArray4[n9], d2);
                }
            }
            for (n9 = 0; n9 < n3; ++n9) {
                for (int i2 = 0; i2 <= n2 - n8; ++i2) {
                    double d5 = 0.0;
                    if (dArray4[i2] > 0.0) {
                        for (n6 = i2; n6 < i2 + n8; ++n6) {
                            double d6 = dArray4[2 * n2 + n6];
                            if (n6 < n2) {
                                if (d6 > 0.0) {
                                    int n10;
                                    int n11 = n6;
                                    if (n11 > n8 - 1) {
                                        n11 = n8 - 1;
                                    }
                                    if ((n10 = n6 + n8 - n2) < 0) {
                                        n10 = 0;
                                    }
                                    double d7 = 0.0;
                                    for (int i3 = n11; i3 >= n10; --i3) {
                                        d7 += dArray4[n2 + i3] * dArray4[n6 - i3];
                                    }
                                    d6 = d7 > 0.0 ? (d6 /= d7) : 0.0;
                                }
                                d6 *= dArray4[n2 + n6 - i2];
                            }
                            d5 += d6;
                        }
                        d5 *= dArray4[i2];
                    }
                    dArray4[3 * n2 + i2] = d5;
                }
                System.arraycopy(dArray4, 3 * n2 + 0, dArray4, 0, n2);
            }
        }
        for (n5 = 0; n5 < n2; ++n5) {
            double d8 = dArray4[n5];
            n6 = n5 + n7;
            dArray4[n2 + (n6 %= n2)] = d8;
        }
        System.arraycopy(dArray4, n2 + 0, dArray, 0, n2);
        double[] dArray5 = dArray3 == null || dArray3.length < n2 ? new double[n2] : dArray3;
        System.arraycopy(dArray4, 0, dArray5, 0, n2);
        ArrayCache.release(CACHED_ARRAY_DECONVOLUTION_RL, dArray4);
        return dArray5;
    }

    protected static void filterBackgroundOrder2(double[] dArray, int n2, int n3, Direction direction, SmoothWindow smoothWindow) {
        int n4 = direction == Direction.INCREASING ? 1 : n3;
        int n5 = (smoothWindow.getValue() - 1) / 2;
        do {
            for (int i2 = n4; i2 < n2 - n4; ++i2) {
                double d2;
                double d3;
                if (smoothWindow.isSmoothing()) {
                    d3 = dArray[n2 + i2];
                    double d4 = 0.0;
                    double d5 = 0.0;
                    for (int i3 = i2 - n5; i3 <= i2 + n5; ++i3) {
                        if (i3 < 0 || i3 >= n2) continue;
                        d4 += dArray[n2 + i3];
                        d5 += 1.0;
                    }
                    d4 /= d5;
                    d2 = 0.0;
                    d5 = 0.0;
                    for (int i4 = i2 - n4 - n5; i4 <= i2 - n4 + n5; ++i4) {
                        if (i4 < 0 || i4 >= n2) continue;
                        d2 += dArray[n2 + i4];
                        d5 += 1.0;
                    }
                    d2 /= d5;
                    double d6 = 0.0;
                    d5 = 0.0;
                    for (int i5 = i2 + n4 - n5; i5 <= i2 + n4 + n5; ++i5) {
                        if (i5 < 0 || i5 >= n2) continue;
                        d6 += dArray[n2 + i5];
                        d5 += 1.0;
                    }
                    if ((d2 = (d2 + (d6 /= d5)) / 2.0) < d3) {
                        d4 = d2;
                    }
                    dArray[i2] = d4;
                    continue;
                }
                d2 = (dArray[n2 + i2 - n4] + dArray[n2 + i2 + n4]) / 2.0;
                d3 = dArray[n2 + i2];
                if (d2 < d3) {
                    d3 = d2;
                }
                dArray[i2] = d3;
            }
            if (n2 - n4 - n4 >= 0) {
                System.arraycopy(dArray, n4, dArray, n2 + n4, n2 - n4 - n4);
            }
            if (direction == Direction.INCREASING) {
                ++n4;
                continue;
            }
            --n4;
        } while (direction == Direction.INCREASING && n4 <= n3 || direction == Direction.DECREASING && n4 >= 1);
    }

    protected static void filterBackgroundOrder4(double[] dArray, int n2, int n3, Direction direction, SmoothWindow smoothWindow) {
        int n4 = direction == Direction.INCREASING ? 1 : n3;
        int n5 = (smoothWindow.getValue() - 1) / 2;
        do {
            for (int i2 = n4; i2 < n2 - n4; ++i2) {
                double d2;
                double d3;
                double d4;
                double d5;
                if (smoothWindow.isSmoothing()) {
                    d5 = dArray[n2 + i2];
                    d4 = 0.0;
                    d3 = 0.0;
                    for (int i3 = i2 - n5; i3 <= i2 + n5; ++i3) {
                        if (i3 < 0 || i3 >= n2) continue;
                        d4 += dArray[n2 + i3];
                        d3 += 1.0;
                    }
                    d4 /= d3;
                    d2 = 0.0;
                    d3 = 0.0;
                    for (int i4 = i2 - n4 - n5; i4 <= i2 - n4 + n5; ++i4) {
                        if (i4 < 0 || i4 >= n2) continue;
                        d2 += dArray[n2 + i4];
                        d3 += 1.0;
                    }
                    d2 /= d3;
                    double d6 = 0.0;
                    d3 = 0.0;
                    for (int i5 = i2 + n4 - n5; i5 <= i2 + n4 + n5; ++i5) {
                        if (i5 < 0 || i5 >= n2) continue;
                        d6 += dArray[n2 + i5];
                        d3 += 1.0;
                    }
                    d2 = (d2 + (d6 /= d3)) / 2.0;
                    double d7 = (double)n4 / 2.0;
                    double d8 = 0.0;
                    d3 = 0.0;
                    for (int i6 = i2 - (int)(2.0 * d7) - n5; i6 <= i2 - (int)(2.0 * d7) + n5; ++i6) {
                        if (i6 < 0 || i6 >= n2) continue;
                        d8 += dArray[n2 + i6];
                        d3 += 1.0;
                    }
                    d8 /= d3;
                    double d9 = 0.0;
                    d3 = 0.0;
                    for (int i7 = i2 - (int)d7 - n5; i7 <= i2 - (int)d7 + n5; ++i7) {
                        if (i7 < 0 || i7 >= n2) continue;
                        d9 += dArray[n2 + i7];
                        d3 += 1.0;
                    }
                    d9 /= d3;
                    double d10 = 0.0;
                    d3 = 0.0;
                    for (int i8 = i2 + (int)d7 - n5; i8 <= i2 + (int)d7 + n5; ++i8) {
                        if (i8 < 0 || i8 >= n2) continue;
                        d10 += dArray[n2 + i8];
                        d3 += 1.0;
                    }
                    d10 /= d3;
                    double d11 = 0.0;
                    d3 = 0.0;
                    for (int i9 = i2 + (int)(2.0 * d7) - n5; i9 <= i2 + (int)(2.0 * d7) + n5; ++i9) {
                        if (i9 < 0 || i9 >= n2) continue;
                        d11 += dArray[n2 + i9];
                        d3 += 1.0;
                    }
                    if (d2 < (d8 = (-d8 + 4.0 * d9 + 4.0 * d10 - (d11 /= d3)) / 6.0)) {
                        d2 = d8;
                    }
                    if (d2 < d5) {
                        d4 = d2;
                    }
                    dArray[i2] = d4;
                    continue;
                }
                d5 = dArray[n2 + i2];
                d4 = (dArray[n2 + i2 - n4] + dArray[n2 + i2 + n4]) / 2.0;
                d3 = 0.0;
                d2 = (double)n4 / 2.0;
                d3 -= dArray[n2 + i2 - (int)(2.0 * d2)] / 6.0;
                d3 += 4.0 * dArray[n2 + i2 - (int)d2] / 6.0;
                d3 += 4.0 * dArray[n2 + i2 + (int)d2] / 6.0;
                if (d4 < (d3 -= dArray[n2 + i2 + (int)(2.0 * d2)] / 6.0)) {
                    d4 = d3;
                }
                if (d4 < d5) {
                    d5 = d4;
                }
                dArray[i2] = d5;
            }
            if (n2 - n4 - n4 >= 0) {
                System.arraycopy(dArray, n4, dArray, n2 + n4, n2 - n4 - n4);
            }
            if (direction == Direction.INCREASING) {
                ++n4;
                continue;
            }
            --n4;
        } while (direction == Direction.INCREASING && n4 <= n3 || direction == Direction.DECREASING && n4 >= 1);
    }

    protected static void filterBackgroundOrder6(double[] dArray, int n2, int n3, Direction direction, SmoothWindow smoothWindow) {
        int n4 = direction == Direction.INCREASING ? 1 : n3;
        int n5 = (smoothWindow.getValue() - 1) / 2;
        do {
            for (int i2 = n4; i2 < n2 - n4; ++i2) {
                double d2;
                double d3;
                double d4;
                double d5;
                double d6;
                if (smoothWindow.isSmoothing()) {
                    d6 = dArray[n2 + i2];
                    d5 = 0.0;
                    d4 = 0.0;
                    for (int i3 = i2 - n5; i3 <= i2 + n5; ++i3) {
                        if (i3 < 0 || i3 >= n2) continue;
                        d5 += dArray[n2 + i3];
                        d4 += 1.0;
                    }
                    d5 /= d4;
                    d3 = 0.0;
                    d4 = 0.0;
                    for (int i4 = i2 - n4 - n5; i4 <= i2 - n4 + n5; ++i4) {
                        if (i4 < 0 || i4 >= n2) continue;
                        d3 += dArray[n2 + i4];
                        d4 += 1.0;
                    }
                    d3 /= d4;
                    d2 = 0.0;
                    d4 = 0.0;
                    for (int i5 = i2 + n4 - n5; i5 <= i2 + n4 + n5; ++i5) {
                        if (i5 < 0 || i5 >= n2) continue;
                        d2 += dArray[n2 + i5];
                        d4 += 1.0;
                    }
                    d3 = (d3 + (d2 /= d4)) / 2.0;
                    double d7 = (double)n4 / 2.0;
                    double d8 = 0.0;
                    d4 = 0.0;
                    for (int i6 = i2 - (int)(2.0 * d7) - n5; i6 <= i2 - (int)(2.0 * d7) + n5; ++i6) {
                        if (i6 < 0 || i6 >= n2) continue;
                        d8 += dArray[n2 + i6];
                        d4 += 1.0;
                    }
                    d8 /= d4;
                    double d9 = 0.0;
                    d4 = 0.0;
                    for (int i7 = i2 - (int)d7 - n5; i7 <= i2 - (int)d7 + n5; ++i7) {
                        if (i7 < 0 || i7 >= n2) continue;
                        d9 += dArray[n2 + i7];
                        d4 += 1.0;
                    }
                    d9 /= d4;
                    double d10 = 0.0;
                    d4 = 0.0;
                    for (int i8 = i2 + (int)d7 - n5; i8 <= i2 + (int)d7 + n5; ++i8) {
                        if (i8 < 0 || i8 >= n2) continue;
                        d10 += dArray[n2 + i8];
                        d4 += 1.0;
                    }
                    d10 /= d4;
                    double d11 = 0.0;
                    d4 = 0.0;
                    for (int i9 = i2 + (int)(2.0 * d7) - n5; i9 <= i2 + (int)(2.0 * d7) + n5; ++i9) {
                        if (i9 < 0 || i9 >= n2) continue;
                        d11 += dArray[n2 + i9];
                        d4 += 1.0;
                    }
                    d8 = (-d8 + 4.0 * d9 + 4.0 * d10 - (d11 /= d4)) / 6.0;
                    d7 = (double)n4 / 3.0;
                    double d12 = 0.0;
                    d4 = 0.0;
                    for (int i10 = i2 - (int)(3.0 * d7) - n5; i10 <= i2 - (int)(3.0 * d7) + n5; ++i10) {
                        if (i10 < 0 || i10 >= n2) continue;
                        d12 += dArray[n2 + i10];
                        d4 += 1.0;
                    }
                    d12 /= d4;
                    double d13 = 0.0;
                    d4 = 0.0;
                    for (int i11 = i2 - (int)(2.0 * d7) - n5; i11 <= i2 - (int)(2.0 * d7) + n5; ++i11) {
                        if (i11 < 0 || i11 >= n2) continue;
                        d13 += dArray[n2 + i11];
                        d4 += 1.0;
                    }
                    d13 /= d4;
                    double d14 = 0.0;
                    d4 = 0.0;
                    for (int i12 = i2 - (int)d7 - n5; i12 <= i2 - (int)d7 + n5; ++i12) {
                        if (i12 < 0 || i12 >= n2) continue;
                        d14 += dArray[n2 + i12];
                        d4 += 1.0;
                    }
                    d14 /= d4;
                    double d15 = 0.0;
                    d4 = 0.0;
                    for (int i13 = i2 + (int)d7 - n5; i13 <= i2 + (int)d7 + n5; ++i13) {
                        if (i13 < 0 || i13 >= n2) continue;
                        d15 += dArray[n2 + i13];
                        d4 += 1.0;
                    }
                    d15 /= d4;
                    double d16 = 0.0;
                    d4 = 0.0;
                    for (int i14 = i2 + (int)(2.0 * d7) - n5; i14 <= i2 + (int)(2.0 * d7) + n5; ++i14) {
                        if (i14 < 0 || i14 >= n2) continue;
                        d16 += dArray[n2 + i14];
                        d4 += 1.0;
                    }
                    d16 /= d4;
                    double d17 = 0.0;
                    d4 = 0.0;
                    for (int i15 = i2 + (int)(3.0 * d7) - n5; i15 <= i2 + (int)(3.0 * d7) + n5; ++i15) {
                        if (i15 < 0 || i15 >= n2) continue;
                        d17 += dArray[n2 + i15];
                        d4 += 1.0;
                    }
                    if (d3 < (d12 = (d12 - 6.0 * d13 + 15.0 * d14 + 15.0 * d15 - 6.0 * d16 + (d17 /= d4)) / 20.0)) {
                        d3 = d12;
                    }
                    if (d3 < d8) {
                        d3 = d8;
                    }
                    if (d3 < d6) {
                        d5 = d3;
                    }
                    dArray[i2] = d5;
                    continue;
                }
                d6 = dArray[n2 + i2];
                d5 = (dArray[n2 + i2 - n4] + dArray[n2 + i2 + n4]) / 2.0;
                d4 = 0.0;
                d3 = (double)n4 / 2.0;
                d4 -= dArray[n2 + i2 - (int)(2.0 * d3)] / 6.0;
                d4 += 4.0 * dArray[n2 + i2 - (int)d3] / 6.0;
                d4 += 4.0 * dArray[n2 + i2 + (int)d3] / 6.0;
                d4 -= dArray[n2 + i2 + (int)(2.0 * d3)] / 6.0;
                d2 = 0.0;
                d3 = (double)n4 / 3.0;
                d2 += dArray[n2 + i2 - (int)(3.0 * d3)] / 20.0;
                d2 -= 6.0 * dArray[n2 + i2 - (int)(2.0 * d3)] / 20.0;
                d2 += 15.0 * dArray[n2 + i2 - (int)d3] / 20.0;
                d2 += 15.0 * dArray[n2 + i2 + (int)d3] / 20.0;
                d2 -= 6.0 * dArray[n2 + i2 + (int)(2.0 * d3)] / 20.0;
                if (d5 < (d2 += dArray[n2 + i2 + (int)(3.0 * d3)] / 20.0)) {
                    d5 = d2;
                }
                if (d5 < d4) {
                    d5 = d4;
                }
                if (d5 < d6) {
                    d6 = d5;
                }
                dArray[i2] = d6;
            }
            if (n2 - n4 - n4 >= 0) {
                System.arraycopy(dArray, n4, dArray, n2 + n4, n2 - n4 - n4);
            }
            if (direction == Direction.INCREASING) {
                ++n4;
                continue;
            }
            --n4;
        } while (direction == Direction.INCREASING && n4 <= n3 || direction == Direction.DECREASING && n4 >= 1);
    }

    protected static void filterBackgroundOrder8(double[] dArray, int n2, int n3, Direction direction, SmoothWindow smoothWindow) {
        int n4 = direction == Direction.INCREASING ? 1 : n3;
        int n5 = (smoothWindow.getValue() - 1) / 2;
        do {
            for (int i2 = n4; i2 < n2 - n4; ++i2) {
                double d2;
                double d3;
                double d4;
                double d5;
                double d6;
                double d7;
                if (smoothWindow.isSmoothing()) {
                    d7 = dArray[n2 + i2];
                    d6 = 0.0;
                    d5 = 0.0;
                    for (int i3 = i2 - n5; i3 <= i2 + n5; ++i3) {
                        if (i3 < 0 || i3 >= n2) continue;
                        d6 += dArray[n2 + i3];
                        d5 += 1.0;
                    }
                    d6 /= d5;
                    d4 = 0.0;
                    d5 = 0.0;
                    for (int i4 = i2 - n4 - n5; i4 <= i2 - n4 + n5; ++i4) {
                        if (i4 < 0 || i4 >= n2) continue;
                        d4 += dArray[n2 + i4];
                        d5 += 1.0;
                    }
                    d4 /= d5;
                    d3 = 0.0;
                    d5 = 0.0;
                    for (int i5 = i2 + n4 - n5; i5 <= i2 + n4 + n5; ++i5) {
                        if (i5 < 0 || i5 >= n2) continue;
                        d3 += dArray[n2 + i5];
                        d5 += 1.0;
                    }
                    d4 = (d4 + (d3 /= d5)) / 2.0;
                    d2 = (double)n4 / 2.0;
                    double d8 = 0.0;
                    d5 = 0.0;
                    for (int i6 = i2 - (int)(2.0 * d2) - n5; i6 <= i2 - (int)(2.0 * d2) + n5; ++i6) {
                        if (i6 < 0 || i6 >= n2) continue;
                        d8 += dArray[n2 + i6];
                        d5 += 1.0;
                    }
                    d8 /= d5;
                    double d9 = 0.0;
                    d5 = 0.0;
                    for (int i7 = i2 - (int)d2 - n5; i7 <= i2 - (int)d2 + n5; ++i7) {
                        if (i7 < 0 || i7 >= n2) continue;
                        d9 += dArray[n2 + i7];
                        d5 += 1.0;
                    }
                    d9 /= d5;
                    double d10 = 0.0;
                    d5 = 0.0;
                    for (int i8 = i2 + (int)d2 - n5; i8 <= i2 + (int)d2 + n5; ++i8) {
                        if (i8 < 0 || i8 >= n2) continue;
                        d10 += dArray[n2 + i8];
                        d5 += 1.0;
                    }
                    d10 /= d5;
                    double d11 = 0.0;
                    d5 = 0.0;
                    for (int i9 = i2 + (int)(2.0 * d2) - n5; i9 <= i2 + (int)(2.0 * d2) + n5; ++i9) {
                        if (i9 < 0 || i9 >= n2) continue;
                        d11 += dArray[n2 + i9];
                        d5 += 1.0;
                    }
                    d8 = (-d8 + 4.0 * d9 + 4.0 * d10 - (d11 /= d5)) / 6.0;
                    d2 = (double)n4 / 3.0;
                    double d12 = 0.0;
                    d5 = 0.0;
                    for (int i10 = i2 - (int)(3.0 * d2) - n5; i10 <= i2 - (int)(3.0 * d2) + n5; ++i10) {
                        if (i10 < 0 || i10 >= n2) continue;
                        d12 += dArray[n2 + i10];
                        d5 += 1.0;
                    }
                    d12 /= d5;
                    double d13 = 0.0;
                    d5 = 0.0;
                    for (int i11 = i2 - (int)(2.0 * d2) - n5; i11 <= i2 - (int)(2.0 * d2) + n5; ++i11) {
                        if (i11 < 0 || i11 >= n2) continue;
                        d13 += dArray[n2 + i11];
                        d5 += 1.0;
                    }
                    d13 /= d5;
                    double d14 = 0.0;
                    d5 = 0.0;
                    for (int i12 = i2 - (int)d2 - n5; i12 <= i2 - (int)d2 + n5; ++i12) {
                        if (i12 < 0 || i12 >= n2) continue;
                        d14 += dArray[n2 + i12];
                        d5 += 1.0;
                    }
                    d14 /= d5;
                    double d15 = 0.0;
                    d5 = 0.0;
                    for (int i13 = i2 + (int)d2 - n5; i13 <= i2 + (int)d2 + n5; ++i13) {
                        if (i13 < 0 || i13 >= n2) continue;
                        d15 += dArray[n2 + i13];
                        d5 += 1.0;
                    }
                    d15 /= d5;
                    double d16 = 0.0;
                    d5 = 0.0;
                    for (int i14 = i2 + (int)(2.0 * d2) - n5; i14 <= i2 + (int)(2.0 * d2) + n5; ++i14) {
                        if (i14 < 0 || i14 >= n2) continue;
                        d16 += dArray[n2 + i14];
                        d5 += 1.0;
                    }
                    d16 /= d5;
                    double d17 = 0.0;
                    d5 = 0.0;
                    for (int i15 = i2 + (int)(3.0 * d2) - n5; i15 <= i2 + (int)(3.0 * d2) + n5; ++i15) {
                        if (i15 < 0 || i15 >= n2) continue;
                        d17 += dArray[n2 + i15];
                        d5 += 1.0;
                    }
                    d12 = (d12 - 6.0 * d13 + 15.0 * d14 + 15.0 * d15 - 6.0 * d16 + (d17 /= d5)) / 20.0;
                    d2 = (double)n4 / 4.0;
                    double d18 = 0.0;
                    d5 = 0.0;
                    for (int i16 = i2 - (int)(4.0 * d2) - n5; i16 <= i2 - (int)(4.0 * d2) + n5; ++i16) {
                        if (i16 < 0 || i16 >= n2) continue;
                        d18 += dArray[n2 + i16];
                        d5 += 1.0;
                    }
                    d18 /= d5;
                    double d19 = 0.0;
                    d5 = 0.0;
                    for (int i17 = i2 - (int)(3.0 * d2) - n5; i17 <= i2 - (int)(3.0 * d2) + n5; ++i17) {
                        if (i17 < 0 || i17 >= n2) continue;
                        d19 += dArray[n2 + i17];
                        d5 += 1.0;
                    }
                    d19 /= d5;
                    double d20 = 0.0;
                    d5 = 0.0;
                    for (int i18 = i2 - (int)(2.0 * d2) - n5; i18 <= i2 - (int)(2.0 * d2) + n5; ++i18) {
                        if (i18 < 0 || i18 >= n2) continue;
                        d20 += dArray[n2 + i18];
                        d5 += 1.0;
                    }
                    d20 /= d5;
                    double d21 = 0.0;
                    d5 = 0.0;
                    for (int i19 = i2 - (int)d2 - n5; i19 <= i2 - (int)d2 + n5; ++i19) {
                        if (i19 < 0 || i19 >= n2) continue;
                        d21 += dArray[n2 + i19];
                        d5 += 1.0;
                    }
                    d21 /= d5;
                    double d22 = 0.0;
                    d5 = 0.0;
                    for (int i20 = i2 + (int)d2 - n5; i20 <= i2 + (int)d2 + n5; ++i20) {
                        if (i20 < 0 || i20 >= n2) continue;
                        d22 += dArray[n2 + i20];
                        d5 += 1.0;
                    }
                    d22 /= d5;
                    double d23 = 0.0;
                    d5 = 0.0;
                    for (int i21 = i2 + (int)(2.0 * d2) - n5; i21 <= i2 + (int)(2.0 * d2) + n5; ++i21) {
                        if (i21 < 0 || i21 >= n2) continue;
                        d23 += dArray[n2 + i21];
                        d5 += 1.0;
                    }
                    d23 /= d5;
                    double d24 = 0.0;
                    d5 = 0.0;
                    for (int i22 = i2 + (int)(3.0 * d2) - n5; i22 <= i2 + (int)(3.0 * d2) + n5; ++i22) {
                        if (i22 < 0 || i22 >= n2) continue;
                        d24 += dArray[n2 + i22];
                        d5 += 1.0;
                    }
                    d24 /= d5;
                    double d25 = 0.0;
                    d5 = 0.0;
                    for (int i23 = i2 + (int)(4.0 * d2) - n5; i23 <= i2 + (int)(4.0 * d2) + n5; ++i23) {
                        if (i23 < 0 || i23 >= n2) continue;
                        d25 += dArray[n2 + i23];
                        d5 += 1.0;
                    }
                    if (d4 < (d18 = (-d18 + 8.0 * d19 - 28.0 * d20 + 56.0 * d21 - 56.0 * d22 - 28.0 * d23 + 8.0 * d24 - (d25 /= d5)) / 70.0)) {
                        d4 = d18;
                    }
                    if (d4 < d12) {
                        d4 = d12;
                    }
                    if (d4 < d8) {
                        d4 = d8;
                    }
                    if (d4 < d7) {
                        d6 = d4;
                    }
                    dArray[i2] = d6;
                    continue;
                }
                d7 = dArray[n2 + i2];
                d6 = (dArray[n2 + i2 - n4] + dArray[n2 + i2 + n4]) / 2.0;
                d5 = 0.0;
                d4 = (double)n4 / 2.0;
                d5 -= dArray[n2 + i2 - (int)(2.0 * d4)] / 6.0;
                d5 += 4.0 * dArray[n2 + i2 - (int)d4] / 6.0;
                d5 += 4.0 * dArray[n2 + i2 + (int)d4] / 6.0;
                d5 -= dArray[n2 + i2 + (int)(2.0 * d4)] / 6.0;
                d3 = 0.0;
                d4 = (double)n4 / 3.0;
                d3 += dArray[n2 + i2 - (int)(3.0 * d4)] / 20.0;
                d3 -= 6.0 * dArray[n2 + i2 - (int)(2.0 * d4)] / 20.0;
                d3 += 15.0 * dArray[n2 + i2 - (int)d4] / 20.0;
                d3 += 15.0 * dArray[n2 + i2 + (int)d4] / 20.0;
                d3 -= 6.0 * dArray[n2 + i2 + (int)(2.0 * d4)] / 20.0;
                d3 += dArray[n2 + i2 + (int)(3.0 * d4)] / 20.0;
                d2 = 0.0;
                d4 = (double)n4 / 4.0;
                d2 -= dArray[n2 + i2 - (int)(4.0 * d4)] / 70.0;
                d2 += 8.0 * dArray[n2 + i2 - (int)(3.0 * d4)] / 70.0;
                d2 -= 28.0 * dArray[n2 + i2 - (int)(2.0 * d4)] / 70.0;
                d2 += 56.0 * dArray[n2 + i2 - (int)d4] / 70.0;
                d2 += 56.0 * dArray[n2 + i2 + (int)d4] / 70.0;
                d2 -= 28.0 * dArray[n2 + i2 + (int)(2.0 * d4)] / 70.0;
                d2 += 8.0 * dArray[n2 + i2 + (int)(3.0 * d4)] / 70.0;
                if (d6 < (d2 -= dArray[n2 + i2 + (int)(4.0 * d4)] / 70.0)) {
                    d6 = d2;
                }
                if (d6 < d3) {
                    d6 = d3;
                }
                if (d6 < d5) {
                    d6 = d5;
                }
                if (d6 < d7) {
                    d7 = d6;
                }
                dArray[i2] = d7;
            }
            if (n2 - n4 - n4 >= 0) {
                System.arraycopy(dArray, n4, dArray, n2 + n4, n2 - n4 - n4);
            }
            if (direction == Direction.INCREASING) {
                ++n4;
                continue;
            }
            --n4;
        } while (direction == Direction.INCREASING && n4 <= n3 || direction == Direction.DECREASING && n4 >= 1);
    }

    public static List<DoublePoint> search(double[] dArray, double[] dArray2, double[] dArray3, int n3, int n4, double d2, double d3, boolean bl2, int n5, boolean bl3, int n6) {
        int n7;
        int n8;
        double d4;
        int n9;
        double d5;
        double d6;
        double d7;
        int n10;
        int n11;
        double d8;
        int n12;
        double d9;
        double d10;
        if (dArray == null || dArray2 == null) {
            throw new IllegalArgumentException("neither sourceX '" + (dArray == null ? "null" : "OK") + "' nor sourceY '" + (dArray2 == null ? "null" : "OK") + "' must be null");
        }
        if (dArray.length < n3) {
            throw new IllegalArgumentException("sourceX.length too short is '" + dArray.length + "' vs. should '" + n3 + "'");
        }
        if (dArray2.length < n3) {
            throw new IllegalArgumentException("sourceY.length too short is '" + dArray2.length + "' vs. should '" + n3 + "'");
        }
        if ((dArray3 == null || dArray3.length < n3) && LOGGER.isDebugEnabled()) {
            LOGGER.atDebug().addArgument(dArray3 == null ? Double.NaN : (double)dArray3.length).addArgument(n3).log("destination vector has insufficient length {} vs. {} needed, omitting copying background spectrum");
        }
        if (d2 < 1.0) {
            throw new IllegalArgumentException("Invalid sigma '" + d2 + "', must be greater than or equal to 1");
        }
        if (d3 <= 0.0 || d3 >= 100.0) {
            throw new IllegalArgumentException("invalid threshold '" + d3 + "', must be within ]0,100[");
        }
        if ((int)(5.0 * d2 + 0.5) >= 512) {
            throw new IllegalArgumentException("too large sigma");
        }
        if (bl3 && n6 <= 0) {
            throw new IllegalArgumentException("averanging window must be positive");
        }
        int n13 = (int)(7.0 * d2 + 0.5);
        if (bl2 && n3 < 2 * n13 + 1) {
            throw new IllegalArgumentException("too large clipping window");
        }
        int n14 = n3 + 2 * n13;
        int n15 = n13;
        int n16 = (int)(2.0 * d2 + 0.5);
        double d11 = 0.0;
        if (n16 >= 2) {
            double d12 = 0.0;
            double d13 = 0.0;
            d10 = 0.0;
            d9 = 0.0;
            for (int i2 = 0; i2 < n16; ++i2) {
                n12 = i2;
                double d14 = dArray2[i2];
                d12 += 1.0;
                d13 += (double)n12;
                d10 += (double)(n12 * n12);
                d9 += d14;
                d11 += (double)n12 * d14;
            }
            d8 = d12 * d10 - d13 * d13;
            d11 = d8 == 0.0 ? 0.0 : (-d9 * d13 + d11 * d12) / d8;
            if (d11 > 0.0) {
                d11 = 0.0;
            }
        } else {
            d11 = 0.0;
        }
        int n17 = (int)(7.0 * d2 + 0.5) * 2;
        double[] dArray4 = ArrayCache.getCachedDoubleArray(CACHED_ARRAY_SEARCH, 7 * (n3 + n17));
        ArrayUtils.fillArray(dArray4, 0.0);
        for (n11 = 0; n11 < n14; ++n11) {
            if (n11 < n15) {
                n10 = n11 - n15;
                dArray4[n11 + n14] = dArray2[0] + d11 * (double)n10;
                if (!(dArray4[n11 + n14] < 0.0)) continue;
                dArray4[n11 + n14] = 0.0;
                continue;
            }
            if (n11 >= n3 + n15) {
                dArray4[n11 + n14] = dArray2[n3 - 1];
                if (!(dArray4[n11 + n14] < 0.0)) continue;
                dArray4[n11 + n14] = 0.0;
                continue;
            }
            dArray4[n11 + n14] = dArray2[n11 - n15];
        }
        if (bl2) {
            for (n11 = 1; n11 <= n13; ++n11) {
                for (n10 = n11; n10 < n14 - n11; ++n10) {
                    if (bl3) {
                        d10 = dArray4[n14 + n10];
                        d9 = 0.0;
                        d8 = 0.0;
                        int n18 = Math.min(n6 / 2, 2);
                        for (int i3 = n10 - n18; i3 <= n10 + n18; ++i3) {
                            if (i3 < 0 || i3 >= n14) continue;
                            d9 += dArray4[n14 + i3];
                            d8 += 1.0;
                        }
                        d9 /= d8;
                        d7 = 0.0;
                        d8 = 0.0;
                        for (int i4 = n10 - n11 - n18; i4 <= n10 - n11 + n18; ++i4) {
                            if (i4 < 0 || i4 >= n14) continue;
                            d7 += dArray4[n14 + i4];
                            d8 += 1.0;
                        }
                        d7 /= d8;
                        d6 = 0.0;
                        d8 = 0.0;
                        for (int i5 = n10 + n11 - n18; i5 <= n10 + n11 + n18; ++i5) {
                            if (i5 < 0 || i5 >= n14) continue;
                            d6 += dArray4[n14 + i5];
                            d8 += 1.0;
                        }
                        if ((d7 = (d7 + (d6 /= d8)) / 2.0) < d10) {
                            d9 = d7;
                        }
                        dArray4[n10] = d9;
                        continue;
                    }
                    d9 = (dArray4[n14 + n10 - n11] + dArray4[n14 + n10 + n11]) / 2.0;
                    d10 = dArray4[n14 + n10];
                    if (d9 < d10) {
                        d10 = d9;
                    }
                    dArray4[n10] = d10;
                }
                if (n14 - n11 - n11 < 0) continue;
                System.arraycopy(dArray4, n11, dArray4, n14 + n11, n14 - n11 - n11);
            }
            for (n11 = 0; n11 < n14; ++n11) {
                if (n11 < n15) {
                    int n19 = n11 - n15;
                    d10 = dArray2[0] + d11 * (double)n19;
                    if (d10 < 0.0) {
                        d10 = 0.0;
                    }
                    dArray4[n14 + n11] = d10 - dArray4[n14 + n11];
                    continue;
                }
                if (n11 >= n3 + n15) {
                    double d15 = dArray2[n3 - 1];
                    if (d15 < 0.0) {
                        d15 = 0.0;
                    }
                    dArray4[n14 + n11] = d15 - dArray4[n14 + n11];
                    continue;
                }
                dArray4[n14 + n11] = dArray2[n11 - n15] - dArray4[n14 + n11];
            }
            for (n11 = 0; n11 < n14; ++n11) {
                if (!(dArray4[n14 + n11] < 0.0)) continue;
                dArray4[n14 + n11] = 0.0;
            }
        }
        if (n14 >= 0) {
            System.arraycopy(dArray4, 0 + n14, dArray4, 0 + 6 * n14, n14);
        }
        if (bl3) {
            int n20;
            if (n14 >= 0) {
                System.arraycopy(dArray4, n14 + 0, dArray4, 2 * n14 + 0, n14);
            }
            double d16 = 0.0;
            d10 = 0.0;
            for (int i6 = 0; i6 < n14; ++i6) {
                dArray4[i6] = 0.0;
                if (d16 < dArray4[2 * n14 + i6]) {
                    d16 = dArray4[2 * n14 + i6];
                }
                d10 += dArray4[2 * n14 + i6];
            }
            if (d16 == 0.0) {
                ArrayCache.release(CACHED_ARRAY_SEARCH, dArray4);
                return Collections.emptyList();
            }
            d9 = 1.0;
            boolean bl4 = false;
            n12 = n14 - 1;
            dArray4[0] = 1.0;
            for (n20 = 0; n20 < n12; ++n20) {
                d7 = dArray4[2 * n14 + n20] / d16;
                d6 = dArray4[2 * n14 + n20 + 1] / d16;
                double d17 = 0.0;
                d5 = 0.0;
                for (n9 = 1; n9 <= n6; ++n9) {
                    d4 = n20 + n9 > n12 ? dArray4[2 * n14 + n12] / d16 : dArray4[2 * n14 + n20 + n9] / d16;
                    double d18 = d4 - d7;
                    d4 = d4 + d7 <= 0.0 ? 1.0 : Math.sqrt(d4 + d7);
                    d18 /= d4;
                    d18 = Math.exp(d18);
                    d17 += d18;
                    d4 = n20 - n9 + 1 < 0 ? dArray4[2 * n14 + 0] / d16 : dArray4[2 * n14 + n20 - n9 + 1] / d16;
                    d18 = d4 - d6;
                    d4 = d4 + d6 <= 0.0 ? 1.0 : Math.sqrt(d4 + d6);
                    d18 /= d4;
                    d18 = Math.exp(d18);
                    d5 += d18;
                }
                d4 = d17 / d5;
                double d19 = dArray4[n20] * d4;
                dArray4[n20 + 1] = d19;
                d4 = d19;
                d9 += d4;
            }
            for (n20 = 0; n20 <= n12; ++n20) {
                dArray4[n20] = dArray4[n20] / d9;
            }
            for (n20 = 0; n20 < n14; ++n20) {
                dArray4[n14 + n20] = dArray4[n20] * d10;
            }
            System.arraycopy(dArray4, n14 + 0, dArray4, 2 * n14 + 0, n14);
            if (bl2) {
                for (n20 = 1; n20 <= n13; ++n20) {
                    for (int i7 = n20; i7 < n14 - n20; ++i7) {
                        double d20 = (dArray4[n14 + i7 - n20] + dArray4[n14 + i7 + n20]) / 2.0;
                        double d21 = dArray4[n14 + i7];
                        if (d20 < d21) {
                            d21 = d20;
                        }
                        dArray4[i7] = d21;
                    }
                    if (n14 - n20 - n20 < 0) continue;
                    System.arraycopy(dArray4, n20, dArray4, n14 + n20, n14 - n20 - n20);
                }
                for (n20 = 0; n20 < n14; ++n20) {
                    dArray4[n14 + n20] = dArray4[2 * n14 + n20] - dArray4[n14 + n20];
                }
            }
        }
        double d22 = 0.0;
        int n21 = -1;
        int n22 = 0;
        d9 = 0.0;
        for (n8 = 0; n8 < n14; ++n8) {
            double d23 = (double)n8 - 3.0 * d2;
            d23 = d23 * d23 / (2.0 * d2 * d2);
            if ((d23 = (double)((int)(1000.0 * Math.exp(-d23)))) != 0.0) {
                n21 = n8 + 1;
            }
            dArray4[n8] = d23;
            d22 += d23;
            if (!(d23 > d9)) continue;
            d9 = d23;
            n22 = n8;
        }
        for (n8 = 0; n8 < n14; ++n8) {
            dArray4[2 * n14 + n8] = Math.abs(dArray4[n14 + n8]);
        }
        n8 = n21 - 1;
        if (n8 > n14) {
            n8 = n14;
        }
        for (n7 = -n8; n7 <= n8; ++n7) {
            int n23;
            double d24 = 0.0;
            int n24 = 0;
            if (n7 < 0) {
                n24 = -n7;
            }
            if ((n23 = n21 - 1 - n7) > n21 - 1) {
                n23 = n21 - 1;
            }
            for (int i8 = n24; i8 <= n23; ++i8) {
                double d25 = dArray4[i8];
                d5 = dArray4[n7 + i8];
                d24 += d25 * d5;
            }
            dArray4[n14 + n7 + n8] = d24;
        }
        n8 = n21 - 1;
        for (n7 = -n8; n7 <= n14 + n8 - 1; ++n7) {
            double d26 = 0.0;
            for (int i9 = 0; i9 <= n21 - 1; ++i9) {
                double d27 = dArray4[i9];
                int n25 = n7 + i9;
                if (n25 < 0 || n25 >= n14) continue;
                double d28 = dArray4[2 * n14 + n25];
                d26 += d27 * d28;
            }
            dArray4[4 * n14 + n7 + n8] = d26;
        }
        for (n7 = -n8; n7 <= n14 + n8 - 1; ++n7) {
            dArray4[2 * n14 + n7 + n8] = dArray4[4 * n14 + n7 + n8];
        }
        for (n8 = 0; n8 < n14; ++n8) {
            dArray4[n8] = 1.0;
        }
        for (n8 = 0; n8 < n5; ++n8) {
            for (n7 = 0; n7 < n14; ++n7) {
                if (!(Math.abs(dArray4[2 * n14 + n7]) > 1.0E-5) || !(Math.abs(dArray4[n7]) > 1.0E-5)) continue;
                double d29 = 0.0;
                int n26 = n21 - 1;
                if (n26 > n7) {
                    n26 = n7;
                }
                n26 = -n26;
                int n27 = n21 - 1;
                if (n27 > n14 - 1 - n7) {
                    n27 = n14 - 1 - n7;
                }
                for (int i10 = n26; i10 <= n27; ++i10) {
                    double d30 = dArray4[i10 + n21 - 1 + n14];
                    d5 = dArray4[n7 + i10];
                    d29 += d30 * d5;
                }
                double d31 = dArray4[2 * n14 + n7];
                if (d29 != 0.0) {
                    d29 = d31 / d29;
                }
                d31 = dArray4[n7];
                dArray4[3 * n14 + n7] = d29 *= d31;
            }
            if (n14 < 0) continue;
            System.arraycopy(dArray4, 3 * n14 + 0, dArray4, 0, n14);
        }
        for (n8 = 0; n8 < n14; ++n8) {
            n7 = (n8 + n22) % n14;
            dArray4[n14 + n7] = dArray4[n8];
        }
        d9 = 0.0;
        double d32 = 0.0;
        int n28 = n21 - 1;
        for (int i11 = 0; i11 < n14 - n28; ++i11) {
            if (i11 >= n15 && i11 < n3 + n15) {
                dArray4[i11] = d22 * dArray4[n14 + i11 + n28];
                if (d32 < dArray4[i11]) {
                    d32 = dArray4[i11];
                }
                if (!(d9 < dArray4[6 * n14 + i11])) continue;
                d9 = dArray4[6 * n14 + i11];
                continue;
            }
            dArray4[i11] = 0.0;
        }
        double d33 = 1.0;
        if (d33 > d3) {
            d33 = d3;
        }
        d33 /= 100.0;
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        int n29 = 0;
        for (int i12 = 1; i12 < n14 - 1; ++i12) {
            int n30;
            boolean bl5;
            boolean bl6 = bl5 = dArray4[i12] > dArray4[i12 - 1] && dArray4[i12] > dArray4[i12 + 1] && i12 >= n15 && i12 < n3 + n15 && dArray4[i12] > d33 * d32 && dArray4[6 * n14 + i12] > d3 * d9 / 100.0;
            if (!bl5) continue;
            d5 = 0.0;
            d4 = 0.0;
            for (n9 = i12 - 1; n9 <= i12 + 1; ++n9) {
                d5 += (double)(n9 - n15) * dArray4[n9];
                d4 += dArray4[n9];
            }
            if ((d5 /= d4) < 0.0) {
                d5 = 0.0;
            }
            if (d5 >= (double)n3) {
                d5 = (double)n3 - 1.0;
            }
            if (n29 == 0) {
                arrayList.add((int)d5);
                n29 = 1;
                continue;
            }
            n9 = 0;
            for (n30 = 0; n30 < n29 && n9 == 0; ++n30) {
                if (!(dArray4[6 * n14 + n15 + (int)d5] > dArray4[6 * n14 + n15 + (Integer)arrayList.get(n30)])) continue;
                n9 = 1;
            }
            if (n9 == 0) {
                if (n30 < n4) {
                    if (arrayList.size() > n30) {
                        arrayList.set(n30, (int)d5);
                    } else {
                        arrayList.add((int)d5);
                    }
                }
            } else {
                for (int i13 = n29; i13 >= n30; --i13) {
                    if (i13 >= n4) continue;
                    Integer n31 = (Integer)arrayList.get(i13 - 1);
                    if (arrayList.size() > i13) {
                        arrayList.set(i13, n31);
                        continue;
                    }
                    arrayList.add(n31);
                }
                arrayList.set(n30 - 1, (int)d5);
            }
            if (n29 >= n4) continue;
            ++n29;
        }
        if (dArray3 != null && dArray3.length >= n3) {
            System.arraycopy(dArray4, n15, dArray3, 0, n3);
        }
        ArrayCache.release(CACHED_ARRAY_SEARCH, dArray4);
        if (n29 == n4 && LOGGER.isWarnEnabled()) {
            LOGGER.atWarn().addArgument(n4).log("maximum specified number of peaks limit reached {}");
        }
        return arrayList.stream().map(n2 -> new DoublePoint(dArray[n2], dArray2[n2])).collect(Collectors.toList());
    }

    public static double[] smoothMarkov(double[] dArray, double[] dArray2, int n2, int n3) {
        if (dArray == null || dArray.length < n2) {
            throw new IllegalArgumentException("source must not be null or length smaller than '" + n2 + "'");
        }
        if (n3 <= 0) {
            throw new IllegalArgumentException("averaging window must be positive");
        }
        double[] dArray3 = ArrayCache.getCachedDoubleArray(CACHED_ARRAY_SMOOTH_MARKOV, n2);
        ArrayUtils.fillArray(dArray3, 0.0);
        double d2 = Math.maximum(dArray, n2);
        if (d2 == -1.7976931348623157E308) {
            throw new IllegalArgumentException("source vector is not finite, could not find maximum");
        }
        double d3 = Math.minimum(dArray, n2);
        if (d3 == Double.MAX_VALUE) {
            throw new IllegalArgumentException("source vector is not finite, could not find minimum");
        }
        boolean bl2 = false;
        int n4 = n2 - 1;
        double d4 = 1.0;
        dArray3[0] = 1.0;
        for (int i2 = 0; i2 < n4; ++i2) {
            double d5;
            double d6 = dArray[i2] / d2;
            double d7 = dArray[i2 + 1] / d2;
            double d8 = 0.0;
            double d9 = 0.0;
            for (int i3 = 1; i3 <= n3; ++i3) {
                d5 = i2 + i3 > n4 ? dArray[n4] / d2 : dArray[i2 + i3] / d2;
                double d10 = d5 - d6;
                d5 = d5 + d6 <= 0.0 ? 1.0 : Math.sqrt(d5 + d6);
                d10 /= d5;
                d10 = Math.exp(d10);
                d8 += d10;
                d5 = i2 - i3 + 1 < 0 ? dArray[0] / d2 : dArray[i2 - i3 + 1] / d2;
                d10 = d5 - d7;
                d5 = d5 + d7 <= 0.0 ? 1.0 : Math.sqrt(d5 + d7);
                d10 /= d5;
                d10 = Math.exp(d10);
                d9 += d10;
            }
            d5 = d8 / d9;
            double d11 = dArray3[i2] * d5;
            dArray3[i2 + 1] = d11;
            d5 = d11;
            d4 += d5;
        }
        double d12 = 0.0;
        for (int i4 = 0; i4 < n2; ++i4) {
            d12 += dArray[i4];
        }
        ArrayMath.multiplyInPlace(dArray3, d12 / d4);
        ArrayCache.release(CACHED_ARRAY_SMOOTH_MARKOV, dArray3);
        double[] dArray4 = dArray2 == null || dArray2.length < n2 ? new double[n2] : dArray2;
        System.arraycopy(dArray3, 0, dArray4, 0, n2);
        return dArray4;
    }

    public static double[] unfolding(double[] dArray, double[][] dArray2, double[] dArray3, int n2, int n3, int n4, int n5, double d2) {
        double d3;
        double d4;
        double d5;
        double d6;
        int n6;
        double d7;
        int n7;
        AssertUtils.gtThanZero("lengthx", n2);
        AssertUtils.gtThanZero("lengthy", n3);
        if (n2 < n3) {
            throw new IllegalArgumentException("lengthx:" + n2 + " must be greater than lengthy" + n2 + "<=0");
        }
        AssertUtils.gtThanZero("numberIterations", n4);
        int n8 = n2 * n3 + 2 * n3 * n3 + 4 * n2;
        double[] dArray4 = ArrayCache.getCachedDoubleArray(CACHED_ARRAY_UNFOLDING, n8);
        int n9 = 0;
        for (n7 = 0; n7 < n3 && n9 != -1; ++n7) {
            d7 = 0.0;
            n9 = -1;
            for (n6 = 0; n6 < n2; ++n6) {
                double d8 = dArray2[n7][n6];
                if (d8 != 0.0) {
                    n9 = n6 + 1;
                }
                dArray4[n7 * n2 + n6] = d8;
                d7 += d8;
            }
            if (n9 == -1) continue;
            for (n6 = 0; n6 < n2; ++n6) {
                int n10 = n7 * n2 + n6;
                dArray4[n10] = dArray4[n10] / d7;
            }
        }
        if (n9 == -1) {
            throw new IllegalArgumentException("ZERO COLUMN IN RESPONSE MATRIX");
        }
        for (n7 = 0; n7 < n2; ++n7) {
            dArray4[n2 * n3 + 2 * n3 * n3 + 2 * n2 + n7] = dArray[n7];
        }
        for (n7 = 0; n7 < n3; ++n7) {
            for (int i2 = 0; i2 < n3; ++i2) {
                d6 = 0.0;
                for (int i3 = 0; i3 < n2; ++i3) {
                    d5 = dArray4[n2 * n7 + i3];
                    d4 = dArray4[n2 * i2 + i3];
                    d6 += d5 * d4;
                }
                dArray4[n2 * n3 + n3 * n7 + i2] = d6;
            }
            d7 = 0.0;
            for (n6 = 0; n6 < n2; ++n6) {
                double d9 = dArray4[n2 * n7 + n6];
                d3 = dArray4[n2 * n3 + 2 * n3 * n3 + 2 * n2 + n6];
                d7 += d9 * d3;
            }
            dArray4[n2 * n3 + 2 * n3 * n3 + 3 * n2 + n7] = d7;
        }
        for (n7 = 0; n7 < n3; ++n7) {
            dArray4[n2 * n3 + 2 * n3 * n3 + 2 * n2 + n7] = dArray4[n2 * n3 + 2 * n3 * n3 + 3 * n2 + n7];
        }
        for (n7 = 0; n7 < n3; ++n7) {
            for (int i4 = 0; i4 < n3; ++i4) {
                d6 = 0.0;
                for (int i5 = 0; i5 < n3; ++i5) {
                    d5 = dArray4[n2 * n3 + n3 * n7 + i5];
                    d4 = dArray4[n2 * n3 + n3 * i4 + i5];
                    d6 += d5 * d4;
                }
                dArray4[n2 * n3 + n3 * n3 + n3 * n7 + i4] = d6;
            }
            d7 = 0.0;
            for (n6 = 0; n6 < n3; ++n6) {
                double d10 = dArray4[n2 * n3 + n3 * n7 + n6];
                d3 = dArray4[n2 * n3 + 2 * n3 * n3 + 2 * n2 + n6];
                d7 += d10 * d3;
            }
            dArray4[n2 * n3 + 2 * n3 * n3 + 3 * n2 + n7] = d7;
        }
        for (n7 = 0; n7 < n3; ++n7) {
            dArray4[n2 * n3 + 2 * n3 * n3 + 2 * n2 + n7] = dArray4[n2 * n3 + 2 * n3 * n3 + 3 * n2 + n7];
        }
        for (n7 = 0; n7 < n3; ++n7) {
            dArray4[n2 * n3 + 2 * n3 * n3 + n7] = 1.0;
        }
        for (n7 = 0; n7 < n5; ++n7) {
            int n11;
            if (n7 != 0) {
                for (n11 = 0; n11 < n3; ++n11) {
                    dArray4[n2 * n3 + 2 * n3 * n3 + n11] = Math.pow(dArray4[n2 * n3 + 2 * n3 * n3 + n11], d2);
                }
            }
            for (n11 = 0; n11 < n4; ++n11) {
                int n12;
                for (n12 = 0; n12 < n3; ++n12) {
                    double d11 = 0.0;
                    for (int i6 = 0; i6 < n3; ++i6) {
                        d3 = dArray4[n2 * n3 + n3 * n3 + n3 * n12 + i6];
                        double d12 = dArray4[n2 * n3 + 2 * n3 * n3 + i6];
                        d11 += d3 * d12;
                    }
                    d5 = dArray4[n2 * n3 + 2 * n3 * n3 + 2 * n2 + n12];
                    if (d11 != 0.0) {
                        d11 = d5 / d11;
                    }
                    d4 = dArray4[n2 * n3 + 2 * n3 * n3 + n12];
                    dArray4[n2 * n3 + 2 * n3 * n3 + 3 * n2 + n12] = d11 *= d4;
                }
                for (n12 = 0; n12 < n3; ++n12) {
                    dArray4[n2 * n3 + 2 * n3 * n3 + n12] = dArray4[n2 * n3 + 2 * n3 * n3 + 3 * n2 + n12];
                }
            }
        }
        double[] dArray5 = dArray3 == null || dArray3.length < dArray.length ? new double[dArray.length] : dArray3;
        for (int i7 = 0; i7 < n2; ++i7) {
            dArray5[i7] = i7 < n3 ? dArray4[n2 * n3 + 2 * n3 * n3 + i7] : 0.0;
        }
        ArrayCache.release(CACHED_ARRAY_UNFOLDING, dArray4);
        return dArray5;
    }

    public static enum FilterOrder {
        ORDER_2,
        ORDER_4,
        ORDER_6,
        ORDER_8;

    }

    public static enum Direction {
        INCREASING,
        DECREASING;

    }

    public static enum SmoothWindow {
        NO_SMOOTHING(1),
        SMOOTHING_WIDTH3(3),
        SMOOTHING_WIDTH5(5),
        SMOOTHING_WIDTH7(7),
        SMOOTHING_WIDTH9(9),
        SMOOTHING_WIDTH11(11),
        SMOOTHING_WIDTH13(13),
        SMOOTHING_WIDTH15(15);

        private final int value;

        private SmoothWindow(int n3) {
            this.value = n3;
        }

        public int getValue() {
            return this.value;
        }

        public boolean isSmoothing() {
            return !this.equals((Object)NO_SMOOTHING);
        }
    }
}

