/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.math.spectra;

import io.fair_acc.dataset.DataSet;
import io.fair_acc.dataset.GridDataSet;
import io.fair_acc.dataset.spi.DataSetBuilder;
import io.fair_acc.dataset.spi.DoubleGridDataSet;
import io.fair_acc.dataset.spi.MultiDimDoubleDataSet;
import io.fair_acc.dataset.utils.AssertUtils;
import io.fair_acc.dataset.utils.DoubleArrayCache;
import io.fair_acc.math.spectra.Apodization;
import io.fair_acc.math.spectra.SpectrumTools;
import java.util.Arrays;
import org.jtransforms.fft.DoubleFFT_1D;

public class ShortTimeFourierTransform {
    protected static void apodizeComplex(double[] dArray, Apodization apodization) {
        double[] dArray2 = apodization.getWindow(dArray.length / 2);
        for (int i2 = 0; i2 < dArray.length / 2; ++i2) {
            dArray[2 * i2] = dArray[2 * i2] * dArray2[i2];
            dArray[2 * i2 + 1] = dArray[2 * i2 + 1] * dArray2[i2];
        }
    }

    private static int ceilDiv(int n2, int n3) {
        return (n2 + n3 - 1) / n3;
    }

    public static GridDataSet complex(DataSet dataSet, GridDataSet gridDataSet, int n2, int n3, Apodization apodization, Padding padding, boolean bl2, boolean bl3) {
        AssertUtils.notNull("input", dataSet);
        AssertUtils.gtThanZero("nFFT", n2);
        AssertUtils.gtThanZero("step", n3);
        AssertUtils.notNull("apodization", apodization);
        AssertUtils.notNull("padding", padding);
        AssertUtils.gtOrEqual("input.getDimension()", 3, dataSet.getDimension());
        if (dataSet.getDataCount() == 0) {
            if (gridDataSet instanceof DoubleGridDataSet) {
                ((DoubleGridDataSet)gridDataSet).clearData();
                ((DoubleGridDataSet)gridDataSet).clearMetaInfo();
                return gridDataSet;
            }
            return new DoubleGridDataSet(ShortTimeFourierTransform.getStftName(dataSet), false, new double[2][0], (double[][])new double[][]{new double[0]});
        }
        int n4 = dataSet.getDataCount();
        double d2 = (dataSet.get(0, n4 - 1) - dataSet.get(0, 0)) / (double)Math.max(n4, 1);
        double[] dArray = dataSet.getValues(1);
        double[] dArray2 = dataSet.getValues(2);
        double[] dArray3 = gridDataSet == null ? null : gridDataSet.getValues(0);
        double[] dArray4 = ShortTimeFourierTransform.getTimeAxis(d2, n4, n3, dArray3);
        double[] dArray5 = gridDataSet == null ? null : gridDataSet.getValues(1);
        double[] dArray6 = ShortTimeFourierTransform.getFrequencyAxisComplex(d2, n2, dArray5);
        double[] dArray7 = gridDataSet instanceof MultiDimDoubleDataSet ? gridDataSet.getValues(2) : null;
        double[] dArray8 = ShortTimeFourierTransform.complex(dArray, dArray2, dArray7, n2, n3, apodization, padding, bl2, bl3);
        DoubleGridDataSet doubleGridDataSet = gridDataSet instanceof DoubleGridDataSet ? (DoubleGridDataSet)gridDataSet : new DataSetBuilder(ShortTimeFourierTransform.getStftName(dataSet)).setValues(0, dArray6).setValues(1, dArray4).setValues(2, dArray8).build(DoubleGridDataSet.class);
        doubleGridDataSet.lock().writeLockGuard(() -> {
            if (dArray3 != dArray4 || dArray5 != dArray6 || dArray7 != dArray8) {
                doubleGridDataSet.set(false, new double[][]{dArray6, dArray4}, new double[][]{dArray8});
            }
            doubleGridDataSet.getMetaInfo().put("ComplexSTFT-nFFT", Integer.toString(n2));
            doubleGridDataSet.getMetaInfo().put("ComplexSTFT-step", Integer.toString(n3));
            String string = dataSet.getAxisDescription(0).getUnit();
            Object object = string.equals("s") ? "Hz" : "1/" + string;
            doubleGridDataSet.getAxisDescription(0).set("Frequency", (String)object, dArray6[0], dArray6[dArray6.length - 1]);
            doubleGridDataSet.getAxisDescription(1).set("Time", string, dArray4[0], dArray4[dArray4.length - 1]);
            doubleGridDataSet.getAxisDescription(2).set("Magnitude", dataSet.getAxisDescription(1).getUnit());
            doubleGridDataSet.recomputeLimits(2);
        });
        return doubleGridDataSet;
    }

    private static String getStftName(DataSet dataSet) {
        return "STFT(" + dataSet.getName() + ")";
    }

    public static double[] complex(double[] dArray, double[] dArray2, double[] dArray3, int n2, int n3, Apodization apodization, Padding padding, boolean bl2, boolean bl3) {
        AssertUtils.equalDoubleArrays(dArray, dArray2);
        int n4 = ShortTimeFourierTransform.ceilDiv(dArray.length, n3);
        double[] dArray4 = dArray3 == null || dArray3.length != n2 * n4 ? new double[n2 * n4] : dArray3;
        double[] dArray5 = DoubleArrayCache.getInstance().getArray(n2);
        DoubleFFT_1D doubleFFT_1D = new DoubleFFT_1D((long)n2);
        double[] dArray6 = DoubleArrayCache.getInstance().getArrayExact(2 * n2);
        for (int i2 = 0; i2 < n4; ++i2) {
            int n5 = i2 * n3;
            int n6 = dArray.length - n5;
            block5: for (int i3 = 0; i3 < n2; ++i3) {
                if (n5 + i3 < dArray.length) {
                    dArray6[2 * i3] = dArray[n5 + i3];
                    dArray6[2 * i3 + 1] = dArray2[n5 + i3];
                    continue;
                }
                switch (padding) {
                    case MIRROR: {
                        dArray6[2 * i3] = dArray[dArray.length - i3 + n6 - 1];
                        dArray6[2 * i3 + 1] = dArray2[dArray2.length - i3 + n6 - 1];
                        continue block5;
                    }
                    case ZERO: {
                        Arrays.fill(dArray6, 2 * i3, 2 * n2, 0.0);
                        break block5;
                    }
                    default: {
                        dArray6[2 * i3] = dArray[dArray.length - 1];
                        dArray6[2 * i3 + 1] = dArray2[dArray2.length - 1];
                    }
                }
            }
            ShortTimeFourierTransform.apodizeComplex(dArray6, apodization);
            doubleFFT_1D.complexForward(dArray6);
            if (bl2) {
                SpectrumTools.computeMagnitudeSpectrum_dB(dArray6, 0, 2 * n2, dArray5, 0, bl3);
            } else {
                SpectrumTools.computeMagnitudeSpectrum(dArray6, 0, 2 * n2, dArray5, 0, bl3);
            }
            System.arraycopy(dArray5, 0, dArray4, i2 * n2 + n2 / 2, n2 / 2);
            System.arraycopy(dArray5, n2 / 2, dArray4, i2 * n2, n2 / 2);
        }
        DoubleArrayCache.getInstance().add(dArray5);
        DoubleArrayCache.getInstance().add(dArray6);
        return dArray4;
    }

    public static double[] complex(double[] dArray, double[] dArray2, int n2, int n3, Apodization apodization, Padding padding, boolean bl2, boolean bl3) {
        int n4 = ShortTimeFourierTransform.ceilDiv(dArray.length, 2 * n3);
        double[] dArray3 = dArray2 == null || dArray2.length != n2 * n4 ? new double[n2 * n4] : dArray2;
        double[] dArray4 = DoubleArrayCache.getInstance().getArray(n2);
        DoubleFFT_1D doubleFFT_1D = new DoubleFFT_1D((long)n2);
        double[] dArray5 = DoubleArrayCache.getInstance().getArrayExact(2 * n2);
        for (int i2 = 0; i2 < n4; ++i2) {
            int n5 = i2 * 2 * n3;
            int n6 = dArray.length - n5;
            if (n6 >= 2 * n2) {
                System.arraycopy(dArray, n5, dArray5, 0, 2 * n2);
            } else {
                System.arraycopy(dArray, n5, dArray5, 0, n6);
                switch (padding) {
                    case MIRROR: {
                        int n7 = n6;
                        while (n7 + 1 < dArray5.length) {
                            dArray5[n7] = dArray[dArray.length - n7 + n6 - 2];
                            dArray5[n7 + 1] = dArray[dArray.length - n7 + n6 - 1];
                            n7 += 2;
                        }
                        break;
                    }
                    case ZERO: {
                        Arrays.fill(dArray5, n6, dArray5.length, 0.0);
                        break;
                    }
                    default: {
                        int n7 = n6;
                        while (n7 + 1 < dArray5.length) {
                            dArray5[n7] = dArray[dArray.length - 2];
                            dArray5[n7 + 1] = dArray[dArray.length - 1];
                            n7 += 2;
                        }
                        break block0;
                    }
                }
            }
            ShortTimeFourierTransform.apodizeComplex(dArray5, apodization);
            doubleFFT_1D.complexForward(dArray5);
            if (bl2) {
                SpectrumTools.computeMagnitudeSpectrum_dB(dArray5, 0, 2 * n2, dArray4, 0, bl3);
            } else {
                SpectrumTools.computeMagnitudeSpectrum(dArray5, 0, 2 * n2, dArray4, 0, bl3);
            }
            System.arraycopy(dArray4, 0, dArray3, i2 * n2 + n2 / 2, n2 / 2);
            System.arraycopy(dArray4, n2 / 2, dArray3, i2 * n2, n2 / 2);
        }
        DoubleArrayCache.getInstance().add(dArray4);
        DoubleArrayCache.getInstance().add(dArray5);
        return dArray3;
    }

    public static double[] getFrequencyAxisComplex(double d2, int n2, double[] dArray) {
        double d3 = 1.0 / d2 / (double)n2;
        double[] dArray2 = dArray == null || dArray.length != n2 ? new double[n2] : dArray;
        for (int i2 = -n2 / 2; i2 < n2 / 2; ++i2) {
            dArray2[i2 + n2 / 2] = (double)i2 * d3;
        }
        return dArray2;
    }

    public static double[] getFrequencyAxisReal(double d2, int n2, double[] dArray) {
        double d3 = 1.0 / d2 / (double)n2;
        double[] dArray2 = dArray == null || dArray.length != n2 / 2 ? new double[n2 / 2] : dArray;
        for (int i2 = 0; i2 < n2 / 2; ++i2) {
            dArray2[i2] = (double)i2 * d3;
        }
        return dArray2;
    }

    public static double[] getTimeAxis(double d2, int n2, int n3, double[] dArray) {
        int n4 = ShortTimeFourierTransform.ceilDiv(n2, n3);
        double[] dArray2 = dArray == null || dArray.length != n4 ? new double[n4] : dArray;
        for (int i2 = 0; i2 < dArray2.length; ++i2) {
            dArray2[i2] = d2 * (double)i2 * (double)n3;
        }
        return dArray2;
    }

    public static GridDataSet real(DataSet dataSet, GridDataSet gridDataSet, int n2, int n3, Apodization apodization, Padding padding, boolean bl2, boolean bl3) {
        AssertUtils.notNull("input", dataSet);
        AssertUtils.gtThanZero("nFFT", n2);
        AssertUtils.gtThanZero("step", n3);
        AssertUtils.notNull("apodization", apodization);
        AssertUtils.notNull("padding", padding);
        AssertUtils.gtOrEqual("input.getDimension()", 2, dataSet.getDimension());
        if (dataSet.getDataCount() == 0) {
            if (gridDataSet instanceof DoubleGridDataSet) {
                ((DoubleGridDataSet)gridDataSet).clearData();
                ((DoubleGridDataSet)gridDataSet).clearMetaInfo();
                return gridDataSet;
            }
            return new DoubleGridDataSet(ShortTimeFourierTransform.getStftName(dataSet), false, new double[2][0], (double[][])new double[][]{new double[0]});
        }
        int n4 = dataSet.getDataCount();
        double d2 = (dataSet.get(0, n4 - 1) - dataSet.get(0, 0)) / (double)Math.max(n4, 1);
        double[] dArray = dataSet.getValues(1);
        double[] dArray2 = gridDataSet == null ? null : gridDataSet.getValues(0);
        double[] dArray3 = ShortTimeFourierTransform.getTimeAxis(d2, n4, n3, dArray2);
        double[] dArray4 = gridDataSet == null ? null : gridDataSet.getValues(1);
        double[] dArray5 = ShortTimeFourierTransform.getFrequencyAxisReal(d2, n2, dArray4);
        double[] dArray6 = gridDataSet instanceof MultiDimDoubleDataSet ? gridDataSet.getValues(2) : null;
        double[] dArray7 = ShortTimeFourierTransform.real(dArray, dArray6, n2, n3, apodization, padding, bl2, bl3);
        DoubleGridDataSet doubleGridDataSet = gridDataSet instanceof DoubleGridDataSet ? (DoubleGridDataSet)gridDataSet : new DataSetBuilder(ShortTimeFourierTransform.getStftName(dataSet)).setValues(0, dArray5).setValues(1, dArray3).setValues(2, dArray7).build(DoubleGridDataSet.class);
        doubleGridDataSet.lock().writeLockGuard(() -> {
            if (dArray2 != dArray3 || dArray4 != dArray5 || dArray6 != dArray7) {
                doubleGridDataSet.set(false, new double[][]{dArray5, dArray3}, new double[][]{dArray7});
            }
            doubleGridDataSet.getMetaInfo().put("RealSTFT-nFFT", Integer.toString(n2));
            doubleGridDataSet.getMetaInfo().put("RealSTFT-step", Integer.toString(n3));
            String string = dataSet.getAxisDescription(0).getUnit();
            Object object = string.equals("s") ? "Hz" : "1/" + string;
            doubleGridDataSet.getAxisDescription(0).set("Frequency", (String)object, dArray5[0], dArray5[dArray5.length - 1]);
            doubleGridDataSet.getAxisDescription(1).set("Time", string, dArray3[0], dArray3[dArray3.length - 1]);
            doubleGridDataSet.getAxisDescription(2).set("Magnitude", dataSet.getAxisDescription(1).getUnit());
            doubleGridDataSet.recomputeLimits(2);
        });
        return doubleGridDataSet;
    }

    public static double[] real(double[] dArray, double[] dArray2, int n2, int n3, Apodization apodization, Padding padding, boolean bl2, boolean bl3) {
        int n4 = ShortTimeFourierTransform.ceilDiv(dArray.length, n3);
        double[] dArray3 = dArray2 == null || dArray2.length != n2 / 2 * n4 ? new double[n2 / 2 * n4] : dArray2;
        double[] dArray4 = DoubleArrayCache.getInstance().getArray(n2 / 2);
        DoubleFFT_1D doubleFFT_1D = new DoubleFFT_1D((long)n2);
        double[] dArray5 = DoubleArrayCache.getInstance().getArrayExact(n2);
        for (int i2 = 0; i2 < n4; ++i2) {
            int n5 = i2 * n3;
            int n6 = dArray.length - n5;
            if (n6 >= n2) {
                System.arraycopy(dArray, n5, dArray5, 0, n2);
            } else {
                System.arraycopy(dArray, n5, dArray5, 0, n6);
                switch (padding) {
                    case MIRROR: {
                        for (int i3 = n6; i3 < dArray5.length; ++i3) {
                            dArray5[i3] = dArray[dArray.length - i3 + n6 - 1];
                        }
                        break;
                    }
                    case ZERO: {
                        Arrays.fill(dArray5, n6, dArray5.length, 0.0);
                        break;
                    }
                    default: {
                        Arrays.fill(dArray5, n6, dArray5.length, dArray[dArray.length - 1]);
                    }
                }
            }
            apodization.apodize(dArray5);
            doubleFFT_1D.realForward(dArray5);
            if (bl2) {
                SpectrumTools.computeMagnitudeSpectrum_dB(dArray5, 0, n2, dArray4, 0, bl3);
            } else {
                SpectrumTools.computeMagnitudeSpectrum(dArray5, 0, n2, dArray4, 0, bl3);
            }
            System.arraycopy(dArray4, 0, dArray3, i2 * n2 / 2, n2 / 2);
        }
        DoubleArrayCache.getInstance().add(dArray4);
        DoubleArrayCache.getInstance().add(dArray5);
        return dArray3;
    }

    public static enum Padding {
        ZERO,
        ZOH,
        MIRROR;

    }
}

