/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.math.spectra;

import io.fair_acc.math.MathBase;
import io.fair_acc.math.spectra.Convolution;
import io.fair_acc.math.utils.ConcurrencyUtils;

public class HilbertTransform
extends Convolution {
    public double[] computeAmplitude(double[] dArray) {
        int n2 = dArray.length;
        double[] dArray2 = this.transformFourier(dArray);
        double[] dArray3 = new double[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            double d2 = dArray2[i2];
            double d3 = dArray[i2];
            dArray3[i2] = Math.sqrt(MathBase.sqr(d2) + MathBase.sqr(d3));
        }
        return dArray3;
    }

    public double[] computeInstantaneousAmplitude(double[] dArray) {
        int n2 = dArray.length;
        double[] dArray2 = this.computeAmplitude(dArray);
        double[] dArray3 = Convolution.getLowPassFilter(ConcurrencyUtils.nextPow2(3 * n2), 0.4);
        Convolution.complexMultiply(dArray3, dArray3);
        return this.transform(dArray2, dArray3, false);
    }

    public double[] computeInstantaneousFrequency(double[] dArray) {
        int n2 = dArray.length;
        double[] dArray2 = this.computePhase(dArray);
        double[] dArray3 = Convolution.getDerivativeFilter(ConcurrencyUtils.nextPow2(3 * n2));
        double[] dArray4 = this.transform(dArray2, dArray3, false);
        for (int i2 = 1; i2 < dArray4.length - 1; ++i2) {
            int n3 = i2;
            dArray4[n3] = dArray4[n3] / (Math.PI * 2);
            if (dArray4[i2] > 0.5) {
                dArray4[i2] = 1.0 - dArray4[i2];
                continue;
            }
            if (!(dArray4[i2] > 0.5)) continue;
            dArray4[i2] = 0.0;
        }
        dArray4[0] = 0.0;
        dArray4[dArray4.length - 1] = 0.0;
        double[] dArray5 = Convolution.getLowPassFilter(ConcurrencyUtils.nextPow2(3 * n2), 0.4);
        Convolution.complexMultiply(dArray5, dArray5);
        return this.transform(dArray4, dArray5, false);
    }

    public double[] computePhase(double[] dArray) {
        int n2 = dArray.length;
        double[] dArray2 = this.transformFourier(dArray);
        double[] dArray3 = new double[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            double d2;
            double d3 = dArray2[i2];
            double d4 = dArray[i2];
            dArray3[i2] = d2 = Math.atan2(d3, d4);
        }
        HilbertTransform.UnwrapPhase2(dArray3);
        return dArray3;
    }

    public double[] computePhase(double[] dArray, double[] dArray2) {
        int n2 = dArray.length;
        double[] dArray3 = this.transformTime(dArray);
        double[] dArray4 = new double[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            double d2 = dArray3[i2];
            double d3 = dArray[i2];
            double d4 = Math.atan2(d2, d3);
            double d5 = Math.sqrt(d2 * d2 + d3 * d3);
            dArray4[i2] = d4;
            dArray2[i2] = (float)d5;
        }
        HilbertTransform.UnwrapPhase2(dArray4);
        return dArray4;
    }

    public double[] transform(double[] dArray) {
        return this.transformFourier(dArray);
    }

    public double[] transform2(double[] dArray) {
        double d2;
        int n2;
        double[] dArray2 = new double[dArray.length];
        boolean bl2 = true;
        double[] dArray3 = new double[3];
        dArray3[1] = 0.0;
        for (n2 = 1; n2 <= 1; ++n2) {
            d2 = 0.54 + 0.46 * Math.cos(Math.PI * (double)n2 / 1.0);
            dArray3[1 + n2] = d2 * (-((double)(n2 % 2)) * 2.0 / (Math.PI * (double)n2));
            dArray3[1 - n2] = -dArray3[1 + n2];
        }
        for (n2 = 0; n2 < dArray.length; ++n2) {
            d2 = 0.0;
            for (int i2 = 0; i2 < dArray3.length; ++i2) {
                int n3 = i2 + 1;
                if (n2 >= n3) {
                    d2 += dArray3[i2] * dArray[n2 - n3];
                    continue;
                }
                d2 += dArray3[i2] * dArray[0];
            }
            if (n2 - dArray3.length < 0 || n2 - dArray3.length > dArray2.length) continue;
            dArray2[n2 - dArray3.length] = d2;
        }
        return dArray2;
    }

    public double[] transformFourier(double[] dArray) {
        int n2 = dArray.length;
        int n3 = ConcurrencyUtils.nextPow2(3 * n2);
        double[] dArray2 = Convolution.getHilbertFilter(n3);
        return this.transform(dArray, dArray2, false);
    }

    public double[] transformTime(double[] dArray) {
        int n2 = dArray.length;
        int n3 = n2 / 2;
        double[] dArray2 = new double[n2];
        double d2 = 0.6366197723675814;
        for (int i2 = 0; i2 < n2; ++i2) {
            double d3 = 0.0;
            if (i2 % 2 == 0) {
                for (var10_8 = 0; var10_8 < n3; ++var10_8) {
                    var11_9 = (var10_8 << 1) + 1;
                    d3 += dArray[var11_9] / (double)(i2 - var11_9);
                }
            } else {
                for (var10_8 = 0; var10_8 < n3; ++var10_8) {
                    var11_9 = var10_8 << 1;
                    d3 += dArray[var11_9] / (double)(i2 - var11_9);
                }
            }
            dArray2[i2] = d3 * 0.6366197723675814;
        }
        return dArray2;
    }

    public static double modulo(double d2, double d3) {
        while (d2 < 0.0) {
            d2 += d3;
        }
        while (d2 >= d3) {
            d2 -= d3;
        }
        return d2;
    }

    public static void UnwrapPhase1(double[] dArray) {
        double d2 = 0.0;
        for (int i2 = 0; i2 < dArray.length - 1; ++i2) {
            double d3 = HilbertTransform.modulo(dArray[i2], Math.PI * 2);
            double d4 = HilbertTransform.modulo(dArray[i2 + 1], Math.PI * 2);
            double d5 = d4 - d3;
            double d6 = 0.0;
            d6 = d5 > Math.PI ? -1.0 : (d5 <= -Math.PI ? 1.0 : 0.0);
            dArray[i2 + 1] = (d2 += d6 * (Math.PI * 2)) + d4;
        }
    }

    public static void UnwrapPhase2(double[] dArray) {
        double d2 = dArray[0];
        for (int i2 = 1; i2 < dArray.length; ++i2) {
            double d3 = HilbertTransform.modulo(dArray[i2] - dArray[i2 - 1], Math.PI * 2);
            dArray[i2] = d2 += d3;
        }
    }
}

