/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.math.matrix;

import io.fair_acc.math.matrix.Matrix;
import io.fair_acc.math.matrix.MatrixD;
import io.fair_acc.math.matrix.SingularValueDecomposition;

public abstract class AbstractMatrix
implements Matrix {
    private static final long serialVersionUID = 4161055769254544900L;
    protected int m;
    protected int n;

    @Override
    public void checkMatrixDimensions(Matrix matrix) {
        if (matrix.getRowDimension() != this.m || matrix.getColumnDimension() != this.n) {
            throw new IllegalArgumentException("Matrix dimensions must agree.");
        }
    }

    @Override
    public int getColumnDimension() {
        return this.n;
    }

    @Override
    public int getRowDimension() {
        return this.m;
    }

    public double norm1() {
        double d2 = 0.0;
        for (int i2 = 0; i2 < this.n; ++i2) {
            double d3 = 0.0;
            for (int i3 = 0; i3 < this.m; ++i3) {
                d3 += Math.abs(this.get(i3, i2));
            }
            d2 = Math.max(d2, d3);
        }
        return d2;
    }

    public double norm2() {
        if (this instanceof MatrixD) {
            return new SingularValueDecomposition((MatrixD)this).norm2();
        }
        MatrixD matrixD = new MatrixD(this.getRowDimension(), this.getColumnDimension());
        for (int i2 = 0; i2 < this.getRowDimension(); ++i2) {
            for (int i3 = 0; i3 < this.getColumnDimension(); ++i3) {
                matrixD.set(i2, i3, this.get(i2, i3));
            }
        }
        return new SingularValueDecomposition(matrixD).norm2();
    }

    public double normF() {
        double d2 = 0.0;
        for (int i2 = 0; i2 < this.m; ++i2) {
            for (int i3 = 0; i3 < this.n; ++i3) {
                d2 = Math.hypot(d2, this.get(i2, i3));
            }
        }
        return d2;
    }

    public double normInf() {
        double d2 = 0.0;
        for (int i2 = 0; i2 < this.m; ++i2) {
            double d3 = 0.0;
            for (int i3 = 0; i3 < this.n; ++i3) {
                d3 += Math.abs(this.get(i2, i3));
            }
            d2 = Math.max(d2, d3);
        }
        return d2;
    }
}

