/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.math.functions;

import io.fair_acc.dataset.DataSet;
import io.fair_acc.dataset.spi.DefaultErrorDataSet;
import io.fair_acc.math.functions.Function;
import java.security.InvalidParameterException;

public interface Function1D
extends Function {
    default public DataSet getDataSetEstimate(double d2, double d3, int n2) {
        if (d2 > d3 || n2 <= 0) {
            throw new InvalidParameterException("AbstractFunciton1D::getDataSetEstimate(" + d2 + "," + d3 + "," + n2 + ") - invalid range");
        }
        double[] dArray = new double[n2];
        double d4 = (d3 - d2) / (double)n2;
        for (int i2 = 0; i2 < n2; ++i2) {
            dArray[i2] = d2 + (double)i2 * d4;
        }
        return this.getDataSetEstimate(dArray);
    }

    default public DataSet getDataSetEstimate(double[] dArray) {
        return new DefaultErrorDataSet(this.getName(), dArray, this.getValues(dArray), new double[dArray.length], new double[dArray.length], dArray.length, true);
    }

    public double getValue(double var1);

    default public double[] getValues(double[] dArray) {
        if (dArray == null) {
            throw new IllegalArgumentException("x array argument is null");
        }
        double[] dArray2 = new double[dArray.length];
        for (int i2 = 0; i2 < dArray.length; ++i2) {
            dArray2[i2] = this.getValue(dArray[i2]);
        }
        return dArray2;
    }
}

