/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.math.functions;

import io.fair_acc.dataset.spi.utils.DoublePoint;
import io.fair_acc.math.functions.AbstractFunction;
import io.fair_acc.math.functions.FunctionND;
import java.util.ArrayList;
import java.util.List;

public class EllipseFunction
extends AbstractFunction
implements FunctionND {
    public EllipseFunction(String string, int n2) {
        super(string, n2);
    }

    @Override
    public String getID() {
        return "EllipseFunction@+" + System.currentTimeMillis();
    }

    @Override
    public int getInputDimension() {
        return 1;
    }

    @Override
    public int getOutputDimension() {
        return 2;
    }

    @Override
    public double[] getValue(double[] dArray) {
        throw new IllegalArgumentException("not implemented");
    }

    @Override
    public double getValue(double[] dArray, int n2) {
        return 0.0;
    }

    public static List<DoublePoint> calculateEllipse(double d2, double d3, double d4, double d5, double d6, double d7) {
        int n2 = d7 == 0.0 ? 11 : (int)(360.0 / d7);
        ArrayList<DoublePoint> arrayList = new ArrayList<DoublePoint>();
        double d8 = -d6 * (Math.PI / 180);
        double d9 = Math.sin(d8);
        double d10 = Math.cos(d8);
        for (int i2 = 0; i2 < 360; i2 += n2) {
            double d11 = (double)i2 * (Math.PI / 180);
            double d12 = Math.sin(d11);
            double d13 = Math.cos(d11);
            double d14 = d2 + (d4 * d13 * d10 - d5 * d12 * d9);
            double d15 = d3 + (d4 * d13 * d9 + d5 * d12 * d10);
            arrayList.add(new DoublePoint(d14, d15));
        }
        return arrayList;
    }
}

