/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.math;

import io.fair_acc.dataset.DataSet;
import io.fair_acc.dataset.utils.AssertUtils;
import io.fair_acc.math.Math;
import io.fair_acc.math.MathBase;
import java.util.Arrays;

public final class SimpleDataSetEstimators {
    private SimpleDataSetEstimators() {
    }

    public static double computeCentreOfMass(DataSet dataSet) {
        return SimpleDataSetEstimators.computeCentreOfMass(dataSet, 0, dataSet.getDataCount());
    }

    public static double computeCentreOfMass(DataSet dataSet, double d2, double d3) {
        AssertUtils.gtOrEqual("max must be greater than min", d2, d3);
        return SimpleDataSetEstimators.computeCentreOfMass(dataSet, dataSet.getIndex(0, d2), dataSet.getIndex(0, d3));
    }

    public static double computeCentreOfMass(DataSet dataSet, int n2, int n3) {
        AssertUtils.gtEqThanZero("minIndex", n2);
        AssertUtils.gtOrEqual("maxIndex must be smaller than dataCount()", n3, dataSet.getDataCount());
        double d2 = 0.0;
        double d3 = 0.0;
        for (int i2 = n2; i2 < n3; ++i2) {
            double d4 = dataSet.get(0, i2);
            double d5 = dataSet.get(1, i2);
            if (!Double.isFinite(d4) || !Double.isFinite(d5)) continue;
            d2 += d4 * d5;
            d3 += d5;
        }
        return d2 / d3;
    }

    public static double computeFWHM(double[] dArray, int n2, int n3) {
        int n4;
        int n5;
        if (n3 <= 0 || n3 >= n2 - 1) {
            return Double.NaN;
        }
        double d2 = 0.5 * dArray[n3];
        for (n5 = n3; n5 < n2 && dArray[n5] > d2; ++n5) {
        }
        for (n4 = n3; n4 >= 0 && dArray[n4] > d2; --n4) {
        }
        if (n5 >= n2 || n4 < 0) {
            return Double.NaN;
        }
        return n5 - n4;
    }

    public static double computeInterpolatedFWHM(double[] dArray, int n2, int n3) {
        int n4;
        int n5;
        if (n3 <= 0 || n3 >= n2 - 1) {
            return Double.NaN;
        }
        double d2 = 0.5 * dArray[n3];
        for (n5 = n3; n5 < n2 && dArray[n5] > d2; ++n5) {
        }
        for (n4 = n3; n4 >= 0 && dArray[n4] > d2; --n4) {
        }
        if (n5 >= n2 || n4 < 0) {
            return Double.NaN;
        }
        double d3 = SimpleDataSetEstimators.linearInterpolate(n4, (double)n4 + 1.0, dArray[n4], dArray[n4 + 1], d2);
        double d4 = SimpleDataSetEstimators.linearInterpolate((double)n5 - 1.0, n5, dArray[n5 - 1], dArray[n5], d2);
        return d4 - d3;
    }

    public static double getDistance(DataSet dataSet, int n2, int n3, boolean bl2) {
        return bl2 ? dataSet.get(0, n3) - dataSet.get(0, n2) : dataSet.get(1, n3) - dataSet.get(1, n2);
    }

    public static double[] getDoubleArray(DataSet dataSet, int n2, int n3) {
        if (n3 - n2 <= 0) {
            return new double[0];
        }
        double[] dArray = new double[n3 - n2];
        int n4 = 0;
        for (int i2 = n2; i2 < n3; ++i2) {
            double d2;
            dArray[n4] = d2 = dataSet.get(1, i2);
            ++n4;
        }
        return dArray;
    }

    public static double getDutyCycle(DataSet dataSet, int n2, int n3) {
        double d2 = SimpleDataSetEstimators.getMinimum(dataSet, n2, n3);
        double d3 = SimpleDataSetEstimators.getMaximum(dataSet, n2, n3);
        double d4 = Math.abs(d3 - d2);
        int n4 = 0;
        int n5 = 0;
        double d5 = d2 + 0.45 * d4;
        double d6 = d2 + 0.55 * d4;
        for (int i2 = n2; i2 < n3; ++i2) {
            double d7 = dataSet.get(1, i2);
            if (!Double.isFinite(d7)) continue;
            if (d7 < d5) {
                ++n4;
            }
            if (!(d7 > d6)) continue;
            ++n5;
        }
        if (n4 + n5 == 0) {
            return Double.NaN;
        }
        return (double)n5 / (double)(n4 + n5);
    }

    public static double getEdgeDetect(DataSet dataSet, int n2, int n3) {
        if (dataSet.getDataCount() == 0 || n2 == n3) {
            return Double.NaN;
        }
        double d2 = SimpleDataSetEstimators.getMinimum(dataSet, n2, n3);
        double d3 = SimpleDataSetEstimators.getMaximum(dataSet, n2, n3);
        double d4 = Math.abs(d3 - d2);
        if (d4 == 0.0) {
            return Double.NaN;
        }
        boolean bl2 = dataSet.get(1, n2) > dataSet.get(1, n3 - 1);
        double d5 = dataSet.get(0, n2);
        if (bl2) {
            for (int i2 = n2; i2 < n3; ++i2) {
                double d6 = dataSet.get(1, i2);
                if (!Double.isFinite(d6) || !(d6 < d3 - 0.5 * d4)) continue;
                return dataSet.get(0, i2) - d5;
            }
        } else {
            for (int i3 = n2; i3 < n3; ++i3) {
                double d7 = dataSet.get(1, i3);
                if (!Double.isFinite(d7) || !(d7 > d2 + 0.5 * d4)) continue;
                return dataSet.get(0, i3) - d5;
            }
        }
        return Double.NaN;
    }

    public static double getFrequencyEstimate(DataSet dataSet, int n2, int n3) {
        double d2 = SimpleDataSetEstimators.getMinimum(dataSet, n2, n3);
        double d3 = SimpleDataSetEstimators.getMaximum(dataSet, n2, n3);
        double d4 = Math.abs(d3 - d2);
        double d5 = d2 + 0.45 * d4;
        double d6 = d2 + 0.55 * d4;
        double d7 = Double.NaN;
        double d8 = Double.NaN;
        double d9 = 0.0;
        int n4 = 0;
        double d10 = 0.0;
        for (int i2 = n2; i2 < n3; ++i2) {
            double d11;
            double d12;
            double d13 = dataSet.get(1, i2);
            if (!Double.isFinite(d13)) continue;
            if (d10 < 0.5) {
                if (!(d13 > d6)) continue;
                d10 = 1.0;
                d12 = dataSet.get(0, i2);
                if (Double.isFinite(d7)) {
                    d11 = d12 - d7;
                    d7 = d12;
                    d9 += d11;
                    ++n4;
                    continue;
                }
                d7 = d12;
                continue;
            }
            if (!(d13 < d5)) continue;
            d10 = 0.0;
            d12 = dataSet.get(0, i2);
            if (Double.isFinite(d8)) {
                d11 = d12 - d8;
                d8 = d12;
                d9 += d11;
                ++n4;
                continue;
            }
            d8 = d12;
        }
        if (n4 == 0) {
            return Double.NaN;
        }
        return (double)n4 / d9;
    }

    public static double getFullWidthHalfMaximum(DataSet dataSet, int n2, int n3, boolean bl2) {
        int n4 = SimpleDataSetEstimators.getLocationMaximum(dataSet, n2, n3);
        if (n4 <= n2 + 1 || n4 >= n3 - 1) {
            return Double.NaN;
        }
        double[] dArray = SimpleDataSetEstimators.getDoubleArray(dataSet, n2, n3);
        AssertUtils.gtThanZero("data.length", dArray.length);
        if (bl2) {
            return SimpleDataSetEstimators.computeInterpolatedFWHM(dArray, dArray.length, n4 - n2);
        }
        return SimpleDataSetEstimators.computeFWHM(dArray, dArray.length, n4 - n2);
    }

    public static double getIntegral(DataSet dataSet, int n2, int n3) {
        double d2 = MathBase.sign(1.0, n3 - n2);
        double d3 = 0.0;
        for (int i2 = Math.min(n2, n3); i2 < Math.max(n2, n3) - 1; ++i2) {
            double d4;
            double d5;
            double d6 = dataSet.get(0, i2);
            double d7 = dataSet.get(0, i2 + 1);
            double d8 = (d7 - d6) * 0.5 * ((d5 = dataSet.get(1, i2)) + (d4 = dataSet.get(1, i2 + 1)));
            if (!Double.isFinite(d8)) continue;
            d3 += d8;
        }
        return d2 * d3;
    }

    public static int getLocationMaximum(DataSet dataSet, int n2, int n3) {
        int n4 = -1;
        double d2 = -1.7976931348623157E308;
        for (int i2 = n2; i2 < n3; ++i2) {
            double d3 = dataSet.get(1, i2);
            if (!Double.isFinite(d3) || !(d3 > d2)) continue;
            d2 = d3;
            n4 = i2;
        }
        return n4;
    }

    public static double getLocationMaximumGaussInterpolated(DataSet dataSet, int n2, int n3) {
        int n4 = SimpleDataSetEstimators.getLocationMaximum(dataSet, n2, n3);
        if (n4 <= n2 + 1 || n4 >= n3 - 1) {
            return Double.NaN;
        }
        double[] dArray = SimpleDataSetEstimators.getDoubleArray(dataSet, n2, n3);
        if (dArray.length == 0) {
            return Double.NaN;
        }
        double d2 = (double)n2 + SimpleDataSetEstimators.interpolateGaussian(dArray, dArray.length, n4 - n2) - (double)n4;
        double d3 = dataSet.get(0, n4);
        double d4 = dataSet.get(0, n4 + 1);
        double d5 = d4 - d3;
        return d3 + d2 * d5;
    }

    public static double getMaximum(DataSet dataSet, int n2, int n3) {
        double d2 = -1.7976931348623157E308;
        for (int i2 = n2; i2 < n3; ++i2) {
            double d3 = dataSet.get(1, i2);
            if (!Double.isFinite(d3)) continue;
            d2 = Math.max(d2, d3);
        }
        return d2;
    }

    public static double getMean(DataSet dataSet, int n2, int n3) {
        double d2 = 0.0;
        int n4 = 0;
        for (int i2 = n2; i2 < n3; ++i2) {
            double d3 = dataSet.get(1, i2);
            if (!Double.isFinite(d3)) continue;
            d2 += d3;
            ++n4;
        }
        if (n4 > 0) {
            return d2 / (double)n4;
        }
        return Double.NaN;
    }

    public static double getMedian(DataSet dataSet, int n2, int n3) {
        double[] dArray = SimpleDataSetEstimators.getDoubleArray(dataSet, n2, n3);
        if (dArray.length == 0) {
            return Double.NaN;
        }
        return SimpleDataSetEstimators.median(dArray, dArray.length);
    }

    public static double getMinimum(DataSet dataSet, int n2, int n3) {
        double d2 = Double.MAX_VALUE;
        for (int i2 = n2; i2 < n3; ++i2) {
            double d3 = dataSet.get(1, i2);
            if (!Double.isFinite(d3)) continue;
            d2 = Math.min(d2, d3);
        }
        return d2;
    }

    public static double getRange(DataSet dataSet, int n2, int n3) {
        if (dataSet.getDataCount() == 0) {
            return Double.NaN;
        }
        double d2 = Double.NaN;
        double d3 = Double.NaN;
        for (int i2 = n2; i2 < n3; ++i2) {
            double d4 = dataSet.get(1, i2);
            if (Double.isNaN(d4)) continue;
            d3 = Double.isNaN(d3) ? d4 : Math.max(d3, d4);
            d2 = Double.isNaN(d2) ? d4 : Math.min(d2, d4);
        }
        return Math.abs(d3 - d2);
    }

    public static double getRms(DataSet dataSet, int n2, int n3) {
        double[] dArray = SimpleDataSetEstimators.getDoubleArray(dataSet, n2, n3);
        if (dArray.length == 0) {
            return Double.NaN;
        }
        return SimpleDataSetEstimators.rootMeanSquare(dArray, dArray.length);
    }

    public static double getSimpleRiseTime(DataSet dataSet, int n2, int n3) {
        return SimpleDataSetEstimators.getSimpleRiseTime2080(dataSet, n2, n3);
    }

    public static double getSimpleRiseTime(DataSet dataSet, int n2, int n3, double d2, double d3) {
        if (!Double.isFinite(d2) || d2 < 0.0 || d2 > 1.0 || !Double.isFinite(d3) || d3 < 0.0 || d3 > 1.0 || d3 <= d2) {
            throw new IllegalArgumentException("[min=" + d2 + ",max=" + d3 + "] must be within [0.0, 1.0]");
        }
        double d4 = SimpleDataSetEstimators.getMinimum(dataSet, n2, n3);
        double d5 = SimpleDataSetEstimators.getMaximum(dataSet, n2, n3);
        double d6 = Math.abs(d5 - d4);
        boolean bl2 = dataSet.get(1, n2) > dataSet.get(1, n3);
        double d7 = dataSet.get(0, n2);
        double d8 = dataSet.get(0, n3);
        boolean bl3 = false;
        if (bl2) {
            for (int i2 = n2; i2 < n3; ++i2) {
                double d9 = dataSet.get(1, i2);
                if (!Double.isFinite(d9)) continue;
                if (!bl3 && d9 < d5 - d2 * d6) {
                    d7 = dataSet.get(0, i2);
                    bl3 = true;
                    continue;
                }
                if (!bl3 || !(d9 < d5 - d3 * d6)) continue;
                d8 = dataSet.get(0, i2);
                break;
            }
        } else {
            for (int i3 = n2; i3 < n3; ++i3) {
                double d10 = dataSet.get(1, i3);
                if (!Double.isFinite(d10)) continue;
                if (!bl3 && d10 > d4 + d2 * d6) {
                    d7 = dataSet.get(0, i3);
                    bl3 = true;
                    continue;
                }
                if (!bl3 || !(d10 > d4 + d3 * d6)) continue;
                d8 = dataSet.get(0, i3);
                break;
            }
        }
        return d8 - d7;
    }

    public static double getSimpleRiseTime1090(DataSet dataSet, int n2, int n3) {
        return SimpleDataSetEstimators.getSimpleRiseTime(dataSet, n2, n3, 0.1, 0.9);
    }

    public static double getSimpleRiseTime2080(DataSet dataSet, int n2, int n3) {
        return SimpleDataSetEstimators.getSimpleRiseTime(dataSet, n2, n3, 0.2, 0.8);
    }

    public static double getTransmission(DataSet dataSet, int n2, int n3, boolean bl2) {
        double d2 = dataSet.get(1, n2);
        double d3 = dataSet.get(1, n3);
        if (d2 == 0.0) {
            return Double.NaN;
        }
        return (bl2 ? d3 : d3 - d2) / d2 * 100.0;
    }

    public static double getZeroCrossing(DataSet dataSet, double d2) {
        int n2 = dataSet.getDataCount();
        if (n2 == 0) {
            return Double.NaN;
        }
        double d3 = dataSet.get(1, 0);
        if (d3 < d2) {
            for (int i2 = 0; i2 < n2; ++i2) {
                double d4 = dataSet.get(1, i2);
                if (!Double.isFinite(d4) || !(d4 >= d2)) continue;
                return dataSet.get(0, i2);
            }
        } else if (d3 > d2) {
            for (int i3 = 0; i3 < n2; ++i3) {
                double d5 = dataSet.get(1, i3);
                if (!Double.isFinite(d5) || !(d5 <= d2)) continue;
                return dataSet.get(0, i3);
            }
        } else {
            return dataSet.get(0, 0);
        }
        return Double.NaN;
    }

    public static double interpolateGaussian(double[] dArray, int n2, int n3) {
        if (n3 <= 0 || n3 >= n2 - 1) {
            return n3;
        }
        double d2 = Math.pow(dArray[n3 - 1], 1.0);
        double d3 = Math.pow(dArray[n3], 1.0);
        double d4 = Math.pow(dArray[n3 + 1], 1.0);
        double d5 = n3;
        return d5 += 0.5 * Math.log(d4 / d2) / Math.log(Math.pow(d3, 2.0) / (d2 * d4));
    }

    public static double linearInterpolate(double d2, double d3, double d4, double d5, double d6) {
        return d2 + (d6 - d4) * (d3 - d2) / (d5 - d4);
    }

    private static synchronized double median(double[] dArray, int n2) {
        double[] dArray2 = SimpleDataSetEstimators.sort(dArray, n2, false);
        if (n2 % 2 == 0) {
            return 0.5 * (dArray2[n2 / 2] + dArray2[n2 / 2 + 1]);
        }
        return dArray2[n2 / 2];
    }

    protected static double rootMeanSquare(double[] dArray, int n2) {
        AssertUtils.notNull("data", dArray);
        AssertUtils.indexInBounds(n2, dArray.length + 1, "length must be inside bounds of data");
        if (n2 == 0) {
            return Double.NaN;
        }
        double d2 = 1.0 / (double)n2;
        double d3 = 0.0;
        double d4 = 0.0;
        for (int i2 = 0; i2 < n2; ++i2) {
            d3 += dArray[i2];
            d4 += dArray[i2] * dArray[i2];
        }
        return Math.sqrt(Math.abs((d4 *= d2) - (d3 *= d2) * d3));
    }

    protected static synchronized double[] sort(double[] dArray, int n2, boolean bl2) {
        if (dArray == null || dArray.length <= 0) {
            return new double[0];
        }
        if (n2 > dArray.length) {
            throw new IllegalArgumentException("length must be smaller or equal to the size of the input array");
        }
        double[] dArray2 = Arrays.copyOf(dArray, n2);
        Arrays.sort(dArray2);
        if (bl2) {
            int n3 = n2 - 1;
            for (int i2 = 0; i2 < n2 / 2; ++i2) {
                double d2 = dArray2[i2];
                dArray2[i2] = dArray2[n3 - i2];
                dArray2[n3 - i2] = d2;
            }
        }
        return dArray2;
    }
}

