/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.math;

import io.fair_acc.dataset.AxisDescription;
import io.fair_acc.dataset.DataSet;
import io.fair_acc.dataset.DefaultNumberFormatter;
import io.fair_acc.dataset.Formatter;
import io.fair_acc.dataset.GridDataSet;
import io.fair_acc.dataset.spi.DoubleErrorDataSet;
import io.fair_acc.dataset.utils.DoubleArrayCache;
import io.fair_acc.math.Math;
import java.util.Arrays;
import java.util.Objects;

public final class MultiDimDataSetMath {
    public static Formatter<Number> DEFAULT_FORMATTER = new DefaultNumberFormatter();

    private MultiDimDataSetMath() {
    }

    @SafeVarargs
    public static void computeIntegral(GridDataSet gridDataSet, DoubleErrorDataSet doubleErrorDataSet, int n2, double d2, double d3, Formatter<Number> ... formatterArray) {
        MultiDimDataSetMath.computeMeanIntegral(gridDataSet, doubleErrorDataSet, n2, d2, d3, false, formatterArray);
    }

    @SafeVarargs
    public static void computeMax(GridDataSet gridDataSet, DoubleErrorDataSet doubleErrorDataSet, int n2, double d2, double d3, Formatter<Number> ... formatterArray) {
        MultiDimDataSetMath.computeMinMax(gridDataSet, doubleErrorDataSet, n2, d2, d3, false, formatterArray);
    }

    @SafeVarargs
    public static void computeMean(GridDataSet gridDataSet, DoubleErrorDataSet doubleErrorDataSet, int n2, double d2, double d3, Formatter<Number> ... formatterArray) {
        MultiDimDataSetMath.computeMeanIntegral(gridDataSet, doubleErrorDataSet, n2, d2, d3, true, new Formatter[0]);
    }

    @SafeVarargs
    public static void computeMin(GridDataSet gridDataSet, DoubleErrorDataSet doubleErrorDataSet, int n2, double d2, double d3, Formatter<Number> ... formatterArray) {
        MultiDimDataSetMath.computeMinMax(gridDataSet, doubleErrorDataSet, n2, d2, d3, true, formatterArray);
    }

    @SafeVarargs
    public static void computeSlice(GridDataSet gridDataSet, DoubleErrorDataSet doubleErrorDataSet, int n2, double d2, Formatter<Number> ... formatterArray) {
        Object object;
        MultiDimDataSetMath.checkMultiDimDataSetCompatibility(gridDataSet);
        MultiDimDataSetMath.checkOutputDataSetCompatibility(doubleErrorDataSet);
        double[] dArray = doubleErrorDataSet.getValues(0);
        double[] dArray2 = doubleErrorDataSet.getValues(1);
        double[] dArray3 = doubleErrorDataSet.getErrorsNegative(1);
        double[] dArray4 = doubleErrorDataSet.getErrorsPositive(1);
        int n3 = gridDataSet.getShape(n2);
        if (n3 == doubleErrorDataSet.getDataCount()) {
            System.arraycopy(gridDataSet.getGridValues(n2), 0, dArray, 0, n3);
            object = MultiDimDataSetMath.getSliceArray(gridDataSet, n2, d2, dArray2);
            doubleErrorDataSet.set(dArray, (double[])object, dArray3, dArray4, false);
        } else {
            object = MultiDimDataSetMath.getSliceArray(gridDataSet, n2, d2, dArray2);
            doubleErrorDataSet.set(Arrays.copyOf(gridDataSet.getGridValues(n2), n3), (double[])object, new double[n3], new double[n3], false);
        }
        object = MultiDimDataSetMath.getFormatter(formatterArray).format("{0}({1})@{2} {3}", "slice", gridDataSet.getName(), d2, gridDataSet.getAxisDescription(n2).getUnit());
        doubleErrorDataSet.setName((String)object);
        doubleErrorDataSet.getAxisDescription(0).set(gridDataSet.getAxisDescription(n2).getName(), gridDataSet.getAxisDescription(n2).getUnit());
        doubleErrorDataSet.getAxisDescription(1).set(gridDataSet.getAxisDescription(2).getName(), gridDataSet.getAxisDescription(2).getUnit());
        doubleErrorDataSet.getAxisDescriptions().forEach(AxisDescription::clear);
    }

    public static double[] getMeanIntegralArray(GridDataSet gridDataSet, int n2, double d2, double d3, double[] dArray, boolean bl2) {
        MultiDimDataSetMath.checkMultiDimDataSetCompatibility(gridDataSet);
        double[] dArray2 = MultiDimDataSetMath.getSanitizedBuffer(gridDataSet, n2, dArray);
        int n3 = gridDataSet.getGridIndex(n2 == 0 ? 1 : 0, d2);
        int n4 = gridDataSet.getGridIndex(n2 == 0 ? 1 : 0, d3);
        int n5 = Math.min(n3, n4);
        int n6 = Math.max(Math.max(n3, n4), n5 + 1);
        int n7 = gridDataSet.getShape(n2);
        if (n2 == 1) {
            for (int i2 = 0; i2 < n7; ++i2) {
                double d4 = 0.0;
                int n8 = 0;
                int n9 = n5;
                while (n9 <= Math.min(n6, n7 - 1)) {
                    d4 += gridDataSet.get(2, n9++, i2);
                    ++n8;
                }
                dArray2[i2] = bl2 ? (n8 == 0 ? Double.NaN : d4 / (double)n8) : d4;
            }
        } else {
            for (int i3 = 0; i3 < n7; ++i3) {
                double d5 = 0.0;
                int n10 = 0;
                int n11 = n5;
                while (n11 <= Math.min(n6, n7 - 1)) {
                    d5 += gridDataSet.get(2, i3, n11++);
                    ++n10;
                }
                dArray2[i3] = bl2 ? (n10 == 0 ? Double.NaN : d5 / (double)n10) : d5;
            }
        }
        return dArray2;
    }

    public static double[] getMinMaxArray(GridDataSet gridDataSet, int n2, double d2, double d3, double[] dArray, boolean bl2) {
        MultiDimDataSetMath.checkMultiDimDataSetCompatibility(gridDataSet);
        double[] dArray2 = MultiDimDataSetMath.getSanitizedBuffer(gridDataSet, n2, dArray);
        int n3 = gridDataSet.getIndex(n2 == 0 ? 1 : 0, d2);
        int n4 = gridDataSet.getIndex(n2 == 0 ? 1 : 0, d3);
        int n5 = Math.min(n3, n4);
        int n6 = Math.max(Math.max(n3, n4), n5 + 1);
        int n7 = gridDataSet.getShape(n2);
        if (n2 == 1) {
            for (int i2 = 0; i2 < n7; ++i2) {
                double d4 = gridDataSet.get(2, n5, i2);
                for (int i3 = n5 + 1; i3 <= Math.min(n6, n7 - 1); ++i3) {
                    double d5 = gridDataSet.get(2, i3, i2);
                    d4 = bl2 ? Math.min(d5, d4) : Math.max(d5, d4);
                }
                dArray2[i2] = d4;
            }
        } else {
            for (int i4 = 0; i4 < n7; ++i4) {
                double d6 = gridDataSet.get(2, i4, n5);
                for (int i5 = n5 + 1; i5 <= Math.min(n6, n7 - 1); ++i5) {
                    double d7 = gridDataSet.get(2, i4, i5);
                    d6 = bl2 ? Math.min(d7, d6) : Math.max(d7, d6);
                }
                dArray2[i4] = d6;
            }
        }
        return dArray2;
    }

    public static double[] getSliceArray(GridDataSet gridDataSet, int n2, double d2, double[] dArray) {
        MultiDimDataSetMath.checkMultiDimDataSetCompatibility(gridDataSet);
        double[] dArray2 = MultiDimDataSetMath.getSanitizedBuffer(gridDataSet, n2, dArray);
        int n3 = gridDataSet.getGridIndex(n2 == 0 ? 1 : 0, d2);
        int n4 = gridDataSet.getShape(n2);
        if (n2 == 1) {
            for (int i2 = 0; i2 < n4; ++i2) {
                double d3;
                dArray2[i2] = d3 = gridDataSet.get(2, n3, i2);
            }
        } else {
            for (int i3 = 0; i3 < n4; ++i3) {
                double d4;
                dArray2[i3] = d4 = gridDataSet.get(2, i3, n3);
            }
        }
        return dArray2;
    }

    private static void checkMultiDimDataSetCompatibility(DataSet dataSet) {
        if (dataSet == null || dataSet.getDimension() <= 2) {
            throw new IllegalArgumentException("source is " + (String)(dataSet == null ? "null" : " has insufficient dimension = " + dataSet.getDimension()));
        }
    }

    private static void checkOutputDataSetCompatibility(DataSet dataSet) {
        if (dataSet == null || dataSet.getDimension() != 2) {
            throw new IllegalArgumentException("output is " + (String)(dataSet == null ? "null" : " has insufficient dimension = " + dataSet.getDimension()));
        }
    }

    @SafeVarargs
    private static void computeMeanIntegral(GridDataSet gridDataSet, DoubleErrorDataSet doubleErrorDataSet, int n2, double d2, double d3, boolean bl2, Formatter<Number> ... formatterArray) {
        Object object;
        MultiDimDataSetMath.checkMultiDimDataSetCompatibility(gridDataSet);
        MultiDimDataSetMath.checkOutputDataSetCompatibility(doubleErrorDataSet);
        double[] dArray = doubleErrorDataSet.getValues(0);
        double[] dArray2 = doubleErrorDataSet.getValues(1);
        double[] dArray3 = doubleErrorDataSet.getErrorsNegative(1);
        double[] dArray4 = doubleErrorDataSet.getErrorsPositive(1);
        int n3 = gridDataSet.getShape(n2);
        if (n3 == doubleErrorDataSet.getDataCount()) {
            System.arraycopy(gridDataSet.getValues(n2), 0, dArray, 0, n3);
            object = MultiDimDataSetMath.getMeanIntegralArray(gridDataSet, n2, d2, d3, dArray2, bl2);
            doubleErrorDataSet.set(dArray, (double[])object, dArray3, dArray4, false);
        } else {
            object = MultiDimDataSetMath.getMeanIntegralArray(gridDataSet, n2, d2, d3, dArray2, bl2);
            doubleErrorDataSet.set(Arrays.copyOf(gridDataSet.getValues(n2), n3), (double[])object, new double[n3], new double[n3], false);
        }
        object = MultiDimDataSetMath.getFormatter(formatterArray).format("{0}({1})@{2}->{3} {4}", bl2 ? "mean" : "int", gridDataSet.getName(), d2, d3, gridDataSet.getAxisDescription(n2).getUnit());
        doubleErrorDataSet.setName((String)object);
        doubleErrorDataSet.getAxisDescription(0).set(gridDataSet.getAxisDescription(n2).getName(), gridDataSet.getAxisDescription(n2).getUnit());
        doubleErrorDataSet.getAxisDescription(1).set(gridDataSet.getAxisDescription(2).getName(), gridDataSet.getAxisDescription(2).getUnit());
        doubleErrorDataSet.getAxisDescriptions().forEach(AxisDescription::clear);
    }

    @SafeVarargs
    private static void computeMinMax(GridDataSet gridDataSet, DoubleErrorDataSet doubleErrorDataSet, int n2, double d2, double d3, boolean bl2, Formatter<Number> ... formatterArray) {
        Object object;
        MultiDimDataSetMath.checkMultiDimDataSetCompatibility(gridDataSet);
        MultiDimDataSetMath.checkOutputDataSetCompatibility(doubleErrorDataSet);
        double[] dArray = doubleErrorDataSet.getValues(0);
        double[] dArray2 = doubleErrorDataSet.getValues(1);
        double[] dArray3 = doubleErrorDataSet.getErrorsNegative(1);
        double[] dArray4 = doubleErrorDataSet.getErrorsPositive(1);
        int n3 = gridDataSet.getShape(n2);
        if (n3 == doubleErrorDataSet.getDataCount()) {
            System.arraycopy(gridDataSet.getValues(n2), 0, dArray, 0, n3);
            object = MultiDimDataSetMath.getMinMaxArray(gridDataSet, n2, d2, d3, dArray2, bl2);
            doubleErrorDataSet.set(dArray, (double[])object, dArray3, dArray4, false);
        } else {
            object = MultiDimDataSetMath.getMinMaxArray(gridDataSet, n2, d2, d3, dArray2, bl2);
            doubleErrorDataSet.set(Arrays.copyOf(gridDataSet.getValues(n2), n3), (double[])object, new double[n3], new double[n3], false);
        }
        object = MultiDimDataSetMath.getFormatter(formatterArray).format("{0}({1})@{2}->{3} {4}", bl2 ? "min" : "max", gridDataSet.getName(), d2, d3, gridDataSet.getAxisDescription(n2).getUnit());
        doubleErrorDataSet.setName((String)object);
        doubleErrorDataSet.getAxisDescription(0).set(gridDataSet.getAxisDescription(n2).getName(), gridDataSet.getAxisDescription(n2).getUnit());
        doubleErrorDataSet.getAxisDescription(1).set(gridDataSet.getAxisDescription(2).getName(), gridDataSet.getAxisDescription(2).getUnit());
        doubleErrorDataSet.getAxisDescriptions().forEach(AxisDescription::clear);
    }

    private static double[] getSanitizedBuffer(GridDataSet gridDataSet, int n2, double[] dArray) {
        int n3 = gridDataSet.getShape(n2);
        boolean bl2 = dArray == null || dArray.length < n3;
        return bl2 ? DoubleArrayCache.getInstance().getArrayExact(n3) : dArray;
    }

    @SafeVarargs
    private static Formatter<Number> getFormatter(Formatter<Number> ... formatterArray) {
        return Objects.requireNonNull(formatterArray, "user-supplied format").length > 0 ? formatterArray[0] : DEFAULT_FORMATTER;
    }
}

