/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.math;

import io.fair_acc.dataset.DataSet;
import io.fair_acc.dataset.DataSetError;
import io.fair_acc.dataset.events.BitState;
import io.fair_acc.dataset.events.ChartBits;
import io.fair_acc.dataset.events.EventProcessor;
import io.fair_acc.dataset.events.ThreadEventProcessor;
import io.fair_acc.dataset.spi.DoubleErrorDataSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class MathDataSet
extends DoubleErrorDataSet {
    private static final long serialVersionUID = -4978160822533565009L;
    private static final long DEFAULT_UPDATE_LIMIT = 40L;
    private final transient List<DataSet> sourceDataSets;
    private final transient DataSetFunction dataSetFunction;
    private final transient DataSetsFunction dataSetsFunction;
    private final transient DataSetValueFunction dataSetValueFunction;
    private final transient long minUpdatePeriod;
    private final transient String transformName;
    private final BitState inputDataSetBitState = BitState.initDirtyMultiThreaded(this, ChartBits.DataSetMask);

    public MathDataSet(String string, DataSetFunction dataSetFunction, DataSet dataSet) {
        this(string, dataSetFunction, null, null, 40L, dataSet);
    }

    public MathDataSet(String string, DataSetFunction dataSetFunction, long l2, DataSet dataSet) {
        this(string, dataSetFunction, null, null, l2, dataSet);
    }

    public MathDataSet(String string, DataSetsFunction dataSetsFunction, DataSet ... dataSetArray) {
        this(string, null, dataSetsFunction, null, 40L, dataSetArray);
    }

    public MathDataSet(String string, DataSetsFunction dataSetsFunction, long l2, DataSet ... dataSetArray) {
        this(string, null, dataSetsFunction, null, l2, dataSetArray);
    }

    public MathDataSet(String string, DataSetValueFunction dataSetValueFunction, DataSet dataSet) {
        this(string, null, null, dataSetValueFunction, 40L, dataSet);
    }

    public MathDataSet(String string, DataSetValueFunction dataSetValueFunction, long l2, DataSet dataSet) {
        this(string, null, null, dataSetValueFunction, l2, dataSet);
    }

    protected MathDataSet(String string, DataSetFunction dataSetFunction, DataSetsFunction dataSetsFunction, DataSetValueFunction dataSetValueFunction, long l2, DataSet ... dataSetArray) {
        super(MathDataSet.getCompositeDataSetName(string, dataSetArray));
        this.sourceDataSets = new ArrayList<DataSet>(Arrays.asList(dataSetArray));
        this.minUpdatePeriod = l2;
        this.dataSetFunction = dataSetFunction;
        this.dataSetsFunction = dataSetsFunction;
        this.dataSetValueFunction = dataSetValueFunction;
        this.transformName = string;
        if (dataSetFunction == null && dataSetsFunction == null && dataSetValueFunction == null) {
            throw new IllegalArgumentException("dataSetFunction, dataSetsFunction and dataSetValueFunction cannot all be null");
        }
        if (dataSetValueFunction != null && this.sourceDataSets.size() > 1) {
            throw new IllegalArgumentException("sources list may not be larger than one if the 'dataSetValueFunction' interface is used -> try to use 'DataSetFunction' instead");
        }
        this.registerListener();
        EventProcessor eventProcessor = ThreadEventProcessor.getUserInstance();
        eventProcessor.addAction(this.inputDataSetBitState, this::update);
    }

    public final void triggerUpdate() {
        this.inputDataSetBitState.setDirty(-1);
    }

    public final void deregisterListener() {
        this.sourceDataSets.forEach(dataSet -> dataSet.getBitState().removeInvalidateListener(this.inputDataSetBitState));
    }

    public final List<DataSet> getSourceDataSets() {
        return this.sourceDataSets;
    }

    public final void registerListener() {
        this.sourceDataSets.forEach(dataSet -> dataSet.getBitState().addInvalidateListener(this.inputDataSetBitState));
    }

    private void handleDataSetValueFunctionInterface() {
        double[] dArray;
        double[] dArray2;
        Object object;
        DataSet dataSet = this.sourceDataSets.get(0);
        int n2 = dataSet.getDataCount();
        double[] dArray3 = dataSet.getValues(0);
        double[] dArray4 = dataSet.getValues(1);
        if (dataSet instanceof DataSetError) {
            object = (DataSetError)dataSet;
            dArray2 = object.getErrorsPositive(1);
            dArray = object.getErrorsNegative(1);
        } else {
            dArray = dArray2 = new double[n2];
        }
        if (this.getCapacity() < n2) {
            int n3 = n2 - this.getCapacity();
            this.increaseCapacity(n3);
        }
        object = this.getValues(0);
        double[] dArray5 = this.getValues(1);
        System.arraycopy(dArray3, 0, object, 0, n2);
        this.dataSetValueFunction.transform(dArray4, dArray5, n2);
        this.set((double[])object, dArray5, dArray, dArray2, n2, false);
    }

    protected void update() {
        this.lock().writeLockGuard(() -> {
            if (this.dataSetFunction != null) {
                this.set(this.dataSetFunction.transform(this.sourceDataSets.get(0)));
            } else if (this.dataSetsFunction != null) {
                this.dataSetsFunction.transform(this.sourceDataSets, this);
            } else {
                if (this.sourceDataSets.isEmpty()) {
                    return;
                }
                this.handleDataSetValueFunctionInterface();
            }
            this.setName(MathDataSet.getCompositeDataSetName(this.transformName, this.sourceDataSets.toArray(new DataSet[0])));
        });
    }

    protected static String getCompositeDataSetName(String string, DataSet ... dataSetArray) {
        List<DataSet> list = Arrays.asList(dataSetArray);
        String string2 = string == null ? "" : string;
        return list.stream().map(DataSet::getName).collect(Collectors.joining(",", string2 + "(", ")"));
    }

    public static interface DataSetFunction {
        public DataSet transform(DataSet var1);
    }

    public static interface DataSetsFunction {
        public void transform(List<DataSet> var1, MathDataSet var2);
    }

    public static interface DataSetValueFunction {
        public void transform(double[] var1, double[] var2, int var3);
    }
}

