/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.math;

import io.fair_acc.math.MathBase;

public class MathBaseFast
extends MathBase {
    private static final int DEFAULT_TRIG_RESOLUTION = 3600;
    private static int precision = 3600;
    private static int modulusRad;
    private static int modulusRadQuater;
    private static int modulusDeg;
    private static float[] sinRadLookup;
    private static float[] sinDegLockup;

    private MathBaseFast() {
    }

    public static double cos(double d2) {
        return MathBaseFast.sinLocalLookUp((int)(d2 * (double)precision + (double)modulusRadQuater + 0.5));
    }

    public static float cos(float f2) {
        return MathBaseFast.sinLocalLookUp((int)(f2 * (float)precision + (float)modulusRadQuater + 0.5f));
    }

    public static double cosDeg(double d2) {
        return MathBaseFast.sinLocalLookUpDegree((int)((d2 + 90.0) * (double)precision + 0.5));
    }

    public static float cosDeg(float f2) {
        return MathBaseFast.sinLocalLookUpDegree((int)((f2 + 90.0f) * (float)precision + 0.5f));
    }

    public static int getPrecision() {
        return precision;
    }

    public static void setPrecision(int n2) {
        if (n2 <= 0) {
            throw new IllegalArgumentException("precision '" + n2 + "'must be positive");
        }
        precision = n2;
        MathBaseFast.init();
    }

    public static double sin(double d2) {
        return MathBaseFast.sinLocalLookUp((int)(d2 * (double)precision + 0.5));
    }

    public static float sin(float f2) {
        return MathBaseFast.sinLocalLookUp((int)(f2 * (float)precision + 0.5f));
    }

    public static double sinDeg(double d2) {
        return MathBaseFast.sinLocalLookUpDegree((int)(d2 * (double)precision + 0.5));
    }

    public static float sinDeg(float f2) {
        return MathBaseFast.sinLocalLookUpDegree((int)(f2 * (float)precision + 0.5f));
    }

    private static void init() {
        int n2;
        modulusRad = (int)(Math.PI * 2 * (double)precision);
        modulusRadQuater = modulusRad >> 2;
        modulusDeg = 360 * precision;
        sinRadLookup = new float[modulusRad];
        sinDegLockup = new float[modulusDeg];
        for (n2 = 0; n2 < modulusRad; ++n2) {
            MathBaseFast.sinRadLookup[n2] = (float)Math.sin((double)n2 / (double)precision);
        }
        for (n2 = 0; n2 < modulusDeg; ++n2) {
            MathBaseFast.sinDegLockup[n2] = (float)Math.sin(Math.toRadians((double)n2 / (double)precision));
        }
    }

    private static float sinLocalLookUp(int n2) {
        return n2 >= 0 ? sinRadLookup[n2 % modulusRad] : -sinRadLookup[-n2 % modulusRad];
    }

    private static float sinLocalLookUpDegree(int n2) {
        return n2 >= 0 ? sinDegLockup[n2 % modulusDeg] : -sinDegLockup[-n2 % modulusDeg];
    }

    static {
        MathBaseFast.init();
    }
}

