/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.math;

import io.fair_acc.math.MathBase;
import java.util.Arrays;
import java.util.Locale;

public class Math
extends MathBase {
    private static final int kWorkMax = 100;

    public double kolmogorovProb(double d2) {
        double d3;
        double[] dArray = new double[]{-2.0, -8.0, -18.0, -32.0};
        double[] dArray2 = new double[4];
        double d4 = 2.50662827;
        double d5 = -1.2337005501361697;
        double d6 = -11.103304951225528;
        double d7 = -30.842513753404244;
        double d8 = Math.abs(d2);
        if (d8 < 0.2) {
            d3 = 1.0;
        } else if (d8 < 0.755) {
            double d9 = 1.0 / (d8 * d8);
            d3 = 1.0 - 2.50662827 * (Math.exp(-1.2337005501361697 * d9) + Math.exp(-11.103304951225528 * d9) + Math.exp(-30.842513753404244 * d9)) / d8;
        } else if (d8 < 6.8116) {
            dArray2[1] = 0.0;
            dArray2[2] = 0.0;
            dArray2[3] = 0.0;
            double d10 = d8 * d8;
            int n2 = Math.max(1, Math.nInt(3.0 / d8));
            for (int i2 = 0; i2 < n2; ++i2) {
                dArray2[i2] = Math.exp(dArray[i2] * d10);
            }
            d3 = 2.0 * (dArray2[0] - dArray2[1] + dArray2[2] - dArray2[3]);
        } else {
            d3 = 0.0;
        }
        return d3;
    }

    public double kolmogorovTest(int n2, double[] dArray, int n3, double[] dArray2, String string) {
        String string2;
        int n4;
        int n5;
        double d2;
        double d3 = -1.0;
        if (dArray == null || dArray2 == null || n2 <= 2 || n3 <= 2) {
            System.err.println("KolmogorovTest(): Sets must have more than 2 points");
            return d3;
        }
        double d4 = n2;
        double d5 = n3;
        double d6 = 1.0 / d4;
        double d7 = 1.0 / d5;
        if (dArray[0] < dArray2[0]) {
            d2 = -d6;
            n5 = 2;
            n4 = 1;
        } else {
            d2 = d7;
            n4 = 2;
            n5 = 1;
        }
        double d8 = Math.abs(d2);
        boolean bl2 = false;
        for (int i2 = 0; i2 < n2 + n3; ++i2) {
            if (dArray[n5 - 1] < dArray2[n4 - 1]) {
                d2 -= d6;
                if (++n5 > n2) {
                    bl2 = true;
                    break;
                }
            } else if (dArray[n5 - 1] > dArray2[n4 - 1]) {
                d2 += d7;
                if (++n4 > n3) {
                    bl2 = true;
                    break;
                }
            } else {
                double d9 = dArray[n5 - 1];
                while (dArray[n5 - 1] == d9 && n5 <= n2) {
                    d2 -= d6;
                    ++n5;
                }
                while (dArray2[n4 - 1] == d9 && n4 <= n3) {
                    d2 += d7;
                    ++n4;
                }
                if (n5 > n2) {
                    bl2 = true;
                    break;
                }
                if (n4 > n3) {
                    bl2 = true;
                    break;
                }
            }
            d8 = Math.max(d8, Math.abs(d2));
        }
        if (bl2) {
            d8 = Math.max(d8, Math.abs(d2));
            double d10 = d8 * Math.sqrt(d4 * d5 / (d4 + d5));
            d3 = this.kolmogorovProb(d10);
        }
        if ((string2 = string.toUpperCase(Locale.UK)).contains("D")) {
            System.out.println(String.format(" Kolmogorov Probability = %g, Max Dist = %g", d3, d8));
        }
        if (string2.contains("M")) {
            return d8;
        }
        return d3;
    }

    double kOrdStat(int n2, double[] dArray, int n3, int[] nArray) {
        int n4;
        int[] nArray2;
        boolean bl2 = false;
        int[] nArray3 = new int[100];
        if (nArray != null) {
            nArray2 = nArray;
        } else {
            nArray2 = nArray3;
            if (n2 > 100) {
                bl2 = true;
                nArray2 = new int[n2];
            }
        }
        for (n4 = 0; n4 < n2; ++n4) {
            nArray2[n4] = n4;
        }
        n4 = n3;
        int n5 = 0;
        int n6 = n2 - 1;
        while (true) {
            int n7;
            if (n6 <= n5 + 1) {
                if (n6 == n5 + 1 && dArray[nArray2[n6]] < dArray[nArray2[n5]]) {
                    n7 = nArray2[n5];
                    nArray2[n5] = nArray2[n6];
                    nArray2[n6] = n7;
                }
                double d2 = dArray[nArray2[n4]];
                if (bl2) {
                    nArray2 = null;
                }
                return d2;
            }
            int n8 = n5 + n6 >> 1;
            n7 = nArray2[n8];
            nArray2[n8] = nArray2[n5 + 1];
            nArray2[n5 + 1] = n7;
            if (dArray[nArray2[n5]] > dArray[nArray2[n6]]) {
                n7 = nArray2[n5];
                nArray2[n5] = nArray2[n6];
                nArray2[n6] = n7;
            }
            if (dArray[nArray2[n5 + 1]] > dArray[nArray2[n6]]) {
                n7 = nArray2[n5 + 1];
                nArray2[n5 + 1] = nArray2[n6];
                nArray2[n6] = n7;
            }
            if (dArray[nArray2[n5]] > dArray[nArray2[n5 + 1]]) {
                n7 = nArray2[n5];
                nArray2[n5] = nArray2[n5 + 1];
                nArray2[n5 + 1] = n7;
            }
            int n9 = n5 + 1;
            int n10 = n6;
            int n11 = nArray2[n5 + 1];
            while (true) {
                if (dArray[nArray2[++n9]] < dArray[n11]) {
                    continue;
                }
                while (dArray[nArray2[--n10]] > dArray[n11]) {
                }
                if (n10 < n9) break;
                n7 = nArray2[n9];
                nArray2[n9] = nArray2[n10];
                nArray2[n10] = n7;
            }
            nArray2[n5 + 1] = nArray2[n10];
            nArray2[n10] = n11;
            if (n10 >= n4) {
                n6 = n10 - 1;
            }
            if (n10 > n4) continue;
            n5 = n9;
        }
    }

    void quantiles(int n2, int n3, double[] dArray, double[] dArray2, double[] dArray3, boolean bl2, int[] nArray, int n4) {
        double d2;
        double d3;
        int n5;
        int n6;
        if (n4 < 1 || n4 > 9) {
            System.err.println("illegal value of type");
            return;
        }
        int[] nArray2 = null;
        if (!bl2) {
            nArray2 = nArray == null ? nArray : new int[n2];
        }
        double d4 = 0.0;
        if (n4 < 4) {
            for (n6 = 0; n6 < n3; ++n6) {
                d4 = (double)n2 * dArray3[n6];
                if (d4 < 1.0) {
                    if (bl2) {
                        dArray2[n6] = dArray[0];
                        continue;
                    }
                    dArray2[n6] = this.kOrdStat(n2, dArray, 0, nArray2);
                    continue;
                }
                n5 = Math.max(Math.floorNint(d4) - 1, 0);
                if (d4 - (double)n5 - 1.0 > 1.0E-14) {
                    if (bl2) {
                        dArray2[n6] = dArray[n5 + 1];
                        continue;
                    }
                    dArray2[n6] = this.kOrdStat(n2, dArray, n5 + 1, nArray2);
                    continue;
                }
                d3 = bl2 ? dArray[n5] : this.kOrdStat(n2, dArray, n5, nArray2);
                if (n4 == 1) {
                    dArray2[n6] = d3;
                }
                if (n4 == 2) {
                    d2 = bl2 ? dArray[n5 + 1] : this.kOrdStat(n2, dArray, n5 + 1, nArray2);
                    dArray2[n6] = 0.5 * (d3 + d2);
                }
                if (n4 != 3) continue;
                if (!Math.even(n5 - 1)) {
                    d2 = bl2 ? dArray[n5 + 1] : this.kOrdStat(n2, dArray, n5 + 1, nArray2);
                    dArray2[n6] = d2;
                    continue;
                }
                dArray2[n6] = d3;
            }
        }
        if (n4 > 3) {
            for (n6 = 0; n6 < n3; ++n6) {
                double d5 = (double)n2 * dArray3[n6];
                if (d5 < 1.0 && n4 != 7 && n4 != 4) {
                    dArray2[n6] = this.kOrdStat(n2, dArray, 0, nArray2);
                    continue;
                }
                if (n4 == 4) {
                    d4 = d5;
                }
                if (n4 == 5) {
                    d4 = d5 + 0.5;
                }
                if (n4 == 6) {
                    d4 = d5 + dArray3[n6];
                }
                if (n4 == 7) {
                    d4 = d5 - dArray3[n6] + 1.0;
                }
                if (n4 == 8) {
                    d4 = d5 + 0.3333333333333333 * (1.0 + dArray3[n6]);
                }
                if (n4 == 9) {
                    d4 = d5 + 0.25 * dArray3[n6] + 0.375;
                }
                int n7 = Math.floorNint(d4);
                n5 = Math.max(n7 - 1, 0);
                double d6 = d4 - (double)n7;
                if (bl2) {
                    d3 = dArray[n5];
                    d2 = dArray[n5 + 1];
                } else {
                    d3 = this.kOrdStat(n2, dArray, n5, nArray2);
                    d2 = this.kOrdStat(n2, dArray, n5 + 1, nArray2);
                }
                dArray2[n6] = (1.0 - d6) * d3 + d6 * d2;
            }
        }
    }

    public boolean rootsCubic(double[] dArray, double[] dArray2) {
        double d2;
        double d3;
        double d4;
        if (dArray[3] == 0.0) {
            return false;
        }
        boolean bl2 = false;
        double d5 = dArray[1] / dArray[3];
        double d6 = dArray[2] / dArray[3];
        double d7 = d5 - d6 * d6 / 3.0;
        double d8 = d7 / 3.0;
        double d9 = d8 * d8 * d8;
        double d10 = dArray[0] / dArray[3];
        double d11 = 2.0 * d6 * d6 * d6 / 27.0 - d6 * d5 / 3.0 + d10;
        double d12 = d11 / 2.0;
        double d13 = d9 + d12 * d12;
        if (d13 >= 0.0) {
            bl2 = true;
            d13 = Math.sqrt(d13);
            double d14 = -d12 + d13;
            double d15 = -d12 - d13;
            double d16 = 0.3333333333333333;
            double d17 = Math.log(Math.abs(d14));
            double d18 = Math.log(Math.abs(d15));
            double d19 = Math.sign(1.0, d14);
            double d20 = Math.sign(1.0, d15);
            d14 = d19 * Math.exp(d16 * d17);
            d15 = d20 * Math.exp(d16 * d18);
            double d21 = d14 + d15;
            double d22 = -d21 / 2.0;
            double d23 = (d14 - d15) * Math.sqrt(3.0) / 2.0;
            d16 = d6 / 3.0;
            d4 = d21 - d16;
            d3 = d22 - d16;
            d2 = d23;
        } else {
            d8 = -d8;
            d9 = -d9;
            double d24 = -d12 / Math.sqrt(d9);
            double d25 = Math.aCos(d24);
            double d26 = d25 / 3.0;
            double d27 = 1.0471975511965976;
            double d28 = Math.cos(d26);
            double d29 = Math.cos(d27 + d26);
            double d30 = Math.cos(d27 - d26);
            double d31 = Math.sqrt(d8);
            double d32 = 2.0 * d31 * d28;
            double d33 = -2.0 * d31 * d29;
            double d34 = -2.0 * d31 * d30;
            d31 = d6 / 3.0;
            d4 = d32 - d31;
            d3 = d33 - d31;
            d2 = d34 - d31;
        }
        dArray2[0] = d4;
        dArray2[1] = d3;
        dArray2[2] = d2;
        return bl2;
    }

    public double voigt(double d2, double d3, double d4, int n2) {
        double d5;
        if (d3 < 0.0 || d4 < 0.0 || d3 == 0.0 && d4 == 0.0) {
            return 0.0;
        }
        if (d3 == 0.0) {
            return d4 * 0.159154943 / (d2 * d2 + d4 * d4 / 4.0);
        }
        if (d4 == 0.0) {
            return 0.39894228 / d3 * Math.exp(-d2 * d2 / (2.0 * d3 * d3));
        }
        double d6 = d2 / d3 / 1.41421356;
        double d7 = d4 / 2.0 / d3 / 1.41421356;
        int n3 = n2 < 2 ? 2 : (n2 > 5 ? 5 : n2);
        double d8 = 1.51 * Math.exp(1.144 * (double)n3);
        double d9 = 1.6 * Math.exp(0.554 * (double)n3);
        double d10 = 0.56418958;
        double d11 = 1.5;
        double d12 = 3.0;
        double d13 = 2.25;
        double[] dArray = new double[]{1.0117281, -0.75197147, 0.012557727, 0.010022008, -2.4206814E-4, 5.0084806E-7};
        double[] dArray2 = new double[]{1.393237, 0.23115241, -0.15535147, 0.0062183662, 9.1908299E-5, -6.2752596E-7};
        double[] dArray3 = new double[]{0.31424038, 0.94778839, 1.5976826, 2.2795071, 3.020637, 3.8897249};
        double d14 = 0.0;
        double d15 = 0.0;
        double d16 = 0.0;
        double d17 = 0.0;
        double d18 = 0.0;
        double d19 = 0.0;
        double d20 = 0.0;
        double d21 = 0.0;
        double d22 = 0.0;
        double d23 = 0.0;
        double d24 = 0.0;
        double d25 = 0.0;
        double d26 = 0.0;
        double d27 = 0.0;
        double d28 = 0.0;
        double d29 = 0.0;
        double d30 = 0.0;
        double d31 = 0.0;
        double d32 = 0.0;
        double d33 = 0.0;
        double[] dArray4 = new double[6];
        double[] dArray5 = new double[6];
        double[] dArray6 = new double[6];
        double[] dArray7 = new double[6];
        double[] dArray8 = new double[6];
        double[] dArray9 = new double[6];
        double[] dArray10 = new double[6];
        double[] dArray11 = new double[6];
        boolean bl2 = true;
        boolean bl3 = true;
        boolean bl4 = true;
        double d34 = d7 * d7;
        double d35 = d7 * 0.56418958;
        double d36 = d8 - d7;
        double d37 = d9 - d7;
        double d38 = 3.097 * d7 - 0.45;
        double d39 = 6.8 - d7;
        double d40 = 18.1 * d7 + 1.65;
        if (d7 <= 1.0E-6) {
            d37 = d36;
            d39 = d36;
        }
        double d41 = Math.abs(d6);
        double d42 = d41 * d41;
        if (d41 > d36) {
            d5 = d35 / (d42 + d34);
        } else if (d41 > d37) {
            if (bl2) {
                bl2 = false;
                d14 = d34 + 0.5;
                d15 = d14 * d14;
                d16 = d34 + d34 - 1.0;
            }
            double d43 = 0.56418958 / (d15 + d42 * (d16 + d42));
            d5 = d43 * d7 * (d14 + d42);
        } else if (d41 > d39) {
            if (bl3) {
                d20 = 0.5625 + d34 * (4.5 + d34 * (10.5 + d34 * (6.0 + d34)));
                d21 = -4.5 + d34 * (9.0 + d34 * (6.0 + d34 * 4.0));
                d22 = 10.5 - d34 * (6.0 - d34 * 6.0);
                d23 = -6.0 + d34 * 4.0;
                d17 = 1.875 + d34 * (8.25 + d34 * (5.5 + d34));
                d18 = 5.25 + d34 * (1.0 + d34 * 3.0);
                d19 = 0.75 * d23;
            }
            double d44 = 0.56418958 / (d20 + d42 * (d21 + d42 * (d22 + d42 * (d23 + d42))));
            d5 = d44 * d7 * (d17 + d42 * (d18 + d42 * (d19 + d42)));
        } else if (d41 < d38) {
            if (bl4) {
                d29 = 272.1014 + d7 * (1280.829 + d7 * (2802.87 + d7 * (3764.966 + d7 * (3447.629 + d7 * (2256.981 + d7 * (1074.409 + d7 * (369.1989 + d7 * (88.26741 + d7 * (13.3988 + d7)))))))));
                d30 = 211.678 + d7 * (902.3066 + d7 * (1758.336 + d7 * (2037.31 + d7 * (1549.675 + d7 * (793.4273 + d7 * (266.2987 + d7 * (53.59518 + d7 * 5.0)))))));
                d31 = 78.86585 + d7 * (308.1852 + d7 * (497.3014 + d7 * (479.2576 + d7 * (269.2916 + d7 * (80.39278 + d7 * 10.0)))));
                d32 = 22.03523 + d7 * (55.02933 + d7 * (92.75679 + d7 * (53.59518 + d7 * 10.0)));
                d33 = 1.49646 + d7 * (13.3988 + d7 * 5.0);
                d24 = 153.5168 + d7 * (549.3954 + d7 * (919.4955 + d7 * (946.897 + d7 * (662.8097 + d7 * (328.2151 + d7 * (115.3772 + d7 * (27.93941 + d7 * (4.264678 + d7 * 0.3183291))))))));
                d25 = -34.16955 + d7 * (-1.322256 + d7 * (124.5975 + d7 * (189.773 + d7 * (139.4665 + d7 * (56.81652 + d7 * (12.79458 + d7 * 1.2733163))))));
                d26 = 2.584042 + d7 * (10.46332 + d7 * (24.01655 + d7 * (29.81482 + d7 * (12.79568 + d7 * 1.9099744))));
                d27 = -0.07272979 + d7 * (0.9377051 + d7 * (4.266322 + d7 * 1.273316));
                d28 = 5.480304E-4 + d7 * 0.3183291;
            }
            double d45 = 1.7724538 / (d29 + d42 * (d30 + d42 * (d31 + d42 * (d32 + d42 * (d33 + d42)))));
            d5 = d45 * (d24 + d42 * (d25 + d42 * (d26 + d42 * (d27 + d42 * d28))));
        } else {
            int n4;
            double d46 = d7 + 1.5;
            double d47 = d46 * d46;
            d5 = 0.0;
            for (n4 = 0; n4 <= 5; ++n4) {
                double d48 = d6 - dArray3[n4];
                dArray8[n4] = d48 * d48;
                dArray10[n4] = 1.0 / (dArray8[n4] + d47);
                dArray5[n4] = dArray10[n4] * d48;
                dArray7[n4] = dArray10[n4] * d46;
                d48 = d6 + dArray3[n4];
                dArray9[n4] = d48 * d48;
                dArray11[n4] = 1.0 / (dArray9[n4] + d47);
                dArray4[n4] = dArray11[n4] * d48;
                dArray6[n4] = dArray11[n4] * d46;
            }
            if (d41 <= d40) {
                for (n4 = 0; n4 <= 5; ++n4) {
                    d5 = d5 + dArray[n4] * (dArray7[n4] + dArray6[n4]) - dArray2[n4] * (dArray5[n4] - dArray4[n4]);
                }
            } else {
                double d49 = d7 + 3.0;
                for (n4 = 0; n4 <= 5; ++n4) {
                    d5 = d5 + (dArray[n4] * (dArray8[n4] * dArray10[n4] - 1.5 * dArray7[n4]) + dArray2[n4] * d49 * dArray5[n4]) / (dArray8[n4] + 2.25) + (dArray[n4] * (dArray9[n4] * dArray11[n4] - 1.5 * dArray6[n4]) - dArray2[n4] * d49 * dArray4[n4]) / (dArray9[n4] + 2.25);
                }
                d5 = d7 * d5 + Math.exp(-d42);
            }
        }
        return d5 / 2.506628 / d3;
    }

    public static double besselI(int n2, double d2) {
        int n3;
        if (n2 < 0) {
            System.err.println("BesselI(): *I* Invalid argument(s) (n,x) = (" + n2 + ", " + d2 + ")");
            return 0.0;
        }
        if (n2 == 0) {
            return Math.besselI0(d2);
        }
        if (n2 == 1) {
            return Math.besselI1(d2);
        }
        if (d2 == 0.0) {
            return 0.0;
        }
        double d3 = 1.0E10;
        if (Math.abs(d2) > 1.0E10) {
            return 0.0;
        }
        int n4 = 40;
        double d4 = 1.0E-10;
        double d5 = 2.0 / Math.abs(d2);
        double d6 = 0.0;
        double d7 = 0.0;
        double d8 = 1.0;
        double d9 = 0.0;
        for (int i2 = n3 = 2 * (n2 + (int)Math.sqrt(40 * n2)); i2 >= 1; --i2) {
            d7 = d6 + (double)i2 * d5 * d8;
            d6 = d8;
            d8 = d7;
            if (Math.abs(d8) > 1.0E10) {
                d9 *= 1.0E-10;
                d8 *= 1.0E-10;
                d6 *= 1.0E-10;
            }
            if (i2 != n2) continue;
            d9 = d6;
        }
        d9 *= Math.besselI0(d2) / d8;
        if (d2 < 0.0 && n2 % 2 == 1) {
            d9 = -d9;
        }
        return d9;
    }

    public static double besselI0(double d2) {
        double d3 = 1.0;
        double d4 = 3.5156229;
        double d5 = 3.0899424;
        double d6 = 1.2067492;
        double d7 = 0.2659732;
        double d8 = 0.0360768;
        double d9 = 0.0045813;
        double d10 = 0.39894228;
        double d11 = 0.01328592;
        double d12 = 0.00225319;
        double d13 = -0.00157565;
        double d14 = 0.00916281;
        double d15 = -0.02057706;
        double d16 = 0.02635537;
        double d17 = -0.01647633;
        double d18 = 0.00392377;
        double d19 = 3.75;
        double d20 = Math.abs(d2);
        double d21 = 0.0;
        double d22 = 0.0;
        if (d20 < 3.75) {
            double d23 = d2 / 3.75;
            d21 = d23 * d23;
            d22 = 1.0 + d21 * (3.5156229 + d21 * (3.0899424 + d21 * (1.2067492 + d21 * (0.2659732 + d21 * (0.0360768 + d21 * 0.0045813)))));
        } else {
            d21 = 3.75 / d20;
            d22 = Math.exp(d20) / Math.sqrt(d20) * (0.39894228 + d21 * (0.01328592 + d21 * (0.00225319 + d21 * (-0.00157565 + d21 * (0.00916281 + d21 * (-0.02057706 + d21 * (0.02635537 + d21 * (-0.01647633 + d21 * 0.00392377))))))));
        }
        return d22;
    }

    public static double besselI1(double d2) {
        double d3 = 0.5;
        double d4 = 0.87890594;
        double d5 = 0.51498869;
        double d6 = 0.15084934;
        double d7 = 0.02658733;
        double d8 = 0.00301532;
        double d9 = 3.2411E-4;
        double d10 = 0.39894228;
        double d11 = -0.03988024;
        double d12 = -0.00362018;
        double d13 = 0.00163801;
        double d14 = -0.01031555;
        double d15 = 0.02282967;
        double d16 = -0.02895312;
        double d17 = 0.01787654;
        double d18 = -0.00420059;
        double d19 = 3.75;
        double d20 = Math.abs(d2);
        double d21 = 0.0;
        double d22 = 0.0;
        if (d20 < 3.75) {
            double d23 = d2 / 3.75;
            d21 = d23 * d23;
            d22 = d2 * (0.5 + d21 * (0.87890594 + d21 * (0.51498869 + d21 * (0.15084934 + d21 * (0.02658733 + d21 * (0.00301532 + d21 * 3.2411E-4))))));
        } else {
            d21 = 3.75 / d20;
            d22 = Math.exp(d20) / Math.sqrt(d20) * (0.39894228 + d21 * (-0.03988024 + d21 * (-0.00362018 + d21 * (0.00163801 + d21 * (-0.01031555 + d21 * (0.02282967 + d21 * (-0.02895312 + d21 * (0.01787654 + d21 * -0.00420059))))))));
            if (d2 < 0.0) {
                d22 = -d22;
            }
        }
        return d22;
    }

    public static double besselJ0(double d2) {
        double d3;
        double d4;
        double d5 = 5.7568490574E10;
        double d6 = -1.3362590354E10;
        double d7 = 6.516196407E8;
        double d8 = -1.121442418E7;
        double d9 = 77392.33017;
        double d10 = -184.9052456;
        double d11 = 5.7568490411E10;
        double d12 = 1.029532985E9;
        double d13 = 9494680.718;
        double d14 = 59272.64853;
        double d15 = 267.8532712;
        double d16 = 0.785398164;
        double d17 = -0.001098628627;
        double d18 = 2.734510407E-5;
        double d19 = -2.073370639E-6;
        double d20 = 2.093887211E-7;
        double d21 = -0.01562499995;
        double d22 = 1.430488765E-4;
        double d23 = -6.911147651E-6;
        double d24 = 7.621095161E-7;
        double d25 = 9.34935152E-8;
        double d26 = 0.636619772;
        double d27 = Math.abs(d2);
        if (d4 < 8.0) {
            double d28 = d2 * d2;
            double d29 = 5.7568490574E10 + d28 * (-1.3362590354E10 + d28 * (6.516196407E8 + d28 * (-1.121442418E7 + d28 * (77392.33017 + d28 * -184.9052456))));
            double d30 = 5.7568490411E10 + d28 * (1.029532985E9 + d28 * (9494680.718 + d28 * (59272.64853 + d28 * (267.8532712 + d28))));
            d3 = d29 / d30;
        } else {
            double d31 = 8.0 / d27;
            double d32 = d31 * d31;
            double d33 = d27 - 0.785398164;
            double d34 = 1.0 + d32 * (-0.001098628627 + d32 * (2.734510407E-5 + d32 * (-2.073370639E-6 + d32 * 2.093887211E-7)));
            double d35 = -0.01562499995 + d32 * (1.430488765E-4 + d32 * (-6.911147651E-6 + d32 * (7.621095161E-7 - d32 * 9.34935152E-8)));
            d3 = Math.sqrt(0.636619772 / d27) * (Math.cos(d33) * d34 - d31 * Math.sin(d33) * d35);
        }
        return d3;
    }

    public static double besselJ1(double d2) {
        double d3;
        double d4;
        double d5 = 7.2362614232E10;
        double d6 = -7.895059235E9;
        double d7 = 2.423968531E8;
        double d8 = -2972611.439;
        double d9 = 15704.4826;
        double d10 = -30.16036606;
        double d11 = 1.44725228442E11;
        double d12 = 2.300535178E9;
        double d13 = 1.858330474E7;
        double d14 = 99447.43394;
        double d15 = 376.9991397;
        double d16 = 2.356194491;
        double d17 = 0.00183105;
        double d18 = -3.516396496E-5;
        double d19 = 2.457520174E-6;
        double d20 = -2.40337019E-7;
        double d21 = 0.04687499995;
        double d22 = -2.002690873E-4;
        double d23 = 8.449199096E-6;
        double d24 = -8.8228987E-7;
        double d25 = 1.05787412E-7;
        double d26 = 0.636619772;
        double d27 = Math.abs(d2);
        if (d4 < 8.0) {
            double d28 = d2 * d2;
            double d29 = d2 * (7.2362614232E10 + d28 * (-7.895059235E9 + d28 * (2.423968531E8 + d28 * (-2972611.439 + d28 * (15704.4826 + d28 * -30.16036606)))));
            double d30 = 1.44725228442E11 + d28 * (2.300535178E9 + d28 * (1.858330474E7 + d28 * (99447.43394 + d28 * (376.9991397 + d28))));
            d3 = d29 / d30;
        } else {
            double d31 = 8.0 / d27;
            double d32 = d31 * d31;
            double d33 = d27 - 2.356194491;
            double d34 = 1.0 + d32 * (0.00183105 + d32 * (-3.516396496E-5 + d32 * (2.457520174E-6 + d32 * -2.40337019E-7)));
            double d35 = 0.04687499995 + d32 * (-2.002690873E-4 + d32 * (8.449199096E-6 + d32 * (-8.8228987E-7 + d32 * 1.05787412E-7)));
            d3 = Math.sqrt(0.636619772 / d27) * (Math.cos(d33) * d34 - d31 * Math.sin(d33) * d35);
            if (d2 < 0.0) {
                d3 = -d3;
            }
        }
        return d3;
    }

    public static double besselK(int n2, double d2) {
        if (d2 <= 0.0 || n2 < 0) {
            System.err.println("BesselK(): *K* Invalid argument(s) (n,x) = (" + n2 + ", " + d2 + ")");
            return 0.0;
        }
        if (n2 == 0) {
            return Math.besselK0(d2);
        }
        if (n2 == 1) {
            return Math.besselK1(d2);
        }
        double d3 = 2.0 / d2;
        double d4 = Math.besselK0(d2);
        double d5 = Math.besselK1(d2);
        double d6 = 0.0;
        for (int i2 = 1; i2 < n2; ++i2) {
            d6 = d4 + (double)i2 * d3 * d5;
            d4 = d5;
            d5 = d6;
        }
        return d5;
    }

    public static double besselK0(double d2) {
        if (d2 <= 0.0) {
            System.err.println("BesselK0(): *K0* Invalid argument x = " + d2);
            return 0.0;
        }
        double d3 = -0.57721566;
        double d4 = 0.4227842;
        double d5 = 0.23069756;
        double d6 = 0.0348859;
        double d7 = 0.00262698;
        double d8 = 1.075E-4;
        double d9 = 7.4E-6;
        double d10 = 1.25331414;
        double d11 = -0.07832358;
        double d12 = 0.02189568;
        double d13 = -0.01062446;
        double d14 = 0.00587872;
        double d15 = -0.0025154;
        double d16 = 5.3208E-4;
        double d17 = 0.0;
        double d18 = 0.0;
        if (d2 <= 2.0) {
            d17 = d2 * d2 / 4.0;
            d18 = -Math.log(d2 / 2.0) * Math.besselI0(d2) + (-0.57721566 + d17 * (0.4227842 + d17 * (0.23069756 + d17 * (0.0348859 + d17 * (0.00262698 + d17 * (1.075E-4 + d17 * 7.4E-6))))));
        } else {
            d17 = 2.0 / d2;
            d18 = Math.exp(-d2) / Math.sqrt(d2) * (1.25331414 + d17 * (-0.07832358 + d17 * (0.02189568 + d17 * (-0.01062446 + d17 * (0.00587872 + d17 * (-0.0025154 + d17 * 5.3208E-4))))));
        }
        return d18;
    }

    public static double besselK1(double d2) {
        if (d2 <= 0.0) {
            System.err.println("BesselK1(): *K1* Invalid argument x = " + d2);
            return 0.0;
        }
        double d3 = 1.0;
        double d4 = 0.15443144;
        double d5 = -0.67278579;
        double d6 = -0.18156897;
        double d7 = -0.01919402;
        double d8 = -0.00110404;
        double d9 = -4.686E-5;
        double d10 = 1.25331414;
        double d11 = 0.23498619;
        double d12 = -0.0365562;
        double d13 = 0.01504268;
        double d14 = -0.00780353;
        double d15 = 0.00325614;
        double d16 = -6.8245E-4;
        double d17 = 0.0;
        double d18 = 0.0;
        if (d2 <= 2.0) {
            d17 = d2 * d2 / 4.0;
            d18 = Math.log(d2 / 2.0) * Math.besselI1(d2) + 1.0 / d2 * (1.0 + d17 * (0.15443144 + d17 * (-0.67278579 + d17 * (-0.18156897 + d17 * (-0.01919402 + d17 * (-0.00110404 + d17 * -4.686E-5))))));
        } else {
            d17 = 2.0 / d2;
            d18 = Math.exp(-d2) / Math.sqrt(d2) * (1.25331414 + d17 * (0.23498619 + d17 * (-0.0365562 + d17 * (0.01504268 + d17 * (-0.00780353 + d17 * (0.00325614 + d17 * -6.8245E-4))))));
        }
        return d18;
    }

    public static double besselY0(double d2) {
        double d3;
        double d4 = -2.957821389E9;
        double d5 = 7.062834065E9;
        double d6 = -5.123598036E8;
        double d7 = 1.087988129E7;
        double d8 = -86327.92757;
        double d9 = 228.4622733;
        double d10 = 4.0076544269E10;
        double d11 = 7.452499648E8;
        double d12 = 7189466.438;
        double d13 = 47447.2647;
        double d14 = 226.1030244;
        double d15 = 0.636619772;
        double d16 = 0.785398164;
        double d17 = -0.001098628627;
        double d18 = 2.734510407E-5;
        double d19 = -2.073370639E-6;
        double d20 = 2.093887211E-7;
        double d21 = -0.01562499995;
        double d22 = 1.430488765E-4;
        double d23 = -6.911147651E-6;
        double d24 = 7.621095161E-7;
        double d25 = -9.34945152E-8;
        double d26 = 0.636619772;
        if (d2 < 8.0) {
            double d27 = d2 * d2;
            double d28 = -2.957821389E9 + d27 * (7.062834065E9 + d27 * (-5.123598036E8 + d27 * (1.087988129E7 + d27 * (-86327.92757 + d27 * 228.4622733))));
            double d29 = 4.0076544269E10 + d27 * (7.452499648E8 + d27 * (7189466.438 + d27 * (47447.2647 + d27 * (226.1030244 + d27))));
            d3 = d28 / d29 + 0.636619772 * Math.besselJ0(d2) * Math.log(d2);
        } else {
            double d30 = 8.0 / d2;
            double d31 = d30 * d30;
            double d32 = d2 - 0.785398164;
            double d33 = 1.0 + d31 * (-0.001098628627 + d31 * (2.734510407E-5 + d31 * (-2.073370639E-6 + d31 * 2.093887211E-7)));
            double d34 = -0.01562499995 + d31 * (1.430488765E-4 + d31 * (-6.911147651E-6 + d31 * (7.621095161E-7 + d31 * -9.34945152E-8)));
            d3 = Math.sqrt(0.636619772 / d2) * (Math.sin(d32) * d33 + d30 * Math.cos(d32) * d34);
        }
        return d3;
    }

    public static double besselY1(double d2) {
        double d3;
        double d4 = -4.900604943E12;
        double d5 = 1.27527439E12;
        double d6 = -5.153438139E10;
        double d7 = 7.349264551E8;
        double d8 = -4237922.726;
        double d9 = 8511.937935;
        double d10 = 2.49958057E13;
        double d11 = 4.244419664E11;
        double d12 = 3.733650367E9;
        double d13 = 2.245904002E7;
        double d14 = 102042.605;
        double d15 = 354.9632885;
        double d16 = 0.636619772;
        double d17 = 2.356194491;
        double d18 = 0.00183105;
        double d19 = -3.516396496E-5;
        double d20 = 2.457520174E-6;
        double d21 = -2.40337019E-7;
        double d22 = 0.04687499995;
        double d23 = -2.002690873E-4;
        double d24 = 8.449199096E-6;
        double d25 = -8.8228987E-7;
        double d26 = 1.05787412E-7;
        double d27 = 0.636619772;
        if (d2 < 8.0) {
            double d28 = d2 * d2;
            double d29 = d2 * (-4.900604943E12 + d28 * (1.27527439E12 + d28 * (-5.153438139E10 + d28 * (7.349264551E8 + d28 * (-4237922.726 + d28 * 8511.937935)))));
            double d30 = 2.49958057E13 + d28 * (4.244419664E11 + d28 * (3.733650367E9 + d28 * (2.245904002E7 + d28 * (102042.605 + d28 * (354.9632885 + d28)))));
            d3 = d29 / d30 + 0.636619772 * (Math.besselJ1(d2) * Math.log(d2) - 1.0 / d2);
        } else {
            double d31 = 8.0 / d2;
            double d32 = d31 * d31;
            double d33 = d2 - 2.356194491;
            double d34 = 1.0 + d32 * (0.00183105 + d32 * (-3.516396496E-5 + d32 * (2.457520174E-6 + d32 * -2.40337019E-7)));
            double d35 = 0.04687499995 + d32 * (-2.002690873E-4 + d32 * (8.449199096E-6 + d32 * (-8.8228987E-7 + d32 * 1.05787412E-7)));
            d3 = Math.sqrt(0.636619772 / d2) * (Math.sin(d33) * d34 + d31 * Math.cos(d33) * d35);
        }
        return d3;
    }

    public static double beta(double d2, double d3) {
        return Math.exp(Math.lnGamma(d2) + Math.lnGamma(d3) - Math.lnGamma(d2 + d3));
    }

    public static double betaCf(double d2, double d3, double d4) {
        int n2;
        int n3 = 500;
        double d5 = 3.0E-14;
        double d6 = 1.0E-30;
        double d7 = d3 + d4;
        double d8 = d3 + 1.0;
        double d9 = d3 - 1.0;
        double d10 = 1.0;
        double d11 = 1.0 - d7 * d2 / d8;
        if (Math.abs(d11) < 1.0E-30) {
            d11 = 1.0E-30;
        }
        double d12 = d11 = 1.0 / d11;
        for (n2 = 1; n2 <= 500; ++n2) {
            int n4 = n2 * 2;
            double d13 = (double)n2 * (d4 - (double)n2) * d2 / ((d9 + (double)n4) * (d3 + (double)n4));
            if (Math.abs(d11 = 1.0 + d13 * d11) < 1.0E-30) {
                d11 = 1.0E-30;
            }
            if (Math.abs(d10 = 1.0 + d13 / d10) < 1.0E-30) {
                d10 = 1.0E-30;
            }
            d11 = 1.0 / d11;
            d12 *= d11 * d10;
            d13 = -(d3 + (double)n2) * (d7 + (double)n2) * d2 / ((d3 + (double)n4) * (d8 + (double)n4));
            if (Math.abs(d11 = 1.0 + d13 * d11) < 1.0E-30) {
                d11 = 1.0E-30;
            }
            if (Math.abs(d10 = 1.0 + d13 / d10) < 1.0E-30) {
                d10 = 1.0E-30;
            }
            d11 = 1.0 / d11;
            double d14 = d11 * d10;
            d12 *= d14;
            if (Math.abs(d14 - 1.0) <= 3.0E-14) break;
        }
        if (n2 > 500) {
            System.err.printf("BetaCf: a or b too big, or itmax too small, a=%e, b=%e, x=%e, h=%e, itmax=%e", d3, d4, d2, d12, 500);
        }
        return d12;
    }

    public static double betaDist(double d2, double d3, double d4) {
        if (d2 < 0.0 || d2 > 1.0 || d3 <= 0.0 || d4 <= 0.0) {
            System.err.println("BetaDist(): - parameter value outside allowed range");
            return 0.0;
        }
        double d5 = Math.beta(d3, d4);
        double d6 = Math.pow(d2, d3 - 1.0) * Math.pow(1.0 - d2, d4 - 1.0) / d5;
        return d6;
    }

    public static double betaDistI(double d2, double d3, double d4) {
        if (d2 < 0.0 || d2 > 1.0 || d3 <= 0.0 || d4 <= 0.0) {
            System.err.println("BetaDistI(): parameter value outside allowed range");
            return 0.0;
        }
        double d5 = Math.betaIncomplete(d2, d3, d4);
        return d5;
    }

    public static double betaIncomplete(double d2, double d3, double d4) {
        if (d2 < 0.0 || d2 > 1.0) {
            System.err.println("BetaIncomplete(): X must between 0 and 1");
            return 0.0;
        }
        double d5 = d2 == 0.0 || d2 == 1.0 ? 0.0 : Math.pow(d2, d3) * Math.pow(1.0 - d2, d4) / Math.beta(d3, d4);
        if (d2 < (d3 + 1.0) / (d3 + d4 + 2.0)) {
            return d5 * Math.betaCf(d2, d3, d4) / d3;
        }
        return 1.0 - d5 * Math.betaCf(1.0 - d2, d4, d3) / d4;
    }

    public static long binarySearch(double[] dArray, double d2) {
        return Math.binarySearch(dArray, 0, dArray.length, d2);
    }

    public static long binarySearch(double[] dArray, int n2, int n3, double d2) {
        if (dArray == null || dArray.length <= 0) {
            return -1L;
        }
        int n4 = n3;
        int n5 = n4 + n2 + 1;
        int n6 = n2;
        while (n5 - n6 > 1) {
            int n7 = (n5 + n6) / 2;
            if (d2 == dArray[n7 - 1]) {
                return n7 - 1;
            }
            if (d2 < dArray[n7 - 1]) {
                n5 = n7;
                continue;
            }
            n6 = n7;
        }
        return n6 - 1;
    }

    public static long binarySearch(float[] fArray, float f2) {
        return Math.binarySearch(fArray, 0, fArray.length, f2);
    }

    public static long binarySearch(float[] fArray, int n2, int n3, float f2) {
        if (fArray == null || fArray.length <= 0) {
            return -1L;
        }
        int n4 = n3;
        int n5 = n4 + n2 + 1;
        int n6 = n2;
        while (n5 - n6 > 1) {
            int n7 = (n5 + n6) / 2;
            if (f2 == fArray[n7 - 1]) {
                return n7 - 1;
            }
            if (f2 < fArray[n7 - 1]) {
                n5 = n7;
                continue;
            }
            n6 = n7;
        }
        return n6 - 1;
    }

    public static long binarySearch(int[] nArray, int n2) {
        return Math.binarySearch(nArray, 0, nArray.length, n2);
    }

    public static long binarySearch(int[] nArray, int n2, int n3, int n4) {
        if (nArray == null || nArray.length <= 0) {
            return -1L;
        }
        int n5 = n3;
        int n6 = n5 + n2 + 1;
        int n7 = n2;
        while (n6 - n7 > 1) {
            int n8 = (n6 + n7) / 2;
            if (n4 == nArray[n8 - 1]) {
                return n8 - 1;
            }
            if (n4 < nArray[n8 - 1]) {
                n6 = n8;
                continue;
            }
            n7 = n8;
        }
        return n7 - 1;
    }

    public static long binarySearch(long[] lArray, long l2) {
        return Math.binarySearch(lArray, 0, lArray.length, l2);
    }

    public static long binarySearch(long[] lArray, int n2, int n3, long l2) {
        if (lArray == null || lArray.length <= 0) {
            return -1L;
        }
        int n4 = n3;
        int n5 = n4 + n2 + 1;
        int n6 = n2;
        while (n5 - n6 > 1) {
            int n7 = (n5 + n6) / 2;
            if (l2 == lArray[n7 - 1]) {
                return n7 - 1;
            }
            if (l2 < lArray[n7 - 1]) {
                n5 = n7;
                continue;
            }
            n6 = n7;
        }
        return n6 - 1;
    }

    public static long binarySearch(short[] sArray, short s2) {
        return Math.binarySearch(sArray, 0, sArray.length, s2);
    }

    public static long binarySearch(short[] sArray, int n2, int n3, short s2) {
        if (sArray == null || sArray.length <= 0) {
            return -1L;
        }
        int n4 = n3;
        int n5 = n4 + n2 + 1;
        int n6 = n2;
        while (n5 - n6 > 1) {
            int n7 = (n5 + n6) / 2;
            if (s2 == sArray[n7 - 1]) {
                return n7 - 1;
            }
            if (s2 < sArray[n7 - 1]) {
                n5 = n7;
                continue;
            }
            n6 = n7;
        }
        return n6 - 1;
    }

    public static double binomial(int n2, int n3) {
        if (n3 == 0 || n2 == n3) {
            return 1.0;
        }
        if (n2 <= 0 || n3 < 0 || n2 < n3) {
            return 0.0;
        }
        int n4 = Math.min(n3, n2 - n3);
        int n5 = n2 - n4;
        double d2 = n5 + 1;
        for (int i2 = n4; i2 > 1; --i2) {
            d2 *= (double)(n5 + i2) / (double)i2;
        }
        return d2;
    }

    public static double binomialI(double d2, int n2, int n3) {
        if (n3 <= 0) {
            return 1.0;
        }
        if (n3 > n2) {
            return 0.0;
        }
        if (n3 == n2) {
            return Math.pow(d2, n2);
        }
        return Math.betaIncomplete(d2, n3, n2 - n3 + 1);
    }

    public static double breitWigner(double d2, double d3, double d4) {
        double d5 = d4 / ((d2 - d3) * (d2 - d3) + d4 * d4 / 4.0);
        return d5 / (java.lang.Math.PI * 2);
    }

    public static double cauchyDist(double d2, double d3, double d4) {
        double d5 = (d2 - d3) * (d2 - d3) / (d4 * d4);
        double d6 = 1.0 / (d4 * java.lang.Math.PI * (1.0 + d5));
        return d6;
    }

    public static double chisquareQuantile(double d2, double d3) {
        double d4;
        double d5;
        double d6;
        double d7;
        double d8;
        double d9;
        double d10;
        double d11;
        double d12;
        double d13;
        double d14;
        double d15;
        double d16;
        if (d3 <= 0.0) {
            return 0.0;
        }
        double[] dArray = new double[]{0.0, 0.01, 0.222222, 0.32, 0.4, 1.24, 2.2, 4.67, 6.66, 6.73, 13.32, 60.0, 70.0, 84.0, 105.0, 120.0, 127.0, 140.0, 175.0, 210.0, 252.0, 264.0, 294.0, 346.0, 420.0, 462.0, 606.0, 672.0, 707.0, 735.0, 889.0, 932.0, 966.0, 1141.0, 1182.0, 1278.0, 1740.0, 2520.0, 5040.0};
        double d17 = 5.0E-7;
        double d18 = 0.6931471806;
        double d19 = Math.lnGamma(0.5 * d3);
        double d20 = 0.5 * d3;
        double d21 = d20 - 1.0;
        if (d3 >= Math.log(d2) * -dArray[5]) {
            if (d3 > dArray[3]) {
                double d22 = Math.normQuantile(d2);
                d15 = d3 * Math.pow(d22 * Math.sqrt(d16 = dArray[2] / d3) + 1.0 - d16, 3.0);
                if (d15 > dArray[6] * d3 + 6.0) {
                    d15 = -2.0 * (Math.log(1.0 - d2) - d21 * Math.log(0.5 * d15) + d19);
                }
            } else {
                d15 = dArray[4];
                d14 = Math.log(1.0 - d2);
                do {
                    d13 = d15;
                    d16 = 1.0 + d15 * (dArray[7] + d15);
                    d12 = d15 * (dArray[9] + d15 * (dArray[8] + d15));
                    d11 = -0.5 + (dArray[7] + 2.0 * d15) / d16 - (dArray[9] + d15 * (dArray[10] + 3.0 * d15)) / d12;
                } while (Math.abs(d13 / (d15 -= (1.0 - Math.exp(d14 + d19 + 0.5 * d15 + d21 * 0.6931471806) * d12 / d16) / d11) - 1.0) > dArray[1]);
            }
        } else {
            d15 = Math.pow(d2 * d20 * Math.exp(d19 + d20 * 0.6931471806), 1.0 / d20);
            if (d15 < 5.0E-7) {
                return d15;
            }
        }
        int n2 = 20;
        for (int i2 = 0; i2 < 20 && !(Math.abs((d13 = d15) / (d15 += (d11 = (d12 = d2 - Math.gamma(d20, d16 = 0.5 * d15)) * Math.exp(d20 * 0.6931471806 + d19 + d16 - d21 * Math.log(d15))) * (1.0 + 0.5 * d11 * (d10 = (dArray[19] + (d14 = 0.5 * d11 - (d9 = d11 / d15) * d21) * (dArray[17] + d14 * (dArray[14] + d14 * (dArray[13] + d14 * (dArray[12] + dArray[11] * d14))))) / dArray[24]) - d9 * d21 * (d10 - d9 * ((d8 = (dArray[24] + d14 * (dArray[29] + d14 * (dArray[32] + d14 * (dArray[33] + dArray[35] * d14)))) / dArray[37]) - d9 * ((d7 = (dArray[19] + d14 * (dArray[25] + d14 * (dArray[28] + dArray[31] * d14))) / dArray[37]) - d9 * ((d6 = (dArray[20] + d14 * (dArray[27] + dArray[34] * d14) + d21 * (dArray[22] + d14 * (dArray[30] + dArray[36] * d14))) / dArray[38]) - d9 * ((d5 = (dArray[13] + dArray[21] * d14 + d21 * (dArray[18] + dArray[26] * d14)) / dArray[37]) - d9 * (d4 = (dArray[15] + d21 * (dArray[23] + dArray[16] * d21)) / dArray[38])))))))) - 1.0) > 5.0E-7); ++i2) {
        }
        return d15;
    }

    public static double correlationCoefficient(double[] dArray, double[] dArray2, double[] dArray3) {
        int n2 = dArray.length;
        if (dArray2.length != n2) {
            throw new IllegalArgumentException("x and y array lengths must be equal");
        }
        if (dArray3.length != n2) {
            throw new IllegalArgumentException("x and weight array lengths must be equal");
        }
        double d2 = Math.covariance(dArray, dArray2, dArray3);
        double d3 = Math.variance(dArray, dArray3);
        double d4 = Math.variance(dArray2, dArray3);
        return d2 / Math.sqrt(d3 * d4);
    }

    public static double covariance(double[] dArray, double[] dArray2, double[] dArray3) {
        int n2 = dArray.length;
        if (n2 != dArray2.length) {
            throw new IllegalArgumentException("length of x variable array, " + n2 + " and length of y array, " + dArray2.length + " are different");
        }
        if (n2 != dArray3.length) {
            throw new IllegalArgumentException("length of x variable array, " + n2 + " and length of weight array, " + dArray2.length + " are different");
        }
        double d2 = Math.effectiveSampleNumber(dArray3);
        double d3 = d2 / (d2 - 1.0);
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        double[] dArray4 = Math.invertAndSquare(dArray3);
        for (int i2 = 0; i2 < n2; ++i2) {
            d4 += dArray[i2] * dArray4[i2];
            d5 += dArray2[i2] * dArray4[i2];
            d6 += dArray4[i2];
        }
        double d7 = d4 / d6;
        double d8 = d5 / d6;
        double d9 = 0.0;
        for (int i3 = 0; i3 < n2; ++i3) {
            d9 += dArray4[i3] * (dArray[i3] - d7) * (dArray2[i3] - d8);
        }
        return d9 * d3 / d6;
    }

    public static double[] cross(double[] dArray, double[] dArray2, double[] dArray3) {
        dArray3[0] = dArray[1] * dArray2[2] - dArray[2] * dArray2[1];
        dArray3[1] = dArray[2] * dArray2[0] - dArray[0] * dArray2[2];
        dArray3[2] = dArray[0] * dArray2[1] - dArray[1] * dArray2[0];
        return dArray3;
    }

    public static float[] cross(float[] fArray, float[] fArray2, float[] fArray3) {
        fArray3[0] = fArray[1] * fArray2[2] - fArray[2] * fArray2[1];
        fArray3[1] = fArray[2] * fArray2[0] - fArray[0] * fArray2[2];
        fArray3[2] = fArray[0] * fArray2[1] - fArray[1] * fArray2[0];
        return fArray3;
    }

    public static double diLog(double d2) {
        double d3;
        double d4 = 0.5;
        double d5 = java.lang.Math.PI;
        double d6 = java.lang.Math.PI * java.lang.Math.PI;
        double d7 = 3.289868133696453;
        double d8 = 1.6449340668482264;
        double d9 = 0.8224670334241132;
        double[] dArray = new double[]{0.429966935608137, 0.4097598753307711, -0.01858843665014592, 0.00145751084062268, -1.430418444234E-4, 1.58841554188E-5, -1.90784959387E-6, 2.4195180854E-7, -3.193341274E-8, 4.34545063E-9, -6.057848E-10, 8.612098E-11, -1.244332E-11, 1.82256E-12, -2.7007E-13, 4.042E-14, -6.1E-15, 9.3E-16, -1.4E-16, 2.0E-17};
        double d10 = 0.0;
        if (d2 == 1.0) {
            d3 = 1.6449340668482264;
        } else if (d2 == -1.0) {
            d3 = -0.8224670334241132;
        } else {
            double d11;
            double d12;
            double d13;
            double d14;
            double d15;
            double d16 = -d2;
            if (d16 <= -2.0) {
                d15 = -1.0 / (1.0 + d16);
                d14 = 1.0;
                d13 = Math.log(-d16);
                d12 = Math.log(1.0 + 1.0 / d16);
                d11 = -3.289868133696453 + 0.5 * (d13 * d13 - d12 * d12);
            } else if (d16 < -1.0) {
                d15 = -1.0 - d16;
                d14 = -1.0;
                d11 = Math.log(-d16);
                d11 = -1.6449340668482264 + d11 * (d11 + Math.log(1.0 + 1.0 / d16));
            } else if (d16 <= -0.5) {
                d15 = -(1.0 + d16) / d16;
                d14 = 1.0;
                d11 = Math.log(-d16);
                d11 = -1.6449340668482264 + d11 * (-0.5 * d11 + Math.log(1.0 + d16));
            } else if (d16 < 0.0) {
                d15 = -d16 / (1.0 + d16);
                d14 = -1.0;
                d13 = Math.log(1.0 + d16);
                d11 = 0.5 * d13 * d13;
            } else if (d16 <= 1.0) {
                d15 = d16;
                d14 = 1.0;
                d11 = 0.0;
            } else {
                d15 = 1.0 / d16;
                d14 = -1.0;
                d13 = Math.log(d16);
                d11 = 1.6449340668482264 + 0.5 * d13 * d13;
            }
            d3 = d15 + d15 - 1.0;
            double d17 = d3 + d3;
            d13 = 0.0;
            d12 = 0.0;
            for (int i2 = 19; i2 >= 0; --i2) {
                d10 = dArray[i2] + d17 * d13 - d12;
                d12 = d13;
                d13 = d10;
            }
            d3 = -(d14 * (d10 - d3 * d12) + d11);
        }
        return d3;
    }

    public static double effectiveSampleNumber(double[] dArray) {
        int n2;
        double[] dArray2 = (double[])dArray.clone();
        for (n2 = 0; n2 < dArray2.length; ++n2) {
            dArray2[n2] = 1.0 / MathBase.sqr(dArray2[n2]);
        }
        n2 = dArray2.length;
        double d2 = 0.0;
        double d3 = 0.0;
        for (int i2 = 0; i2 < n2; ++i2) {
            d2 += dArray2[i2];
            d3 += dArray2[i2] * dArray2[i2];
        }
        d2 *= d2;
        double d4 = d2 / d3;
        return d4;
    }

    public static double erf(double d2) {
        return 1.0 - Math.erfc(d2);
    }

    public static double erfc(double d2) {
        double d3 = 1.0;
        double d4 = Math.abs(d2);
        if (d4 <= 0.0) {
            return d3;
        }
        double d5 = -1.26551223;
        double d6 = 1.00002368;
        double d7 = 0.37409196;
        double d8 = 0.09678418;
        double d9 = -0.18628806;
        double d10 = 0.27886807;
        double d11 = -1.13520398;
        double d12 = 1.48851587;
        double d13 = -0.82215223;
        double d14 = 0.17087277;
        double d15 = 1.0 / (1.0 + 0.5 * d4);
        d3 = d15 * Math.exp(-d4 * d4 + -1.26551223 + d15 * (1.00002368 + d15 * (0.37409196 + d15 * (0.09678418 + d15 * (-0.18628806 + d15 * (0.27886807 + d15 * (-1.13520398 + d15 * (1.48851587 + d15 * (-0.82215223 + d15 * 0.17087277)))))))));
        if (d2 < 0.0) {
            d3 = 2.0 - d3;
        }
        return d3;
    }

    public static double erfInverse(double d2) {
        double d3 = 1.0E-14;
        double d4 = 0.8862269254527579;
        if (Math.abs(d2) <= 1.0E-14) {
            return 0.8862269254527579 * d2;
        }
        int n2 = 50;
        if (Math.abs(d2) < 1.0) {
            double d5 = 0.8862269254527579 * Math.abs(d2);
            double d6 = Math.erf(0.9 * d5);
            double d7 = 0.1 * d5;
            for (int i2 = 0; i2 < 50; ++i2) {
                double d8 = 1.0 - Math.erfc(d5);
                double d9 = Math.abs(d2) - d8;
                if (Math.abs(d9) < 1.0E-14) {
                    if (d2 < 0.0) {
                        return -d5;
                    }
                    return d5;
                }
                double d10 = d8 - d6;
                d7 *= d9 / d10;
                d6 = d8;
                if (!(Math.abs(d7 / (d5 += d7)) < 1.0E-14)) continue;
                if (d2 < 0.0) {
                    return -d5;
                }
                return d5;
            }
        }
        return Double.NaN;
    }

    public static double factorial(int n2) {
        if (n2 <= 0) {
            return 1.0;
        }
        double d2 = 1.0;
        int n3 = 0;
        do {
            d2 *= (double)(++n3);
        } while (n3 != n2);
        return d2;
    }

    public static double fDist(double d2, double d3, double d4) {
        if (d2 < 0.0 || d3 < 1.0 || d4 < 1.0) {
            return 0.0;
        }
        double d5 = Math.gamma(d3 / 2.0) * Math.gamma(d4 / 2.0) * Math.pow(d4 + d3 * d2, (d3 + d4) / 2.0);
        double d6 = Math.gamma((d3 + d4) / 2.0) * Math.pow(d3, d3 / 2.0) * Math.pow(d4, d4 / 2.0) * Math.pow(d2, 0.5 * d3 - 1.0);
        return d6 / d5;
    }

    public static double fDistI(double d2, double d3, double d4) {
        double d5 = 1.0 - Math.betaIncomplete(d4 / (d4 + d3 * d2), d4 * 0.5, d3 * 0.5);
        return d5;
    }

    public static double freq(double d2) {
        double d3;
        double d4;
        double d5 = 0.5641895835477563;
        double d6 = 1.4142135623730951;
        double d7 = 242.66795523053176;
        double d8 = 215.0588758698612;
        double d9 = 21.979261618294153;
        double d10 = 91.1649054045149;
        double d11 = 6.996383488619135;
        double d12 = 15.082797630407788;
        double d13 = -0.035609843701815386;
        double d14 = 1.0;
        double d15 = 300.4592610201616;
        double d16 = 300.4592609569833;
        double d17 = 451.9189537118729;
        double d18 = 790.9509253278981;
        double d19 = 339.3208167343437;
        double d20 = 931.3540948506096;
        double d21 = 152.9892850469404;
        double d22 = 638.9802644656312;
        double d23 = 43.162227222056735;
        double d24 = 277.58544474398764;
        double d25 = 7.2117582508830935;
        double d26 = 77.00015293522948;
        double d27 = 0.564195517478974;
        double d28 = 12.782727319629423;
        double d29 = -1.368648573827167E-7;
        double d30 = 1.0;
        double d31 = -0.002996107077035422;
        double d32 = 0.010620923052846792;
        double d33 = -0.04947309106232507;
        double d34 = 0.19130892610782985;
        double d35 = -0.22695659353968692;
        double d36 = 1.051675107067932;
        double d37 = -0.2786613086096478;
        double d38 = 1.9873320181713525;
        double d39 = -0.02231924597341847;
        double d40 = 1.0;
        double d41 = Math.abs(d2) / 1.4142135623730951;
        double d42 = d41 * d41;
        if (d41 < 0.5) {
            double d43 = d42;
            double d44 = -0.035609843701815386;
            double d45 = 1.0;
            d44 = 6.996383488619135 + d43 * d44;
            d44 = 21.979261618294153 + d43 * d44;
            d44 = 242.66795523053176 + d43 * d44;
            d45 = 15.082797630407788 + d43 * d45;
            d45 = 91.1649054045149 + d43 * d45;
            d45 = 215.0588758698612 + d43 * d45;
            d4 = d41 * d44 / d45;
            d3 = 1.0 - d4;
        } else if (d41 < 4.0) {
            double d46 = -1.368648573827167E-7;
            double d47 = 1.0;
            d46 = 0.564195517478974 + d41 * d46;
            d46 = 7.2117582508830935 + d41 * d46;
            d46 = 43.162227222056735 + d41 * d46;
            d46 = 152.9892850469404 + d41 * d46;
            d46 = 339.3208167343437 + d41 * d46;
            d46 = 451.9189537118729 + d41 * d46;
            d46 = 300.4592610201616 + d41 * d46;
            d47 = 12.782727319629423 + d41 * d47;
            d47 = 77.00015293522948 + d41 * d47;
            d47 = 277.58544474398764 + d41 * d47;
            d47 = 638.9802644656312 + d41 * d47;
            d47 = 931.3540948506096 + d41 * d47;
            d47 = 790.9509253278981 + d41 * d47;
            d47 = 300.4592609569833 + d41 * d47;
            d3 = Math.exp(-d42) * d46 / d47;
            d4 = 1.0 - d3;
        } else {
            double d48 = 1.0 / d42;
            double d49 = -0.02231924597341847;
            double d50 = 1.0;
            d49 = -0.2786613086096478 + d48 * d49;
            d49 = -0.22695659353968692 + d48 * d49;
            d49 = -0.04947309106232507 + d48 * d49;
            d49 = -0.002996107077035422 + d48 * d49;
            d50 = 1.9873320181713525 + d48 * d50;
            d50 = 1.051675107067932 + d48 * d50;
            d50 = 0.19130892610782985 + d48 * d50;
            d50 = 0.010620923052846792 + d48 * d50;
            d3 = Math.exp(-d42) * (0.5641895835477563 + d48 * d49 / d50) / d41;
            d4 = 1.0 - d3;
        }
        if (d2 > 0.0) {
            return 0.5 + 0.5 * d4;
        }
        return 0.5 * d3;
    }

    public static double gamCf(double d2, double d3) {
        double d4;
        if (d2 <= 0.0 || d3 <= 0.0) {
            return 0.0;
        }
        int n2 = 100;
        double d5 = 3.0E-14;
        double d6 = 1.0E-30;
        double d7 = Math.lnGamma(d2);
        double d8 = d3 + 1.0 - d2;
        double d9 = 9.999999999999999E29;
        double d10 = d4 = 1.0 / d8;
        for (int i2 = 1; i2 <= 100; ++i2) {
            double d11 = (double)(-i2) * ((double)i2 - d2);
            if (Math.abs(d4 = d11 * d4 + (d8 += 2.0)) < 1.0E-30) {
                d4 = 1.0E-30;
            }
            if (Math.abs(d9 = d8 + d11 / d9) < 1.0E-30) {
                d9 = 1.0E-30;
            }
            d4 = 1.0 / d4;
            double d12 = d4 * d9;
            d10 *= d12;
            if (Math.abs(d12 - 1.0) < 3.0E-14) break;
        }
        double d13 = Math.exp(-d3 + d2 * Math.log(d3) - d7) * d10;
        return 1.0 - d13;
    }

    public static double gamma(double d2) {
        if (d2 <= 0.0) {
            return 0.0;
        }
        double d3 = Math.lnGamma(d2);
        return Math.exp(d3);
    }

    public static double gamma(double d2, double d3) {
        if (d2 <= 0.0 || d3 <= 0.0) {
            return 0.0;
        }
        if (d3 < d2 + 1.0) {
            return Math.gamSer(d2, d3);
        }
        return Math.gamCf(d2, d3);
    }

    public static double gammaDist(double d2, double d3, double d4, double d5) {
        if (d2 < d4 || d3 <= 0.0 || d5 <= 0.0) {
            System.err.println("GammaDist(): illegal parameter values");
            return 0.0;
        }
        double d6 = (d2 - d4) / d5;
        double d7 = d5 * Math.gamma(d3);
        double d8 = Math.pow(d6, d3 - 1.0) * Math.exp(-d6) / d7;
        return d8;
    }

    public static double gamSer(double d2, double d3) {
        double d4;
        if (d2 <= 0.0 || d3 <= 0.0) {
            return 0.0;
        }
        int n2 = 100;
        double d5 = 3.0E-14;
        double d6 = Math.lnGamma(d2);
        double d7 = d2;
        double d8 = d4 = 1.0 / d2;
        for (int i2 = 1; i2 <= 100; ++i2) {
            d8 = d8 * d3 / (d7 += 1.0);
            if (Math.abs(d8) < Math.abs((d4 += d8) * 3.0E-14)) break;
        }
        double d9 = d4 * Math.exp(-d3 + d2 * Math.log(d3) - d6);
        return d9;
    }

    public static double gauss(double d2, double d3, double d4, boolean bl2) {
        if (d4 == 0.0) {
            return 1.0E30;
        }
        double d5 = (d2 - d3) / d4;
        double d6 = Math.exp(-0.5 * d5 * d5);
        if (!bl2) {
            return d6;
        }
        return d6 / (2.5066282746310002 * d4);
    }

    public static double geometricMean(double[] dArray, int n2, int n3) {
        if (dArray == null || dArray.length <= 0) {
            return -1.0;
        }
        double d2 = 0.0;
        for (int i2 = n2; i2 < n3 + n2; ++i2) {
            if (dArray[i2] == 0.0) {
                return 0.0;
            }
            double d3 = Math.abs(dArray[i2]);
            d2 += Math.log(d3);
        }
        return Math.exp(d2 / (double)n3);
    }

    public static double geometricMean(double[] dArray) {
        return Math.geometricMean(dArray, 0, dArray.length);
    }

    public static float geometricMean(float[] fArray, int n2, int n3) {
        if (fArray == null || fArray.length <= 0) {
            return -1.0f;
        }
        double d2 = 0.0;
        for (int i2 = n2; i2 < n3 + n2; ++i2) {
            if (fArray[i2] == 0.0f) {
                return 0.0f;
            }
            double d3 = Math.abs(fArray[i2]);
            d2 += Math.log(d3);
        }
        return (float)Math.exp(d2 / (double)n3);
    }

    public static float geometricMean(float[] fArray) {
        return Math.geometricMean(fArray, 0, fArray.length);
    }

    public static int geometricMean(int[] nArray, int n2, int n3) {
        if (nArray == null || nArray.length <= 0) {
            return -1;
        }
        double d2 = 0.0;
        for (int i2 = n2; i2 < n3 + n2; ++i2) {
            if (nArray[i2] == 0) {
                return 0;
            }
            double d3 = Math.abs(nArray[i2]);
            d2 += Math.log(d3);
        }
        return (int)Math.exp(d2 / (double)n3);
    }

    public static int geometricMean(int[] nArray) {
        return Math.geometricMean(nArray, 0, nArray.length);
    }

    public static long geometricMean(long[] lArray, int n2, int n3) {
        if (lArray == null || lArray.length <= 0) {
            return -1L;
        }
        double d2 = 0.0;
        for (int i2 = n2; i2 < n3 + n2; ++i2) {
            if (lArray[i2] == 0L) {
                return 0L;
            }
            double d3 = Math.abs(lArray[i2]);
            d2 += Math.log(d3);
        }
        return (long)Math.exp(d2 / (double)n3);
    }

    public static long geometricMean(long[] lArray) {
        return Math.geometricMean(lArray, 0, lArray.length);
    }

    public static short geometricMean(short[] sArray, int n2, int n3) {
        if (sArray == null || sArray.length <= 0) {
            return -1;
        }
        double d2 = 0.0;
        for (int i2 = n2; i2 < n3 + n2; ++i2) {
            if (sArray[i2] == 0) {
                return 0;
            }
            double d3 = Math.abs(sArray[i2]);
            d2 += Math.log(d3);
        }
        return (short)Math.exp(d2 / (double)n3);
    }

    public static short geometricMean(short[] sArray) {
        return Math.geometricMean(sArray, 0, sArray.length);
    }

    private static double[] invertAndSquare(double[] dArray) {
        double[] dArray2 = new double[dArray.length];
        for (int i2 = 0; i2 < dArray.length; ++i2) {
            double d2 = dArray[i2];
            dArray2[i2] = d2 == 0.0 ? Double.POSITIVE_INFINITY : (Double.isNaN(d2) ? Double.NaN : (Double.isInfinite(d2) ? 0.0 : 1.0 / MathBase.pow(d2, 2.0)));
        }
        return dArray2;
    }

    public static boolean isInside(double d2, double d3, int n2, double[] dArray, double[] dArray2) {
        int n3 = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            double d4;
            double d5;
            double d6;
            if (i2 < n2 - 1) {
                d6 = dArray[i2 + 1];
                d5 = dArray2[i2 + 1];
            } else {
                d6 = dArray[0];
                d5 = dArray2[0];
            }
            if (dArray2[i2] == d5 || d3 <= dArray2[i2] && d3 <= d5 || dArray2[i2] < d3 && d5 < d3 || !(d2 < (d4 = dArray[i2] + (d3 - dArray2[i2]) * (d6 - dArray[i2]) / (d5 - dArray2[i2])))) continue;
            ++n3;
        }
        return n3 % 2 > 0;
    }

    public static boolean isInside(float f2, float f3, int n2, float[] fArray, float[] fArray2) {
        int n3 = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            double d2;
            float f4;
            float f5;
            if (i2 < n2 - 1) {
                f5 = fArray[i2 + 1];
                f4 = fArray2[i2 + 1];
            } else {
                f5 = fArray[0];
                f4 = fArray2[0];
            }
            if (fArray2[i2] == f4 || f3 <= fArray2[i2] && f3 <= f4 || fArray2[i2] < f3 && f4 < f3 || !((double)f2 < (d2 = (double)(fArray[i2] + (f3 - fArray2[i2]) * (f5 - fArray[i2]) / (f4 - fArray2[i2]))))) continue;
            ++n3;
        }
        return n3 % 2 > 0;
    }

    public static boolean isInside(int n2, int n3, int n4, int[] nArray, int[] nArray2) {
        int n5 = 0;
        for (int i2 = 0; i2 < n4; ++i2) {
            double d2;
            int n6;
            int n7;
            if (i2 < n4 - 1) {
                n7 = nArray[i2 + 1];
                n6 = nArray2[i2 + 1];
            } else {
                n7 = nArray[0];
                n6 = nArray2[0];
            }
            if (nArray2[i2] == n6 || n3 <= nArray2[i2] && n3 <= n6 || nArray2[i2] < n3 && n6 < n3 || !((double)n2 < (d2 = (double)nArray[i2] + (double)((n3 - nArray2[i2]) * (n7 - nArray[i2])) / (double)(n6 - nArray2[i2])))) continue;
            ++n5;
        }
        return n5 % 2 > 0;
    }

    public static double landau(double d2, double d3, double d4, boolean bl2) {
        double d5;
        if (d4 <= 0.0) {
            return 0.0;
        }
        double[] dArray = new double[]{0.4259894875, -0.124976255, 0.039842437, -0.006298287635, 0.001511162253};
        double[] dArray2 = new double[]{1.0, -0.3388260629, 0.09594393323, -0.01608042283, 0.003778942063};
        double[] dArray3 = new double[]{0.1788541609, 0.1173957403, 0.01488850518, -0.001394989411, 1.283617211E-4};
        double[] dArray4 = new double[]{1.0, 0.7428795082, 0.3153932961, 0.06694219548, 0.008790609714};
        double[] dArray5 = new double[]{0.1788544503, 0.09359161662, 0.006325387654, 6.611667319E-5, -2.031049101E-6};
        double[] dArray6 = new double[]{1.0, 0.6097809921, 0.2560616665, 0.04746722384, 0.006957301675};
        double[] dArray7 = new double[]{0.9874054407, 118.6723273, 849.279436, -743.7792444, 427.0262186};
        double[] dArray8 = new double[]{1.0, 106.8615961, 337.6496214, 2016.712389, 1597.063511};
        double[] dArray9 = new double[]{1.003675074, 167.5702434, 4789.711289, 21217.86767, -22324.9491};
        double[] dArray10 = new double[]{1.0, 156.9424537, 3745.310488, 9834.698876, 66924.28357};
        double[] dArray11 = new double[]{1.000827619, 664.9143136, 62972.92665, 475554.6998, -5743609.109};
        double[] dArray12 = new double[]{1.0, 651.4101098, 56974.73333, 165917.4725, -2815759.939};
        double[] dArray13 = new double[]{0.04166666667, -0.01996527778, 0.02709538966};
        double[] dArray14 = new double[]{-1.84556867, -4.284640743};
        double d6 = (d2 - d3) / d4;
        if (d6 < -5.5) {
            double d7 = Math.exp(d6 + 1.0);
            if (d7 < 1.0E-10) {
                return 0.0;
            }
            double d8 = Math.exp(-1.0 / d7);
            double d9 = Math.sqrt(d7);
            d5 = 0.3989422803 * (d8 / d9) * (1.0 + (dArray13[0] + (dArray13[1] + dArray13[2] * d7) * d7) * d7);
        } else if (d6 < -1.0) {
            double d10 = Math.exp(-d6 - 1.0);
            d5 = Math.exp(-d10) * Math.sqrt(d10) * (dArray[0] + (dArray[1] + (dArray[2] + (dArray[3] + dArray[4] * d6) * d6) * d6) * d6) / (dArray2[0] + (dArray2[1] + (dArray2[2] + (dArray2[3] + dArray2[4] * d6) * d6) * d6) * d6);
        } else if (d6 < 1.0) {
            d5 = (dArray3[0] + (dArray3[1] + (dArray3[2] + (dArray3[3] + dArray3[4] * d6) * d6) * d6) * d6) / (dArray4[0] + (dArray4[1] + (dArray4[2] + (dArray4[3] + dArray4[4] * d6) * d6) * d6) * d6);
        } else if (d6 < 5.0) {
            d5 = (dArray5[0] + (dArray5[1] + (dArray5[2] + (dArray5[3] + dArray5[4] * d6) * d6) * d6) * d6) / (dArray6[0] + (dArray6[1] + (dArray6[2] + (dArray6[3] + dArray6[4] * d6) * d6) * d6) * d6);
        } else if (d6 < 12.0) {
            double d11 = 1.0 / d6;
            d5 = d11 * d11 * (dArray7[0] + (dArray7[1] + (dArray7[2] + (dArray7[3] + dArray7[4] * d11) * d11) * d11) * d11) / (dArray8[0] + (dArray8[1] + (dArray8[2] + (dArray8[3] + dArray8[4] * d11) * d11) * d11) * d11);
        } else if (d6 < 50.0) {
            double d12 = 1.0 / d6;
            d5 = d12 * d12 * (dArray9[0] + (dArray9[1] + (dArray9[2] + (dArray9[3] + dArray9[4] * d12) * d12) * d12) * d12) / (dArray10[0] + (dArray10[1] + (dArray10[2] + (dArray10[3] + dArray10[4] * d12) * d12) * d12) * d12);
        } else if (d6 < 300.0) {
            double d13 = 1.0 / d6;
            d5 = d13 * d13 * (dArray11[0] + (dArray11[1] + (dArray11[2] + (dArray11[3] + dArray11[4] * d13) * d13) * d13) * d13) / (dArray12[0] + (dArray12[1] + (dArray12[2] + (dArray12[3] + dArray12[4] * d13) * d13) * d13) * d13);
        } else {
            double d14 = 1.0 / (d6 - d6 * Math.log(d6) / (d6 + 1.0));
            d5 = d14 * d14 * (1.0 + (dArray14[0] + dArray14[1] * d14) * d14);
        }
        if (!bl2) {
            return d5;
        }
        return d5 / d4;
    }

    public static double landauI(double d2) {
        double d3;
        double[] dArray = new double[]{0.2514091491, -0.06250580444, 0.0145838123, -0.002108817737, 7.41124729E-4};
        double[] dArray2 = new double[]{1.0, -0.005571175625, 0.06225310236, -0.003137378427, 0.001931496439};
        double[] dArray3 = new double[]{0.2868328584, 0.3564363231, 0.1523518695, 0.02251304883};
        double[] dArray4 = new double[]{1.0, 0.6191136137, 0.1720721448, 0.02278594771};
        double[] dArray5 = new double[]{0.2868329066, 0.3003828436, 0.09950951941, 0.008733827185};
        double[] dArray6 = new double[]{1.0, 0.4237190502, 0.1095631512, 0.008693851567};
        double[] dArray7 = new double[]{1.00035163, 4.503592498, 10.8588388, 7.536052269};
        double[] dArray8 = new double[]{1.0, 5.539969678, 19.33581111, 27.21321508};
        double[] dArray9 = new double[]{1.000006517, 49.09414111, 85.05544753, 153.2153455};
        double[] dArray10 = new double[]{1.0, 50.09928881, 139.9819104, 420.0002909};
        double[] dArray11 = new double[]{1.000000983, 132.9868456, 916.2149244, -960.5054274};
        double[] dArray12 = new double[]{1.0, 133.9887843, 1055.990413, 553.2224619};
        double[] dArray13 = new double[]{0.0, -0.4583333333, 0.6675347222, -1.641741416};
        double[] dArray14 = new double[]{0.0, 1.0, -0.4227843351, -2.043403138};
        double d4 = d2;
        if (d4 < -5.5) {
            double d5 = Math.exp(d4 + 1.0);
            d3 = 0.3989422803 * Math.exp(-1.0 / d5) * Math.sqrt(d5) * (1.0 + (dArray13[1] + (dArray13[2] + dArray13[3] * d5) * d5) * d5);
        } else if (d4 < -1.0) {
            double d6 = Math.exp(-d4 - 1.0);
            d3 = Math.exp(-d6) / Math.sqrt(d6) * (dArray[0] + (dArray[1] + (dArray[2] + (dArray[3] + dArray[4] * d4) * d4) * d4) * d4) / (dArray2[0] + (dArray2[1] + (dArray2[2] + (dArray2[3] + dArray2[4] * d4) * d4) * d4) * d4);
        } else if (d4 < 1.0) {
            d3 = (dArray3[0] + (dArray3[1] + (dArray3[2] + dArray3[3] * d4) * d4) * d4) / (dArray4[0] + (dArray4[1] + (dArray4[2] + dArray4[3] * d4) * d4) * d4);
        } else if (d4 < 4.0) {
            d3 = (dArray5[0] + (dArray5[1] + (dArray5[2] + dArray5[3] * d4) * d4) * d4) / (dArray6[0] + (dArray6[1] + (dArray6[2] + dArray6[3] * d4) * d4) * d4);
        } else if (d4 < 12.0) {
            double d7 = 1.0 / d4;
            d3 = (dArray7[0] + (dArray7[1] + (dArray7[2] + dArray7[3] * d7) * d7) * d7) / (dArray8[0] + (dArray8[1] + (dArray8[2] + dArray8[3] * d7) * d7) * d7);
        } else if (d4 < 50.0) {
            double d8 = 1.0 / d4;
            d3 = (dArray9[0] + (dArray9[1] + (dArray9[2] + dArray9[3] * d8) * d8) * d8) / (dArray10[0] + (dArray10[1] + (dArray10[2] + dArray10[3] * d8) * d8) * d8);
        } else if (d4 < 300.0) {
            double d9 = 1.0 / d4;
            d3 = (dArray11[0] + (dArray11[1] + (dArray11[2] + dArray11[3] * d9) * d9) * d9) / (dArray12[0] + (dArray12[1] + (dArray12[2] + dArray12[3] * d9) * d9) * d9);
        } else {
            double d10 = 1.0 / (d4 - d4 * Math.log(d4) / (d4 + 1.0));
            d3 = 1.0 - (dArray14[1] + (dArray14[2] + dArray14[3] * d10) * d10) * d10;
        }
        return d3;
    }

    public static double laplaceDist(double d2, double d3, double d4) {
        double d5 = Math.exp(-Math.abs((d2 - d3) / d4));
        return d5 /= 2.0 * d4;
    }

    public static double laplaceDistI(double d2, double d3, double d4) {
        double d5 = d2 <= d3 ? 0.5 * Math.exp(-Math.abs((d2 - d3) / d4)) : 1.0 - 0.5 * Math.exp(-Math.abs((d2 - d3) / d4));
        return d5;
    }

    public static double lnGamma(double d2) {
        double d3;
        if (d2 <= 0.0) {
            return 0.0;
        }
        double[] dArray = new double[]{2.5066282746310007, 76.18009172947146, -86.50532032941678, 24.01409824083091, -1.231739572450155, 0.001208650973866179, -5.395239384953E-6};
        double d4 = d3 = d2;
        double d5 = d3 + 5.5;
        d5 = (d3 + 0.5) * Math.log(d5) - d5;
        double d6 = 1.000000000190015;
        for (int i2 = 1; i2 < 7; ++i2) {
            d6 += dArray[i2] / (d4 += 1.0);
        }
        return d5 + Math.log(dArray[0] * d6 / d3);
    }

    public static long locationMaximum(double[] dArray, int n2) {
        if (dArray == null || dArray.length <= 0) {
            return -1L;
        }
        double d2 = dArray[0];
        long l2 = 0L;
        for (int i2 = 1; i2 < n2; ++i2) {
            if (!(d2 < dArray[i2])) continue;
            d2 = dArray[i2];
            l2 = i2;
        }
        return l2;
    }

    public static long locationMinimum(double[] dArray, int n2) {
        if (dArray == null || dArray.length <= 0) {
            return -1L;
        }
        double d2 = dArray[0];
        long l2 = 0L;
        for (int i2 = 1; i2 < n2; ++i2) {
            if (!(d2 > dArray[i2])) continue;
            d2 = dArray[i2];
            l2 = i2;
        }
        return l2;
    }

    public static long locationMaximum(float[] fArray, int n2) {
        if (fArray == null || fArray.length <= 0) {
            return -1L;
        }
        float f2 = fArray[0];
        long l2 = 0L;
        for (int i2 = 1; i2 < n2; ++i2) {
            if (!(f2 < fArray[i2])) continue;
            f2 = fArray[i2];
            l2 = i2;
        }
        return l2;
    }

    public static long locationMinimum(float[] fArray, int n2) {
        if (fArray == null || fArray.length <= 0) {
            return -1L;
        }
        float f2 = fArray[0];
        long l2 = 0L;
        for (int i2 = 1; i2 < n2; ++i2) {
            if (!(f2 > fArray[i2])) continue;
            f2 = fArray[i2];
            l2 = i2;
        }
        return l2;
    }

    public static long locationMaximum(int[] nArray, int n2) {
        if (nArray == null || nArray.length <= 0) {
            return -1L;
        }
        int n3 = nArray[0];
        long l2 = 0L;
        for (int i2 = 1; i2 < n2; ++i2) {
            if (n3 >= nArray[i2]) continue;
            n3 = nArray[i2];
            l2 = i2;
        }
        return l2;
    }

    public static long locationMinimum(int[] nArray, int n2) {
        if (nArray == null || nArray.length <= 0) {
            return -1L;
        }
        int n3 = nArray[0];
        long l2 = 0L;
        for (int i2 = 1; i2 < n2; ++i2) {
            if (n3 <= nArray[i2]) continue;
            n3 = nArray[i2];
            l2 = i2;
        }
        return l2;
    }

    public static long locationMaximum(long[] lArray, int n2) {
        if (lArray == null || lArray.length <= 0) {
            return -1L;
        }
        long l2 = lArray[0];
        long l3 = 0L;
        for (int i2 = 1; i2 < n2; ++i2) {
            if (l2 >= lArray[i2]) continue;
            l2 = lArray[i2];
            l3 = i2;
        }
        return l3;
    }

    public static long locationMinimum(long[] lArray, int n2) {
        if (lArray == null || lArray.length <= 0) {
            return -1L;
        }
        long l2 = lArray[0];
        long l3 = 0L;
        for (int i2 = 1; i2 < n2; ++i2) {
            if (l2 <= lArray[i2]) continue;
            l2 = lArray[i2];
            l3 = i2;
        }
        return l3;
    }

    public static long locationMaximum(short[] sArray, int n2) {
        if (sArray == null || sArray.length <= 0) {
            return -1L;
        }
        short s2 = sArray[0];
        long l2 = 0L;
        for (int i2 = 1; i2 < n2; ++i2) {
            if (s2 >= sArray[i2]) continue;
            s2 = sArray[i2];
            l2 = i2;
        }
        return l2;
    }

    public static long locationMinimum(short[] sArray, int n2) {
        if (sArray == null || sArray.length <= 0) {
            return -1L;
        }
        short s2 = sArray[0];
        long l2 = 0L;
        for (int i2 = 1; i2 < n2; ++i2) {
            if (s2 <= sArray[i2]) continue;
            s2 = sArray[i2];
            l2 = i2;
        }
        return l2;
    }

    public static double logNormal(double d2, double d3, double d4, double d5) {
        if (d2 < d4 || d3 <= 0.0 || d5 <= 0.0) {
            System.err.println("Lognormal(): illegal parameter values");
            return 0.0;
        }
        double d6 = Math.log((d2 - d4) / d5) * Math.log((d2 - d4) / d5);
        double d7 = Math.exp(-d6 / (2.0 * d3 * d3));
        double d8 = (d2 - d4) * d3 * Math.sqrt(java.lang.Math.PI * 2);
        return d7 / d8;
    }

    public static double maximum(double[] dArray) {
        return Math.maximum(dArray, dArray.length);
    }

    public static double maximum(double[] dArray, int n2) {
        double d2 = -1.7976931348623157E308;
        for (int i2 = 0; i2 < n2; ++i2) {
            d2 = Math.max(d2, dArray[i2]);
        }
        return d2;
    }

    public static double mean(double[] dArray) {
        return Math.mean(dArray, dArray.length);
    }

    public static double mean(double[] dArray, int n2) {
        double d2 = 1.0 / (double)n2;
        double d3 = 0.0;
        for (int i2 = 0; i2 < n2; ++i2) {
            d3 += d2 * dArray[i2];
        }
        return d3;
    }

    public static double median(double[] dArray) {
        return Math.median(dArray, dArray.length);
    }

    public static double median(double[] dArray, int n2) {
        double[] dArray2 = Math.sort(dArray, n2, false);
        if (n2 % 2 == 0) {
            return 0.5 * (dArray2[n2 / 2] + dArray2[n2 / 2 + 1]);
        }
        return dArray2[n2 / 2];
    }

    public static double minimum(double[] dArray) {
        return Math.minimum(dArray, dArray.length);
    }

    public static double minimum(double[] dArray, int n2) {
        double d2 = Double.MAX_VALUE;
        for (int i2 = 0; i2 < n2; ++i2) {
            d2 = Math.min(d2, dArray[i2]);
        }
        return d2;
    }

    public static float maximum(float[] fArray) {
        return Math.maximum(fArray, fArray.length);
    }

    public static float maximum(float[] fArray, int n2) {
        float f2 = -3.4028235E38f;
        for (int i2 = 0; i2 < n2; ++i2) {
            f2 = Math.max(f2, fArray[i2]);
        }
        return f2;
    }

    public static float mean(float[] fArray) {
        return Math.mean(fArray, fArray.length);
    }

    public static float mean(float[] fArray, int n2) {
        float f2 = 1.0f / (float)n2;
        float f3 = 0.0f;
        for (int i2 = 0; i2 < n2; ++i2) {
            f3 += f2 * fArray[i2];
        }
        return f3;
    }

    public static float median(float[] fArray) {
        return Math.median(fArray, fArray.length);
    }

    public static float median(float[] fArray, int n2) {
        float[] fArray2 = Math.sort(fArray, n2, false);
        if (n2 % 2 == 0) {
            return (float)(0.5 * (double)(fArray2[n2 / 2] + fArray2[n2 / 2 + 1]));
        }
        return fArray2[n2 / 2];
    }

    public static float minimum(float[] fArray) {
        return Math.minimum(fArray, fArray.length);
    }

    public static float minimum(float[] fArray, int n2) {
        float f2 = Float.MAX_VALUE;
        for (int i2 = 0; i2 < n2; ++i2) {
            f2 = Math.min(f2, fArray[i2]);
        }
        return f2;
    }

    public static int maximum(int[] nArray) {
        return Math.maximum(nArray, nArray.length);
    }

    public static int maximum(int[] nArray, int n2) {
        int n3 = -2147483647;
        for (int i2 = 0; i2 < n2; ++i2) {
            n3 = Math.max(n3, nArray[i2]);
        }
        return n3;
    }

    public static int mean(int[] nArray) {
        return Math.mean(nArray, nArray.length);
    }

    public static int mean(int[] nArray, int n2) {
        double d2 = 1.0 / (double)n2;
        double d3 = 0.0;
        for (int i2 = 0; i2 < n2; ++i2) {
            d3 += d2 * (double)nArray[i2];
        }
        return (int)d3;
    }

    public static int median(int[] nArray) {
        return Math.median(nArray, nArray.length);
    }

    public static int median(int[] nArray, int n2) {
        int[] nArray2 = Math.sort(nArray, n2, false);
        if (n2 % 2 == 0) {
            return (int)(0.5 * (double)(nArray2[n2 / 2] + nArray2[n2 / 2 + 1]));
        }
        return nArray2[n2 / 2];
    }

    public static int minimum(int[] nArray) {
        return Math.minimum(nArray, nArray.length);
    }

    public static int minimum(int[] nArray, int n2) {
        int n3 = Integer.MAX_VALUE;
        for (int i2 = 0; i2 < n2; ++i2) {
            n3 = Math.min(n3, nArray[i2]);
        }
        return n3;
    }

    public static long maximum(long[] lArray) {
        return Math.maximum(lArray, lArray.length);
    }

    public static long maximum(long[] lArray, int n2) {
        long l2 = -9223372036854775807L;
        for (int i2 = 0; i2 < n2; ++i2) {
            l2 = Math.max(l2, lArray[i2]);
        }
        return l2;
    }

    public static long mean(long[] lArray) {
        return Math.mean(lArray, lArray.length);
    }

    public static long mean(long[] lArray, int n2) {
        double d2 = 1.0 / (double)n2;
        double d3 = 0.0;
        for (int i2 = 0; i2 < n2; ++i2) {
            d3 += d2 * (double)lArray[i2];
        }
        return (long)d3;
    }

    public static long median(long[] lArray) {
        return Math.median(lArray, lArray.length);
    }

    public static long median(long[] lArray, int n2) {
        long[] lArray2 = Math.sort(lArray, n2, false);
        if (n2 % 2 == 0) {
            return (long)(0.5 * (double)(lArray2[n2 / 2] + lArray2[n2 / 2 + 1]));
        }
        return lArray2[n2 / 2];
    }

    public static long minimum(long[] lArray) {
        return Math.minimum(lArray, lArray.length);
    }

    public static long minimum(long[] lArray, int n2) {
        long l2 = Long.MAX_VALUE;
        for (int i2 = 0; i2 < n2; ++i2) {
            l2 = Math.min(l2, lArray[i2]);
        }
        return l2;
    }

    public static short maximum(short[] sArray) {
        return Math.maximum(sArray, sArray.length);
    }

    public static short maximum(short[] sArray, int n2) {
        short s2 = -32767;
        for (int i2 = 0; i2 < n2; ++i2) {
            s2 = Math.max(s2, sArray[i2]);
        }
        return s2;
    }

    public static short mean(short[] sArray) {
        return Math.mean(sArray, sArray.length);
    }

    public static short mean(short[] sArray, int n2) {
        double d2 = 1.0 / (double)n2;
        double d3 = 0.0;
        for (int i2 = 0; i2 < n2; ++i2) {
            d3 += d2 * (double)sArray[i2];
        }
        return (short)d3;
    }

    public static short median(short[] sArray) {
        return Math.median(sArray, sArray.length);
    }

    public static short median(short[] sArray, int n2) {
        short[] sArray2 = Math.sort(sArray, n2, false);
        if (n2 % 2 == 0) {
            return (short)(0.5 * (double)(sArray2[n2 / 2] + sArray2[n2 / 2 + 1]));
        }
        return sArray2[n2 / 2];
    }

    public static short minimum(short[] sArray) {
        return Math.minimum(sArray, sArray.length);
    }

    public static short minimum(short[] sArray, int n2) {
        short s2 = Short.MAX_VALUE;
        for (int i2 = 0; i2 < n2; ++i2) {
            s2 = Math.min(s2, sArray[i2]);
        }
        return s2;
    }

    public static double[] normal2Plane(double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4) {
        double[] dArray5 = new double[3];
        double[] dArray6 = new double[3];
        dArray5[0] = dArray2[0] - dArray[0];
        dArray5[1] = dArray2[1] - dArray[1];
        dArray5[2] = dArray2[2] - dArray[2];
        dArray6[0] = dArray3[0] - dArray[0];
        dArray6[1] = dArray3[1] - dArray[1];
        dArray6[2] = dArray3[2] - dArray[2];
        Math.normCross(dArray5, dArray6, dArray4);
        return dArray4;
    }

    public static float[] normal2Plane(float[] fArray, float[] fArray2, float[] fArray3, float[] fArray4) {
        float[] fArray5 = new float[3];
        float[] fArray6 = new float[3];
        fArray5[0] = fArray2[0] - fArray[0];
        fArray5[1] = fArray2[1] - fArray[1];
        fArray5[2] = fArray2[2] - fArray[2];
        fArray6[0] = fArray3[0] - fArray[0];
        fArray6[1] = fArray3[1] - fArray[1];
        fArray6[2] = fArray3[2] - fArray[2];
        Math.normCross(fArray5, fArray6, fArray4);
        return fArray4;
    }

    public static double normalize(double[] dArray) {
        double d2;
        double d3;
        double d4;
        double d5 = Math.abs(dArray[0]);
        double d6 = Math.abs(dArray[1]);
        double d7 = Math.abs(dArray[2]);
        if (d5 >= d6 && d5 >= d7) {
            d4 = d5;
            d3 = d6;
            d2 = d7;
        } else if (d6 >= d5 && d6 >= d7) {
            d4 = d6;
            d3 = d5;
            d2 = d7;
        } else {
            d4 = d7;
            d3 = d5;
            d2 = d6;
        }
        if (d4 == 0.0) {
            return 0.0;
        }
        double d8 = d3 / d4;
        double d9 = d2 / d4;
        double d10 = d4 * Math.sqrt(1.0 + d8 * d8 + d9 * d9);
        dArray[0] = dArray[0] / d10;
        dArray[1] = dArray[1] / d10;
        dArray[2] = dArray[2] / d10;
        return d10;
    }

    public static float normalize(float[] fArray) {
        float f2 = (float)Math.sqrt(fArray[0] * fArray[0] + fArray[1] * fArray[1] + fArray[2] * fArray[2]);
        if (f2 != 0.0f) {
            fArray[0] = fArray[0] / f2;
            fArray[1] = fArray[1] / f2;
            fArray[2] = fArray[2] / f2;
        }
        return f2;
    }

    public static double normCross(double[] dArray, double[] dArray2, double[] dArray3) {
        return Math.normalize(Math.cross(dArray, dArray2, dArray3));
    }

    public static float normCross(float[] fArray, float[] fArray2, float[] fArray3) {
        return Math.normalize(Math.cross(fArray, fArray2, fArray3));
    }

    public static double normQuantile(double d2) {
        double d3;
        if (d2 <= 0.0 || d2 >= 1.0) {
            System.err.println("NormQuantile(): probability outside (0, 1)");
            return 0.0;
        }
        double d4 = 3.3871328727963665;
        double d5 = 133.14166789178438;
        double d6 = 1971.5909503065513;
        double d7 = 13731.69376550946;
        double d8 = 45921.95393154987;
        double d9 = 67265.7709270087;
        double d10 = 33430.57558358813;
        double d11 = 2509.0809287301227;
        double d12 = 42.31333070160091;
        double d13 = 687.1870074920579;
        double d14 = 5394.196021424751;
        double d15 = 21213.794301586597;
        double d16 = 39307.89580009271;
        double d17 = 28729.085735721943;
        double d18 = 5226.495278852854;
        double d19 = 1.4234371107496835;
        double d20 = 4.630337846156546;
        double d21 = 5.769497221460691;
        double d22 = 3.6478483247632045;
        double d23 = 1.2704582524523684;
        double d24 = 0.2417807251774506;
        double d25 = 0.022723844989269184;
        double d26 = 7.745450142783414E-4;
        double d27 = 2.053191626637759;
        double d28 = 1.6763848301838038;
        double d29 = 0.6897673349851;
        double d30 = 0.14810397642748008;
        double d31 = 0.015198666563616457;
        double d32 = 5.475938084995345E-4;
        double d33 = 1.0507500716444169E-9;
        double d34 = 6.657904643501103;
        double d35 = 5.463784911164114;
        double d36 = 1.7848265399172913;
        double d37 = 0.29656057182850487;
        double d38 = 0.026532189526576124;
        double d39 = 0.0012426609473880784;
        double d40 = 2.7115555687434876E-5;
        double d41 = 2.0103343992922881E-7;
        double d42 = 0.599832206555888;
        double d43 = 0.1369298809227358;
        double d44 = 0.014875361290850615;
        double d45 = 7.868691311456133E-4;
        double d46 = 1.8463183175100548E-5;
        double d47 = 1.421511758316446E-7;
        double d48 = 2.0442631033899397E-15;
        double d49 = 0.425;
        double d50 = 5.0;
        double d51 = 0.180625;
        double d52 = 1.6;
        double d53 = d2 - 0.5;
        if (Math.abs(d53) < 0.425) {
            double d54 = 0.180625 - d53 * d53;
            d3 = d53 * (((((((2509.0809287301227 * d54 + 33430.57558358813) * d54 + 67265.7709270087) * d54 + 45921.95393154987) * d54 + 13731.69376550946) * d54 + 1971.5909503065513) * d54 + 133.14166789178438) * d54 + 3.3871328727963665) / (((((((5226.495278852854 * d54 + 28729.085735721943) * d54 + 39307.89580009271) * d54 + 21213.794301586597) * d54 + 5394.196021424751) * d54 + 687.1870074920579) * d54 + 42.31333070160091) * d54 + 1.0);
        } else {
            double d55 = d53 < 0.0 ? d2 : 1.0 - d2;
            if (d55 <= 0.0) {
                d3 = 0.0;
            } else {
                d3 = (d55 = Math.sqrt(-Math.log(d55))) <= 5.0 ? (((((((7.745450142783414E-4 * (d55 -= 1.6) + 0.022723844989269184) * d55 + 0.2417807251774506) * d55 + 1.2704582524523684) * d55 + 3.6478483247632045) * d55 + 5.769497221460691) * d55 + 4.630337846156546) * d55 + 1.4234371107496835) / (((((((1.0507500716444169E-9 * d55 + 5.475938084995345E-4) * d55 + 0.015198666563616457) * d55 + 0.14810397642748008) * d55 + 0.6897673349851) * d55 + 1.6763848301838038) * d55 + 2.053191626637759) * d55 + 1.0) : (((((((2.0103343992922881E-7 * (d55 -= 5.0) + 2.7115555687434876E-5) * d55 + 0.0012426609473880784) * d55 + 0.026532189526576124) * d55 + 0.29656057182850487) * d55 + 1.7848265399172913) * d55 + 5.463784911164114) * d55 + 6.657904643501103) / (((((((2.0442631033899397E-15 * d55 + 1.421511758316446E-7) * d55 + 1.8463183175100548E-5) * d55 + 7.868691311456133E-4) * d55 + 0.014875361290850615) * d55 + 0.1369298809227358) * d55 + 0.599832206555888) * d55 + 1.0);
                if (d53 < 0.0) {
                    d3 = -d3;
                }
            }
        }
        return d3;
    }

    public static double peakToPeak(double[] dArray) {
        return Math.peakToPeak(dArray, dArray.length);
    }

    public static double peakToPeak(double[] dArray, int n2) {
        return Math.abs(Math.maximum(dArray, n2) - Math.minimum(dArray, n2));
    }

    public static float peakToPeak(float[] fArray) {
        return Math.peakToPeak(fArray, fArray.length);
    }

    public static float peakToPeak(float[] fArray, int n2) {
        return Math.abs(Math.maximum(fArray, n2) - Math.minimum(fArray, n2));
    }

    public static int peakToPeak(int[] nArray) {
        return Math.peakToPeak(nArray, nArray.length);
    }

    public static int peakToPeak(int[] nArray, int n2) {
        return Math.abs(Math.maximum(nArray, n2) - Math.minimum(nArray, n2));
    }

    public static long peakToPeak(long[] lArray) {
        return Math.peakToPeak(lArray, lArray.length);
    }

    public static long peakToPeak(long[] lArray, int n2) {
        return Math.abs(Math.maximum(lArray, n2) - Math.minimum(lArray, n2));
    }

    public static short peakToPeak(short[] sArray) {
        return Math.peakToPeak(sArray, sArray.length);
    }

    public static short peakToPeak(short[] sArray, int n2) {
        return (short)Math.abs(Math.maximum(sArray, n2) - Math.minimum(sArray, n2));
    }

    public static boolean permute(int n2, int[] nArray) {
        int n3;
        int n4;
        int n5 = -1;
        for (n4 = n2 - 2; n4 > -1; --n4) {
            if (nArray[n4] >= nArray[n4 + 1]) continue;
            n5 = n4;
            break;
        }
        if (n5 == -1) {
            return false;
        }
        for (n4 = n2 - 1; n4 > n5; --n4) {
            if (nArray[n4] <= nArray[n5]) continue;
            n3 = nArray[n5];
            nArray[n5] = nArray[n4];
            nArray[n4] = n3;
            break;
        }
        for (n4 = 0; n4 < (n2 - n5 - 1) / 2; ++n4) {
            n3 = nArray[n5 + n4 + 1];
            nArray[n5 + n4 + 1] = nArray[n2 - n4 - 1];
            nArray[n2 - n4 - 1] = n3;
        }
        return true;
    }

    public static double poisson(double d2, double d3) {
        if (d2 < 0.0) {
            return 0.0;
        }
        if (d2 == 0.0) {
            return 1.0 / Math.exp(d3);
        }
        double d4 = d2 * Math.log(d3) - d3 - Math.lnGamma(d2 + 1.0);
        return Math.exp(d4);
    }

    public static double poissonI(double d2, double d3) {
        if (d2 < 0.0) {
            return 0.0;
        }
        if (d2 < 1.0) {
            return Math.exp(-d3);
        }
        int n2 = (int)d2;
        double d4 = 2000000.0;
        double d5 = d2 < 2000000.0 ? Math.pow(d3, n2) / Math.gamma(n2 + 1) : Math.pow(d3, d2) / Math.gamma(d2 + 1.0);
        return d5 / Math.exp(d3);
    }

    public static double prob(double d2, int n2) {
        if (n2 <= 0) {
            return 0.0;
        }
        if (d2 <= 0.0) {
            if (d2 < 0.0) {
                return 0.0;
            }
            return 1.0;
        }
        if (n2 == 1) {
            return 1.0 - Math.erf(Math.sqrt(d2) / Math.sqrt(2.0));
        }
        double d3 = Math.sqrt(2.0 * d2) - Math.sqrt(2 * n2 - 1);
        if (n2 <= 30 || !(d3 > 5.0)) {
            return 1.0 - Math.gamma(0.5 * (double)n2, 0.5 * d2);
        }
        return 0.5 * (1.0 - Math.erf(d3 / Math.sqrt(2.0)));
    }

    public static double rms(double[] dArray) {
        return Math.rms(dArray, dArray.length);
    }

    public static double rms(double[] dArray, int n2) {
        if (n2 <= 0) {
            return -1.0;
        }
        double d2 = 1.0 / (double)n2;
        double d3 = 0.0;
        double d4 = 0.0;
        for (int i2 = 0; i2 < n2; ++i2) {
            d3 += dArray[i2];
            d4 += dArray[i2] * dArray[i2];
        }
        return Math.sqrt(Math.abs((d4 *= d2) - (d3 *= d2) * d3));
    }

    public static float rms(float[] fArray) {
        return Math.rms(fArray, fArray.length);
    }

    public static float rms(float[] fArray, int n2) {
        if (n2 <= 0) {
            return -1.0f;
        }
        double d2 = 1.0 / (double)n2;
        double d3 = 0.0;
        double d4 = 0.0;
        for (int i2 = 0; i2 < n2; ++i2) {
            d3 += (double)fArray[i2];
            d4 += (double)(fArray[i2] * fArray[i2]);
        }
        return (float)Math.sqrt(Math.abs((d4 *= d2) - (d3 *= d2) * d3));
    }

    public static int rms(int[] nArray) {
        return Math.rms(nArray, nArray.length);
    }

    public static int rms(int[] nArray, int n2) {
        if (n2 <= 0) {
            return -1;
        }
        double d2 = 1.0 / (double)n2;
        double d3 = 0.0;
        double d4 = 0.0;
        for (int i2 = 0; i2 < n2; ++i2) {
            d3 += (double)nArray[i2];
            d4 += (double)(nArray[i2] * nArray[i2]);
        }
        return (int)Math.sqrt(Math.abs((d4 *= d2) - (d3 *= d2) * d3));
    }

    public static long rms(long[] lArray) {
        return Math.rms(lArray, lArray.length);
    }

    public static long rms(long[] lArray, int n2) {
        if (n2 <= 0) {
            return -1L;
        }
        double d2 = 1.0 / (double)n2;
        double d3 = 0.0;
        double d4 = 0.0;
        for (int i2 = 0; i2 < n2; ++i2) {
            d3 += (double)lArray[i2];
            d4 += (double)(lArray[i2] * lArray[i2]);
        }
        return (long)Math.sqrt(Math.abs((d4 *= d2) - (d3 *= d2) * d3));
    }

    public static short rms(short[] sArray) {
        return Math.rms(sArray, sArray.length);
    }

    public static short rms(short[] sArray, int n2) {
        if (n2 <= 0) {
            return -1;
        }
        double d2 = 1.0 / (double)n2;
        double d3 = 0.0;
        double d4 = 0.0;
        for (int i2 = 0; i2 < n2; ++i2) {
            d3 += (double)sArray[i2];
            d4 += (double)(sArray[i2] * sArray[i2]);
        }
        return (short)Math.sqrt(Math.abs((d4 *= d2) - (d3 *= d2) * d3));
    }

    public static double sinc(double d2, boolean bl2) {
        if (d2 == 0.0) {
            return 1.0;
        }
        double d3 = bl2 ? java.lang.Math.PI : 1.0;
        return MathBase.sin(d3 * d2) / (d3 * d2);
    }

    public static double[] sort(double[] dArray, int n2, boolean bl2) {
        if (dArray == null || dArray.length <= 0) {
            return new double[0];
        }
        double[] dArray2 = Arrays.copyOf(dArray, n2);
        Arrays.sort(dArray2);
        if (bl2) {
            int n3 = n2 - 1;
            for (int i2 = 0; i2 < n2 / 2; ++i2) {
                double d2 = dArray2[i2];
                dArray2[i2] = dArray2[n3 - i2];
                dArray2[n3 - i2] = d2;
            }
        }
        return dArray2;
    }

    public static float[] sort(float[] fArray, int n2, boolean bl2) {
        if (fArray == null || fArray.length <= 0) {
            return new float[0];
        }
        float[] fArray2 = Arrays.copyOf(fArray, n2);
        Arrays.sort(fArray2);
        if (bl2) {
            int n3 = n2 - 1;
            for (int i2 = 0; i2 < n2 / 2; ++i2) {
                float f2 = fArray2[i2];
                fArray2[i2] = fArray2[n3 - i2];
                fArray2[n3 - i2] = f2;
            }
        }
        return fArray2;
    }

    public static int[] sort(int[] nArray, int n2, boolean bl2) {
        if (nArray == null || nArray.length <= 0) {
            return new int[0];
        }
        int[] nArray2 = Arrays.copyOf(nArray, n2);
        Arrays.sort(nArray2);
        if (bl2) {
            int n3 = n2 - 1;
            for (int i2 = 0; i2 < n2 / 2; ++i2) {
                int n4 = nArray2[i2];
                nArray2[i2] = nArray2[n3 - i2];
                nArray2[n3 - i2] = n4;
            }
        }
        return nArray2;
    }

    public static long[] sort(long[] lArray, int n2, boolean bl2) {
        if (lArray == null || lArray.length <= 0) {
            return new long[0];
        }
        long[] lArray2 = Arrays.copyOf(lArray, n2);
        Arrays.sort(lArray2);
        if (bl2) {
            int n3 = n2 - 1;
            for (int i2 = 0; i2 < n2 / 2; ++i2) {
                long l2 = lArray2[i2];
                lArray2[i2] = lArray2[n3 - i2];
                lArray2[n3 - i2] = l2;
            }
        }
        return lArray2;
    }

    public static short[] sort(short[] sArray, int n2, boolean bl2) {
        if (sArray == null || sArray.length <= 0) {
            return new short[0];
        }
        short[] sArray2 = Arrays.copyOf(sArray, n2);
        Arrays.sort(sArray2);
        if (bl2) {
            int n3 = n2 - 1;
            for (int i2 = 0; i2 < n2 / 2; ++i2) {
                short s2 = sArray2[i2];
                sArray2[i2] = sArray2[n3 - i2];
                sArray2[n3 - i2] = s2;
            }
        }
        return sArray2;
    }

    public static double struveH0(double d2) {
        double d3;
        int n2 = 15;
        int n3 = 25;
        double[] dArray = new double[]{1.00215845609912, -1.6396929268130915, 1.502369396182928, -0.7248511530212187, 0.18955327371093136, -0.03067052022988, 0.00337561447375194, -2.6965014312602E-4, 1.637461692612E-5, -7.8244408508E-7, 3.021593188E-8, -9.6326645E-10, 2.579337E-11, -5.8854E-13, 1.158E-14, -2.0E-16};
        double[] dArray2 = new double[]{0.9928372757642394, -0.00696891281138625, 1.8205103787037E-4, -1.063258252844E-5, 9.8198294287E-7, -1.2250645445E-7, 1.894083312E-8, -3.44358226E-9, 7.1119102E-10, -1.6288744E-10, 4.065681E-11, -1.091505E-11, 3.12005E-12, -9.4202E-13, 2.9848E-13, -9.872E-14, 3.394E-14, -1.208E-14, 4.44E-15, -1.68E-15, 6.5E-16, -2.6E-16, 1.1E-16, -4.0E-17, 2.0E-17, -1.0E-17};
        double d4 = 0.6366197723675814;
        double d5 = Math.abs(d2);
        d5 = Math.abs(d2);
        if (d5 < 8.0) {
            double d6 = d5 / 8.0;
            d3 = 2.0 * d6 * d6 - 1.0;
            double d7 = d3 + d3;
            double d8 = 0.0;
            double d9 = 0.0;
            double d10 = 0.0;
            for (int i2 = 15; i2 >= 0; --i2) {
                d8 = dArray[i2] + d7 * d9 - d10;
                d10 = d9;
                d9 = d8;
            }
            d3 = d6 * (d8 - d3 * d10);
        } else {
            double d11 = 1.0 / d5;
            d3 = 128.0 * d11 * d11 - 1.0;
            double d12 = d3 + d3;
            double d13 = 0.0;
            double d14 = 0.0;
            double d15 = 0.0;
            for (int i3 = 25; i3 >= 0; --i3) {
                d13 = dArray2[i3] + d12 * d14 - d15;
                d15 = d14;
                d14 = d13;
            }
            d3 = Math.besselY0(d5) + d11 * 0.6366197723675814 * (d13 - d3 * d15);
        }
        if (d2 < 0.0) {
            d3 = -d3;
        }
        return d3;
    }

    public static double struveH1(double d2) {
        double d3;
        int n2 = 16;
        int n3 = 22;
        double[] dArray = new double[]{0.5578891446481605, -0.11188325726569816, -0.16337958125200938, 0.322569320724059, -0.14581632367244243, 0.03292677399374035, -0.00460372142093573, 4.434706163314E-4, -3.142099529341E-5, 1.7123719938E-6, -7.416987005E-8, 2.61837671E-9, -7.685839E-11, 1.9067E-12, -4.052E-14, 7.5E-16, -1.0E-17};
        double[] dArray2 = new double[]{1.0075764729386565, 0.00750316051248257, -7.043933264519E-5, 2.66205393382E-6, -1.8841157753E-7, 1.949014958E-8, -2.6126199E-9, 4.236269E-10, -7.955156E-11, 1.679973E-11, -3.9072E-12, 9.8543E-13, -2.6636E-13, 7.645E-14, -2.313E-14, 7.33E-15, -2.42E-15, 8.3E-16, -3.0E-16, 1.1E-16, -4.0E-17, 2.0E-17, -1.0E-17};
        double d4 = 0.6366197723675814;
        double d5 = 0.2122065907891938;
        double d6 = Math.abs(d2);
        if (d6 == 0.0) {
            d3 = 0.0;
        } else if (d6 <= 0.3) {
            double d7 = d6 * d6;
            double d8 = 1.0;
            d3 = 1.0;
            int n4 = (int)(-8.0 / Math.log10(d6));
            for (int i2 = 1; i2 <= n4; ++i2) {
                d3 = -d3 * d7 / (double)((2 * i2 + 1) * (2 * i2 + 3));
                d8 += d3;
            }
            d3 = 0.2122065907891938 * d7 * d8;
        } else if (d6 < 8.0) {
            d3 = d6 * d6 / 32.0 - 1.0;
            double d9 = d3 + d3;
            double d10 = 0.0;
            double d11 = 0.0;
            double d12 = 0.0;
            for (int i3 = 16; i3 >= 0; --i3) {
                d10 = dArray[i3] + d9 * d11 - d12;
                d12 = d11;
                d11 = d10;
            }
            d3 = d10 - d3 * d12;
        } else {
            d3 = 128.0 / (d6 * d6) - 1.0;
            double d13 = d3 + d3;
            double d14 = 0.0;
            double d15 = 0.0;
            double d16 = 0.0;
            for (int i4 = 22; i4 >= 0; --i4) {
                d14 = dArray2[i4] + d13 * d15 - d16;
                d16 = d15;
                d15 = d14;
            }
            d3 = Math.besselY1(d6) + 0.6366197723675814 * (d14 - d3 * d16);
        }
        return d3;
    }

    public static double struveL0(double d2) {
        double d3;
        double d4 = java.lang.Math.PI;
        double d5 = 1.0;
        double d6 = 1.0;
        if (d2 <= 20.0) {
            double d7 = 2.0 * d2 / java.lang.Math.PI;
            for (int i2 = 1; i2 <= 60 && !(Math.abs((d6 *= d2 / (double)(2 * i2 + 1) * (d2 / (double)(2 * i2 + 1))) / (d5 += d6)) < 1.0E-12); ++i2) {
            }
            d3 = d7 * d5;
        } else {
            int n2;
            int n3 = (int)(5.0 * (d2 + 1.0));
            if (d2 >= 50.0) {
                n3 = 25;
            }
            for (n2 = 1; n2 <= n3 && !(Math.abs((d6 *= (double)((2 * n2 - 1) * (2 * n2 - 1)) / d2 / d2) / (d5 += d6)) < 1.0E-12); ++n2) {
            }
            double d8 = Math.exp(d2) / Math.sqrt(java.lang.Math.PI * 2 * d2);
            d6 = 1.0;
            double d9 = 1.0;
            for (n2 = 1; n2 <= 16 && !(Math.abs((d6 = 0.125 * d6 * (2.0 * (double)n2 - 1.0) * (2.0 * (double)n2 - 1.0) / ((double)n2 * d2)) / (d9 += d6)) < 1.0E-12); ++n2) {
            }
            d3 = -2.0 / (java.lang.Math.PI * d2) * d5 + (d9 *= d8);
        }
        return d3;
    }

    public static double struveL1(double d2) {
        double d3;
        double d4 = java.lang.Math.PI;
        double d5 = 1.0;
        if (d2 <= 20.0) {
            double d6 = 0.0;
            for (int i2 = 1; i2 <= 60; ++i2) {
                if (Math.abs(d5) < Math.abs(d6 += (d5 *= d2 * d2 / (4.0 * (double)i2 * (double)i2 - 1.0))) * 1.0E-12) break;
            }
            d3 = 0.6366197723675814 * d6;
        } else {
            int n2;
            double d7 = 1.0;
            int n3 = (int)(0.5 * d2);
            if (d2 > 50.0) {
                n3 = 25;
            }
            for (n2 = 1; n2 <= n3 && !(Math.abs((d5 *= (double)((2 * n2 + 3) * (2 * n2 + 1)) / d2 / d2) / (d7 += d5)) < 1.0E-12); ++n2) {
            }
            d3 = 0.6366197723675814 * (-1.0 + 1.0 / (d2 * d2) + 3.0 * d7 / (d2 * d2 * d2 * d2));
            double d8 = Math.exp(d2) / Math.sqrt(java.lang.Math.PI * 2 * d2);
            d5 = 1.0;
            double d9 = 1.0;
            for (n2 = 1; n2 <= 16 && !(Math.abs((d5 = -0.125 * d5 * (4.0 - (2.0 * (double)n2 - 1.0) * (2.0 * (double)n2 - 1.0)) / ((double)n2 * d2)) / (d9 += d5)) < 1.0E-12); ++n2) {
            }
            d3 += d8 * d9;
        }
        return d3;
    }

    public static double student(double d2, double d3) {
        if (d3 < 1.0) {
            return 0.0;
        }
        double d4 = d3;
        double d5 = 0.5 * d4;
        double d6 = d5 + 0.5;
        double d7 = Math.sqrt(d4 * java.lang.Math.PI) * Math.gamma(d5) * Math.pow(1.0 + d2 * d2 / d4, d6);
        return Math.gamma(d6) / d7;
    }

    public static double studentI(double d2, double d3) {
        double d4 = d3;
        double d5 = d2 > 0.0 ? 1.0 - 0.5 * Math.betaIncomplete(d4 / (d4 + d2 * d2), d4 * 0.5, 0.5) : 0.5 * Math.betaIncomplete(d4 / (d4 + d2 * d2), d4 * 0.5, 0.5);
        return d5;
    }

    public static double studentQuantile(double d2, double d3, boolean bl2) {
        double d4;
        double d5;
        boolean bl3;
        if (d3 < 1.0 || d2 >= 1.0 || d2 <= 0.0) {
            System.err.println("StudentQuantile() - illegal parameter values");
            return 0.0;
        }
        if (bl2 && d2 > 0.5 || !bl2 && d2 < 0.5) {
            bl3 = false;
            d5 = 2.0 * (bl2 ? 1.0 - d2 : d2);
        } else {
            bl3 = true;
            d5 = 2.0 * (bl2 ? d2 : 1.0 - d2);
        }
        if (d3 - 1.0 < 1.0E-8) {
            double d6 = 1.5707963267948966 * d5;
            d4 = Math.cos(d6) / Math.sin(d6);
        } else if (d3 - 2.0 < 1.0E-8) {
            d4 = Math.sqrt(2.0 / (d5 * (2.0 - d5)) - 2.0);
        } else {
            double d7 = 1.0 / (d3 - 0.5);
            double d8 = 48.0 / (d7 * d7);
            double d9 = ((20700.0 * d7 / d8 - 98.0) * d7 - 16.0) * d7 + 96.36;
            double d10 = ((94.5 / (d8 + d9) - 3.0) / d8 + 1.0) * Math.sqrt(d7 * 1.5707963267948966) * d3;
            double d11 = d5 * d10;
            double d12 = Math.pow(d11, 2.0 / d3);
            if (d12 > 0.05 + d7) {
                d11 = Math.normQuantile(d5 * 0.5);
                d12 = d11 * d11;
                if (d3 < 5.0) {
                    d9 += 0.3 * (d3 - 4.5) * (d11 + 0.6);
                }
                d12 = (((((0.4 * d12 + 6.3) * d12 + 36.0) * d12 + 94.5) / (d9 += (((0.05 * d10 * d11 - 5.0) * d11 - 7.0) * d11 - 2.0) * d11 + d8) - d12 - 3.0) / d8 + 1.0) * d11;
                d12 = (d12 = d7 * d12 * d12) > 0.002 ? Math.exp(d12) - 1.0 : (d12 += 0.5 * d12 * d12);
            } else {
                d12 = ((1.0 / (((d3 + 6.0) / (d3 * d12) - 0.089 * d10 - 0.822) * (d3 + 2.0) * 3.0) + 0.5 / (d3 + 4.0)) * d12 - 1.0) * (d3 + 1.0) / (d3 + 2.0) + 1.0 / d12;
            }
            d4 = Math.sqrt(d3 * d12);
        }
        if (bl3) {
            d4 = -d4;
        }
        return d4;
    }

    public static double variance(double[] dArray, double[] dArray2) {
        int n2;
        int n3 = dArray.length;
        if (n3 != dArray2.length) {
            throw new IllegalArgumentException("length of variable array, " + n3 + " and length of weight array, " + dArray2.length + " are different");
        }
        double d2 = Math.effectiveSampleNumber(dArray2);
        double d3 = d2 / (d2 - 1.0);
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        double[] dArray3 = Math.invertAndSquare(dArray2);
        for (n2 = 0; n2 < n3; ++n2) {
            d4 += dArray[n2] * dArray3[n2];
            d5 += dArray3[n2];
        }
        d6 = d4 / d5;
        d4 = 0.0;
        for (n2 = 0; n2 < n3; ++n2) {
            d4 += dArray3[n2] * MathBase.sqr(dArray[n2] - d6);
        }
        return d4 * d3 / d5;
    }

    public static double vavilov(double d2, double d3, double d4) {
        double[] dArray = new double[14];
        double[] dArray2 = new double[9];
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        Math.vavilovSet(d3, d4, false, null, dArray, dArray2, nArray, nArray2);
        double d5 = Math.vavilovDenEval(d2, dArray, dArray2, nArray[0]);
        return d5;
    }

    protected static double vavilovDenEval(double d2, double[] dArray, double[] dArray2, int n2) {
        if (d2 < dArray[0] || d2 > dArray[8]) {
            return 0.0;
        }
        double d3 = 0.0;
        double[] dArray3 = new double[10];
        if (n2 == 1) {
            int n3;
            double d4;
            double d5 = 1.0;
            dArray3[1] = d4 = (d2 + dArray2[0]) * dArray2[1];
            dArray3[2] = d4 * d4 - 1.0;
            for (n3 = 2; n3 <= 8; ++n3) {
                dArray3[n3 + 1] = d4 * dArray3[n3] - (d5 += 1.0) * dArray3[n3 - 1];
            }
            double d6 = 1.0 + dArray2[7] * dArray3[9];
            for (n3 = 2; n3 <= 6; ++n3) {
                d6 += dArray2[n3] * dArray3[n3 + 1];
            }
            d3 = dArray2[8] * Math.exp(-0.5 * d4 * d4) * Math.max(d6, 0.0);
        } else if (n2 == 2) {
            double d7 = d2 * d2;
            d3 = dArray[1] * Math.exp(-dArray[2] * (d2 + dArray[5] * d7) - dArray[3] * Math.exp(-dArray[4] * (d2 + dArray[6] * d7)));
        } else if (n2 == 3) {
            if (d2 < dArray[7]) {
                double d8 = d2 * d2;
                d3 = dArray[1] * Math.exp(-dArray[2] * (d2 + dArray[5] * d8) - dArray[3] * Math.exp(-dArray[4] * (d2 + dArray[6] * d8)));
            } else {
                double d9 = 1.0 / d2;
                d3 = (dArray[11] * d9 + dArray[12]) * d9;
            }
        } else if (n2 == 4) {
            // empty if block
        }
        return d3;
    }

    public static double vavilovI(double d2, double d3, double d4) {
        double d5;
        double[] dArray = new double[14];
        double[] dArray2 = new double[9];
        double[] dArray3 = new double[200];
        int[] nArray = new int[]{};
        int[] nArray2 = new int[]{};
        Math.vavilovSet(d3, d4, true, dArray3, dArray, dArray2, nArray, nArray2);
        if (d2 < dArray[0]) {
            d5 = 0.0;
        } else if (d2 >= dArray[8]) {
            d5 = 1.0;
        } else {
            double d6 = d2 - dArray[0];
            int n2 = (int)(d6 * dArray[10]);
            d5 = Math.min(dArray3[n2] + (d6 - (double)n2 * dArray[9]) * (dArray3[n2 + 1] - dArray3[n2]) * dArray[10], 1.0);
        }
        return d5;
    }

    public static void vavilovSet(double d2, double d3, boolean bl2, double[] dArray, double[] dArray2, double[] dArray3, int[] nArray, int[] nArray2) {
        int n2;
        double d4;
        double d5;
        double d6;
        double d7;
        if (d2 < 0.01 || d2 > 12.0) {
            System.err.println("Vavilov distribution - illegal value of kappa");
            return;
        }
        double d8 = 0.02;
        double d9 = 0.05;
        double d10 = 0.12;
        double d11 = 0.05;
        double d12 = 0.22;
        double d13 = 0.05;
        double d14 = 0.1;
        double d15 = 1.0;
        double d16 = 0.2;
        double d17 = 1.0;
        double d18 = 0.3;
        double d19 = 1.0;
        double d20 = 25.0;
        double d21 = 24.999999999999996;
        double d22 = 25.000000000000004;
        double d23 = 2.1052631578947367;
        double d24 = 2.1052631578947367;
        double d25 = 2.1052631578947367;
        double[] dArray4 = new double[]{0.0, 1.0, 0.5, 0.33333333, 0.25, 0.2};
        double[] dArray5 = new double[]{0.0, 0.0, 0.16666667, 0.041666667, 0.0083333333, 0.013888889, 0.0069444444, 7.7160493E-4};
        double[] dArray6 = new double[]{0.0, 0.25850868, 0.032477982, -0.0059020496, 0.0, 0.024880692, 0.0047404356, -7.444513E-4, 0.0073225731, 0.0, 0.0011668284, 0.0, -0.0015727318, -0.0011210142};
        double[] dArray7 = new double[]{0.0, 0.43142611, 0.040797543, -0.0091490215, 0.0, 0.042127077, 0.0073167928, -0.0014026047, 0.016195241, 0.0024714789, 0.0020751278, 0.0, -0.0025141668, -0.0014064022};
        double[] dArray8 = new double[]{0.0, 0.25225955, 0.064820468, -0.023615759, 0.0, 0.023834176, 0.0021624675, -0.0026865597, -0.0054891384, 0.0039800522, 0.0048447456, -0.0089439554, -0.0062756944, -0.0024655436};
        double[] dArray9 = new double[]{0.0, 1.2593231, -0.20374501, 0.095055662, -0.020771531, -0.04686518, -0.0077222986, 0.0032241039, 0.008988292, -0.0067167236, -0.013049241, 0.018786468, 0.014484097};
        double[] dArray10 = new double[]{0.0, -0.024864376, -0.0010368495, 0.0014330117, 2.005273E-4, 0.0018751903, 0.0012668869, 4.8736023E-4, 0.0034850854, 0.0, -3.6597173E-4, 0.0019372124, 7.0761825E-4, 4.6898375E-4};
        double[] dArray11 = new double[]{0.0, 0.035855696, -0.027542114, 0.012631023, -0.0030188807, -8.4479939E-4, 0.0, 4.5675843E-4, -0.0069836141, 0.0039876546, -0.0036055679, 0.0, 0.0015298434, 0.0019247256};
        double[] dArray12 = new double[]{0.0, 10.234691, -3.5619655, 0.69387764, -0.14047599, -1.995239, -0.45679694, 0.0, 0.50505298};
        double[] dArray13 = new double[]{0.0, 21.487518, -11.825253, 4.3133087, -1.4500543, -3.4343169, -1.1063164, -0.21000819, 1.7891643, -0.89601916, 0.39120793, 0.73410606, 0.0, -0.32454506};
        double[] dArray14 = new double[]{0.0, 0.27827257, -0.0014227603, 0.0024848327, 0.0, 0.045091424, 0.0080559636, -0.0038974523, 0.0, -0.0030634124, 7.5633702E-4, 0.0054730726, 0.0019792507};
        double[] dArray15 = new double[]{0.0, 0.41421789, -0.030061649, 0.0052249697, 0.0, 0.12693873, 0.022999801, -0.0086792801, 0.031875584, -0.0061757928, 0.0, 0.019716857, 0.0032596742};
        double[] dArray16 = new double[]{0.0, 0.20191056, -0.046831422, 0.0096777473, -0.0017995317, 0.053921588, 0.003506874, -0.012621494, -0.0054996531, -0.0090029985, 0.0034958743, 0.018513506, 0.0068332334, -0.0012940502};
        double[] dArray17 = new double[]{0.0, 1.3206081, 0.10036618, -0.022015201, 0.0061667091, -0.14986093, -0.012720568, 0.024972042, -0.0097751962, 0.026087455, -0.011399062, -0.048282515, -0.0098552378};
        double[] dArray18 = new double[]{0.0, 0.016435243, 0.0360514, 0.002303652, -6.1666343E-4, -0.010775802, 0.0051476061, 0.0056856517, -0.013438433, 0.0, 0.0, -0.0025421507, 0.0020169108, -0.0015144931};
        double[] dArray19 = new double[]{0.0, 0.033432405, 0.0060583916, -0.0023381379, 8.3846081E-4, -0.013346861, -0.0017402116, 0.0021052496, 0.0015528195, 0.002190067, -0.0013202847, -0.0045124157, -0.0015629454, 2.2499176E-4};
        double[] dArray20 = new double[]{0.0, 5.4529572, -0.90906096, 0.086122438, 0.0, -1.2218009, -0.3232412, -0.027373591, 0.12173464, 0.0, 0.0, 0.040917471};
        double[] dArray21 = new double[]{0.0, 9.3841352, -1.6276904, 0.16571423, 0.0, -1.8160479, -0.50919193, -0.051384654, 0.21413992, 0.0, 0.0, 0.066596366};
        double[] dArray22 = new double[]{0.0, 0.29712951, 0.0097572934, 0.0, -0.0015291686, 0.035707399, 0.0096221631, -0.0018402821, -0.0049821585, 0.0018831112, 0.0043541673, 0.0020301312, -0.0018723311, -7.3403108E-4};
        double[] dArray23 = new double[]{0.0, 0.40882635, 0.014474912, 0.0025023704, -0.0037707379, 0.18719727, 0.056954987, 0.0, 0.023020158, 0.0050574313, 0.009455014, 0.019300232};
        double[] dArray24 = new double[]{0.0, 0.16861629, 0.0, 0.0036317285, -0.0043657818, 0.030144338, 0.013891826, -0.0058030495, -0.0038717547, 0.0085359607, 0.014507659, 0.0082387775, -0.010116105, -0.005513567};
        double[] dArray25 = new double[]{0.0, 1.3493891, -0.0026863185, -0.003521604, 0.024434909, -0.083447911, -0.04806136, 0.0076473951, 0.02449443, -0.0162092, -0.037768479, -0.047890063, 0.017778596, 0.013179324};
        double[] dArray26 = new double[]{0.0, 0.10264945, 0.032738857, 0.0, 0.0043608779, -0.043097757, -0.0022647176, 0.009453129, -0.012442571, -0.0032283517, -0.0075640352, -0.0088293329, 0.0052537299, 0.0013340546};
        double[] dArray27 = new double[]{0.0, 0.029568177, -0.001630006, -2.1119745E-4, 0.0023599053, -0.0048515387, -0.0040797531, 4.0403265E-4, 0.0018200105, -0.0014346306, -0.0039165276, -0.0037432073, 0.001995038, 0.0012222675};
        double[] dArray28 = new double[]{0.0, 6.6184645, -0.73866379, 0.044693973, 0.0, -1.4540925, -0.39529833, -0.044293243, 0.088741049};
        nArray[0] = 0;
        double[] dArray29 = new double[6];
        double[] dArray30 = new double[6];
        double[] dArray31 = new double[8];
        if (d2 >= 0.29) {
            int n3;
            nArray[0] = 1;
            nArray2[0] = 100;
            d7 = 1.0 / Math.sqrt(d2);
            dArray2[0] = (-0.032227 * d3 - 0.074275) * d2 + (0.24533 * d3 + 0.070152) * d7 + (-0.5561 * d3 - 3.1579);
            dArray2[8] = (-0.013483 * d3 - 0.048801) * d2 + (-1.6921 * d3 + 8.3656) * d7 + (-0.73275 * d3 - 3.5226);
            dArray29[1] = d7 * d7;
            dArray30[1] = Math.sqrt(d2 / (1.0 - 0.5 * d3));
            for (n3 = 1; n3 <= 4; ++n3) {
                dArray29[n3 + 1] = dArray29[1] * dArray29[n3];
                dArray30[n3 + 1] = dArray30[1] * dArray30[n3];
                dArray31[n3 + 1] = (dArray4[n3] - d3 * dArray4[n3 + 1]) * dArray29[n3];
            }
            dArray3[0] = Math.log(d2) + d3 + 0.42278434;
            dArray3[1] = dArray30[1];
            dArray3[2] = dArray31[3] * dArray30[3];
            dArray3[3] = (3.0 * dArray31[2] * dArray31[2] + dArray31[4]) * dArray30[4] - 3.0;
            dArray3[4] = (10.0 * dArray31[2] * dArray31[3] + dArray31[5]) * dArray30[5] - 10.0 * dArray3[2];
            dArray3[5] = dArray3[2] * dArray3[2];
            dArray3[6] = dArray3[2] * dArray3[3];
            dArray3[7] = dArray3[2] * dArray3[5];
            for (n3 = 2; n3 <= 7; ++n3) {
                int n4 = n3;
                dArray3[n4] = dArray3[n4] * dArray5[n3];
            }
            dArray3[8] = 0.39894228 * dArray3[1];
        } else if (d2 >= 0.22) {
            nArray[0] = 2;
            nArray2[0] = 150;
            d6 = 1.0 + (d2 - 0.3) * 25.000000000000004;
            d5 = 1.0 + (Math.sqrt(d3) - 1.0) * 2.1052631578947367;
            var79_58 = 2.0 * d6;
            var81_59 = 2.0 * d5;
            var83_60 = var79_58 * d6 - 1.0;
            var85_61 = var79_58 * var83_60 - d6;
            var87_62 = var81_59 * d5 - 1.0;
            var89_63 = var81_59 * var87_62 - d5;
            var91_64 = d6 * d5;
            d4 = var83_60 * d5;
            var95_66 = var85_61 * d5;
            var97_67 = var87_62 * d6;
            var99_68 = var89_63 * d6;
            var101_69 = var83_60 * var87_62;
            dArray2[1] = dArray22[1] + dArray22[2] * d6 + dArray22[4] * var85_61 + dArray22[5] * d5 + dArray22[6] * var87_62 + dArray22[7] * var89_63 + dArray22[8] * var91_64 + dArray22[9] * d4 + dArray22[10] * var95_66 + dArray22[11] * var97_67 + dArray22[12] * var99_68 + dArray22[13] * var101_69;
            dArray2[2] = dArray23[1] + dArray23[2] * d6 + dArray23[3] * var83_60 + dArray23[4] * var85_61 + dArray23[5] * d5 + dArray23[6] * var87_62 + dArray23[8] * var91_64 + dArray23[9] * d4 + dArray23[10] * var95_66 + dArray23[11] * var97_67;
            dArray2[3] = dArray24[1] + dArray24[3] * var83_60 + dArray24[4] * var85_61 + dArray24[5] * d5 + dArray24[6] * var87_62 + dArray24[7] * var89_63 + dArray24[8] * var91_64 + dArray24[9] * d4 + dArray24[10] * var95_66 + dArray24[11] * var97_67 + dArray24[12] * var99_68 + dArray24[13] * var101_69;
            dArray2[4] = dArray25[1] + dArray25[2] * d6 + dArray25[3] * var83_60 + dArray25[4] * var85_61 + dArray25[5] * d5 + dArray25[6] * var87_62 + dArray25[7] * var89_63 + dArray25[8] * var91_64 + dArray25[9] * d4 + dArray25[10] * var95_66 + dArray25[11] * var97_67 + dArray25[12] * var99_68 + dArray25[13] * var101_69;
            dArray2[5] = dArray26[1] + dArray26[2] * d6 + dArray26[4] * var85_61 + dArray26[5] * d5 + dArray26[6] * var87_62 + dArray26[7] * var89_63 + dArray26[8] * var91_64 + dArray26[9] * d4 + dArray26[10] * var95_66 + dArray26[11] * var97_67 + dArray26[12] * var99_68 + dArray26[13] * var101_69;
            dArray2[6] = dArray27[1] + dArray27[2] * d6 + dArray27[3] * var83_60 + dArray27[4] * var85_61 + dArray27[5] * d5 + dArray27[6] * var87_62 + dArray27[7] * var89_63 + dArray27[8] * var91_64 + dArray27[9] * d4 + dArray27[10] * var95_66 + dArray27[11] * var97_67 + dArray27[12] * var99_68 + dArray27[13] * var101_69;
            dArray2[8] = dArray28[1] + dArray28[2] * d6 + dArray28[3] * var83_60 + dArray28[5] * d5 + dArray28[6] * var87_62 + dArray28[7] * var89_63 + dArray28[8] * var91_64;
            dArray2[0] = -3.05;
        } else if (d2 >= 0.12) {
            nArray[0] = 3;
            nArray2[0] = 200;
            d6 = 1.0 + (d2 - 0.2) * 24.999999999999996;
            d5 = 1.0 + (Math.sqrt(d3) - 1.0) * 2.1052631578947367;
            var79_58 = 2.0 * d6;
            var81_59 = 2.0 * d5;
            var83_60 = var79_58 * d6 - 1.0;
            var85_61 = var79_58 * var83_60 - d6;
            var87_62 = var81_59 * d5 - 1.0;
            var89_63 = var81_59 * var87_62 - d5;
            var91_64 = d6 * d5;
            d4 = var83_60 * d5;
            var95_66 = var85_61 * d5;
            var97_67 = var87_62 * d6;
            var99_68 = var89_63 * d6;
            var101_69 = var83_60 * var87_62;
            dArray2[1] = dArray14[1] + dArray14[2] * d6 + dArray14[3] * var83_60 + dArray14[5] * d5 + dArray14[6] * var87_62 + dArray14[7] * var89_63 + dArray14[9] * d4 + dArray14[10] * var95_66 + dArray14[11] * var97_67 + dArray14[12] * var99_68;
            dArray2[2] = dArray15[1] + dArray15[2] * d6 + dArray15[3] * var83_60 + dArray15[5] * d5 + dArray15[6] * var87_62 + dArray15[7] * var89_63 + dArray15[8] * var91_64 + dArray15[9] * d4 + dArray15[11] * var97_67 + dArray15[12] * var99_68;
            dArray2[3] = dArray16[1] + dArray16[2] * d6 + dArray16[3] * var83_60 + dArray16[4] * var85_61 + dArray16[5] * d5 + dArray16[6] * var87_62 + dArray16[7] * var89_63 + dArray16[8] * var91_64 + dArray16[9] * d4 + dArray16[10] * var95_66 + dArray16[11] * var97_67 + dArray16[12] * var99_68 + dArray16[13] * var101_69;
            dArray2[4] = dArray17[1] + dArray17[2] * d6 + dArray17[3] * var83_60 + dArray17[4] * var85_61 + dArray17[5] * d5 + dArray17[6] * var87_62 + dArray17[7] * var89_63 + dArray17[8] * var91_64 + dArray17[9] * d4 + dArray17[10] * var95_66 + dArray17[11] * var97_67 + dArray17[12] * var99_68;
            dArray2[5] = dArray18[1] + dArray18[2] * d6 + dArray18[3] * var83_60 + dArray18[4] * var85_61 + dArray18[5] * d5 + dArray18[6] * var87_62 + dArray18[7] * var89_63 + dArray18[8] * var91_64 + dArray18[11] * var97_67 + dArray18[12] * var99_68 + dArray18[13] * var101_69;
            dArray2[6] = dArray19[1] + dArray19[2] * d6 + dArray19[3] * var83_60 + dArray19[4] * var85_61 + dArray19[5] * d5 + dArray19[6] * var87_62 + dArray19[7] * var89_63 + dArray19[8] * var91_64 + dArray19[9] * d4 + dArray19[10] * var95_66 + dArray19[11] * var97_67 + dArray19[12] * var99_68 + dArray19[13] * var101_69;
            dArray2[7] = dArray20[1] + dArray20[2] * d6 + dArray20[3] * var83_60 + dArray20[5] * d5 + dArray20[6] * var87_62 + dArray20[7] * var89_63 + dArray20[8] * var91_64 + dArray20[11] * var97_67;
            dArray2[8] = dArray21[1] + dArray21[2] * d6 + dArray21[3] * var83_60 + dArray21[5] * d5 + dArray21[6] * var87_62 + dArray21[7] * var89_63 + dArray21[8] * var91_64 + dArray21[11] * var97_67;
            dArray2[0] = -3.04;
        } else {
            nArray[0] = 4;
            if (d2 >= 0.02) {
                nArray[0] = 3;
            }
            nArray2[0] = 200;
            d6 = 1.0 + (d2 - 0.1) * 25.0;
            d5 = 1.0 + (Math.sqrt(d3) - 1.0) * 2.1052631578947367;
            var79_58 = 2.0 * d6;
            var81_59 = 2.0 * d5;
            var83_60 = var79_58 * d6 - 1.0;
            var85_61 = var79_58 * var83_60 - d6;
            var87_62 = var81_59 * d5 - 1.0;
            var89_63 = var81_59 * var87_62 - d5;
            var91_64 = d6 * d5;
            d4 = var83_60 * d5;
            var95_66 = var85_61 * d5;
            var97_67 = var87_62 * d6;
            var99_68 = var89_63 * d6;
            var101_69 = var83_60 * var87_62;
            if (nArray[0] == 3) {
                dArray2[1] = dArray6[1] + dArray6[2] * d6 + dArray6[3] * var83_60 + dArray6[5] * d5 + dArray6[6] * var87_62 + dArray6[7] * var89_63 + dArray6[8] * var91_64 + dArray6[10] * var95_66 + dArray6[12] * var99_68 + dArray6[13] * var101_69;
                dArray2[2] = dArray7[1] + dArray7[2] * d6 + dArray7[3] * var83_60 + dArray7[5] * d5 + dArray7[6] * var87_62 + dArray7[7] * var89_63 + dArray7[8] * var91_64 + dArray7[9] * d4 + dArray7[10] * var95_66 + dArray7[12] * var99_68 + dArray7[13] * var101_69;
                dArray2[3] = dArray8[1] + dArray8[2] * d6 + dArray8[3] * var83_60 + dArray8[5] * d5 + dArray8[6] * var87_62 + dArray8[7] * var89_63 + dArray8[8] * var91_64 + dArray8[9] * d4 + dArray8[10] * var95_66 + dArray8[11] * var97_67 + dArray8[12] * var99_68 + dArray8[13] * var101_69;
                dArray2[4] = dArray9[1] + dArray9[2] * d6 + dArray9[3] * var83_60 + dArray9[4] * var85_61 + dArray9[5] * d5 + dArray9[6] * var87_62 + dArray9[7] * var89_63 + dArray9[8] * var91_64 + dArray9[9] * d4 + dArray9[10] * var95_66 + dArray9[11] * var97_67 + dArray9[12] * var99_68;
                dArray2[5] = dArray10[1] + dArray10[2] * d6 + dArray10[3] * var83_60 + dArray10[4] * var85_61 + dArray10[5] * d5 + dArray10[6] * var87_62 + dArray10[7] * var89_63 + dArray10[8] * var91_64 + dArray10[10] * var95_66 + dArray10[11] * var97_67 + dArray10[12] * var99_68 + dArray10[13] * var101_69;
                dArray2[6] = dArray11[1] + dArray11[2] * d6 + dArray11[3] * var83_60 + dArray11[4] * var85_61 + dArray11[5] * d5 + dArray11[7] * var89_63 + dArray11[8] * var91_64 + dArray11[9] * d4 + dArray11[10] * var95_66 + dArray11[12] * var99_68 + dArray11[13] * var101_69;
                dArray2[7] = dArray12[1] + dArray12[2] * d6 + dArray12[3] * var83_60 + dArray12[4] * var85_61 + dArray12[5] * d5 + dArray12[6] * var87_62 + dArray12[8] * var91_64;
            }
            dArray2[8] = dArray13[1] + dArray13[2] * d6 + dArray13[3] * var83_60 + dArray13[4] * var85_61 + dArray13[5] * d5 + dArray13[6] * var87_62 + dArray13[7] * var89_63 + dArray13[8] * var91_64 + dArray13[9] * d4 + dArray13[10] * var95_66 + dArray13[11] * var97_67 + dArray13[13] * var101_69;
            dArray2[0] = -3.03;
        }
        dArray2[9] = (dArray2[8] - dArray2[0]) / (double)nArray2[0];
        dArray2[10] = 1.0 / dArray2[9];
        if (nArray[0] == 3) {
            d6 = (dArray2[7] - dArray2[8]) / (dArray2[7] * dArray2[8]);
            d5 = 1.0 / Math.log(dArray2[8] / dArray2[7]);
            d4 = dArray2[7] * dArray2[7];
            dArray2[11] = d4 * (dArray2[1] * Math.exp(-dArray2[2] * (dArray2[7] + dArray2[5] * d4) - dArray2[3] * Math.exp(-dArray2[4] * (dArray2[7] + dArray2[6] * d4))) - 0.045 * d5 / dArray2[7]) / (1.0 + d6 * d5 * dArray2[7]);
            dArray2[12] = (0.045 + d6 * dArray2[11]) * d5;
        }
        if (nArray[0] == 4) {
            dArray2[13] = 0.995 / Math.landauI(dArray2[8]);
        }
        if (!bl2) {
            return;
        }
        d6 = dArray2[0];
        if (dArray == null || dArray.length == 0) {
            throw new IllegalArgumentException("WCM must not be null or zero-length");
        }
        dArray[0] = 0.0;
        d7 = Math.vavilovDenEval(d6, dArray2, dArray3, nArray[0]);
        for (n2 = 1; n2 <= nArray2[0]; ++n2) {
            double d26 = Math.vavilovDenEval(d6 += dArray2[9], dArray2, dArray3, nArray[0]);
            dArray[n2] = dArray[n2 - 1] + d7 + d26;
            d7 = d26;
        }
        d6 = 0.5 * dArray2[9];
        n2 = 1;
        while (n2 <= nArray2[0]) {
            int n5 = n2++;
            dArray[n5] = dArray[n5] * d6;
        }
    }
}

