/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.math;

import io.fair_acc.dataset.DataSet;
import io.fair_acc.dataset.DataSetError;
import io.fair_acc.dataset.DefaultNumberFormatter;
import io.fair_acc.dataset.EditableDataSet;
import io.fair_acc.dataset.Formatter;
import io.fair_acc.dataset.GridDataSet;
import io.fair_acc.dataset.Histogram;
import io.fair_acc.dataset.spi.DoubleDataSet;
import io.fair_acc.dataset.spi.DoubleErrorDataSet;
import io.fair_acc.dataset.spi.Histogram;
import io.fair_acc.dataset.spi.utils.DoublePointError;
import io.fair_acc.dataset.utils.NoDuplicatesList;
import io.fair_acc.math.ArrayMath;
import io.fair_acc.math.Math;
import io.fair_acc.math.MathBase;
import io.fair_acc.math.SimpleDataSetEstimators;
import io.fair_acc.math.TRandom;
import io.fair_acc.math.spectra.Apodization;
import io.fair_acc.math.spectra.SpectrumTools;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jtransforms.fft.DoubleFFT_1D;

public final class DataSetMath {
    private static final char INTEGRAL_SYMBOL = '\u222b';
    private static final char DIFFERENTIAL_SYMBOL = '\u2202';
    private static final char MULTIPLICATION_SYMBOL = '\u00b7';
    private static final String DIFFERENTIAL = "\u2202/\u2202x";
    public static Formatter<Number> DEFAULT_FORMATTER = new DefaultNumberFormatter();

    private DataSetMath() {
    }

    public static DoubleErrorDataSet applyMathOperation(DoubleErrorDataSet doubleErrorDataSet, MathOp mathOp, double d2, double d3, double d4, double d5, double d6, double d7, double d8) {
        switch (mathOp) {
            case ADD: {
                return doubleErrorDataSet.add(d2, d3 + d4, MathBase.hypot(d5, d7), MathBase.hypot(d6, d8));
            }
            case SUBTRACT: {
                return doubleErrorDataSet.add(d2, d3 - d4, MathBase.hypot(d5, d7), MathBase.hypot(d6, d8));
            }
            case MULTIPLY: {
                return doubleErrorDataSet.add(d2, d3 * d4, MathBase.hypot(d4 * d5, d3 * d7), MathBase.hypot(d4 * d6, d3 * d8));
            }
            case DIVIDE: {
                double d9 = d3 / d4;
                double d10 = MathBase.hypot(d5 / d4, d9 * d7 / d4);
                double d11 = MathBase.hypot(d6 / d4, d9 * d8 / d4);
                return doubleErrorDataSet.add(d2, d9, d10, d11);
            }
            case SQR: {
                return doubleErrorDataSet.add(d2, MathBase.sqr(d3 + d4), 2.0 * MathBase.abs(d3 + d4) * MathBase.hypot(d5, d7), 2.0 * MathBase.abs(d3 + d4) * MathBase.hypot(d6, d8));
            }
            case SQRT: {
                return doubleErrorDataSet.add(d2, MathBase.sqrt(d3 + d4), MathBase.sqrt(MathBase.abs(d3 + d4)) * MathBase.hypot(d5, d7), MathBase.sqrt(MathBase.abs(d3 + d4)) * MathBase.hypot(d6, d8));
            }
            case LOG10: {
                double d12 = 1.0 / MathBase.log(10.0);
                double d13 = d3 + d4 > 0.0 ? d12 / MathBase.abs(d3 + d4) * MathBase.hypot(d5, d7) : Double.NaN;
                double d14 = d3 + d4 > 0.0 ? d12 / MathBase.abs(d3 + d4) * MathBase.hypot(d6, d8) : Double.NaN;
                return doubleErrorDataSet.add(d2, 10.0 * MathBase.log10(d3 + d4), d13, d14);
            }
            case DB: {
                double d15 = 20.0 / MathBase.log(10.0);
                double d16 = d3 + d4 > 0.0 ? d15 / MathBase.abs(d3 + d4) * MathBase.hypot(d5, d7) : Double.NaN;
                double d17 = d3 + d4 > 0.0 ? d15 / MathBase.abs(d3 + d4) * MathBase.hypot(d6, d8) : Double.NaN;
                return doubleErrorDataSet.add(d2, 20.0 * MathBase.log10(d3 + d4), d16, d17);
            }
        }
        return doubleErrorDataSet.add(d2, d3 + d4, d5, d6);
    }

    private static double error(DataSet dataSet, ErrType errType, int n2, double d2, boolean bl2) {
        if (!(dataSet instanceof DataSetError)) {
            return 0.0;
        }
        DataSetError dataSetError = (DataSetError)dataSet;
        if (bl2) {
            switch (errType) {
                case EXN: {
                    return dataSetError.getErrorNegative(0, d2);
                }
                case EXP: {
                    return dataSetError.getErrorPositive(0, d2);
                }
                case EYN: {
                    return dataSetError.getErrorNegative(1, d2);
                }
                case EYP: {
                    return dataSetError.getErrorPositive(1, d2);
                }
            }
        } else {
            switch (errType) {
                case EXN: {
                    return dataSetError.getErrorNegative(0, n2);
                }
                case EXP: {
                    return dataSetError.getErrorPositive(0, n2);
                }
                case EYN: {
                    return dataSetError.getErrorNegative(1, n2);
                }
                case EYP: {
                    return dataSetError.getErrorPositive(1, n2);
                }
            }
        }
        return 0.0;
    }

    @SafeVarargs
    public static DataSet addFunction(DataSet dataSet, DataSet dataSet2, Formatter<Number> ... formatterArray) {
        return DataSetMath.mathFunction(dataSet, dataSet2, MathOp.ADD, formatterArray);
    }

    @SafeVarargs
    public static DataSet addFunction(DataSet dataSet, double d2, Formatter<Number> ... formatterArray) {
        return DataSetMath.mathFunction(dataSet, d2, MathOp.ADD, formatterArray);
    }

    @SafeVarargs
    public static DataSet addGaussianNoise(DataSet dataSet, double d2, Formatter<Number> ... formatterArray) {
        int n2 = dataSet.getDataCount();
        String string = DataSetMath.getFormatter(formatterArray).format("{0}+noise({1})", dataSet.getName(), d2);
        DoubleErrorDataSet doubleErrorDataSet = new DoubleErrorDataSet(string, n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            double d3 = dataSet.get(0, i2);
            double d4 = dataSet.get(1, i2) + TRandom.Gaus(0.0, d2);
            doubleErrorDataSet.add(d3, d4, d2, d2);
        }
        return doubleErrorDataSet;
    }

    @SafeVarargs
    public static DataSet averageDataSetsFIR(@NotNull List<DataSet> list, int n2, Formatter<Number> ... formatterArray) {
        if (list.isEmpty()) {
            return new DoubleErrorDataSet(DataSetMath.getFormatter(formatterArray).format("LP({0}, FIR)", "<empty>"));
        }
        String string = DataSetMath.getFormatter(formatterArray).format("LP({0}, FIR)", list.get(0).getName());
        if (list.size() <= 1) {
            DataSet dataSet = list.get(0);
            if (dataSet instanceof DataSetError) {
                return new DoubleErrorDataSet(string, dataSet.getValues(0), dataSet.getValues(1), DataSetMath.errors(dataSet, ErrType.EYN), DataSetMath.errors(dataSet, ErrType.EYP), dataSet.getDataCount(), true);
            }
            int n3 = dataSet.getDataCount();
            return new DoubleErrorDataSet(string, dataSet.getValues(0), dataSet.getValues(1), new double[n3], new double[n3], n3, true);
        }
        int n4 = MathBase.min(n2, list.size());
        DataSet dataSet = list.get(list.size() - 1);
        DoubleErrorDataSet doubleErrorDataSet = new DoubleErrorDataSet(string, dataSet.getDataCount() + 2);
        for (int i2 = 0; i2 < dataSet.getDataCount(); ++i2) {
            double d2;
            double d3 = dataSet.get(0, i2);
            double d4 = 0.0;
            double d5 = 0.0;
            double d6 = 0.0;
            double d7 = 0.0;
            int n5 = 0;
            for (int i3 = MathBase.max(0, list.size() - n4); i3 < list.size(); ++i3) {
                DataSet dataSet2 = list.get(i3);
                d2 = dataSet2.get(0, i2);
                double d8 = d2 == d3 ? dataSet2.get(1, i2) : dataSet2.getValue(0, d3);
                d4 += d8;
                d5 += d8 * d8;
                boolean bl2 = d2 != d3;
                d6 += DataSetMath.error(dataSet2, ErrType.EYN, i2, d3, bl2);
                d7 += DataSetMath.error(dataSet2, ErrType.EYP, i2, d3, bl2);
                ++n5;
            }
            if (n5 == 0) {
                doubleErrorDataSet.add(d3, Double.NaN, Double.NaN, Double.NaN);
                continue;
            }
            d6 /= (double)n5;
            d7 /= (double)n5;
            double d9 = (d4 /= (double)n5) * d4;
            d2 = MathBase.abs((d5 /= (double)n5) - d9);
            d6 = MathBase.sqrt(d6 * d6 + d2);
            d7 = MathBase.sqrt(d7 * d7 + d2);
            doubleErrorDataSet.add(d3, d4, d6, d7);
        }
        return doubleErrorDataSet;
    }

    @SafeVarargs
    public static DataSet averageDataSetsIIR(DataSet dataSet, DataSet dataSet2, DataSet dataSet3, int n2, Formatter<Number> ... formatterArray) {
        String string = DataSetMath.getFormatter(formatterArray).format("LP({0}, IIR)", dataSet3.getName());
        if (dataSet == null || dataSet2 == null || dataSet.getDataCount() == 0 || dataSet2.getDataCount() == 0) {
            double[] dArray = dataSet3.getValues(1);
            double[] dArray2 = DataSetMath.errors(dataSet3, ErrType.EYN);
            double[] dArray3 = DataSetMath.errors(dataSet3, ErrType.EYP);
            if (dataSet2 instanceof DoubleErrorDataSet) {
                ((DoubleErrorDataSet)dataSet2).set(dataSet3.getValues(0), ArrayMath.sqr(dArray), ArrayMath.sqr(dArray2), ArrayMath.sqr(dArray3));
            } else if (dataSet2 instanceof DoubleDataSet) {
                ((DoubleDataSet)dataSet2).set(dataSet3.getValues(0), ArrayMath.sqr(dArray));
            }
            return new DoubleErrorDataSet(string, dataSet3.getValues(0), dArray, dArray2, dArray3, dataSet3.getDataCount(), true);
        }
        int n3 = dataSet.getDataCount();
        int n4 = dataSet2.getDataCount();
        DoubleErrorDataSet doubleErrorDataSet = n3 == 0 ? new DoubleErrorDataSet(string, dataSet3.getValues(0), dataSet3.getValues(1), DataSetMath.errors(dataSet3, ErrType.EYN), DataSetMath.errors(dataSet3, ErrType.EYP), dataSet3.getDataCount(), true) : new DoubleErrorDataSet(dataSet.getName(), dataSet.getValues(0), dataSet.getValues(1), DataSetMath.errors(dataSet, ErrType.EYN), DataSetMath.errors(dataSet, ErrType.EYP), dataSet3.getDataCount(), true);
        double d2 = 1.0 / (1.0 + (double)n2);
        boolean bl2 = n4 == 0;
        for (int i2 = 0; i2 < n3; ++i2) {
            double d3 = dataSet.get(0, i2);
            double d4 = dataSet.get(1, i2);
            double d5 = bl2 ? d4 * d4 : dataSet2.get(1, i2);
            double d6 = dataSet3.get(0, i2);
            boolean bl3 = d3 != d6;
            double d7 = bl3 ? dataSet3.getValue(1, d3) : dataSet3.get(1, i2);
            double d8 = (1.0 - d2) * d4 + d2 * d7;
            double d9 = (1.0 - d2) * d5 + d2 * (d7 * d7);
            double d10 = DataSetMath.error(dataSet3, ErrType.EYN, i2, d6, bl3);
            double d11 = DataSetMath.error(dataSet3, ErrType.EYP, i2, d6, bl3);
            if (dataSet2 instanceof DoubleErrorDataSet) {
                if (bl2) {
                    ((DoubleErrorDataSet)dataSet2).add(d6, d9, d10, d11);
                } else {
                    ((DoubleErrorDataSet)dataSet2).set(i2, d6, d9, d10, d11);
                }
            }
            double d12 = MathBase.sqrt(MathBase.abs(d9 - MathBase.pow(d8, 2.0)) + d10 * d10);
            double d13 = MathBase.sqrt(MathBase.abs(d9 - MathBase.pow(d8, 2.0)) + d11 * d11);
            doubleErrorDataSet.set(i2, d3, d8, d12, d13);
        }
        return doubleErrorDataSet;
    }

    @SafeVarargs
    public static DataSet dbFunction(DataSet dataSet, Formatter<Number> ... formatterArray) {
        return DataSetMath.mathFunction(dataSet, 0.0, MathOp.DB, formatterArray);
    }

    @SafeVarargs
    public static DataSet dbFunction(DataSet dataSet, DataSet dataSet2, Formatter<Number> ... formatterArray) {
        return DataSetMath.mathFunction(dataSet, dataSet2, MathOp.DB, formatterArray);
    }

    @SafeVarargs
    public static DataSet derivativeFunction(DataSet dataSet, Formatter<Number> ... formatterArray) {
        return DataSetMath.derivativeFunction(dataSet, 1.0, formatterArray);
    }

    @SafeVarargs
    public static DataSet derivativeFunction(DataSet dataSet, double d2, Formatter<Number> ... formatterArray) {
        double d3;
        int n2;
        String string = d2 == 1.0 ? "" : Double.toString(d2) + "\u00b7";
        int n3 = dataSet.getDataCount();
        String string2 = DataSetMath.getFormatter(formatterArray).format("{0}{1}({2})", string, DIFFERENTIAL, dataSet.getName());
        DoubleErrorDataSet doubleErrorDataSet = new DoubleErrorDataSet(string2, n3);
        if (n3 <= 3) {
            return doubleErrorDataSet;
        }
        for (n2 = 0; n2 < 2; ++n2) {
            d3 = dataSet.get(0, n2);
            doubleErrorDataSet.add(d3, 0.0, 0.0, 0.0);
        }
        for (n2 = 2; n2 < n3 - 2; ++n2) {
            d3 = dataSet.get(0, n2);
            double d4 = d3 - dataSet.get(0, n2 - 1);
            double d5 = dataSet.get(0, n2 + 1) - d3;
            double d6 = dataSet.get(1, n2 - 1);
            double d7 = dataSet.get(1, n2);
            double d8 = dataSet.get(1, n2 + 1);
            double d9 = DataSetMath.error(dataSet, ErrType.EYN, n2 - 1);
            double d10 = DataSetMath.error(dataSet, ErrType.EYN, n2);
            double d11 = DataSetMath.error(dataSet, ErrType.EYN, n2 + 1);
            double d12 = MathBase.sqrt(MathBase.sqr(d9) + MathBase.sqr(d10) + MathBase.sqr(d11)) / 4.0;
            double d13 = DataSetMath.error(dataSet, ErrType.EYP, n2 - 1);
            double d14 = DataSetMath.error(dataSet, ErrType.EYP, n2);
            double d15 = DataSetMath.error(dataSet, ErrType.EYP, n2 + 1);
            double d16 = MathBase.sqrt(MathBase.sqr(d13) + MathBase.sqr(d14) + MathBase.sqr(d15)) / 4.0;
            double d17 = 0.5 * ((d7 - d6) / d4 + (d8 - d7) / d5);
            doubleErrorDataSet.add(d3, d2 * d17, d12, d16);
        }
        for (n2 = n3 - 2; n2 < n3; ++n2) {
            d3 = dataSet.get(0, n2);
            doubleErrorDataSet.add(d3, 0.0, 0.0, 0.0);
        }
        return doubleErrorDataSet;
    }

    @SafeVarargs
    public static DataSet divideFunction(DataSet dataSet, DataSet dataSet2, Formatter<Number> ... formatterArray) {
        return DataSetMath.mathFunction(dataSet, dataSet2, MathOp.DIVIDE, formatterArray);
    }

    @SafeVarargs
    public static DataSet divideFunction(DataSet dataSet, double d2, Formatter<Number> ... formatterArray) {
        return DataSetMath.mathFunction(dataSet, d2, MathOp.DIVIDE, formatterArray);
    }

    public static double error(DataSet dataSet, ErrType errType, double d2) {
        return DataSetMath.error(dataSet, errType, -1, d2, true);
    }

    public static double error(DataSet dataSet, ErrType errType, int n2) {
        return DataSetMath.error(dataSet, errType, n2, 0.0, false);
    }

    public static double[] errors(DataSet dataSet, ErrType errType) {
        int n2 = dataSet.getDataCount();
        if (!(dataSet instanceof DataSetError)) {
            return new double[n2];
        }
        DataSetError dataSetError = (DataSetError)dataSet;
        switch (errType) {
            case EXN: {
                return DataSetMath.cropToLength(dataSetError.getErrorsNegative(0), n2);
            }
            case EXP: {
                return DataSetMath.cropToLength(dataSetError.getErrorsPositive(0), n2);
            }
            case EYN: {
                return DataSetMath.cropToLength(dataSetError.getErrorsNegative(1), n2);
            }
        }
        return DataSetMath.cropToLength(dataSetError.getErrorsPositive(1), n2);
    }

    @SafeVarargs
    public static DataSet filterFunction(DataSet dataSet, double d2, Filter filter, Formatter<Number> ... formatterArray) {
        Object object;
        int n2 = dataSet.getDataCount();
        String string = DataSetMath.getFormatter(formatterArray).format("{0}({1},{2})", filter.getTag(), dataSet.getName(), d2);
        DoubleErrorDataSet doubleErrorDataSet = new DoubleErrorDataSet(string, n2);
        for (int i2 = 0; i2 < doubleErrorDataSet.getDimension(); ++i2) {
            object = dataSet.getAxisDescription(i2);
            doubleErrorDataSet.getAxisDescription(i2).set(object.getName(), object.getUnit());
        }
        double[] dArray = new double[n2];
        object = new double[n2];
        double[] dArray2 = new double[n2];
        double[] dArray3 = dataSet.getValues(0);
        double[] dArray4 = dataSet.getValues(1);
        double[] dArray5 = DataSetMath.errors(dataSet, ErrType.EYN);
        double[] dArray6 = DataSetMath.errors(dataSet, ErrType.EYN);
        block9: for (int i3 = 0; i3 < n2; ++i3) {
            double d3 = dArray3[i3];
            int n3 = 0;
            for (int i4 = 0; i4 < n2; ++i4) {
                double d4 = dArray3[i4];
                if (!(MathBase.abs(d3 - d4) <= d2)) continue;
                dArray[n3] = dArray4[i4];
                object[n3] = dArray5[i4];
                dArray2[n3] = dArray6[i4];
                ++n3;
            }
            double d5 = n3 > 0 ? 1.0 / MathBase.sqrt(n3) : 0.0;
            switch (filter) {
                case MEDIAN: {
                    doubleErrorDataSet.add(d3, Math.median(dArray, n3), Math.median((double[])object, n3), Math.median(dArray2, n3));
                    continue block9;
                }
                case MIN: {
                    doubleErrorDataSet.add(d3, Math.minimum(dArray, n3), Math.minimum((double[])object, n3), Math.minimum(dArray2, n3));
                    continue block9;
                }
                case MAX: {
                    doubleErrorDataSet.add(d3, Math.maximum(dArray, n3), Math.maximum((double[])object, n3), Math.maximum(dArray2, n3));
                    continue block9;
                }
                case P2P: {
                    doubleErrorDataSet.add(d3, Math.peakToPeak(dArray, n3), Math.peakToPeak((double[])object, n3), Math.peakToPeak(dArray2, n3));
                    continue block9;
                }
                case RMS: {
                    doubleErrorDataSet.add(d3, Math.rms(dArray, n3), Math.rms((double[])object, n3), Math.rms(dArray2, n3));
                    continue block9;
                }
                case GEOMMEAN: {
                    doubleErrorDataSet.add(d3, Math.geometricMean(dArray, 0, n3), Math.geometricMean((double[])object, 0, n3), Math.geometricMean(dArray2, 0, n3));
                    continue block9;
                }
                default: {
                    doubleErrorDataSet.add(d3, Math.mean(dArray, n3), Math.mean((double[])object, n3) * d5, Math.mean(dArray2, n3) * d5);
                }
            }
        }
        return doubleErrorDataSet;
    }

    @SafeVarargs
    public static DataSet geometricMeanFilteredFunction(DataSet dataSet, double d2, Formatter<Number> ... formatterArray) {
        return DataSetMath.filterFunction(dataSet, d2, Filter.GEOMMEAN, formatterArray);
    }

    @SafeVarargs
    public static DataSet getSubRange(DataSet dataSet, double d2, double d3, Formatter<Number> ... formatterArray) {
        int n2 = dataSet.getDataCount();
        String string = DataSetMath.getFormatter(formatterArray).format("subRange({0}, {1})", d2, d3);
        DoubleErrorDataSet doubleErrorDataSet = new DoubleErrorDataSet(string, n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            double d4 = dataSet.get(0, i2);
            double d5 = dataSet.get(1, i2);
            double d6 = DataSetMath.error(dataSet, ErrType.EXP, i2);
            double d7 = DataSetMath.error(dataSet, ErrType.EYP, i2);
            if (!(d4 >= d2) || !(d4 <= d3)) continue;
            doubleErrorDataSet.add(d4, d5, d6, d7);
        }
        return doubleErrorDataSet;
    }

    @SafeVarargs
    public static DataSet iirLowPassFilterFunction(DataSet dataSet, double d2, Formatter<Number> ... formatterArray) {
        double d3;
        double d4;
        double d5;
        int n2;
        int n3 = dataSet.getDataCount();
        String string = DataSetMath.getFormatter(formatterArray).format("iir{0}({1},{2})", Filter.MEAN.getTag(), dataSet.getName(), d2);
        DoubleErrorDataSet doubleErrorDataSet = new DoubleErrorDataSet(string, n3);
        if (n3 <= 1) {
            String string2;
            int n4;
            if (!(dataSet instanceof GridDataSet)) {
                doubleErrorDataSet.set(dataSet);
                return doubleErrorDataSet;
            }
            doubleErrorDataSet.set(dataSet.getValues(0), dataSet.getValues(1), DataSetMath.errors(dataSet, ErrType.EYN), DataSetMath.errors(dataSet, ErrType.EYP));
            for (n4 = 0; n4 < dataSet.getDataCount(); ++n4) {
                string2 = dataSet.getDataLabel(n4);
                if (string2 == null || string2.isEmpty()) continue;
                doubleErrorDataSet.addDataLabel(n4, string2);
            }
            for (n4 = 0; n4 < dataSet.getDataCount(); ++n4) {
                string2 = dataSet.getStyle(n4);
                if (string2 == null || string2.isEmpty()) continue;
                doubleErrorDataSet.addDataStyle(n4, string2);
            }
            doubleErrorDataSet.setStyle(dataSet.getStyle());
            return doubleErrorDataSet;
        }
        double[] dArray = dataSet.getValues(0);
        double[] dArray2 = dataSet.getValues(1);
        double[] dArray3 = DataSetMath.errors(dataSet, ErrType.EYN);
        double[] dArray4 = DataSetMath.errors(dataSet, ErrType.EYN);
        double[] dArray5 = new double[n3];
        double[] dArray6 = new double[n3];
        double[] dArray7 = new double[n3];
        double[] dArray8 = new double[n3];
        double d6 = 0.5 * d2;
        double d7 = dArray2[0];
        double d8 = d7 * d7;
        for (n2 = 1; n2 < n3; ++n2) {
            d5 = dArray[n2 - 1];
            d4 = dArray[n2];
            d3 = dArray2[n2];
            d7 += (d4 - d5) * (d3 - d7) / d6;
            d8 += (d4 - d5) * (d3 * d3 - d8) / d6;
            dArray5[n2] = d7;
            dArray7[n2] = d8;
        }
        d7 = dArray2[n3 - 1];
        d8 = d7 * d7;
        for (n2 = n3 - 2; n2 >= 0; --n2) {
            d5 = dArray[n2];
            d4 = dArray[n2 + 1];
            d3 = dArray2[n2];
            d7 += (d4 - d5) * (d3 - d7) / d6;
            d8 += (d4 - d5) * (d3 * d3 - d8) / d6;
            dArray6[n2] = d7;
            dArray8[n2] = d8;
        }
        doubleErrorDataSet.add(dArray[0], dArray2[0], dArray3[0], dArray4[0]);
        for (n2 = 1; n2 < n3; ++n2) {
            d5 = dArray[n2];
            d4 = 0.5 * (dArray5[n2] + dArray6[n2]);
            d3 = d4 * d4;
            double d9 = 0.5 * MathBase.pow(dArray7[n2] + dArray8[n2], 1.0);
            double d10 = MathBase.abs(d9 - d3);
            double d11 = MathBase.sqrt(d10 + dArray3[n2] * dArray3[n2]);
            double d12 = MathBase.sqrt(d10 + dArray4[n2] * dArray4[n2]);
            doubleErrorDataSet.add(d5, d4, d11, d12);
        }
        return doubleErrorDataSet;
    }

    public static DoublePointError integral(DataSet dataSet) {
        DataSet dataSet2 = DataSetMath.integrateFunction(dataSet, new Formatter[0]);
        int n2 = dataSet2.getDataCount() - 1;
        if (n2 <= 0) {
            return new DoublePointError(0.0, 0.0, 0.0, 0.0);
        }
        double d2 = dataSet2.get(0, n2);
        double d3 = dataSet2.get(1, n2);
        double d4 = DataSetMath.error(dataSet2, ErrType.EYN, n2);
        double d5 = DataSetMath.error(dataSet2, ErrType.EYP, n2);
        double d6 = 0.5 * (d4 + d5);
        return new DoublePointError(d2, d3, 0.0, d6);
    }

    public static DoublePointError integral(DataSet dataSet, double d2, double d3) {
        DataSet dataSet2 = DataSetMath.integrateFunction(dataSet, d2, d3, new Formatter[0]);
        int n2 = dataSet2.getDataCount() - 1;
        double d4 = DataSetMath.error(dataSet2, ErrType.EYN, n2);
        double d5 = DataSetMath.error(dataSet2, ErrType.EYP, n2);
        double d6 = 0.5 * (d4 + d5);
        return new DoublePointError(dataSet2.get(0, n2), dataSet2.get(1, n2), 0.0, d6);
    }

    public static double integralSimple(DataSet dataSet) {
        double d2 = 0.0;
        double d3 = 0.0;
        int n2 = dataSet.getDataCount();
        if (n2 <= 1) {
            return 0.0;
        }
        for (int i2 = 1; i2 < n2; ++i2) {
            double d4 = dataSet.get(0, i2) - dataSet.get(0, i2 - 1);
            double d5 = dataSet.get(1, i2 - 1);
            double d6 = dataSet.get(1, i2);
            d2 += d4 * d5;
            d3 += d4 * d6;
        }
        return 0.5 * (d2 + d3);
    }

    @SafeVarargs
    public static DataSet integrateFunction(DataSet dataSet, Formatter<Number> ... formatterArray) {
        return DataSetMath.integrateFunction(dataSet, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, formatterArray);
    }

    @SafeVarargs
    public static DataSet integrateFunction(DataSet dataSet, double d2, double d3, Formatter<Number> ... formatterArray) {
        double d4;
        double d5;
        double d6;
        double d7;
        double d8;
        int n2 = dataSet.getDataCount();
        String string = "{0}({1})dyn|_'{'{2}'}'^'{'{3}'}'";
        String string2 = DataSetMath.getFormatter(formatterArray).format("{0}({1})dyn|_'{'{2}'}'^'{'{3}'}'", Character.valueOf('\u222b'), dataSet.getName(), d2, d3);
        if (n2 <= 0) {
            if (!(dataSet instanceof GridDataSet) || dataSet.getDimension() > 2) {
                int n3 = dataSet.getDataCount();
                double[] dArray = new double[n3];
                return new DoubleErrorDataSet(string2, dataSet.getValues(0), dArray, dArray, dArray, n3, true);
            }
            throw new IllegalStateException("not yet implemented for non 2D dataSets");
        }
        if (!dataSet.getAxisDescription(0).isDefined()) {
            dataSet.recomputeLimits(0);
        }
        double d9 = dataSet.getAxisDescription(0).getMin();
        double d10 = dataSet.getAxisDescription(0).getMax();
        double d11 = 1.0;
        if (Double.isFinite(d2) && Double.isFinite(d3)) {
            d9 = MathBase.min(d2, d3);
            d10 = MathBase.max(d2, d3);
            if (d2 > d3) {
                d11 = -1.0;
            }
        } else if (Double.isFinite(d2)) {
            d9 = d2;
        } else if (Double.isFinite(d3)) {
            d10 = d3;
        }
        DoubleErrorDataSet doubleErrorDataSet = new DoubleErrorDataSet(string2, n2);
        if (n2 <= 1) {
            doubleErrorDataSet.add(dataSet.get(0, 0), 0.0, 0.0, 0.0);
            return doubleErrorDataSet;
        }
        double d12 = 0.0;
        double d13 = 0.0;
        double d14 = 0.0;
        if (Double.isFinite(d2) && d2 <= dataSet.get(0, 0)) {
            double d15 = dataSet.getValue(1, d2);
            d8 = dataSet.get(0, 0);
            d7 = dataSet.get(1, 0);
            d6 = d8 - d2;
            d5 = DataSetMath.error(dataSet, ErrType.EYN, 0);
            d4 = DataSetMath.error(dataSet, ErrType.EYP, 0);
            d13 = MathBase.hypot(d13, d6 * d5);
            d14 = MathBase.hypot(d14, d6 * d4);
            doubleErrorDataSet.add(d2, d12 += d11 * 0.5 * d6 * (d15 + d7), 0.0, 0.0);
        }
        doubleErrorDataSet.add(dataSet.get(0, 0), d12, d13, d14);
        for (int i2 = 1; i2 < n2; ++i2) {
            double d16 = dataSet.get(0, i2 - 1);
            double d17 = dataSet.get(0, i2);
            double d18 = d17 - d16;
            double d19 = dataSet.get(1, i2 - 1);
            double d20 = DataSetMath.error(dataSet, ErrType.EYN, i2 - 1);
            double d21 = DataSetMath.error(dataSet, ErrType.EYP, i2 - 1);
            double d22 = dataSet.get(1, i2);
            double d23 = DataSetMath.error(dataSet, ErrType.EYN, i2);
            double d24 = DataSetMath.error(dataSet, ErrType.EYP, i2);
            if (d16 >= d9 && d17 <= d10) {
                d12 += d11 * 0.5 * d18 * (d19 + d22);
                d13 = MathBase.hypot(d13, 0.5 * d18 * (d20 + d23));
                d14 = MathBase.hypot(d14, 0.5 * d18 * (d21 + d24));
            } else if (!(d17 < d9) || !(d16 < d9)) {
                if (d16 < d9 && d17 > d9) {
                    doubleErrorDataSet.add(d2, d12, d13, d14);
                    d18 = d17 - d9;
                    d12 += d11 * 0.5 * d18 * (dataSet.getValue(1, d9) + d22);
                    d13 = MathBase.hypot(d13, 0.5 * d18 * (d20 + d23));
                    d14 = MathBase.hypot(d14, 0.5 * d18 * (d21 + d24));
                } else if (d16 < d10 && d17 > d10) {
                    d18 = d10 - d16;
                    double d25 = dataSet.getValue(1, d10);
                    d13 = MathBase.hypot(d13, 0.5 * d18 * (d20 + d23));
                    d14 = MathBase.hypot(d14, 0.5 * d18 * (d21 + d24));
                    doubleErrorDataSet.add(d10, d12 += d11 * 0.5 * d18 * (d19 + d25), d13, d14);
                }
            }
            doubleErrorDataSet.add(d17, d12, d13, d14);
        }
        if (Double.isFinite(d3) && d3 > dataSet.get(0, n2 - 1)) {
            double d26 = dataSet.get(0, n2 - 1);
            d8 = dataSet.get(1, n2 - 1);
            d7 = dataSet.getValue(1, d3);
            d6 = d3 - d26;
            d5 = DataSetMath.error(dataSet, ErrType.EYN, n2 - 1);
            d4 = DataSetMath.error(dataSet, ErrType.EYP, n2 - 1);
            d13 = MathBase.hypot(d13, d6 * d5);
            d14 = MathBase.hypot(d14, d6 * d4);
            doubleErrorDataSet.add(d3, d12 += 0.5 * d6 * (d8 + d7), d13, d14);
        }
        return doubleErrorDataSet;
    }

    @SafeVarargs
    public static DataSet integrateFromCentre(@NotNull DataSet dataSet, double d2, double d3, boolean bl2, Formatter<Number> ... formatterArray) {
        double d4 = dataSet.getAxisDescription(0).getMin();
        double d5 = dataSet.getAxisDescription(0).getMax();
        double d6 = Double.isFinite(d2) ? d2 : SimpleDataSetEstimators.computeCentreOfMass(dataSet, 0, dataSet.getDataCount());
        String string = "{0}({1},c={2})dyn|_'{'c-{3}'}'^'{'c+{3}'}'";
        int n2 = dataSet.getDataCount();
        String string2 = DataSetMath.getFormatter(formatterArray).format("{0}({1},c={2})dyn|_'{'c-{3}'}'^'{'c+{3}'}'", Character.valueOf('\u222b'), dataSet.getName(), d6, d3);
        if (n2 < 2) {
            if (!(dataSet instanceof GridDataSet) || dataSet.getDimension() > 2) {
                int n3 = dataSet.getDataCount();
                double[] dArray = new double[n3];
                return new DoubleErrorDataSet(string2, dataSet.getValues(0), dArray, dArray, dArray, n3, true);
            }
            throw new IllegalStateException("not yet implemented for non 2D dataSets");
        }
        DoubleErrorDataSet doubleErrorDataSet = new DoubleErrorDataSet(string2, n2 / 2);
        if (d3 <= 0.0) {
            return doubleErrorDataSet;
        }
        if (d6 <= d4 || d6 >= d5) {
            throw new IllegalArgumentException(String.format("centre %f is outside DataSetRange [%f,%f]", d6, d4, d5));
        }
        double d7 = bl2 ? 1.0 / DataSetMath.integral(dataSet, MathBase.max(d6 - d3, d4), MathBase.min(d6 + d3, d5)).getY() : 1.0;
        int n4 = dataSet.getIndex(0, d6);
        int n5 = MathBase.min(n4, dataSet.getDataCount() - 1 - n4);
        double d8 = 0.0;
        for (int i2 = 0; i2 < n5; ++i2) {
            double d9 = dataSet.get(0, n4 - i2 - 1);
            double d10 = dataSet.get(0, n4 - i2);
            double d11 = d10 - d9;
            double d12 = dataSet.get(0, n4 + i2);
            double d13 = dataSet.get(0, n4 + i2 + 1);
            double d14 = d13 - d12;
            double d15 = dataSet.get(1, n4 - i2 - 1);
            double d16 = dataSet.get(1, n4 - i2);
            double d17 = dataSet.get(1, n4 + i2);
            double d18 = dataSet.get(1, n4 + i2 + 1);
            double d19 = 0.5 * (d13 - d9);
            doubleErrorDataSet.add(d19, d8 += d7 * 0.5 * (d11 * (d15 + d16) + d14 * (d17 + d18)), 0.0, 0.0);
        }
        return doubleErrorDataSet;
    }

    public static double integralWidth(@NotNull DataSet dataSet, double d2, double d3, double d4) {
        return SimpleDataSetEstimators.getZeroCrossing(DataSetMath.integrateFromCentre(dataSet, d2, d3, true, new Formatter[0]), d4);
    }

    @SafeVarargs
    public static DataSet inversedbFunction(DataSet dataSet, Formatter<Number> ... formatterArray) {
        return DataSetMath.mathFunction(dataSet, 1.0, MathOp.INV_DB, formatterArray);
    }

    @SafeVarargs
    public static DataSet log10Function(DataSet dataSet, Formatter<Number> ... formatterArray) {
        return DataSetMath.mathFunction(dataSet, 0.0, MathOp.LOG10, formatterArray);
    }

    @SafeVarargs
    public static DataSet log10Function(DataSet dataSet, DataSet dataSet2, Formatter<Number> ... formatterArray) {
        return DataSetMath.mathFunction(dataSet, dataSet2, MathOp.LOG10, formatterArray);
    }

    @SafeVarargs
    public static DataSet lowPassFilterFunction(DataSet dataSet, double d2, Formatter<Number> ... formatterArray) {
        return DataSetMath.filterFunction(dataSet, d2, Filter.MEAN, formatterArray);
    }

    @SafeVarargs
    public static DataSet magnitudeSpectrum(DataSet dataSet, Formatter<Number> ... formatterArray) {
        return DataSetMath.magnitudeSpectrum(dataSet, Apodization.Hann, false, false, formatterArray);
    }

    @SafeVarargs
    public static DataSet magnitudeSpectrum(DataSet dataSet, Apodization apodization, boolean bl2, boolean bl3, Formatter<Number> ... formatterArray) {
        double d2;
        String string = DataSetMath.getFormatter(formatterArray).format("Mag{0}({1})", bl2 ? "[dB]" : "", dataSet.getName());
        int n2 = dataSet.getDataCount();
        if (n2 == 0) {
            return new DoubleErrorDataSet(string, 0);
        }
        DoubleFFT_1D doubleFFT_1D = new DoubleFFT_1D((long)n2);
        double[] dArray = new double[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            d2 = apodization.getIndex(i2, n2);
            dArray[i2] = dataSet.get(1, i2) * d2;
        }
        doubleFFT_1D.realForward(dArray);
        double[] dArray2 = bl2 ? SpectrumTools.computeMagnitudeSpectrum_dB(dArray, true) : SpectrumTools.computeMagnitudeSpectrum(dArray, true);
        d2 = dataSet.get(0, dataSet.getDataCount() - 1) - dataSet.get(0, 0);
        double d3 = bl3 || d2 <= 0.0 ? 0.5 / (double)dArray2.length : 1.0 / d2;
        DoubleErrorDataSet doubleErrorDataSet = new DoubleErrorDataSet(string, dArray2.length);
        for (int i3 = 0; i3 < dArray2.length; ++i3) {
            doubleErrorDataSet.add((double)i3 * d3, dArray2[i3], 0.0, 0.0);
        }
        return doubleErrorDataSet;
    }

    @SafeVarargs
    public static DataSet magnitudeSpectrumComplex(DataSet dataSet, Formatter<Number> ... formatterArray) {
        return DataSetMath.magnitudeSpectrumComplex(dataSet, Apodization.Hann, false, false, formatterArray);
    }

    @SafeVarargs
    public static DataSet magnitudeSpectrumComplex(DataSet dataSet, Apodization apodization, boolean bl2, boolean bl3, Formatter<Number> ... formatterArray) {
        double d2;
        int n2 = dataSet.getDataCount();
        DoubleFFT_1D doubleFFT_1D = new DoubleFFT_1D((long)n2);
        double[] dArray = new double[2 * n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            d2 = apodization.getIndex(i2, n2);
            dArray[2 * i2] = dataSet.get(1, i2) * d2;
            dArray[2 * i2 + 1] = dataSet.get(2, i2) * d2;
        }
        doubleFFT_1D.complexForward(dArray);
        double[] dArray2 = bl2 ? SpectrumTools.computeMagnitudeSpectrum_dB(dArray, true) : SpectrumTools.computeMagnitudeSpectrum(dArray, true);
        d2 = dataSet.get(0, dataSet.getDataCount() - 1) - dataSet.get(0, 0);
        double d3 = bl3 || d2 <= 0.0 ? 0.5 / (double)dArray2.length : 1.0 / d2;
        String string = DataSetMath.getFormatter(formatterArray).format("Mag{0}({1})", bl2 ? "[dB]" : "", dataSet.getName());
        DoubleErrorDataSet doubleErrorDataSet = new DoubleErrorDataSet(string, dArray2.length);
        for (int i3 = 0; i3 < dArray2.length; ++i3) {
            if (i3 < dArray2.length / 2) {
                doubleErrorDataSet.add(((double)i3 - (double)dArray2.length / 2.0) * d3, dArray2[i3 + dArray2.length / 2], 0.0, 0.0);
                continue;
            }
            doubleErrorDataSet.add(((double)i3 - (double)dArray2.length / 2.0) * d3, dArray2[i3 - dArray2.length / 2], 0.0, 0.0);
        }
        return doubleErrorDataSet;
    }

    public static DataSet magnitudeSpectrumDecibel(DataSet dataSet) {
        return DataSetMath.magnitudeSpectrum(dataSet, Apodization.Hann, true, false, new Formatter[0]);
    }

    public static boolean sameHorizontalBase(DataSet dataSet, DataSet dataSet2) {
        if (dataSet.getDataCount() != dataSet2.getDataCount()) {
            return false;
        }
        for (int i2 = 0; i2 < dataSet.getDataCount(); ++i2) {
            double d2;
            double d3 = dataSet.get(0, i2);
            if (d3 == (d2 = dataSet2.get(0, i2))) continue;
            return false;
        }
        return true;
    }

    @SafeVarargs
    public static DataSet mathFunction(DataSet dataSet, DataSet dataSet2, MathOp mathOp, Formatter<Number> ... formatterArray) {
        boolean bl2;
        String string = DataSetMath.getFormatter(formatterArray).format("{0}{1}{2}", dataSet.getName(), mathOp.getTag(), dataSet2.getName());
        DoubleErrorDataSet doubleErrorDataSet = new DoubleErrorDataSet(string, dataSet.getDataCount());
        doubleErrorDataSet.getAxisDescription(0).set(dataSet.getAxisDescription(0));
        doubleErrorDataSet.getAxisDescription(1).set(dataSet.getAxisDescription(1).getName(), dataSet.getAxisDescription(1).getUnit());
        boolean bl3 = bl2 = !DataSetMath.sameHorizontalBase(dataSet, dataSet2);
        if (bl2) {
            List<Double> list = DataSetMath.getCommonBase(dataSet, dataSet2);
            for (double d2 : list) {
                double d3 = dataSet.getValue(1, d2);
                double d4 = dataSet2.getValue(1, d2);
                double d5 = DataSetMath.error(dataSet, ErrType.EYN, 0, d2, bl2);
                double d6 = DataSetMath.error(dataSet, ErrType.EYP, 0, d2, bl2);
                double d7 = DataSetMath.error(dataSet2, ErrType.EYN, 0, d2, bl2);
                double d8 = DataSetMath.error(dataSet2, ErrType.EYP, 0, d2, bl2);
                DataSetMath.applyMathOperation(doubleErrorDataSet, mathOp, d2, d3, d4, d5, d6, d7, d8);
            }
            return doubleErrorDataSet;
        }
        for (int i2 = 0; i2 < dataSet.getDataCount(); ++i2) {
            double d9 = dataSet.get(0, i2);
            double d10 = dataSet.get(1, i2);
            double d11 = dataSet2.get(1, i2);
            double d12 = DataSetMath.error(dataSet, ErrType.EYN, i2);
            double d13 = DataSetMath.error(dataSet, ErrType.EYP, i2);
            double d14 = DataSetMath.error(dataSet2, ErrType.EYN, i2, d9, bl2);
            double d15 = DataSetMath.error(dataSet2, ErrType.EYP, i2, d9, bl2);
            DataSetMath.applyMathOperation(doubleErrorDataSet, mathOp, d9, d10, d11, d12, d13, d14, d15);
        }
        return doubleErrorDataSet;
    }

    public static List<Double> getCommonBase(DataSet ... dataSetArray) {
        NoDuplicatesList<Double> noDuplicatesList = new NoDuplicatesList<Double>();
        for (DataSet dataSet : dataSetArray) {
            for (int i2 = 0; i2 < dataSet.getDataCount(); ++i2) {
                if (dataSet instanceof Histogram) {
                    noDuplicatesList.add(((Histogram)dataSet).getBinLimits(0, Histogram.Boundary.LOWER, i2));
                    noDuplicatesList.add(((Histogram)dataSet).getBinCenter(0, i2));
                    noDuplicatesList.add(((Histogram)dataSet).getBinLimits(0, Histogram.Boundary.UPPER, i2));
                    continue;
                }
                noDuplicatesList.add(dataSet.get(0, i2));
            }
        }
        Collections.sort(noDuplicatesList);
        return noDuplicatesList;
    }

    @SafeVarargs
    public static DataSet mathFunction(DataSet dataSet, double d2, MathOp mathOp, Formatter<Number> ... formatterArray) {
        String string = DataSetMath.getFormatter(formatterArray).format("{0}({1})", mathOp.getTag(), dataSet.getName());
        double[] dArray = dataSet.getValues(1);
        double[] dArray2 = Arrays.copyOf(DataSetMath.errors(dataSet, ErrType.EYN), dArray.length);
        double[] dArray3 = Arrays.copyOf(DataSetMath.errors(dataSet, ErrType.EYP), dArray.length);
        int n2 = dataSet.getDataCount();
        switch (mathOp) {
            case ADD: {
                return new DoubleErrorDataSet(string, dataSet.getValues(0), ArrayMath.add(dArray, d2), dArray2, dArray3, n2, true);
            }
            case SUBTRACT: {
                return new DoubleErrorDataSet(string, dataSet.getValues(0), ArrayMath.subtract(dArray, d2), dArray2, dArray3, n2, true);
            }
            case MULTIPLY: {
                return new DoubleErrorDataSet(string, dataSet.getValues(0), ArrayMath.multiply(dArray, d2), ArrayMath.multiply(dArray2, d2), ArrayMath.multiply(dArray3, d2), n2, true);
            }
            case DIVIDE: {
                return new DoubleErrorDataSet(string, dataSet.getValues(0), ArrayMath.divide(dArray, d2), ArrayMath.divide(dArray2, d2), ArrayMath.divide(dArray3, d2), n2, true);
            }
            case SQR: {
                for (int i2 = 0; i2 < dArray2.length; ++i2) {
                    dArray2[i2] = 2.0 * MathBase.abs(dArray[i2] + d2) * dArray2[i2];
                    dArray3[i2] = 2.0 * MathBase.abs(dArray[i2] + d2) * dArray3[i2];
                }
                return new DoubleErrorDataSet(string, dataSet.getValues(0), d2 == 0.0 ? ArrayMath.sqr(dArray) : ArrayMath.sqr(ArrayMath.add(dArray, d2)), dArray2, dArray3, n2, true);
            }
            case SQRT: {
                for (int i3 = 0; i3 < dArray2.length; ++i3) {
                    dArray2[i3] = MathBase.sqrt(MathBase.abs(dArray[i3] + d2)) * dArray2[i3];
                    dArray3[i3] = MathBase.sqrt(MathBase.abs(dArray[i3] + d2)) * dArray3[i3];
                }
                return new DoubleErrorDataSet(string, dataSet.getValues(0), d2 == 0.0 ? ArrayMath.sqrt(dArray) : ArrayMath.sqrt(ArrayMath.add(dArray, d2)), dArray2, dArray3, n2, true);
            }
            case LOG10: {
                for (int i4 = 0; i4 < dArray2.length; ++i4) {
                    dArray2[i4] = 0.0;
                    dArray3[i4] = 0.0;
                }
                return new DoubleErrorDataSet(string, dataSet.getValues(0), ArrayMath.tenLog10(dArray), dArray2, dArray3, n2, true);
            }
            case DB: {
                for (int i5 = 0; i5 < dArray2.length; ++i5) {
                    dArray2[i5] = 0.0;
                    dArray3[i5] = 0.0;
                }
                return new DoubleErrorDataSet(string, dataSet.getValues(0), ArrayMath.decibel(dArray), dArray2, dArray3, n2, true);
            }
            case INV_DB: {
                for (int i6 = 0; i6 < dArray2.length; ++i6) {
                    dArray2[i6] = 0.0;
                    dArray3[i6] = 0.0;
                }
                return new DoubleErrorDataSet(string, dataSet.getValues(0), ArrayMath.inverseDecibel(dArray), dArray2, dArray3, n2, true);
            }
        }
        return new DoubleErrorDataSet(string, dataSet.getValues(0), dataSet.getValues(1), DataSetMath.errors(dataSet, ErrType.EYN), DataSetMath.errors(dataSet, ErrType.EYP), n2, true);
    }

    @SafeVarargs
    public static DataSet maxFilteredFunction(DataSet dataSet, double d2, Formatter<Number> ... formatterArray) {
        return DataSetMath.filterFunction(dataSet, d2, Filter.MAX, formatterArray);
    }

    @SafeVarargs
    public static DataSet medianFilteredFunction(DataSet dataSet, double d2, Formatter<Number> ... formatterArray) {
        return DataSetMath.filterFunction(dataSet, d2, Filter.MEDIAN, formatterArray);
    }

    @SafeVarargs
    public static DataSet minFilteredFunction(DataSet dataSet, double d2, Formatter<Number> ... formatterArray) {
        return DataSetMath.filterFunction(dataSet, d2, Filter.MIN, formatterArray);
    }

    @SafeVarargs
    public static DataSet multiplyFunction(DataSet dataSet, DataSet dataSet2, Formatter<Number> ... formatterArray) {
        return DataSetMath.mathFunction(dataSet, dataSet2, MathOp.MULTIPLY, formatterArray);
    }

    @SafeVarargs
    public static DataSet multiplyFunction(DataSet dataSet, double d2, Formatter<Number> ... formatterArray) {
        return DataSetMath.mathFunction(dataSet, d2, MathOp.MULTIPLY, formatterArray);
    }

    @SafeVarargs
    public static DataSet normalisedFunction(DataSet dataSet, Formatter<Number> ... formatterArray) {
        return DataSetMath.normalisedFunction(dataSet, 1.0, formatterArray);
    }

    @SafeVarargs
    public static DataSet normalisedFunction(DataSet dataSet, double d2, Formatter<Number> ... formatterArray) {
        DoublePointError doublePointError = DataSetMath.integral(dataSet);
        double d3 = doublePointError.getY() / d2;
        int n2 = dataSet.getDataCount();
        String string = DataSetMath.getFormatter(formatterArray).format("{0}", dataSet.getName());
        if (d3 == 0.0) {
            return new DoubleErrorDataSet(string, dataSet.getValues(0), new double[n2], new double[n2], new double[n2], n2, true);
        }
        double[] dArray = dataSet.getValues(0);
        double[] dArray2 = ArrayMath.divide(dataSet.getValues(1), d3);
        double[] dArray3 = ArrayMath.divide(DataSetMath.errors(dataSet, ErrType.EYN), d3);
        double[] dArray4 = ArrayMath.divide(DataSetMath.errors(dataSet, ErrType.EYP), d3);
        return new DoubleErrorDataSet(string, dArray, dArray2, dArray3, dArray4, n2, true);
    }

    @SafeVarargs
    public static DataSet normalisedMagnitudeSpectrumDecibel(DataSet dataSet, Formatter<Number> ... formatterArray) {
        return DataSetMath.magnitudeSpectrum(dataSet, Apodization.Hann, true, true, formatterArray);
    }

    @SafeVarargs
    public static DataSet peakToPeakFilteredFunction(DataSet dataSet, double d2, Formatter<Number> ... formatterArray) {
        return DataSetMath.filterFunction(dataSet, d2, Filter.P2P, formatterArray);
    }

    @SafeVarargs
    public static DataSet rmsFilteredFunction(DataSet dataSet, double d2, Formatter<Number> ... formatterArray) {
        return DataSetMath.filterFunction(dataSet, d2, Filter.RMS, formatterArray);
    }

    public static EditableDataSet setFunction(EditableDataSet editableDataSet, double d2, double d3, double d4) {
        int n2 = editableDataSet.getDataCount();
        double d5 = editableDataSet.get(0, 0);
        double d6 = editableDataSet.get(0, n2 - 1);
        if (Double.isFinite(d3) && Double.isFinite(d4)) {
            d5 = MathBase.min(d3, d4);
            d6 = MathBase.max(d3, d4);
        } else if (Double.isFinite(d3)) {
            d5 = d3;
        } else if (Double.isFinite(d4)) {
            d6 = d4;
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            double d7 = editableDataSet.get(0, i2);
            if (!(d7 >= d5) || !(d7 <= d6)) continue;
            editableDataSet.set(i2, d7, d2);
        }
        return editableDataSet;
    }

    @SafeVarargs
    public static DataSet sqrFunction(DataSet dataSet, double d2, Formatter<Number> ... formatterArray) {
        return DataSetMath.mathFunction(dataSet, d2, MathOp.SQR, formatterArray);
    }

    @SafeVarargs
    public static DataSet sqrFunction(DataSet dataSet, DataSet dataSet2, Formatter<Number> ... formatterArray) {
        return DataSetMath.mathFunction(dataSet, dataSet2, MathOp.SQR, formatterArray);
    }

    @SafeVarargs
    public static DataSet sqrtFunction(DataSet dataSet, double d2, Formatter<Number> ... formatterArray) {
        return DataSetMath.mathFunction(dataSet, d2, MathOp.SQRT, formatterArray);
    }

    @SafeVarargs
    public static DataSet sqrtFunction(DataSet dataSet, DataSet dataSet2, Formatter<Number> ... formatterArray) {
        return DataSetMath.mathFunction(dataSet, dataSet2, MathOp.SQRT, formatterArray);
    }

    @SafeVarargs
    public static DataSet subtractFunction(DataSet dataSet, DataSet dataSet2, Formatter<Number> ... formatterArray) {
        return DataSetMath.mathFunction(dataSet, dataSet2, MathOp.SUBTRACT, formatterArray);
    }

    @SafeVarargs
    public static DataSet subtractFunction(DataSet dataSet, double d2, Formatter<Number> ... formatterArray) {
        return DataSetMath.mathFunction(dataSet, d2, MathOp.SUBTRACT, formatterArray);
    }

    @SafeVarargs
    private static Formatter<Number> getFormatter(Formatter<Number> ... formatterArray) {
        return Objects.requireNonNull(formatterArray, "user-supplied format").length > 0 ? formatterArray[0] : DEFAULT_FORMATTER;
    }

    private static double[] cropToLength(double[] dArray, int n2) {
        if (dArray.length == n2) {
            return dArray;
        }
        return Arrays.copyOf(dArray, n2);
    }

    public static enum MathOp {
        ADD("+"),
        SUBTRACT("-"),
        MULTIPLY("*"),
        DIVIDE("*"),
        SQR("SQR"),
        SQRT("SQRT"),
        LOG10("Log10"),
        DB("dB"),
        INV_DB("dB^{-1}"),
        IDENTITY("Copy");

        private final String tag;

        private MathOp(String string2) {
            this.tag = string2;
        }

        public String getTag() {
            return this.tag;
        }
    }

    public static enum ErrType {
        EXN,
        EXP,
        EYN,
        EYP;

    }

    public static enum Filter {
        MEAN("LowPass"),
        MEDIAN("Median"),
        MIN("Min"),
        MAX("Max"),
        P2P("PeakToPeak"),
        RMS("RMS"),
        GEOMMEAN("GeometricMean");

        private final String tag;

        private Filter(String string2) {
            this.tag = string2;
        }

        public String getTag() {
            return this.tag;
        }
    }
}

