/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.math;

import io.fair_acc.dataset.utils.AssertUtils;
import io.fair_acc.math.Math;
import java.util.Arrays;
import java.util.function.IntFunction;
import java.util.function.ToIntFunction;

public final class ArrayUtils {
    private static final String ARRAY = "array";

    private ArrayUtils() {
    }

    public static double[] convertToDouble(boolean[] blArray) {
        double[] dArray = new double[blArray.length];
        for (int i2 = 0; i2 < blArray.length; ++i2) {
            dArray[i2] = blArray[i2] ? 1.0 : 0.0;
        }
        return dArray;
    }

    public static double[] convertToDouble(boolean[] blArray, double d2) {
        double[] dArray = new double[blArray.length];
        for (int i2 = 0; i2 < blArray.length; ++i2) {
            dArray[i2] = d2 * (blArray[i2] ? 1.0 : 0.0);
        }
        return dArray;
    }

    public static double[] convertToDouble(byte[] byArray) {
        double[] dArray = new double[byArray.length];
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            dArray[i2] = byArray[i2];
        }
        return dArray;
    }

    public static double[] convertToDouble(byte[] byArray, double d2) {
        double[] dArray = new double[byArray.length];
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            dArray[i2] = d2 * (double)byArray[i2];
        }
        return dArray;
    }

    public static double[] convertToDouble(float[] fArray) {
        double[] dArray = new double[fArray.length];
        for (int i2 = 0; i2 < fArray.length; ++i2) {
            dArray[i2] = fArray[i2];
        }
        return dArray;
    }

    public static double[] convertToDouble(float[] fArray, double d2) {
        double[] dArray = new double[fArray.length];
        for (int i2 = 0; i2 < fArray.length; ++i2) {
            dArray[i2] = (double)fArray[i2] * d2;
        }
        return dArray;
    }

    public static double[] convertToDouble(int[] nArray) {
        double[] dArray = new double[nArray.length];
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            dArray[i2] = nArray[i2];
        }
        return dArray;
    }

    public static double[] convertToDouble(int[] nArray, double d2) {
        double[] dArray = new double[nArray.length];
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            dArray[i2] = (double)nArray[i2] * d2;
        }
        return dArray;
    }

    public static double[] convertToDouble(long[] lArray) {
        double[] dArray = new double[lArray.length];
        for (int i2 = 0; i2 < lArray.length; ++i2) {
            dArray[i2] = lArray[i2];
        }
        return dArray;
    }

    public static double[] convertToDouble(long[] lArray, double d2) {
        double[] dArray = new double[lArray.length];
        for (int i2 = 0; i2 < lArray.length; ++i2) {
            dArray[i2] = (double)lArray[i2] * d2;
        }
        return dArray;
    }

    public static double[] convertToDouble(short[] sArray) {
        double[] dArray = new double[sArray.length];
        for (int i2 = 0; i2 < sArray.length; ++i2) {
            dArray[i2] = sArray[i2];
        }
        return dArray;
    }

    public static double[] convertToDouble(short[] sArray, double d2) {
        double[] dArray = new double[sArray.length];
        for (int i2 = 0; i2 < sArray.length; ++i2) {
            dArray[i2] = (double)sArray[i2] * d2;
        }
        return dArray;
    }

    public static double[] createArray(double d2, double d3, int n2) {
        double[] dArray = new double[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            dArray[i2] = (double)i2 * d3 + d2;
        }
        return dArray;
    }

    public static void fillArray(boolean[] blArray, boolean bl2) {
        AssertUtils.notNull(ARRAY, blArray);
        int n2 = blArray.length;
        if (n2 > 0) {
            blArray[0] = bl2;
        }
        for (int i2 = 1; i2 < n2; i2 += i2) {
            System.arraycopy(blArray, 0, blArray, i2, n2 - i2 < i2 ? n2 - i2 : i2);
        }
    }

    public static void fillArray(byte[] byArray, byte by2) {
        AssertUtils.notNull(ARRAY, byArray);
        int n2 = byArray.length;
        if (n2 > 0) {
            byArray[0] = by2;
        }
        for (int i2 = 1; i2 < n2; i2 += i2) {
            System.arraycopy(byArray, 0, byArray, i2, n2 - i2 < i2 ? n2 - i2 : i2);
        }
    }

    public static void fillArray(double[] dArray, double d2) {
        AssertUtils.notNull(ARRAY, dArray);
        int n2 = dArray.length;
        ArrayUtils.fillArray(dArray, 0, n2, d2);
    }

    public static void fillArray(double[] dArray, int n2, int n3, double d2) {
        AssertUtils.notNull(ARRAY, dArray);
        int n4 = n3 - n2;
        if (n4 > 0) {
            dArray[n2] = d2;
        }
        for (int i2 = 1; i2 < n4; i2 <<= 1) {
            System.arraycopy(dArray, n2, dArray, n2 + i2, n4 - i2 < i2 ? n4 - i2 : i2);
        }
    }

    public static void fillArray(float[] fArray, float f2) {
        AssertUtils.notNull(ARRAY, fArray);
        int n2 = fArray.length;
        ArrayUtils.fillArray(fArray, 0, n2, f2);
    }

    public static void fillArray(float[] fArray, int n2, int n3, float f2) {
        AssertUtils.notNull(ARRAY, fArray);
        int n4 = n3 - n2;
        if (n4 > 0) {
            fArray[n2] = f2;
        }
        for (int i2 = 1; i2 < n4; i2 += i2) {
            System.arraycopy(fArray, n2, fArray, i2, n4 - i2 < i2 ? n4 - i2 : i2);
        }
    }

    public static void fillArray(int[] nArray, int n2) {
        AssertUtils.notNull(ARRAY, nArray);
        int n3 = nArray.length;
        if (n3 > 0) {
            nArray[0] = n2;
        }
        for (int i2 = 1; i2 < n3; i2 += i2) {
            System.arraycopy(nArray, 0, nArray, i2, n3 - i2 < i2 ? n3 - i2 : i2);
        }
    }

    public static void fillArray(long[] lArray, long l2) {
        AssertUtils.notNull(ARRAY, lArray);
        int n2 = lArray.length;
        if (n2 > 0) {
            lArray[0] = l2;
        }
        for (int i2 = 1; i2 < n2; i2 += i2) {
            System.arraycopy(lArray, 0, lArray, i2, n2 - i2 < i2 ? n2 - i2 : i2);
        }
    }

    public static void fillArray(short[] sArray, short s2) {
        AssertUtils.notNull(ARRAY, sArray);
        int n2 = sArray.length;
        if (n2 > 0) {
            sArray[0] = s2;
        }
        for (int i2 = 1; i2 < n2; i2 += i2) {
            System.arraycopy(sArray, 0, sArray, i2, n2 - i2 < i2 ? n2 - i2 : i2);
        }
    }

    public static <T> void fillArray(T[] TArray, int n2, int n3, T t2) {
        AssertUtils.notNull(ARRAY, TArray);
        int n4 = n3 - n2;
        if (n4 > 0) {
            TArray[n2] = t2;
        }
        for (int i2 = 1; i2 < n4; i2 += i2) {
            System.arraycopy(TArray, n2, TArray, i2, n4 - i2 < i2 ? n4 - i2 : i2);
        }
    }

    public static <T> void fillArray(T[] TArray, T t2) {
        AssertUtils.notNull(ARRAY, TArray);
        int n2 = TArray.length;
        ArrayUtils.fillArray(TArray, 0, n2, t2);
    }

    public static boolean[] resizeMin(boolean[] blArray2, int n2) {
        if (blArray2 != null && blArray2.length >= n2) {
            return blArray2;
        }
        return new boolean[ArrayUtils.growSize(n2, blArray2, blArray -> ((boolean[])blArray).length)];
    }

    public static double[] resizeMin(double[] dArray2, int n2) {
        if (dArray2 != null && dArray2.length >= n2) {
            return dArray2;
        }
        return new double[ArrayUtils.growSize(n2, dArray2, dArray -> ((double[])dArray).length)];
    }

    public static double[] resizeMin(double[] dArray2, int n2, boolean bl2) {
        if (dArray2 != null && dArray2.length >= n2) {
            return dArray2;
        }
        int n3 = ArrayUtils.growSize(n2, dArray2, dArray -> ((double[])dArray).length);
        if (!bl2 || dArray2 == null) {
            return new double[n3];
        }
        return Arrays.copyOfRange(dArray2, 0, n3);
    }

    public static int[] resizeMin(int[] nArray2, int n2) {
        if (nArray2 != null && nArray2.length >= n2) {
            return nArray2;
        }
        return new int[ArrayUtils.growSize(n2, nArray2, nArray -> ((int[])nArray).length)];
    }

    public static <T> T[] resizeMinNulled(T[] TArray, int n2, IntFunction<T[]> intFunction) {
        return ArrayUtils.resizeMin(TArray, n2, intFunction, true);
    }

    public static <T> T[] resizeMin(T[] TArray, int n2, IntFunction<T[]> intFunction, boolean bl2) {
        if (TArray != null && TArray.length >= n2) {
            if (bl2) {
                Arrays.fill(TArray, 0, n2, null);
            }
            return TArray;
        }
        return intFunction.apply(ArrayUtils.growSize(n2, TArray, objectArray -> ((Object[])objectArray).length));
    }

    private static <T> int growSize(int n2, T t2, ToIntFunction<T> toIntFunction) {
        int n3 = t2 == null ? 0 : toIntFunction.applyAsInt(t2);
        int n4 = Math.max(n3 + 200, (int)((double)n3 * 1.2));
        return Math.max(n2, n4);
    }

    public static boolean[] clearIfLarger(boolean[] blArray, int n2) {
        return (boolean[])(blArray != null && blArray.length > n2 ? null : blArray);
    }

    public static double[] clearIfLarger(double[] dArray, int n2) {
        return (double[])(dArray != null && dArray.length > n2 ? null : dArray);
    }

    public static <T> T[] clearIfLarger(T[] TArray, int n2) {
        return TArray != null && TArray.length > n2 ? null : TArray;
    }
}

