/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.dataset.utils.trees;

import io.fair_acc.dataset.utils.trees.IndexedNavigableMap;
import io.fair_acc.dataset.utils.trees.IndexedNavigableSet;
import io.fair_acc.dataset.utils.trees.IndexedTreeMap;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.Objects;
import java.util.SortedSet;

public class IndexedTreeSet<E>
extends AbstractSet<E>
implements IndexedNavigableSet<E>,
Cloneable,
Serializable {
    private static final Object PRESENT = new Object();
    private static final long serialVersionUID = -2479143000061671589L;
    private transient NavigableMap<E, Object> m;

    public IndexedTreeSet() {
        this(new IndexedTreeMap());
    }

    public IndexedTreeSet(Collection<? extends E> collection) {
        this();
        this.addAll(collection);
    }

    public IndexedTreeSet(Comparator<? super E> comparator) {
        this(new IndexedTreeMap(comparator));
    }

    IndexedTreeSet(NavigableMap<E, Object> navigableMap) {
        if (!(navigableMap instanceof IndexedTreeMap)) {
            throw new IllegalArgumentException("Map should implement IndexedTreeMap");
        }
        this.m = navigableMap;
    }

    public IndexedTreeSet(SortedSet<E> sortedSet) {
        this(sortedSet.comparator());
        this.addAll(sortedSet);
    }

    @Override
    public boolean add(E e2) {
        return this.m.put(e2, PRESENT) == null;
    }

    @Override
    public boolean addAll(Collection<? extends E> collection) {
        if (this.m.isEmpty() && !collection.isEmpty() && collection instanceof SortedSet && this.m instanceof IndexedTreeMap) {
            Comparator comparator;
            SortedSet sortedSet = (SortedSet)collection;
            IndexedTreeMap indexedTreeMap = (IndexedTreeMap)this.m;
            Comparator comparator2 = sortedSet.comparator();
            if (Objects.equals(comparator2, comparator = indexedTreeMap.comparator())) {
                indexedTreeMap.addAllForTreeSet(sortedSet, PRESENT);
                return true;
            }
        }
        return super.addAll(collection);
    }

    @Override
    public E ceiling(E e2) {
        return this.m.ceilingKey(e2);
    }

    @Override
    public void clear() {
        this.m.clear();
    }

    public Object clone() {
        IndexedTreeSet indexedTreeSet = null;
        try {
            indexedTreeSet = (IndexedTreeSet)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
        indexedTreeSet.m = new IndexedTreeMap<E, Object>(this.m);
        return indexedTreeSet;
    }

    @Override
    public Comparator<? super E> comparator() {
        return this.m.comparator();
    }

    @Override
    public boolean contains(Object object) {
        return this.m.containsKey(object);
    }

    public void debug() throws Exception {
        IndexedTreeMap.Entry entry = ((IndexedTreeMap)this.m).getFirstEntry();
        while (entry != null) {
            if (entry.weight != entry.sumup()) {
                throw new IllegalStateException("Weight is incorrect:" + entry.weight + "!=" + entry.sumup() + " for " + entry.key);
            }
            entry = IndexedTreeMap.successor(entry);
        }
    }

    @Override
    public Iterator<E> descendingIterator() {
        return this.m.descendingKeySet().iterator();
    }

    @Override
    public NavigableSet<E> descendingSet() {
        return new IndexedTreeSet<E>(this.m.descendingMap());
    }

    @Override
    public E first() {
        return (E)this.m.firstKey();
    }

    @Override
    public E floor(E e2) {
        return this.m.floorKey(e2);
    }

    @Override
    public E get(int n2) {
        Map.Entry entry = ((IndexedNavigableMap)this.m).exactEntry(n2);
        return entry == null ? null : (E)entry.getKey();
    }

    @Override
    public int getIndex(E e2) {
        return ((IndexedNavigableMap)this.m).keyIndex(e2);
    }

    @Override
    public SortedSet<E> headSet(E e2) {
        return this.headSet(e2, false);
    }

    @Override
    public NavigableSet<E> headSet(E e2, boolean bl2) {
        return new IndexedTreeSet<E>(this.m.headMap(e2, bl2));
    }

    @Override
    public E higher(E e2) {
        return this.m.higherKey(e2);
    }

    @Override
    public boolean isEmpty() {
        return this.m.isEmpty();
    }

    @Override
    public Iterator<E> iterator() {
        return this.m.navigableKeySet().iterator();
    }

    @Override
    public E last() {
        return (E)this.m.lastKey();
    }

    @Override
    public E lower(E e2) {
        return this.m.lowerKey(e2);
    }

    @Override
    public E pollFirst() {
        Map.Entry<E, Object> entry = this.m.pollFirstEntry();
        return entry == null ? null : (E)entry.getKey();
    }

    @Override
    public E pollLast() {
        Map.Entry<E, Object> entry = this.m.pollLastEntry();
        return entry == null ? null : (E)entry.getKey();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        Comparator comparator = (Comparator)objectInputStream.readObject();
        IndexedTreeMap<Object, Object> indexedTreeMap = comparator == null ? new IndexedTreeMap<E, Object>() : new IndexedTreeMap(comparator);
        this.m = indexedTreeMap;
        int n2 = objectInputStream.readInt();
        indexedTreeMap.readTreeSet(n2, objectInputStream, PRESENT);
    }

    @Override
    public boolean remove(Object object) {
        return this.m.remove(object) == PRESENT;
    }

    @Override
    public int size() {
        return this.m.size();
    }

    @Override
    public NavigableSet<E> subSet(E e2, boolean bl2, E e3, boolean bl3) {
        return new IndexedTreeSet<E>(this.m.subMap(e2, bl2, e3, bl3));
    }

    @Override
    public SortedSet<E> subSet(E e2, E e3) {
        return this.subSet(e2, true, e3, false);
    }

    @Override
    public SortedSet<E> tailSet(E e2) {
        return this.tailSet(e2, true);
    }

    @Override
    public NavigableSet<E> tailSet(E e2, boolean bl2) {
        return new IndexedTreeSet<E>(this.m.tailMap(e2, bl2));
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeObject(this.m.comparator());
        objectOutputStream.writeInt(this.m.size());
        for (Object k2 : this.m.keySet()) {
            objectOutputStream.writeObject(k2);
        }
    }
}

