/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.dataset.utils;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamUtils {
    private static final Logger logger = LoggerFactory.getLogger(StreamUtils.class);
    public static final String CLASSPATH_PREFIX = "classpath:";
    public static final String ZIP_PREFIX = "zip:";

    public static InputStream getInputStream(String string) throws FileNotFoundException {
        InputStream inputStream;
        block12: {
            if (string.startsWith(CLASSPATH_PREFIX)) {
                String string2 = string.substring(CLASSPATH_PREFIX.length());
                inputStream = StreamUtils.class.getClassLoader().getResourceAsStream(string2);
            } else {
                if (string.startsWith(ZIP_PREFIX)) {
                    int n2;
                    String string3 = string.substring(ZIP_PREFIX.length());
                    String string4 = string3.substring(n2 = string3.toLowerCase().indexOf(".zip") + 4);
                    if (string4.startsWith("/")) {
                        string4 = string4.substring(1);
                    }
                    string3 = string3.substring(0, n2);
                    try (ZipFile zipFile = new ZipFile(string3);){
                        inputStream = zipFile.getInputStream(zipFile.getEntry(string4));
                        break block12;
                    }
                    catch (IOException iOException) {
                        throw new FileNotFoundException("Zip resource not found for " + string + " IOException=" + iOException.getMessage());
                    }
                }
                inputStream = new FileInputStream(string);
            }
        }
        if (inputStream == null) {
            logger.error("The resource is not found: " + string);
        }
        return inputStream;
    }
}

