/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.dataset.utils;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.Spliterator;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;

public class SoftKeyHashMap<K, V>
extends AbstractMap<K, V>
implements Map<K, V> {
    private static final int DEFAULT_INITIAL_CAPACITY = 16;
    private static final int MAXIMUM_CAPACITY = 0x40000000;
    private static final float DEFAULT_LOAD_FACTOR = 0.75f;
    private static final Object NULL_KEY = new Object();
    Entry<K, V>[] table;
    private int size;
    private int threshold;
    private final float loadFactor;
    private final ReferenceQueue<Object> queue = new ReferenceQueue();
    int modCount;
    private transient Set<Map.Entry<K, V>> entrySet;

    public SoftKeyHashMap() {
        this(16, 0.75f);
    }

    public SoftKeyHashMap(int n2) {
        this(n2, 0.75f);
    }

    public SoftKeyHashMap(int n2, float f2) {
        int n3;
        if (n2 < 0) {
            throw new IllegalArgumentException("Illegal Initial Capacity: " + n2);
        }
        if (n2 > 0x40000000) {
            n2 = 0x40000000;
        }
        if (f2 <= 0.0f || Float.isNaN(f2)) {
            throw new IllegalArgumentException("Illegal Load factor: " + f2);
        }
        for (n3 = 1; n3 < n2; n3 <<= 1) {
        }
        this.table = this.newTable(n3);
        this.loadFactor = f2;
        this.threshold = (int)((float)n3 * f2);
    }

    public SoftKeyHashMap(Map<? extends K, ? extends V> map) {
        this(Math.max((int)((float)map.size() / 0.75f) + 1, 16), 0.75f);
        this.putAll(map);
    }

    @Override
    public void clear() {
        while (this.queue.poll() != null) {
        }
        ++this.modCount;
        Arrays.fill(this.table, null);
        this.size = 0;
        while (this.queue.poll() != null) {
        }
    }

    @Override
    public boolean containsKey(Object object) {
        return this.getEntry(object) != null;
    }

    @Override
    public boolean containsValue(Object object) {
        if (object == null) {
            return this.containsNullValue();
        }
        Entry<K, V>[] entryArray = this.getTable();
        int n2 = entryArray.length;
        while (n2-- > 0) {
            Entry<K, V> entry = entryArray[n2];
            while (entry != null) {
                if (object.equals(entry.value)) {
                    return true;
                }
                entry = entry.next;
            }
        }
        return false;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        EntrySet entrySet = this.entrySet;
        return entrySet != null ? entrySet : (this.entrySet = new EntrySet());
    }

    @Override
    public void forEach(BiConsumer<? super K, ? super V> biConsumer) {
        Entry<K, V>[] entryArray;
        Objects.requireNonNull(biConsumer);
        int n2 = this.modCount;
        for (Entry<K, V> entry : entryArray = this.getTable()) {
            while (entry != null) {
                Object t2 = entry.get();
                if (t2 != null) {
                    biConsumer.accept(SoftKeyHashMap.unmaskNull(t2), entry.value);
                }
                entry = entry.next;
                if (n2 == this.modCount) continue;
                throw new ConcurrentModificationException();
            }
        }
    }

    @Override
    public V get(Object object) {
        Object object2 = SoftKeyHashMap.maskNull(object);
        int n2 = this.hash(object2);
        Entry<K, V>[] entryArray = this.getTable();
        int n3 = SoftKeyHashMap.indexFor(n2, entryArray.length);
        Entry<K, V> entry = entryArray[n3];
        while (entry != null) {
            if (entry.hash == n2 && SoftKeyHashMap.eq(object2, entry.get())) {
                return entry.value;
            }
            entry = entry.next;
        }
        return null;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public V put(K k2, V v2) {
        if (k2 == null || v2 == null) {
            throw new NullPointerException();
        }
        Object object = SoftKeyHashMap.maskNull(k2);
        int n2 = this.hash(object);
        Entry<K, V>[] entryArray = this.getTable();
        int n3 = SoftKeyHashMap.indexFor(n2, entryArray.length);
        Entry<K, V> entry = entryArray[n3];
        while (entry != null) {
            if (n2 == entry.hash && SoftKeyHashMap.eq(object, entry.get())) {
                Object v3 = entry.value;
                if (v2 != v3) {
                    entry.value = v2;
                }
                return v3;
            }
            entry = entry.next;
        }
        ++this.modCount;
        entry = entryArray[n3];
        entryArray[n3] = new Entry<K, V>(object, v2, this.queue, n2, entry);
        if (++this.size >= this.threshold) {
            this.resize(entryArray.length * 2);
        }
        return null;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        if (map == null) {
            return;
        }
        int n2 = map.size();
        if (n2 == 0) {
            return;
        }
        if (n2 > this.threshold) {
            int n3;
            int n4 = (int)((float)n2 / this.loadFactor + 1.0f);
            if (n4 > 0x40000000) {
                n4 = 0x40000000;
            }
            for (n3 = this.table.length; n3 < n4; n3 <<= 1) {
            }
            if (n3 > this.table.length) {
                this.resize(n3);
            }
        }
        for (Map.Entry<K, V> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public V remove(Object object) {
        Entry<K, V> entry;
        Object object2 = SoftKeyHashMap.maskNull(object);
        int n2 = this.hash(object2);
        Entry<K, V>[] entryArray = this.getTable();
        int n3 = SoftKeyHashMap.indexFor(n2, entryArray.length);
        Entry<K, V> entry2 = entry = entryArray[n3];
        while (entry2 != null) {
            Entry entry3 = entry2.next;
            if (n2 == entry2.hash && SoftKeyHashMap.eq(object2, entry2.get())) {
                ++this.modCount;
                --this.size;
                if (entry == entry2) {
                    entryArray[n3] = entry3;
                } else {
                    entry.next = entry3;
                }
                return entry2.value;
            }
            entry = entry2;
            entry2 = entry3;
        }
        return null;
    }

    @Override
    public void replaceAll(BiFunction<? super K, ? super V, ? extends V> biFunction) {
        Entry<K, V>[] entryArray;
        Objects.requireNonNull(biFunction);
        int n2 = this.modCount;
        for (Entry<K, V> entry : entryArray = this.getTable()) {
            while (entry != null) {
                Object t2 = entry.get();
                if (t2 != null) {
                    entry.value = biFunction.apply(SoftKeyHashMap.unmaskNull(t2), entry.value);
                }
                entry = entry.next;
                if (n2 == this.modCount) continue;
                throw new ConcurrentModificationException();
            }
        }
    }

    @Override
    public int size() {
        if (this.size == 0) {
            return 0;
        }
        this.expungeStaleEntries();
        return this.size;
    }

    private boolean containsNullValue() {
        Entry<K, V>[] entryArray = this.getTable();
        int n2 = entryArray.length;
        while (n2-- > 0) {
            Entry<K, V> entry = entryArray[n2];
            while (entry != null) {
                if (entry.value == null) {
                    return true;
                }
                entry = entry.next;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void expungeStaleEntries() {
        Reference<Object> reference;
        while ((reference = this.queue.poll()) != null) {
            ReferenceQueue<Object> referenceQueue = this.queue;
            synchronized (referenceQueue) {
                Entry<K, V> entry;
                Entry entry2 = (Entry)reference;
                int n2 = SoftKeyHashMap.indexFor(entry2.hash, this.table.length);
                Entry<K, V> entry3 = entry = this.table[n2];
                while (entry3 != null) {
                    Entry entry4 = entry3.next;
                    if (entry3 == entry2) {
                        if (entry == entry2) {
                            this.table[n2] = entry4;
                        } else {
                            entry.next = entry4;
                        }
                        entry2.value = null;
                        --this.size;
                        break;
                    }
                    entry = entry3;
                    entry3 = entry4;
                }
            }
        }
    }

    private Entry<K, V>[] getTable() {
        this.expungeStaleEntries();
        return this.table;
    }

    private Entry<K, V>[] newTable(int n2) {
        return new Entry[n2];
    }

    private void transfer(Entry<K, V>[] entryArray, Entry<K, V>[] entryArray2) {
        for (int i2 = 0; i2 < entryArray.length; ++i2) {
            Entry<K, V> entry = entryArray[i2];
            entryArray[i2] = null;
            while (entry != null) {
                Entry entry2 = entry.next;
                Object t2 = entry.get();
                if (t2 == null) {
                    entry.next = null;
                    entry.value = null;
                    --this.size;
                } else {
                    int n2 = SoftKeyHashMap.indexFor(entry.hash, entryArray2.length);
                    entry.next = entryArray2[n2];
                    entryArray2[n2] = entry;
                }
                entry = entry2;
            }
        }
    }

    Entry<K, V> getEntry(Object object) {
        Object object2 = SoftKeyHashMap.maskNull(object);
        int n2 = this.hash(object2);
        Entry<K, V>[] entryArray = this.getTable();
        int n3 = SoftKeyHashMap.indexFor(n2, entryArray.length);
        Entry<K, V> entry = entryArray[n3];
        while (!(entry == null || entry.hash == n2 && SoftKeyHashMap.eq(object2, entry.get()))) {
            entry = entry.next;
        }
        return entry;
    }

    final int hash(Object object) {
        int n2 = object.hashCode();
        n2 ^= n2 >>> 20 ^ n2 >>> 12;
        return n2 ^ n2 >>> 7 ^ n2 >>> 4;
    }

    boolean removeMapping(Object object) {
        Entry<K, V> entry;
        if (!(object instanceof Map.Entry)) {
            return false;
        }
        Entry<K, V>[] entryArray = this.getTable();
        Map.Entry entry2 = (Map.Entry)object;
        Object object2 = SoftKeyHashMap.maskNull(entry2.getKey());
        int n2 = this.hash(object2);
        int n3 = SoftKeyHashMap.indexFor(n2, entryArray.length);
        Entry<K, V> entry3 = entry = entryArray[n3];
        while (entry3 != null) {
            Entry entry4 = entry3.next;
            if (n2 == entry3.hash && entry3.equals(entry2)) {
                ++this.modCount;
                --this.size;
                if (entry == entry3) {
                    entryArray[n3] = entry4;
                } else {
                    entry.next = entry4;
                }
                return true;
            }
            entry = entry3;
            entry3 = entry4;
        }
        return false;
    }

    void resize(int n2) {
        Entry<K, V>[] entryArray = this.getTable();
        int n3 = entryArray.length;
        if (n3 == 0x40000000) {
            this.threshold = Integer.MAX_VALUE;
            return;
        }
        Entry<K, V>[] entryArray2 = this.newTable(n2);
        this.transfer(entryArray, entryArray2);
        this.table = entryArray2;
        if (this.size >= this.threshold / 2) {
            this.threshold = (int)((float)n2 * this.loadFactor);
        } else {
            this.expungeStaleEntries();
            this.transfer(entryArray2, entryArray);
            this.table = entryArray;
        }
    }

    private static boolean eq(Object object, Object object2) {
        return object == object2 || object.equals(object2);
    }

    private static int indexFor(int n2, int n3) {
        return n2 & n3 - 1;
    }

    private static Object maskNull(Object object) {
        return object == null ? NULL_KEY : object;
    }

    static Object unmaskNull(Object object) {
        return object == NULL_KEY ? null : object;
    }

    private static class Entry<K, V>
    extends SoftReference<Object>
    implements Map.Entry<K, V> {
        V value;
        final int hash;
        Entry<K, V> next;

        Entry(Object object, V v2, ReferenceQueue<Object> referenceQueue, int n2, Entry<K, V> entry) {
            super(object, referenceQueue);
            this.value = v2;
            this.hash = n2;
            this.next = entry;
        }

        @Override
        public boolean equals(Object object) {
            Object k2;
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            K k3 = this.getKey();
            if (Objects.equals(k3, k2 = entry.getKey())) {
                V v2 = this.getValue();
                Object v3 = entry.getValue();
                return Objects.equals(v2, v3);
            }
            return false;
        }

        @Override
        public K getKey() {
            return (K)SoftKeyHashMap.unmaskNull(this.get());
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public int hashCode() {
            K k2 = this.getKey();
            V v2 = this.getValue();
            return Objects.hashCode(k2) ^ Objects.hashCode(v2);
        }

        @Override
        public V setValue(V v2) {
            V v3 = this.value;
            this.value = v2;
            return v3;
        }

        public String toString() {
            return this.getKey() + "=" + this.getValue();
        }
    }

    private class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        private EntrySet() {
        }

        @Override
        public void clear() {
            SoftKeyHashMap.this.clear();
        }

        @Override
        public boolean contains(Object object) {
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            Entry entry2 = SoftKeyHashMap.this.getEntry(entry.getKey());
            return entry2 != null && entry2.equals(entry);
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new EntryIterator();
        }

        @Override
        public boolean remove(Object object) {
            return SoftKeyHashMap.this.removeMapping(object);
        }

        @Override
        public int size() {
            return SoftKeyHashMap.this.size();
        }

        @Override
        public Spliterator<Map.Entry<K, V>> spliterator() {
            return new EntrySpliterator(SoftKeyHashMap.this, 0, -1, 0, 0);
        }

        @Override
        public Object[] toArray() {
            return this.deepCopy().toArray();
        }

        @Override
        public <T> T[] toArray(T[] TArray) {
            return this.deepCopy().toArray(TArray);
        }

        private List<Map.Entry<K, V>> deepCopy() {
            ArrayList arrayList = new ArrayList(this.size());
            this.forEach(entry -> arrayList.add(new AbstractMap.SimpleEntry(entry)));
            return arrayList;
        }
    }

    static final class ValueSpliterator<K, V>
    extends SoftHashMapSpliterator<K, V>
    implements Spliterator<V> {
        ValueSpliterator(SoftKeyHashMap<K, V> softKeyHashMap, int n2, int n3, int n4, int n5) {
            super(softKeyHashMap, n2, n3, n4, n5);
        }

        @Override
        public int characteristics() {
            return 0;
        }

        @Override
        public void forEachRemaining(Consumer<? super V> consumer) {
            int n2;
            int n3;
            if (consumer == null) {
                throw new NullPointerException();
            }
            SoftKeyHashMap softKeyHashMap = this.map;
            Entry<K, V>[] entryArray = softKeyHashMap.table;
            int n4 = this.fence;
            if (n4 < 0) {
                n3 = this.expectedModCount = softKeyHashMap.modCount;
                n4 = this.fence = entryArray.length;
            } else {
                n3 = this.expectedModCount;
            }
            if (entryArray.length >= n4 && (n2 = this.index) >= 0 && (n2 < (this.index = n4) || this.current != null)) {
                Entry entry = this.current;
                this.current = null;
                do {
                    if (entry == null) {
                        entry = entryArray[n2++];
                        continue;
                    }
                    Object t2 = entry.get();
                    Object v2 = entry.value;
                    entry = entry.next;
                    if (t2 == null) continue;
                    consumer.accept(v2);
                } while (entry != null || n2 < n4);
            }
            if (softKeyHashMap.modCount != n3) {
                throw new ConcurrentModificationException();
            }
        }

        @Override
        public boolean tryAdvance(Consumer<? super V> consumer) {
            if (consumer == null) {
                throw new NullPointerException();
            }
            Entry<K, V>[] entryArray = this.map.table;
            int n2 = this.getFence();
            if (entryArray.length >= n2 && this.index >= 0) {
                while (this.current != null || this.index < n2) {
                    if (this.current == null) {
                        this.current = entryArray[this.index++];
                        continue;
                    }
                    Object t2 = this.current.get();
                    Object v2 = this.current.value;
                    this.current = this.current.next;
                    if (t2 == null) continue;
                    consumer.accept(v2);
                    if (this.map.modCount != this.expectedModCount) {
                        throw new ConcurrentModificationException();
                    }
                    return true;
                }
            }
            return false;
        }

        public ValueSpliterator<K, V> trySplit() {
            ValueSpliterator<K, V> valueSpliterator;
            int n2 = this.index;
            int n3 = this.getFence();
            int n4 = n2 + n3 >>> 1;
            if (n2 >= n4) {
                valueSpliterator = null;
            } else {
                this.index = n4;
                ValueSpliterator<K, V> valueSpliterator2 = new ValueSpliterator<K, V>(this.map, n2, this.index, this.est >>>= 1, this.expectedModCount);
                valueSpliterator = valueSpliterator2;
            }
            return valueSpliterator;
        }
    }

    static class SoftHashMapSpliterator<K, V> {
        final SoftKeyHashMap<K, V> map;
        Entry<K, V> current;
        int index;
        int fence;
        int est;
        int expectedModCount;

        SoftHashMapSpliterator(SoftKeyHashMap<K, V> softKeyHashMap, int n2, int n3, int n4, int n5) {
            this.map = softKeyHashMap;
            this.index = n2;
            this.fence = n3;
            this.est = n4;
            this.expectedModCount = n5;
        }

        public final long estimateSize() {
            this.getFence();
            return this.est;
        }

        final int getFence() {
            int n2 = this.fence;
            if (n2 < 0) {
                SoftKeyHashMap<K, V> softKeyHashMap = this.map;
                this.est = softKeyHashMap.size();
                this.expectedModCount = softKeyHashMap.modCount;
                n2 = this.fence = softKeyHashMap.table.length;
            }
            return n2;
        }
    }

    static final class KeySpliterator<K, V>
    extends SoftHashMapSpliterator<K, V>
    implements Spliterator<K> {
        KeySpliterator(SoftKeyHashMap<K, V> softKeyHashMap, int n2, int n3, int n4, int n5) {
            super(softKeyHashMap, n2, n3, n4, n5);
        }

        @Override
        public int characteristics() {
            return 1;
        }

        @Override
        public void forEachRemaining(Consumer<? super K> consumer) {
            int n2;
            int n3;
            if (consumer == null) {
                throw new NullPointerException();
            }
            SoftKeyHashMap softKeyHashMap = this.map;
            Entry<K, V>[] entryArray = softKeyHashMap.table;
            int n4 = this.fence;
            if (n4 < 0) {
                n3 = this.expectedModCount = softKeyHashMap.modCount;
                n4 = this.fence = entryArray.length;
            } else {
                n3 = this.expectedModCount;
            }
            if (entryArray.length >= n4 && (n2 = this.index) >= 0 && (n2 < (this.index = n4) || this.current != null)) {
                Entry entry = this.current;
                this.current = null;
                do {
                    if (entry == null) {
                        entry = entryArray[n2++];
                        continue;
                    }
                    Object t2 = entry.get();
                    entry = entry.next;
                    if (t2 == null) continue;
                    Object object = SoftKeyHashMap.unmaskNull(t2);
                    consumer.accept(object);
                } while (entry != null || n2 < n4);
            }
            if (softKeyHashMap.modCount != n3) {
                throw new ConcurrentModificationException();
            }
        }

        @Override
        public boolean tryAdvance(Consumer<? super K> consumer) {
            if (consumer == null) {
                throw new NullPointerException();
            }
            Entry<K, V>[] entryArray = this.map.table;
            int n2 = this.getFence();
            if (entryArray.length >= n2 && this.index >= 0) {
                while (this.current != null || this.index < n2) {
                    if (this.current == null) {
                        this.current = entryArray[this.index++];
                        continue;
                    }
                    Object t2 = this.current.get();
                    this.current = this.current.next;
                    if (t2 == null) continue;
                    Object object = SoftKeyHashMap.unmaskNull(t2);
                    consumer.accept(object);
                    if (this.map.modCount != this.expectedModCount) {
                        throw new ConcurrentModificationException();
                    }
                    return true;
                }
            }
            return false;
        }

        public KeySpliterator<K, V> trySplit() {
            KeySpliterator<K, V> keySpliterator;
            int n2 = this.index;
            int n3 = this.getFence();
            int n4 = n2 + n3 >>> 1;
            if (n2 >= n4) {
                keySpliterator = null;
            } else {
                this.index = n4;
                KeySpliterator<K, V> keySpliterator2 = new KeySpliterator<K, V>(this.map, n2, this.index, this.est >>>= 1, this.expectedModCount);
                keySpliterator = keySpliterator2;
            }
            return keySpliterator;
        }
    }

    static final class EntrySpliterator<K, V>
    extends SoftHashMapSpliterator<K, V>
    implements Spliterator<Map.Entry<K, V>> {
        EntrySpliterator(SoftKeyHashMap<K, V> softKeyHashMap, int n2, int n3, int n4, int n5) {
            super(softKeyHashMap, n2, n3, n4, n5);
        }

        @Override
        public int characteristics() {
            return 1;
        }

        @Override
        public void forEachRemaining(Consumer<? super Map.Entry<K, V>> consumer) {
            int n2;
            int n3;
            if (consumer == null) {
                throw new NullPointerException();
            }
            SoftKeyHashMap softKeyHashMap = this.map;
            Entry<K, V>[] entryArray = softKeyHashMap.table;
            int n4 = this.fence;
            if (n4 < 0) {
                n3 = this.expectedModCount = softKeyHashMap.modCount;
                n4 = this.fence = entryArray.length;
            } else {
                n3 = this.expectedModCount;
            }
            if (entryArray.length >= n4 && (n2 = this.index) >= 0 && (n2 < (this.index = n4) || this.current != null)) {
                Entry entry = this.current;
                this.current = null;
                do {
                    if (entry == null) {
                        entry = entryArray[n2++];
                        continue;
                    }
                    Object t2 = entry.get();
                    Object v2 = entry.value;
                    entry = entry.next;
                    if (t2 == null) continue;
                    Object object = SoftKeyHashMap.unmaskNull(t2);
                    consumer.accept(new AbstractMap.SimpleImmutableEntry(object, v2));
                } while (entry != null || n2 < n4);
            }
            if (softKeyHashMap.modCount != n3) {
                throw new ConcurrentModificationException();
            }
        }

        @Override
        public boolean tryAdvance(Consumer<? super Map.Entry<K, V>> consumer) {
            if (consumer == null) {
                throw new NullPointerException();
            }
            Entry<K, V>[] entryArray = this.map.table;
            int n2 = this.getFence();
            if (entryArray.length >= n2 && this.index >= 0) {
                while (this.current != null || this.index < n2) {
                    if (this.current == null) {
                        this.current = entryArray[this.index++];
                        continue;
                    }
                    Object t2 = this.current.get();
                    Object v2 = this.current.value;
                    this.current = this.current.next;
                    if (t2 == null) continue;
                    Object object = SoftKeyHashMap.unmaskNull(t2);
                    consumer.accept(new AbstractMap.SimpleImmutableEntry(object, v2));
                    if (this.map.modCount != this.expectedModCount) {
                        throw new ConcurrentModificationException();
                    }
                    return true;
                }
            }
            return false;
        }

        public EntrySpliterator<K, V> trySplit() {
            EntrySpliterator<K, V> entrySpliterator;
            int n2 = this.index;
            int n3 = this.getFence();
            int n4 = n2 + n3 >>> 1;
            if (n2 >= n4) {
                entrySpliterator = null;
            } else {
                this.index = n4;
                EntrySpliterator<K, V> entrySpliterator2 = new EntrySpliterator<K, V>(this.map, n2, this.index, this.est >>>= 1, this.expectedModCount);
                entrySpliterator = entrySpliterator2;
            }
            return entrySpliterator;
        }
    }

    private abstract class HashIterator<T>
    implements Iterator<T> {
        private int index;
        private Entry<K, V> entry;
        private Entry<K, V> lastReturned;
        private int expectedModCount;
        private Object nextKey;
        private Object currentKey;

        HashIterator() {
            this.expectedModCount = SoftKeyHashMap.this.modCount;
            this.index = SoftKeyHashMap.this.isEmpty() ? 0 : SoftKeyHashMap.this.table.length;
        }

        @Override
        public boolean hasNext() {
            Entry<K, V>[] entryArray = SoftKeyHashMap.this.table;
            while (this.nextKey == null) {
                Entry entry = this.entry;
                int n2 = this.index;
                while (entry == null && n2 > 0) {
                    entry = entryArray[--n2];
                }
                this.entry = entry;
                this.index = n2;
                if (entry == null) {
                    this.currentKey = null;
                    return false;
                }
                this.nextKey = entry.get();
                if (this.nextKey != null) continue;
                this.entry = this.entry.next;
            }
            return true;
        }

        @Override
        public void remove() {
            if (this.lastReturned == null) {
                throw new IllegalStateException();
            }
            if (SoftKeyHashMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            SoftKeyHashMap.this.remove(this.currentKey);
            this.expectedModCount = SoftKeyHashMap.this.modCount;
            this.lastReturned = null;
            this.currentKey = null;
        }

        protected Entry<K, V> nextEntry() {
            if (SoftKeyHashMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            if (this.nextKey == null && !this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.lastReturned = this.entry;
            this.entry = this.entry.next;
            this.currentKey = this.nextKey;
            this.nextKey = null;
            return this.lastReturned;
        }
    }

    private class EntryIterator
    extends HashIterator<Map.Entry<K, V>> {
        private EntryIterator() {
        }

        @Override
        public Map.Entry<K, V> next() {
            return this.nextEntry();
        }
    }
}

