/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.dataset.utils;

import java.util.LinkedList;

public class LimitedQueue<E>
extends LinkedList<E> {
    private static final long serialVersionUID = 7158175707385120597L;
    private int limit;

    public LimitedQueue(int n2) {
        if (n2 < 1) {
            throw new IllegalArgumentException("limit = '" + n2 + "'must be >=1 ");
        }
        this.limit = n2;
    }

    @Override
    public boolean add(E e2) {
        boolean bl2 = super.add(e2);
        while (bl2 && this.size() > this.limit) {
            super.remove();
        }
        return bl2;
    }

    public int getLimit() {
        return this.limit;
    }

    public int setLimit(int n2) {
        if (n2 < 1) {
            throw new IllegalArgumentException("limit = '" + this.limit + "'must be >=1 ");
        }
        this.limit = n2;
        return this.limit;
    }
}

