/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.dataset.utils;

public final class GenericsHelper {
    private GenericsHelper() {
    }

    private static void checkForNonConformity(Object[] objectArray, Class<?> clazz) {
        if (objectArray == null) {
            throw new IllegalArgumentException("null array pointer ");
        }
        if (objectArray.length == 0) {
            return;
        }
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            if (objectArray[i2] != null) continue;
            throw new IllegalArgumentException("array class element " + i2 + " is null, should be of type'" + clazz.getName() + "'");
        }
        if (!clazz.isAssignableFrom(objectArray[0].getClass())) {
            throw new IllegalArgumentException("array class type '" + objectArray[0].getClass().getName() + "' mismatch with '" + clazz.getName() + "'");
        }
    }

    public static boolean[] toBoolPrimitive(Object[] objectArray) {
        GenericsHelper.checkForNonConformity(objectArray, Boolean.class);
        boolean[] blArray = new boolean[objectArray.length];
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            blArray[i2] = objectArray[i2] != null && (Boolean)objectArray[i2] != false;
        }
        return blArray;
    }

    public static byte[] toBytePrimitive(Object[] objectArray) {
        GenericsHelper.checkForNonConformity(objectArray, Byte.class);
        byte[] byArray = new byte[objectArray.length];
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            byArray[i2] = objectArray[i2] == null ? (byte)0 : (Byte)objectArray[i2];
        }
        return byArray;
    }

    public static char[] toCharPrimitive(Object[] objectArray) {
        GenericsHelper.checkForNonConformity(objectArray, Character.class);
        char[] cArray = new char[objectArray.length];
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            cArray[i2] = objectArray[i2] == null ? (char)'\u0000' : ((Character)objectArray[i2]).charValue();
        }
        return cArray;
    }

    public static double[] toDoublePrimitive(Object[] objectArray) {
        GenericsHelper.checkForNonConformity(objectArray, Double.class);
        double[] dArray = new double[objectArray.length];
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            dArray[i2] = objectArray[i2] == null ? Double.NaN : (Double)objectArray[i2];
        }
        return dArray;
    }

    public static float[] toFloatPrimitive(Object[] objectArray) {
        GenericsHelper.checkForNonConformity(objectArray, Float.class);
        float[] fArray = new float[objectArray.length];
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            fArray[i2] = objectArray[i2] == null ? Float.NaN : ((Float)objectArray[i2]).floatValue();
        }
        return fArray;
    }

    public static int[] toIntegerPrimitive(Object[] objectArray) {
        GenericsHelper.checkForNonConformity(objectArray, Integer.class);
        int[] nArray = new int[objectArray.length];
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            nArray[i2] = objectArray[i2] == null ? 0 : (Integer)objectArray[i2];
        }
        return nArray;
    }

    public static long[] toLongPrimitive(Object[] objectArray) {
        GenericsHelper.checkForNonConformity(objectArray, Long.class);
        long[] lArray = new long[objectArray.length];
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            lArray[i2] = objectArray[i2] == null ? 0L : (Long)objectArray[i2];
        }
        return lArray;
    }

    public static Boolean[] toObject(boolean[] blArray) {
        Boolean[] booleanArray = new Boolean[blArray.length];
        for (int i2 = 0; i2 < blArray.length; ++i2) {
            booleanArray[i2] = blArray[i2];
        }
        return booleanArray;
    }

    public static Byte[] toObject(byte[] byArray) {
        Byte[] byteArray = new Byte[byArray.length];
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            byteArray[i2] = byArray[i2];
        }
        return byteArray;
    }

    public static Character[] toObject(char[] cArray) {
        Character[] characterArray = new Character[cArray.length];
        for (int i2 = 0; i2 < cArray.length; ++i2) {
            characterArray[i2] = Character.valueOf(cArray[i2]);
        }
        return characterArray;
    }

    public static Double[] toObject(double[] dArray) {
        Double[] doubleArray = new Double[dArray.length];
        for (int i2 = 0; i2 < dArray.length; ++i2) {
            doubleArray[i2] = dArray[i2];
        }
        return doubleArray;
    }

    public static Float[] toObject(float[] fArray) {
        Float[] floatArray = new Float[fArray.length];
        for (int i2 = 0; i2 < fArray.length; ++i2) {
            floatArray[i2] = Float.valueOf(fArray[i2]);
        }
        return floatArray;
    }

    public static Integer[] toObject(int[] nArray) {
        Integer[] integerArray = new Integer[nArray.length];
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            integerArray[i2] = nArray[i2];
        }
        return integerArray;
    }

    public static Long[] toObject(long[] lArray) {
        Long[] longArray = new Long[lArray.length];
        for (int i2 = 0; i2 < lArray.length; ++i2) {
            longArray[i2] = lArray[i2];
        }
        return longArray;
    }

    public static Short[] toObject(short[] sArray) {
        Short[] shortArray = new Short[sArray.length];
        for (int i2 = 0; i2 < sArray.length; ++i2) {
            shortArray[i2] = sArray[i2];
        }
        return shortArray;
    }

    public static boolean[] toPrimitive(Boolean[] booleanArray) {
        boolean[] blArray = new boolean[booleanArray.length];
        for (int i2 = 0; i2 < booleanArray.length; ++i2) {
            blArray[i2] = booleanArray[i2];
        }
        return blArray;
    }

    public static byte[] toPrimitive(Byte[] byteArray) {
        byte[] byArray = new byte[byteArray.length];
        for (int i2 = 0; i2 < byteArray.length; ++i2) {
            byArray[i2] = byteArray[i2];
        }
        return byArray;
    }

    public static char[] toPrimitive(Character[] characterArray) {
        char[] cArray = new char[characterArray.length];
        for (int i2 = 0; i2 < characterArray.length; ++i2) {
            cArray[i2] = characterArray[i2].charValue();
        }
        return cArray;
    }

    public static double[] toPrimitive(Double[] doubleArray) {
        double[] dArray = new double[doubleArray.length];
        for (int i2 = 0; i2 < doubleArray.length; ++i2) {
            dArray[i2] = doubleArray[i2];
        }
        return dArray;
    }

    public static float[] toPrimitive(Float[] floatArray) {
        float[] fArray = new float[floatArray.length];
        for (int i2 = 0; i2 < floatArray.length; ++i2) {
            fArray[i2] = floatArray[i2].floatValue();
        }
        return fArray;
    }

    public static int[] toPrimitive(Integer[] integerArray) {
        int[] nArray = new int[integerArray.length];
        for (int i2 = 0; i2 < integerArray.length; ++i2) {
            nArray[i2] = integerArray[i2];
        }
        return nArray;
    }

    public static long[] toPrimitive(Long[] longArray) {
        long[] lArray = new long[longArray.length];
        for (int i2 = 0; i2 < longArray.length; ++i2) {
            lArray[i2] = longArray[i2];
        }
        return lArray;
    }

    public static short[] toPrimitive(Short[] shortArray) {
        short[] sArray = new short[shortArray.length];
        for (int i2 = 0; i2 < shortArray.length; ++i2) {
            sArray[i2] = shortArray[i2];
        }
        return sArray;
    }

    public static short[] toShortPrimitive(Object[] objectArray) {
        short[] sArray = new short[objectArray.length];
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            sArray[i2] = (Short)objectArray[i2];
        }
        return sArray;
    }

    public static String[] toStringPrimitive(Object[] objectArray) {
        String[] stringArray;
        block6: {
            block8: {
                block7: {
                    block5: {
                        stringArray = new String[objectArray.length];
                        if (objectArray.length == 0) {
                            return stringArray;
                        }
                        if (!(objectArray[0] instanceof String)) break block5;
                        for (int i2 = 0; i2 < objectArray.length; ++i2) {
                            stringArray[i2] = (String)objectArray[i2];
                        }
                        break block6;
                    }
                    if (!(objectArray[0] instanceof Boolean)) break block7;
                    for (int i3 = 0; i3 < objectArray.length; ++i3) {
                        stringArray[i3] = ((Boolean)objectArray[i3]).toString();
                    }
                    break block6;
                }
                if (!(objectArray[0] instanceof Character)) break block8;
                for (int i4 = 0; i4 < objectArray.length; ++i4) {
                    stringArray[i4] = objectArray[i4].toString();
                }
                break block6;
            }
            if (!(objectArray[0] instanceof Number)) break block6;
            for (int i5 = 0; i5 < objectArray.length; ++i5) {
                stringArray[i5] = objectArray[i5].toString();
            }
        }
        return stringArray;
    }

    public static double[] toDoublePrimitive(boolean[] blArray) {
        double[] dArray = new double[blArray.length];
        for (int i2 = 0; i2 < blArray.length; ++i2) {
            dArray[i2] = blArray[i2] ? 1.0 : 0.0;
        }
        return dArray;
    }

    public static double[] toDoublePrimitive(byte[] byArray) {
        double[] dArray = new double[byArray.length];
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            dArray[i2] = byArray[i2];
        }
        return dArray;
    }

    public static double[] toDoublePrimitive(char[] cArray) {
        double[] dArray = new double[cArray.length];
        for (int i2 = 0; i2 < cArray.length; ++i2) {
            dArray[i2] = cArray[i2];
        }
        return dArray;
    }

    public static double[] toDoublePrimitive(float[] fArray) {
        double[] dArray = new double[fArray.length];
        for (int i2 = 0; i2 < fArray.length; ++i2) {
            dArray[i2] = fArray[i2];
        }
        return dArray;
    }

    public static double[] toDoublePrimitive(int[] nArray) {
        double[] dArray = new double[nArray.length];
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            dArray[i2] = nArray[i2];
        }
        return dArray;
    }

    public static double[] toDoublePrimitive(long[] lArray) {
        double[] dArray = new double[lArray.length];
        for (int i2 = 0; i2 < lArray.length; ++i2) {
            dArray[i2] = lArray[i2];
        }
        return dArray;
    }

    public static double[] toDoublePrimitive(short[] sArray) {
        double[] dArray = new double[sArray.length];
        for (int i2 = 0; i2 < sArray.length; ++i2) {
            dArray[i2] = sArray[i2];
        }
        return dArray;
    }

    public static double[] toDoublePrimitive(String[] stringArray) {
        double[] dArray = new double[stringArray.length];
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            dArray[i2] = stringArray[i2] == null ? Double.NaN : Double.parseDouble(stringArray[i2]);
        }
        return dArray;
    }
}

