/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.dataset.utils;

public class DoubleCircularBuffer {
    private final double[] elements;
    private final int capacity;
    private int writePos;
    private boolean flipped;

    public DoubleCircularBuffer(double[] dArray, int n2) {
        this(n2);
        this.put(dArray, dArray.length);
    }

    public DoubleCircularBuffer(int n2) {
        if (n2 <= 0) {
            throw new IllegalArgumentException("capcacity='" + n2 + "' must be larger than zero");
        }
        this.capacity = n2;
        this.elements = new double[n2];
        this.flipped = false;
    }

    public int available() {
        if (this.flipped) {
            return this.capacity;
        }
        return this.writePos;
    }

    public int capacity() {
        return this.capacity;
    }

    public double[] elements() {
        return this.elements;
    }

    public double get() {
        return this.get(0);
    }

    public double[] get(double[] dArray, int n2) {
        return this.get(dArray, 0, n2);
    }

    public double[] get(double[] dArray, int n2, int n3) {
        double[] dArray2 = dArray == null || dArray.length < n3 ? new double[n3] : dArray;
        for (int i2 = 0; i2 < n3; ++i2) {
            dArray2[i2] = this.get(i2 + n2);
        }
        return dArray2;
    }

    public double get(int n2) {
        int n3 = this.getIndex(n2);
        return this.elements[n3];
    }

    protected int getIndex(int n2) {
        int n3;
        int n4 = n3 = this.flipped ? this.writePos + n2 : n2;
        if (!this.flipped) {
            if (n3 >= 0) {
                return n3;
            }
            throw new IllegalArgumentException("writePos = '" + this.writePos + "' readPos = '" + n2 + "'/index = '" + n3 + "' is beyond circular buffer capacity limits = [0," + this.capacity + "]");
        }
        while (n3 < 0) {
            n3 += this.capacity;
        }
        while (n3 >= this.capacity) {
            n3 -= this.capacity;
        }
        return n3;
    }

    public boolean isBufferFlipped() {
        return this.flipped;
    }

    public boolean put(double d2) {
        this.elements[this.writePos++] = d2;
        if (this.writePos == this.capacity) {
            this.writePos = 0;
            this.flipped = true;
        }
        return true;
    }

    public int put(double[] dArray, int n2) {
        return this.put(dArray, 0, n2);
    }

    public int put(double[] dArray, int n2, int n3) {
        int n4 = this.capacity - this.writePos;
        if (n3 <= n4) {
            System.arraycopy(dArray, n2, this.elements, this.writePos, n3);
            this.writePos += n3;
            if (this.writePos == this.capacity) {
                this.writePos = 0;
                this.flipped = true;
            }
            return this.writePos;
        }
        System.arraycopy(dArray, n2, this.elements, this.writePos, n4);
        this.writePos = this.capacity - 1;
        this.writePos += n4;
        if (this.writePos >= this.capacity) {
            this.writePos = 0;
            this.flipped = true;
        }
        return this.put(dArray, n2 + n4, n3 - n4);
    }

    public int remainingCapacity() {
        return this.capacity - this.available();
    }

    public double replace(double d2) {
        return this.replace(d2, 0);
    }

    public double replace(double d2, int n2) {
        int n3 = this.getIndex(n2);
        double d3 = this.elements[n3];
        this.elements[n3] = d2;
        return d3;
    }

    public void reset() {
        this.writePos = 0;
        this.flipped = false;
    }

    public int writePosition() {
        return this.writePos;
    }
}

