/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.dataset.utils;

public final class AssertUtils {
    private static final String MUST_BE_GREATER_THAN_OR_EQUAL_TO_0 = " must be greater than or equal to 0!";
    private static final String MUST_BE_NON_EMPTY = " must be non-empty!";

    private AssertUtils() {
    }

    public static boolean areEqual(double d2, double d3) {
        return Double.isNaN(d2) && Double.isNaN(d3) || d2 == d3;
    }

    public static void assertType(Object object, Class<?> clazz) {
        if (!clazz.isInstance(object)) {
            throw new IllegalArgumentException("The argument has incorrect type. The correct type is " + clazz.getName());
        }
    }

    public static void belongsToEnum(String string, int[] nArray, int n2) {
        for (int n3 : nArray) {
            if (n2 != n3) continue;
            return;
        }
        throw new IllegalArgumentException("The " + string + " has incorrect value!");
    }

    public static void checkArrayDimension(String string, boolean[] blArray, int n2) {
        AssertUtils.notNull(string, blArray);
        AssertUtils.nonEmptyArray(string, blArray);
        if (blArray.length != n2) {
            throw new IllegalArgumentException("The " + string + " boolean array must have a length of " + n2);
        }
    }

    public static void checkArrayDimension(String string, byte[] byArray, int n2) {
        AssertUtils.notNull(string, byArray);
        AssertUtils.nonEmptyArray(string, byArray);
        if (byArray.length != n2) {
            throw new IllegalArgumentException("The " + string + " byte array must have a length of " + n2);
        }
    }

    public static void checkArrayDimension(String string, double[] dArray, int n2) {
        AssertUtils.notNull(string, dArray);
        AssertUtils.nonEmptyArray(string, dArray);
        if (dArray.length != n2) {
            throw new IllegalArgumentException("The " + string + " double array must have a length of " + n2);
        }
    }

    public static void checkArrayDimension(String string, float[] fArray, int n2) {
        AssertUtils.notNull(string, fArray);
        AssertUtils.nonEmptyArray(string, fArray);
        if (fArray.length != n2) {
            throw new IllegalArgumentException("The " + string + " float array must have a length of " + n2);
        }
    }

    public static void checkArrayDimension(String string, int[] nArray, int n2) {
        AssertUtils.notNull(string, nArray);
        AssertUtils.nonEmptyArray(string, nArray);
        if (nArray.length != n2) {
            throw new IllegalArgumentException("The " + string + " int array must have a length of " + n2);
        }
    }

    public static <T> void equalArrays(T[] TArray, T[] TArray2) {
        if (TArray.length != TArray2.length) {
            throw new IllegalArgumentException("The double arrays must have the same length!");
        }
    }

    public static void equalDoubleArrays(double[] dArray, double[] dArray2) {
        if (dArray.length != dArray2.length) {
            throw new IllegalArgumentException("The double arrays must have the same length! length1 = " + dArray.length + " vs. length2 = " + dArray2.length);
        }
    }

    public static void equalDoubleArrays(double[] dArray, double[] dArray2, int n2) {
        int n3;
        int n4 = Math.min(n2, dArray.length);
        if (n4 != (n3 = Math.min(n2, dArray2.length))) {
            throw new IllegalArgumentException("The double arrays must have the same length! length1 = " + dArray.length + " vs. length2 = " + dArray2.length + " (nMinSize = " + n2 + ")");
        }
    }

    public static void equalFloatArrays(float[] fArray, float[] fArray2) {
        if (fArray.length != fArray2.length) {
            throw new IllegalArgumentException("The float arrays must have the same length! length1 = " + fArray.length + " vs. length2 = " + fArray2.length);
        }
    }

    public static void equalFloatArrays(float[] fArray, float[] fArray2, int n2) {
        int n3;
        int n4 = Math.min(n2, fArray.length);
        if (n4 != (n3 = Math.min(n2, fArray2.length))) {
            throw new IllegalArgumentException("The double arrays must have the same length! length1 = " + fArray.length + " vs. length2 = " + fArray2.length + " (nMinSize = " + n2 + ")");
        }
    }

    public static void gtEqThanZero(String string, double d2) {
        if (d2 < 0.0) {
            throw new IllegalArgumentException("The " + string + MUST_BE_GREATER_THAN_OR_EQUAL_TO_0);
        }
    }

    public static void gtEqThanZero(String string, int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("The " + string + MUST_BE_GREATER_THAN_OR_EQUAL_TO_0);
        }
    }

    public static <T extends Number> void gtEqThanZero(String string, T t2) {
        if (t2.doubleValue() < 0.0) {
            throw new IllegalArgumentException("The " + string + MUST_BE_GREATER_THAN_OR_EQUAL_TO_0);
        }
    }

    public static void gtThanZero(String string, int n2) {
        if (n2 <= 0) {
            throw new IllegalArgumentException("The " + string + " must be greater than 0!");
        }
    }

    public static <T extends Number> void gtThanZero(String string, T t2) {
        if (t2.doubleValue() <= 0.0) {
            throw new IllegalArgumentException("The " + string + " must be greater than 0!");
        }
    }

    public static void indexInBounds(int n2, int n3) {
        AssertUtils.indexInBounds(n2, n3, "The index is out of bounds: 0 <= " + n2 + " < " + n3);
    }

    public static void indexInBounds(int n2, int n3, String string) {
        if (n2 < 0 || n2 >= n3) {
            throw new IndexOutOfBoundsException(string);
        }
    }

    public static void indexOrder(int n2, int n3, String string) {
        if (n2 > n3) {
            throw new IndexOutOfBoundsException(string);
        }
    }

    public static void indexOrder(int n2, String string, int n3, String string2) {
        if (n2 > n3) {
            throw new IndexOutOfBoundsException("Index " + string + "(" + n2 + ") is greated than index " + string2 + "(" + n3 + ")");
        }
    }

    public static void gtOrEqual(String string, double d2, double d3) {
        if (d3 < d2) {
            throw new IllegalArgumentException("The " + string + " len = '" + d3 + "' must be less or equal than " + d2);
        }
    }

    public static void gtOrEqual(String string, float f2, float f3) {
        if (f3 < f2) {
            throw new IllegalArgumentException("The " + string + " len = '" + f3 + "' must be less or equal than " + f2);
        }
    }

    public static void gtOrEqual(String string, int n2, int n3) {
        if (n3 < n2) {
            throw new IllegalArgumentException("The " + string + " len = '" + n3 + "' must be greater or equal than " + n2);
        }
    }

    public static void gtOrEqual(String string, long l2, long l3) {
        if (l3 < l2) {
            throw new IllegalArgumentException("The " + string + " len = '" + l3 + "' must be less or equal than " + l2);
        }
    }

    public static void nonEmptyArray(String string, boolean[] blArray) {
        AssertUtils.notNull(string, blArray);
        if (blArray.length == 0) {
            throw new IllegalArgumentException("The " + string + MUST_BE_NON_EMPTY);
        }
    }

    public static void nonEmptyArray(String string, byte[] byArray) {
        AssertUtils.notNull(string, byArray);
        if (byArray.length == 0) {
            throw new IllegalArgumentException("The " + string + MUST_BE_NON_EMPTY);
        }
    }

    public static void nonEmptyArray(String string, double[] dArray) {
        AssertUtils.notNull(string, dArray);
        if (dArray.length == 0) {
            throw new IllegalArgumentException("The " + string + MUST_BE_NON_EMPTY);
        }
    }

    public static void nonEmptyArray(String string, float[] fArray) {
        AssertUtils.notNull(string, fArray);
        if (fArray.length == 0) {
            throw new IllegalArgumentException("The " + string + MUST_BE_NON_EMPTY);
        }
    }

    public static void nonEmptyArray(String string, int[] nArray) {
        AssertUtils.notNull(string, nArray);
        if (nArray.length == 0) {
            throw new IllegalArgumentException("The " + string + MUST_BE_NON_EMPTY);
        }
    }

    public static void nonEmptyArray(String string, Object[] objectArray) {
        AssertUtils.notNull(string, objectArray);
        if (objectArray.length == 0) {
            throw new IllegalArgumentException("The " + string + MUST_BE_NON_EMPTY);
        }
        for (Object object : objectArray) {
            if (object != null) continue;
            throw new NullPointerException("Elements of the " + string + " must be non-null!");
        }
    }

    public static <T> T notNull(String string, T t2) {
        if (t2 == null) {
            throw new IllegalArgumentException("The " + string + " must be non-null!");
        }
        return t2;
    }
}

