/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.dataset.utils;

import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;

public final class ArrayCache {
    private static final ConcurrentHashMap<String, WeakHashMap<ArrayCacheSizeKey, boolean[]>> booleanArrayCache = new ConcurrentHashMap();
    private static final ConcurrentHashMap<String, WeakHashMap<ArrayCacheSizeKey, byte[]>> byteArrayCache = new ConcurrentHashMap();
    private static final ConcurrentHashMap<String, WeakHashMap<ArrayCacheSizeKey, double[]>> doubleArrayCache = new ConcurrentHashMap();
    private static final ConcurrentHashMap<String, WeakHashMap<ArrayCacheSizeKey, float[]>> floatArrayCache = new ConcurrentHashMap();
    private static final ConcurrentHashMap<String, WeakHashMap<ArrayCacheSizeKey, int[]>> intArrayCache = new ConcurrentHashMap();
    private static final ConcurrentHashMap<String, WeakHashMap<ArrayCacheSizeKey, long[]>> longArrayCache = new ConcurrentHashMap();
    private static final ConcurrentHashMap<String, WeakHashMap<ArrayCacheSizeKey, short[]>> shortArrayCache = new ConcurrentHashMap();
    private static final ConcurrentHashMap<String, WeakHashMap<ArrayCacheSizeKey, String[]>> stringArrayCache = new ConcurrentHashMap();

    private ArrayCache() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean[] getCachedBooleanArray(String string2, int n2) {
        ConcurrentHashMap<String, WeakHashMap<ArrayCacheSizeKey, boolean[]>> concurrentHashMap = booleanArrayCache;
        synchronized (concurrentHashMap) {
            WeakHashMap weakHashMap = booleanArrayCache.computeIfAbsent(string2, string -> new WeakHashMap());
            ArrayCacheSizeKey arrayCacheSizeKey = new ArrayCacheSizeKey(n2);
            boolean[] blArray = (boolean[])weakHashMap.get(arrayCacheSizeKey);
            if (blArray == null) {
                blArray = new boolean[n2];
            } else {
                booleanArrayCache.get(string2).remove(arrayCacheSizeKey);
            }
            return blArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getCachedByteArray(String string2, int n2) {
        ConcurrentHashMap<String, WeakHashMap<ArrayCacheSizeKey, byte[]>> concurrentHashMap = byteArrayCache;
        synchronized (concurrentHashMap) {
            WeakHashMap weakHashMap = byteArrayCache.computeIfAbsent(string2, string -> new WeakHashMap());
            ArrayCacheSizeKey arrayCacheSizeKey = new ArrayCacheSizeKey(n2);
            byte[] byArray = (byte[])weakHashMap.get(arrayCacheSizeKey);
            if (byArray == null) {
                byArray = new byte[n2];
            } else {
                byteArrayCache.get(string2).remove(arrayCacheSizeKey);
            }
            return byArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static double[] getCachedDoubleArray(String string2, int n2) {
        ConcurrentHashMap<String, WeakHashMap<ArrayCacheSizeKey, double[]>> concurrentHashMap = doubleArrayCache;
        synchronized (concurrentHashMap) {
            WeakHashMap weakHashMap = doubleArrayCache.computeIfAbsent(string2, string -> new WeakHashMap());
            ArrayCacheSizeKey arrayCacheSizeKey = new ArrayCacheSizeKey(n2);
            double[] dArray = (double[])weakHashMap.get(arrayCacheSizeKey);
            if (dArray == null) {
                dArray = new double[n2];
            } else {
                doubleArrayCache.get(string2).remove(arrayCacheSizeKey);
            }
            return dArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static float[] getCachedFloatArray(String string2, int n2) {
        ConcurrentHashMap<String, WeakHashMap<ArrayCacheSizeKey, float[]>> concurrentHashMap = floatArrayCache;
        synchronized (concurrentHashMap) {
            WeakHashMap weakHashMap = floatArrayCache.computeIfAbsent(string2, string -> new WeakHashMap());
            ArrayCacheSizeKey arrayCacheSizeKey = new ArrayCacheSizeKey(n2);
            float[] fArray = (float[])weakHashMap.get(arrayCacheSizeKey);
            if (fArray == null) {
                fArray = new float[n2];
            } else {
                floatArrayCache.get(string2).remove(arrayCacheSizeKey);
            }
            return fArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int[] getCachedIntArray(String string2, int n2) {
        ConcurrentHashMap<String, WeakHashMap<ArrayCacheSizeKey, int[]>> concurrentHashMap = intArrayCache;
        synchronized (concurrentHashMap) {
            WeakHashMap weakHashMap = intArrayCache.computeIfAbsent(string2, string -> new WeakHashMap());
            ArrayCacheSizeKey arrayCacheSizeKey = new ArrayCacheSizeKey(n2);
            int[] nArray = (int[])weakHashMap.get(arrayCacheSizeKey);
            if (nArray == null) {
                nArray = new int[n2];
            } else {
                intArrayCache.get(string2).remove(arrayCacheSizeKey);
            }
            return nArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long[] getCachedLongArray(String string2, int n2) {
        ConcurrentHashMap<String, WeakHashMap<ArrayCacheSizeKey, long[]>> concurrentHashMap = longArrayCache;
        synchronized (concurrentHashMap) {
            WeakHashMap weakHashMap = longArrayCache.computeIfAbsent(string2, string -> new WeakHashMap());
            ArrayCacheSizeKey arrayCacheSizeKey = new ArrayCacheSizeKey(n2);
            long[] lArray = (long[])weakHashMap.get(arrayCacheSizeKey);
            if (lArray == null) {
                lArray = new long[n2];
            } else {
                longArrayCache.get(string2).remove(arrayCacheSizeKey);
            }
            return lArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static short[] getCachedShortArray(String string2, int n2) {
        ConcurrentHashMap<String, WeakHashMap<ArrayCacheSizeKey, short[]>> concurrentHashMap = shortArrayCache;
        synchronized (concurrentHashMap) {
            WeakHashMap weakHashMap = shortArrayCache.computeIfAbsent(string2, string -> new WeakHashMap());
            ArrayCacheSizeKey arrayCacheSizeKey = new ArrayCacheSizeKey(n2);
            short[] sArray = (short[])weakHashMap.get(arrayCacheSizeKey);
            if (sArray == null) {
                sArray = new short[n2];
            } else {
                shortArrayCache.get(string2).remove(arrayCacheSizeKey);
            }
            return sArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] getCachedStringArray(String string2, int n2) {
        ConcurrentHashMap<String, WeakHashMap<ArrayCacheSizeKey, String[]>> concurrentHashMap = stringArrayCache;
        synchronized (concurrentHashMap) {
            WeakHashMap weakHashMap = stringArrayCache.computeIfAbsent(string2, string -> new WeakHashMap());
            ArrayCacheSizeKey arrayCacheSizeKey = new ArrayCacheSizeKey(n2);
            String[] stringArray = (String[])weakHashMap.get(arrayCacheSizeKey);
            if (stringArray == null) {
                stringArray = new String[n2];
            } else {
                stringArrayCache.get(string2).remove(arrayCacheSizeKey);
            }
            return stringArray;
        }
    }

    public static void release(String string, boolean[] blArray) {
        if (blArray == null) {
            return;
        }
        booleanArrayCache.get(string).put(new ArrayCacheSizeKey(blArray.length), blArray);
    }

    public static void release(String string, byte[] byArray) {
        if (byArray == null) {
            return;
        }
        byteArrayCache.get(string).put(new ArrayCacheSizeKey(byArray.length), byArray);
    }

    public static void release(String string, double[] dArray) {
        if (dArray == null) {
            return;
        }
        doubleArrayCache.get(string).put(new ArrayCacheSizeKey(dArray.length), dArray);
    }

    public static void release(String string, float[] fArray) {
        if (fArray == null) {
            return;
        }
        floatArrayCache.get(string).put(new ArrayCacheSizeKey(fArray.length), fArray);
    }

    public static void release(String string, int[] nArray) {
        if (nArray == null) {
            return;
        }
        intArrayCache.get(string).put(new ArrayCacheSizeKey(nArray.length), nArray);
    }

    public static void release(String string, long[] lArray) {
        if (lArray == null) {
            return;
        }
        longArrayCache.get(string).put(new ArrayCacheSizeKey(lArray.length), lArray);
    }

    public static void release(String string, short[] sArray) {
        if (sArray == null) {
            return;
        }
        shortArrayCache.get(string).put(new ArrayCacheSizeKey(sArray.length), sArray);
    }

    public static void release(String string, String[] stringArray) {
        if (stringArray == null) {
            return;
        }
        stringArrayCache.get(string).put(new ArrayCacheSizeKey(stringArray.length), stringArray);
    }

    public static class ArrayCacheSizeKey {
        private final int value;

        ArrayCacheSizeKey(int n2) {
            this.value = n2;
        }

        public int hashCode() {
            return Integer.hashCode(this.value);
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object instanceof Integer && (Integer)object == this.value) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            ArrayCacheSizeKey arrayCacheSizeKey = (ArrayCacheSizeKey)object;
            return this.value == arrayCacheSizeKey.value;
        }
    }
}

