/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.dataset.utils;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Set;

public class AggregateException
extends RuntimeException {
    private static final long serialVersionUID = 1580760362088821678L;
    private static final String CAUSE_CAPTION = "Caused by: ";
    private static final String SUPPRESSED_CAPTION = "Suppressed: ";
    private static final String AGGREGATION_CAPTION = "additional aggregated exception #";
    private final List<Throwable> throwableList = Collections.synchronizedList(new ArrayList());

    public AggregateException(String string) {
        this(string, Collections.emptyList());
    }

    public AggregateException(String string, List<Throwable> list) {
        super(string, list.isEmpty() ? null : list.get(0));
        this.throwableList.addAll(list);
    }

    public synchronized void add(Throwable throwable) {
        if (throwable != null) {
            this.throwableList.add(throwable);
        }
    }

    @Override
    public synchronized Throwable getCause() {
        if (this.throwableList.isEmpty()) {
            return super.getCause();
        }
        return this.throwableList.get(0);
    }

    public synchronized List<Throwable> getThrowableList() {
        return this.throwableList;
    }

    public synchronized boolean isEmpty() {
        return this.throwableList.isEmpty();
    }

    @Override
    public void printStackTrace(PrintStream printStream) {
        this.printStackTrace(new WrappedPrintStream(printStream));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void printStackTrace(PrintStreamOrWriter printStreamOrWriter) {
        Set<Throwable> set = Collections.newSetFromMap(new IdentityHashMap());
        set.add(this);
        Object object = printStreamOrWriter.lock();
        synchronized (object) {
            StackTraceElement[] stackTraceElementArray;
            printStreamOrWriter.println(this.getClass().getSimpleName() + " - primary exception cause:");
            printStreamOrWriter.println(this);
            for (StackTraceElement stackTraceElement : stackTraceElementArray = this.getStackTrace()) {
                printStreamOrWriter.println("\tat " + stackTraceElement);
            }
            for (Throwable throwable : this.getSuppressed()) {
                AggregateException.printEnclosedStackTrace(throwable, printStreamOrWriter, stackTraceElementArray, SUPPRESSED_CAPTION, "\t", set);
            }
            Throwable throwable = this.getCause();
            if (throwable != null) {
                AggregateException.printEnclosedStackTrace(throwable, printStreamOrWriter, stackTraceElementArray, CAUSE_CAPTION, "", set);
            }
            int n2 = 0;
            for (Throwable throwable2 : this.getThrowableList()) {
                if (++n2 == 1) continue;
                AggregateException.printEnclosedStackTrace(throwable2, printStreamOrWriter, stackTraceElementArray, AGGREGATION_CAPTION + n2 + ": ", "", set);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    protected static void printEnclosedStackTrace(Throwable throwable, PrintStreamOrWriter printStreamOrWriter, StackTraceElement[] stackTraceElementArray, String string, String string2, Set<Throwable> set) {
        void object;
        assert (Thread.holdsLock(printStreamOrWriter.lock()));
        if (set.contains(throwable)) {
            printStreamOrWriter.println("\t[CIRCULAR REFERENCE: " + throwable + "]");
            return;
        }
        set.add(throwable);
        StackTraceElement[] stackTraceElementArray2 = throwable.getStackTrace();
        int n2 = stackTraceElementArray2.length - 1;
        for (int i2 = stackTraceElementArray.length - 1; n2 >= 0 && i2 >= 0 && stackTraceElementArray2[n2].equals(stackTraceElementArray[i2]); --n2, --i2) {
        }
        int n3 = stackTraceElementArray2.length - 1 - n2;
        printStreamOrWriter.println(string2 + string + throwable);
        boolean i3 = false;
        while (object <= n2) {
            printStreamOrWriter.println(string2 + "\tat " + stackTraceElementArray2[object]);
            ++object;
        }
        if (n3 != 0) {
            printStreamOrWriter.println(string2 + "\t... " + n3 + " more");
        }
        for (Throwable throwable2 : throwable.getSuppressed()) {
            AggregateException.printEnclosedStackTrace(throwable2, printStreamOrWriter, stackTraceElementArray2, SUPPRESSED_CAPTION, string2 + "\t", set);
        }
        Throwable throwable3 = throwable.getCause();
        if (throwable3 != null) {
            AggregateException.printEnclosedStackTrace(throwable3, printStreamOrWriter, stackTraceElementArray2, CAUSE_CAPTION, string2, set);
        }
    }

    protected static class WrappedPrintStream
    implements PrintStreamOrWriter {
        private final PrintStream printStream;

        WrappedPrintStream(PrintStream printStream) {
            this.printStream = printStream;
        }

        @Override
        public Object lock() {
            return this.printStream;
        }

        @Override
        public void println(Object object) {
            this.printStream.println(object);
        }
    }

    protected static interface PrintStreamOrWriter {
        public Object lock();

        public void println(Object var1);
    }

    protected static class WrappedPrintWriter
    implements PrintStreamOrWriter {
        private final PrintWriter printWriter;

        WrappedPrintWriter(PrintWriter printWriter) {
            this.printWriter = printWriter;
        }

        @Override
        public Object lock() {
            return this.printWriter;
        }

        @Override
        public void println(Object object) {
            this.printWriter.println(object);
        }
    }
}

