/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.dataset.spi.utils;

import io.fair_acc.dataset.spi.utils.HashMapHelper;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Set;

public class ObjectObjectMap<K, V>
implements Map<K, V> {
    private static final String NOT_IMPLEMENTED = "not implemented";
    private static final Object FREE_KEY = new Object();
    private static final Object REMOVED_KEY = new Object();
    private Object[] data;
    private Object nullValue;
    private boolean hasNull;
    private final float fillFactor;
    private int threshold;
    private int sizeInternal;
    private int mask;
    private int mask2;

    public ObjectObjectMap(int n2, float f2) {
        if (f2 <= 0.0f || f2 >= 1.0f) {
            throw new IllegalArgumentException("FillFactor must be in (0, 1)");
        }
        if (n2 <= 0) {
            throw new IllegalArgumentException("Size must be positive!");
        }
        int n3 = HashMapHelper.arraySize(n2, f2);
        this.mask = n3 - 1;
        this.mask2 = n3 * 2 - 1;
        this.fillFactor = f2;
        this.data = new Object[n3 * 2];
        Arrays.fill(this.data, FREE_KEY);
        this.threshold = (int)((float)n3 * f2);
    }

    @Override
    public void clear() {
        Arrays.fill(this.data, FREE_KEY);
    }

    @Override
    public boolean containsKey(Object object) {
        return this.get(object) != null;
    }

    @Override
    public boolean containsValue(Object object) {
        throw new IllegalStateException(NOT_IMPLEMENTED);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        throw new IllegalStateException(NOT_IMPLEMENTED);
    }

    @Override
    public V get(Object object) {
        if (object == null) {
            return (V)this.nullValue;
        }
        int n2 = (object.hashCode() & this.mask) << 1;
        Object object2 = this.data[n2];
        if (object2.equals(FREE_KEY)) {
            return null;
        }
        if (object2.equals(object)) {
            return (V)this.data[n2 + 1];
        }
        do {
            if (!(object2 = this.data[n2 = n2 + 2 & this.mask2]).equals(FREE_KEY)) continue;
            return null;
        } while (!object2.equals(object));
        return (V)this.data[n2 + 1];
    }

    public int getStartIndex(Object object) {
        return object.hashCode() & this.mask;
    }

    private V insertNullKey(V v2) {
        if (this.hasNull) {
            Object object = this.nullValue;
            this.nullValue = v2;
            return (V)object;
        }
        this.nullValue = v2;
        ++this.sizeInternal;
        return null;
    }

    @Override
    public boolean isEmpty() {
        return this.sizeInternal == 0;
    }

    @Override
    public Set<K> keySet() {
        throw new IllegalStateException(NOT_IMPLEMENTED);
    }

    @Override
    public V put(K k2, V v2) {
        if (k2 == null) {
            return this.insertNullKey(v2);
        }
        int n2 = this.getStartIndex(k2) << 1;
        Object object = this.data[n2];
        if (object.equals(FREE_KEY)) {
            this.data[n2] = k2;
            this.data[n2 + 1] = v2;
            if (this.sizeInternal >= this.threshold) {
                this.rehash(this.data.length * 2);
            } else {
                ++this.sizeInternal;
            }
            return null;
        }
        if (object.equals(k2)) {
            Object object2 = this.data[n2 + 1];
            this.data[n2 + 1] = v2;
            return (V)object2;
        }
        int n3 = -1;
        if (object.equals(REMOVED_KEY)) {
            n3 = n2;
        }
        while (true) {
            if ((object = this.data[n2 = n2 + 2 & this.mask2]).equals(FREE_KEY)) {
                if (n3 != -1) {
                    n2 = n3;
                }
                this.data[n2] = k2;
                this.data[n2 + 1] = v2;
                if (this.sizeInternal >= this.threshold) {
                    this.rehash(this.data.length * 2);
                } else {
                    ++this.sizeInternal;
                }
                return null;
            }
            if (object.equals(k2)) {
                Object object3 = this.data[n2 + 1];
                this.data[n2 + 1] = v2;
                return (V)object3;
            }
            if (!object.equals(REMOVED_KEY) || n3 != -1) continue;
            n3 = n2;
        }
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        throw new IllegalStateException(NOT_IMPLEMENTED);
    }

    private void rehash(int n2) {
        this.threshold = (int)((double)n2 / 2.0 * (double)this.fillFactor);
        this.mask = n2 / 2 - 1;
        this.mask2 = n2 - 1;
        int n3 = this.data.length;
        Object[] objectArray = this.data;
        this.data = new Object[n2];
        Arrays.fill(this.data, FREE_KEY);
        this.sizeInternal = this.hasNull ? 1 : 0;
        for (int i2 = 0; i2 < n3; i2 += 2) {
            Object object = objectArray[i2];
            if (object.equals(FREE_KEY) || object.equals(REMOVED_KEY)) continue;
            this.put(object, objectArray[i2 + 1]);
        }
    }

    @Override
    public V remove(Object object) {
        if (object == null) {
            return this.removeNullKey();
        }
        int n2 = this.getStartIndex(object) << 1;
        Object object2 = this.data[n2];
        if (object2.equals(FREE_KEY)) {
            return null;
        }
        if (object2.equals(object)) {
            --this.sizeInternal;
            this.data[n2] = this.data[n2 + 2 & this.mask2] == FREE_KEY ? FREE_KEY : REMOVED_KEY;
            Object object3 = this.data[n2 + 1];
            this.data[n2 + 1] = null;
            return (V)object3;
        }
        do {
            if (!(object2 = this.data[n2 = n2 + 2 & this.mask2]).equals(FREE_KEY)) continue;
            return null;
        } while (!object2.equals(object));
        --this.sizeInternal;
        this.data[n2] = this.data[n2 + 2 & this.mask2] == FREE_KEY ? FREE_KEY : REMOVED_KEY;
        Object object4 = this.data[n2 + 1];
        this.data[n2 + 1] = null;
        return (V)object4;
    }

    private V removeNullKey() {
        if (this.hasNull) {
            Object object = this.nullValue;
            this.nullValue = null;
            this.hasNull = false;
            --this.sizeInternal;
            return (V)object;
        }
        return null;
    }

    @Override
    public int size() {
        return this.sizeInternal;
    }

    @Override
    public Collection<V> values() {
        throw new IllegalStateException(NOT_IMPLEMENTED);
    }
}

