/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.dataset.spi.utils;

import io.fair_acc.dataset.spi.utils.MultiArray;
import io.fair_acc.dataset.utils.AssertUtils;
import java.util.Arrays;

public class MultiArrayDouble
extends MultiArray<double[]> {
    public static MultiArrayDouble wrap(double[] dArray) {
        return MultiArrayDouble.wrap(dArray, 0, dArray.length);
    }

    public static MultiArrayDouble wrap(double[] dArray, int n2, int n3) {
        return new MultiArray1DDouble(dArray, new int[]{n3}, n2);
    }

    public static MultiArrayDouble wrap(double[] dArray, int[] nArray) {
        return MultiArrayDouble.wrap(dArray, 0, nArray);
    }

    public static MultiArrayDouble wrap(double[] dArray, int n2, int[] nArray) {
        int n3 = 1;
        for (int n4 : nArray) {
            n3 *= n4;
        }
        AssertUtils.gtOrEqual("Array size", n3 + n2, dArray.length);
        switch (nArray.length) {
            case 1: {
                return new MultiArray1DDouble(dArray, nArray, n2);
            }
            case 2: {
                return new MultiArray2DDouble(dArray, nArray, n2);
            }
        }
        return new MultiArrayDouble(dArray, nArray, n2);
    }

    public static MultiArrayDouble allocate(int[] nArray) {
        switch (nArray.length) {
            case 1: {
                return new MultiArray1DDouble(new double[nArray[0]], nArray, 0);
            }
            case 2: {
                return new MultiArray2DDouble(new double[nArray[1] * nArray[0]], nArray, 0);
            }
        }
        int n2 = 1;
        for (int n3 : nArray) {
            n2 *= n3;
        }
        return new MultiArrayDouble(new double[n2], nArray, 0);
    }

    protected MultiArrayDouble(double[] dArray, int[] nArray, int n2) {
        super(dArray, nArray, n2);
    }

    public void setStrided(int n2, double d2) {
        ((double[])this.elements)[n2 + this.offset] = d2;
    }

    public void set(int[] nArray, double d2) {
        ((double[])this.elements)[this.getIndex((int[])nArray)] = d2;
    }

    public double getStrided(int n2) {
        return ((double[])this.elements)[n2 + this.offset];
    }

    public double get(int[] nArray) {
        return ((double[])this.elements)[this.getIndex(nArray)];
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof MultiArrayDouble)) {
            return false;
        }
        MultiArrayDouble multiArrayDouble = (MultiArrayDouble)object;
        return Arrays.equals(this.dimensions, multiArrayDouble.dimensions) && Arrays.equals((double[])this.elements, this.offset, this.offset + this.getElementsCount(), (double[])multiArrayDouble.elements, multiArrayDouble.offset, multiArrayDouble.offset + this.getElementsCount());
    }

    public int hashCode() {
        int n2 = 1;
        for (int i2 = this.offset; i2 < this.offset + this.getElementsCount(); ++i2) {
            n2 = 31 * n2 + Double.hashCode(((double[])this.elements)[i2]);
        }
        n2 = 31 * n2 + Arrays.hashCode(this.dimensions);
        return n2;
    }

    public static class MultiArray1DDouble
    extends MultiArrayDouble {
        protected MultiArray1DDouble(double[] dArray, int[] nArray, int n2) {
            super(dArray, nArray, n2);
        }

        public double get(int n2) {
            return this.getStrided(n2);
        }

        public void set(int n2, double d2) {
            this.setStrided(n2, d2);
        }
    }

    public static class MultiArray2DDouble
    extends MultiArrayDouble {
        private final int stride;

        protected MultiArray2DDouble(double[] dArray, int[] nArray, int n2) {
            super(dArray, nArray, n2);
            this.stride = nArray[1];
        }

        public double get(int n2, int n3) {
            return ((double[])this.elements)[this.offset + n3 + n2 * this.stride];
        }

        public void set(int n2, int n3, double d2) {
            ((double[])this.elements)[this.offset + n3 + n2 * this.stride] = d2;
        }

        public double[] getRow(int n2) {
            int n3 = n2 * this.stride + this.offset;
            return Arrays.copyOfRange((double[])this.elements, n3, n3 + this.stride);
        }
    }
}

