/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.dataset.spi.utils;

import io.fair_acc.dataset.spi.utils.MultiArrayBoolean;
import io.fair_acc.dataset.spi.utils.MultiArrayByte;
import io.fair_acc.dataset.spi.utils.MultiArrayChar;
import io.fair_acc.dataset.spi.utils.MultiArrayDouble;
import io.fair_acc.dataset.spi.utils.MultiArrayFloat;
import io.fair_acc.dataset.spi.utils.MultiArrayInt;
import io.fair_acc.dataset.spi.utils.MultiArrayLong;
import io.fair_acc.dataset.spi.utils.MultiArrayObject;
import io.fair_acc.dataset.spi.utils.MultiArrayShort;
import io.fair_acc.dataset.utils.AssertUtils;
import java.util.Collections;

public abstract class MultiArray<T> {
    protected final T elements;
    private final int elementCount;
    protected final int[] dimensions;
    protected final int[] strides;
    protected final int offset;

    public static <O> MultiArray<O> wrap(O o2, int[] nArray) {
        return MultiArray.wrap(o2, 0, nArray);
    }

    public static <O> MultiArray<O> wrap(O o2, int n2, int[] nArray) {
        if (o2 instanceof double[]) {
            return MultiArrayDouble.wrap((double[])o2, n2, nArray);
        }
        if (o2 instanceof float[]) {
            return MultiArrayFloat.wrap((float[])o2, n2, nArray);
        }
        if (o2 instanceof int[]) {
            return MultiArrayInt.wrap((int[])o2, n2, nArray);
        }
        if (o2 instanceof byte[]) {
            return MultiArrayByte.wrap((byte[])o2, n2, nArray);
        }
        if (o2 instanceof char[]) {
            return MultiArrayChar.wrap((char[])o2, n2, nArray);
        }
        if (o2 instanceof long[]) {
            return MultiArrayLong.wrap((long[])o2, n2, nArray);
        }
        if (o2 instanceof short[]) {
            return MultiArrayShort.wrap((short[])o2, n2, nArray);
        }
        if (o2 instanceof boolean[]) {
            return MultiArrayBoolean.wrap((boolean[])o2, n2, nArray);
        }
        if (o2 instanceof Object[]) {
            return MultiArrayObject.wrap((Object[])o2, n2, nArray);
        }
        throw new IllegalArgumentException("Data type not supported for MultiDimArray");
    }

    public static <O> MultiArray<O> wrap(O o2) {
        return MultiArray.wrap(o2, 0);
    }

    public static <O> MultiArray<O> wrap(O o2, int n2) {
        if (o2 instanceof double[]) {
            return MultiArrayDouble.wrap((double[])o2, n2, ((double[])o2).length);
        }
        if (o2 instanceof float[]) {
            return MultiArrayFloat.wrap((float[])o2, n2, ((float[])o2).length);
        }
        if (o2 instanceof int[]) {
            return MultiArrayInt.wrap((int[])o2, n2, ((int[])o2).length);
        }
        if (o2 instanceof byte[]) {
            return MultiArrayByte.wrap((byte[])o2, n2, ((byte[])o2).length);
        }
        if (o2 instanceof char[]) {
            return MultiArrayChar.wrap((char[])o2, n2, ((char[])o2).length);
        }
        if (o2 instanceof long[]) {
            return MultiArrayLong.wrap((long[])o2, n2, ((long[])o2).length);
        }
        if (o2 instanceof short[]) {
            return MultiArrayShort.wrap((short[])o2, n2, ((short[])o2).length);
        }
        if (o2 instanceof boolean[]) {
            return MultiArrayBoolean.wrap((boolean[])o2, n2, ((boolean[])o2).length);
        }
        if (o2 instanceof Object[]) {
            return MultiArrayObject.wrap((Object[])o2, n2, ((Object[])o2).length);
        }
        throw new IllegalArgumentException("Data type not supported for MultiDimArray");
    }

    protected MultiArray(T t2, int[] nArray, int n2) {
        AssertUtils.notNull("dimensions", nArray);
        AssertUtils.notNull("elements", t2);
        this.dimensions = nArray;
        this.elements = t2;
        this.offset = n2;
        this.strides = new int[nArray.length];
        this.strides[nArray.length - 1] = 1;
        for (int i2 = nArray.length - 2; i2 >= 0; --i2) {
            this.strides[i2] = this.strides[i2 + 1] * nArray[i2 + 1];
        }
        this.elementCount = this.strides[0] * nArray[0];
    }

    public int[] getDimensions() {
        return this.dimensions;
    }

    public int getOffset() {
        return this.offset;
    }

    public int getElementsCount() {
        return this.elementCount;
    }

    public int getIndex(int[] nArray) {
        int n2 = this.offset;
        int n3 = 1;
        for (int i2 = nArray.length - 1; i2 >= 0; --i2) {
            if (nArray[i2] < 0 || nArray[i2] >= this.dimensions[i2]) {
                throw new IndexOutOfBoundsException("Index " + nArray[i2] + " for dimension " + i2 + " out of bounds " + this.dimensions[i2]);
            }
            n2 += nArray[i2] * n3;
            n3 *= this.dimensions[i2];
        }
        return n2;
    }

    public int[] getIndices(int n2) {
        if (n2 >= this.elementCount + this.offset || n2 < this.offset) {
            throw new IndexOutOfBoundsException();
        }
        if (n2 == this.offset) {
            return new int[this.dimensions.length];
        }
        int[] nArray = new int[this.dimensions.length];
        int n3 = n2 - this.offset;
        for (int i2 = 0; i2 < this.dimensions.length; ++i2) {
            nArray[i2] = n3 / this.strides[i2];
            n3 -= nArray[i2] * this.strides[i2];
        }
        return nArray;
    }

    public T elements() {
        return this.elements;
    }

    public String toString() {
        return String.format("MultiArray [dimensions = %s, elements = %s]", Collections.singletonList(this.dimensions).toString(), Collections.singletonList(this.elements).toString());
    }
}

