/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.dataset.spi.financial;

import io.fair_acc.dataset.DataSet;
import io.fair_acc.dataset.spi.AbstractDataSet;
import io.fair_acc.dataset.spi.financial.api.attrs.AttributeModel;
import io.fair_acc.dataset.spi.financial.api.attrs.AttributeModelAware;
import io.fair_acc.dataset.spi.financial.api.ohlcv.IOhlcv;
import io.fair_acc.dataset.spi.financial.api.ohlcv.IOhlcvItem;
import io.fair_acc.dataset.spi.financial.api.ohlcv.IOhlcvItemAware;
import java.util.Iterator;

public class OhlcvDataSet
extends AbstractDataSet<OhlcvDataSet>
implements Iterable<IOhlcvItem>,
IOhlcvItemAware,
AttributeModelAware {
    public static final int DIM_Y_OPEN = 1;
    public static final int DIM_Y_HIGH = 2;
    public static final int DIM_Y_LOW = 3;
    public static final int DIM_Y_CLOSE = 4;
    public static final int DIM_Y_VOLUME = 5;
    public static final int DIM_Y_OI = 6;
    private IOhlcv ohlcv;
    private boolean isCategoryBased = false;

    public OhlcvDataSet(String string) {
        super(string, 7);
    }

    public void setData(IOhlcv iOhlcv) {
        this.ohlcv = iOhlcv;
    }

    public IOhlcv getData() {
        return this.ohlcv;
    }

    public boolean isCategoryBased() {
        return this.isCategoryBased;
    }

    public void setCategoryBased(boolean bl2) {
        this.isCategoryBased = bl2;
    }

    @Override
    public double get(int n2, int n3) {
        IOhlcvItem iOhlcvItem = this.ohlcv.getOhlcvItem(n3);
        switch (n2) {
            case 0: {
                return this.isCategoryBased ? (double)n3 : (double)iOhlcvItem.getTimeStamp().getTime() / 1000.0;
            }
            case 1: {
                return iOhlcvItem.getOpen();
            }
            case 2: {
                return iOhlcvItem.getHigh();
            }
            case 3: {
                return iOhlcvItem.getLow();
            }
            case 4: {
                return iOhlcvItem.getClose();
            }
            case 5: {
                return iOhlcvItem.getVolume();
            }
            case 6: {
                return iOhlcvItem.getOpenInterest();
            }
        }
        throw new IllegalArgumentException("Dimension not allowed! dimIndex=" + n2);
    }

    @Override
    public Iterator<IOhlcvItem> iterator() {
        return this.ohlcv.iterator();
    }

    @Override
    public int getDataCount() {
        return this.ohlcv.size();
    }

    @Override
    public DataSet set(DataSet dataSet, boolean bl2) {
        this.ohlcv = ((OhlcvDataSet)dataSet).ohlcv;
        return this;
    }

    public int getXIndex(double d2) {
        return this.getIndex(0, d2);
    }

    @Override
    public AttributeModel getAddon() {
        return this.ohlcv.getAddon();
    }

    @Override
    public AttributeModel getAddonOrCreate() {
        return this.ohlcv.getAddonOrCreate();
    }

    @Override
    public IOhlcvItem getItem(int n2) {
        return this.ohlcv.getOhlcvItem(n2);
    }

    @Override
    public IOhlcvItem getLastItem() {
        int n2 = this.ohlcv.size();
        if (n2 == 0) {
            return null;
        }
        return this.ohlcv.getOhlcvItem(n2 - 1);
    }
}

