/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.dataset.spi;

import io.fair_acc.dataset.AxisDescription;
import io.fair_acc.dataset.DataSet;
import io.fair_acc.dataset.DataSet2D;
import io.fair_acc.dataset.events.ChartBits;
import io.fair_acc.dataset.spi.AbstractDataSet;
import io.fair_acc.dataset.spi.LabelledMarker;
import io.fair_acc.dataset.spi.utils.DoublePoint;
import io.fair_acc.dataset.utils.AssertUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class LabelledMarkerDataSet
extends AbstractDataSet<LabelledMarkerDataSet>
implements DataSet2D {
    private static final long serialVersionUID = -3267447868117053651L;
    protected final ArrayList<String> dataLabels = new ArrayList();
    protected final ArrayList<String> dataStyles = new ArrayList();
    protected final transient ArrayList<DoublePoint> data = new ArrayList();

    public LabelledMarkerDataSet(String string) {
        super(string, 2);
    }

    public LabelledMarkerDataSet add(LabelledMarker labelledMarker) {
        AssertUtils.notNull("marker", labelledMarker);
        this.lock().writeLockGuard(() -> {
            this.data.add(new DoublePoint(labelledMarker.getX(), labelledMarker.getY()));
            this.getAxisDescription(0).add(labelledMarker.getX());
            this.dataLabels.add(labelledMarker.getLabel());
            this.dataStyles.add(labelledMarker.getStyle());
        });
        this.fireInvalidated(ChartBits.DataSetDataAdded);
        return (LabelledMarkerDataSet)this.getThis();
    }

    public LabelledMarkerDataSet clearData() {
        this.lock().writeLockGuard(() -> {
            this.data.clear();
            this.dataLabels.clear();
            this.dataStyles.clear();
            this.getAxisDescriptions().forEach(AxisDescription::clear);
        });
        this.fireInvalidated(ChartBits.DataSetDataRemoved);
        return (LabelledMarkerDataSet)this.getThis();
    }

    @Override
    public double get(int n2, int n3) {
        return n2 == 0 ? this.data.get(n3).getX() : this.data.get(n3).getY();
    }

    public List<DoublePoint> getData() {
        return this.data;
    }

    @Override
    public int getDataCount() {
        return this.data.size();
    }

    @Override
    public String getDataLabel(int n2) {
        String string = this.dataLabels.get(n2);
        if (string != null) {
            return string;
        }
        return super.getDataLabel(n2);
    }

    public List<String> getDataLabels() {
        return this.dataLabels;
    }

    public List<String> getDataStyles() {
        return this.dataStyles;
    }

    @Override
    public String getStyle(int n2) {
        return this.dataStyles.get(n2);
    }

    public LabelledMarkerDataSet remove(int n2, int n3) {
        this.lock().writeLockGuard(() -> {
            AssertUtils.indexInBounds(n2, this.getDataCount(), "fromIndex");
            AssertUtils.indexInBounds(n3, this.getDataCount(), "toIndex");
            AssertUtils.indexOrder(n2, "fromIndex", n3, "toIndex");
            this.data.subList(n2, n3).clear();
            this.dataLabels.subList(n2, n3).clear();
            this.dataStyles.subList(n2, n3).clear();
            this.getAxisDescriptions().forEach(AxisDescription::clear);
        });
        this.fireInvalidated(ChartBits.DataSetDataRemoved);
        return (LabelledMarkerDataSet)this.getThis();
    }

    public LabelledMarkerDataSet set(int n2, LabelledMarker labelledMarker) {
        AssertUtils.indexInBounds(n2, this.getDataCount());
        this.lock().writeLockGuard(() -> {
            this.data.get(n2).set(labelledMarker.getX(), labelledMarker.getY());
            this.getAxisDescription(0).add(labelledMarker.getX());
            this.dataLabels.set(n2, labelledMarker.getLabel());
            this.dataStyles.set(n2, labelledMarker.getStyle());
        });
        this.fireInvalidated(ChartBits.DataSetData);
        return (LabelledMarkerDataSet)this.getThis();
    }

    public LabelledMarkerDataSet set(LabelledMarker[] labelledMarkerArray) {
        AssertUtils.notNull("markers", labelledMarkerArray);
        return this.set(Arrays.asList(labelledMarkerArray));
    }

    public LabelledMarkerDataSet set(List<LabelledMarker> list) {
        AssertUtils.notNull("markers", list);
        this.lock().writeLockGuard(() -> {
            this.data.clear();
            this.dataLabels.clear();
            this.dataStyles.clear();
            this.getAxisDescriptions().forEach(AxisDescription::clear);
            for (LabelledMarker labelledMarker : list) {
                double d2 = labelledMarker.getX();
                double d3 = labelledMarker.getY();
                this.data.add(new DoublePoint(d2, d3));
                this.getAxisDescription(0).add(d2);
                this.dataLabels.add(labelledMarker.getLabel());
                this.dataStyles.add(labelledMarker.getStyle());
            }
        });
        this.fireInvalidated(ChartBits.DataSetData);
        return (LabelledMarkerDataSet)this.getThis();
    }

    @Override
    public DataSet set(DataSet dataSet, boolean bl2) {
        throw new UnsupportedOperationException("copy setting transposed data set is not implemented");
    }
}

