/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.dataset.spi;

import io.fair_acc.dataset.DataSet;
import io.fair_acc.dataset.DataSet2D;
import io.fair_acc.dataset.events.ChartBits;
import io.fair_acc.dataset.spi.AbstractDataSet;
import io.fair_acc.dataset.spi.DoubleDataSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;

public class FragmentedDataSet
extends AbstractDataSet<FragmentedDataSet>
implements DataSet2D {
    private static final long serialVersionUID = 2540953806461866839L;
    protected int dataCount;
    protected final ArrayList<DataSet> list = new ArrayList();

    public FragmentedDataSet(String string) {
        super(string, 2);
    }

    public void add(DataSet dataSet) {
        this.lock().writeLockGuard(() -> {
            this.list.add(dataSet);
            this.list.sort(Comparator.comparingDouble(dataSet -> dataSet.getAxisDescription(0).getMin()));
            this.dataCount += dataSet.getDataCount();
            this.getAxisDescription(0).add(dataSet.getAxisDescription(0).getMax());
            this.getAxisDescription(0).add(dataSet.getAxisDescription(0).getMin());
            this.getAxisDescription(1).add(dataSet.getAxisDescription(1).getMax());
            this.getAxisDescription(1).add(dataSet.getAxisDescription(1).getMin());
        });
        this.fireInvalidated(ChartBits.DataSetDataAdded);
    }

    public void add(double[] dArray, double[] dArray2) {
        DoubleDataSet doubleDataSet = new DoubleDataSet(String.format("Fragment #%d", this.list.size() + 1), dArray, dArray2, dArray.length, false);
        this.add(doubleDataSet);
    }

    public void clear() {
        this.lock().writeLockGuard(() -> {
            this.dataCount = 0;
            this.list.clear();
            this.fireInvalidated(ChartBits.DataSetDataRemoved);
        });
    }

    @Override
    public int getDataCount() {
        return this.dataCount;
    }

    public int getDatasetCount() {
        return this.list.size();
    }

    public Collection<DataSet> getDatasets() {
        return this.list;
    }

    @Override
    public String getStyle(int n2) {
        for (DataSet dataSet : this.list) {
            if (n2 < dataSet.getDataCount()) {
                return dataSet.getStyle(n2);
            }
            n2 -= dataSet.getDataCount();
        }
        return "";
    }

    @Override
    public double get(int n2, int n3) {
        int n4 = n3;
        for (DataSet dataSet : this.list) {
            if (n4 < dataSet.getDataCount()) {
                return dataSet.get(n2, n4);
            }
            n4 -= dataSet.getDataCount();
        }
        return Double.NaN;
    }

    @Override
    public double[] getValues(int n2) {
        return this.lock().readLockGuard(() -> {
            double[] dArray = new double[this.dataCount];
            int n3 = 0;
            for (DataSet dataSet : this.list) {
                for (int i2 = 0; i2 < dataSet.getDataCount(); ++i2) {
                    dArray[n3++] = dataSet.get(n2, i2);
                }
            }
            return dArray;
        });
    }

    @Override
    public DataSet set(DataSet dataSet, boolean bl2) {
        this.lock().writeLockGuard(() -> dataSet.lock().writeLockGuard(() -> {
            this.clear();
            this.add(dataSet);
            this.copyMetaData(dataSet);
            this.copyDataLabelsAndStyles(dataSet, bl2);
            this.copyAxisDescription(dataSet);
        }));
        this.fireInvalidated(ChartBits.DataSetData);
        return this.getThis();
    }
}

