/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.dataset.spi;

import io.fair_acc.dataset.AxisDescription;
import io.fair_acc.dataset.DataSet;
import io.fair_acc.dataset.DataSetError;
import io.fair_acc.dataset.DataSetMetaData;
import io.fair_acc.dataset.EditableDataSet;
import io.fair_acc.dataset.spi.AbstractDataSet;
import io.fair_acc.dataset.spi.DefaultAxisDescription;
import io.fair_acc.dataset.spi.DefaultDataSet;
import io.fair_acc.dataset.spi.DefaultErrorDataSet;
import io.fair_acc.dataset.spi.DoubleGridDataSet;
import io.fair_acc.dataset.spi.FloatDataSet;
import io.fair_acc.dataset.spi.MultiDimDoubleDataSet;
import io.fair_acc.dataset.utils.AssertUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.IntStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataSetBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(DataSetBuilder.class);
    protected String name;
    protected Map<Integer, double[]> values = new HashMap<Integer, double[]>();
    protected Map<Integer, double[]> errorsPos = new HashMap<Integer, double[]>();
    protected Map<Integer, double[]> errorsNeg = new HashMap<Integer, double[]>();
    protected Map<Integer, float[]> valuesFloat = new HashMap<Integer, float[]>();
    protected Map<Integer, float[]> errorsPosFloat = new HashMap<Integer, float[]>();
    protected Map<Integer, float[]> errorsNegFloat = new HashMap<Integer, float[]>();
    protected int[] initialCapacity = null;
    private int dimension = -1;
    private boolean useErrors = false;
    private boolean useFloat = false;
    protected List<String> infoList = new ArrayList<String>();
    protected List<String> warningList = new ArrayList<String>();
    protected List<String> errorList = new ArrayList<String>();
    protected Map<String, String> metaInfoMap = new HashMap<String, String>();
    protected Map<Integer, String> dataLabels = new HashMap<Integer, String>();
    protected Map<Integer, String> dataStyles = new HashMap<Integer, String>();
    protected Map<Integer, AxisDescription> axisDescriptions = new HashMap<Integer, AxisDescription>();

    public DataSetBuilder() {
    }

    public DataSetBuilder(String string) {
        this.setName(string);
    }

    protected void addDataLabelStyleMap(DataSet dataSet) {
        if (!(dataSet instanceof AbstractDataSet)) {
            if (!this.dataLabels.isEmpty() || !this.dataStyles.isEmpty()) {
                LOGGER.atWarn().addArgument(dataSet.getClass().getCanonicalName()).log("Dropping MetaData because return type does not implement DataSetMetaData: {}");
            }
            return;
        }
        AbstractDataSet abstractDataSet = (AbstractDataSet)dataSet;
        this.dataLabels.forEach(abstractDataSet::addDataLabel);
        this.dataStyles.forEach(abstractDataSet::addDataStyle);
    }

    protected void addDataRanges(DataSet dataSet) {
        for (Map.Entry<Integer, AxisDescription> entry : this.axisDescriptions.entrySet()) {
            dataSet.getAxisDescription(entry.getKey()).set(entry.getValue());
        }
    }

    protected void addMetaData(DataSet dataSet) {
        if (!(dataSet instanceof DataSetMetaData)) {
            if (!(this.infoList.isEmpty() && this.warningList.isEmpty() && this.errorList.isEmpty() && this.metaInfoMap.isEmpty())) {
                LOGGER.atWarn().addArgument(dataSet.getClass().getCanonicalName()).log("Dropping MetaData because return type does not implement DataSetMetaData: {}");
            }
            return;
        }
        DataSetMetaData dataSetMetaData = (DataSetMetaData)((Object)dataSet);
        dataSetMetaData.getInfoList().addAll(this.infoList);
        dataSetMetaData.getWarningList().addAll(this.warningList);
        dataSetMetaData.getErrorList().addAll(this.errorList);
        dataSetMetaData.getMetaInfo().putAll(this.metaInfoMap);
    }

    public DataSet build() {
        Object object = this.name == null ? "DataSet@" + System.currentTimeMillis() : this.name;
        int n2 = this.getResultDimension();
        int[] nArray = this.getResultSize(n2);
        DataSet dataSet = this.buildRawDataSet((String)object, n2, nArray);
        this.addMetaData(dataSet);
        this.addDataRanges(dataSet);
        this.addDataLabelStyleMap(dataSet);
        return dataSet;
    }

    public <T extends DataSet> T build(Class<T> clazz) {
        DataSet dataSet;
        Object object = this.name == null ? "DataSet@" + System.currentTimeMillis() : this.name;
        int n2 = this.getResultDimension();
        int[] nArray = this.getResultSize(n2);
        int n3 = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            n3 = Math.max(n3, nArray[i2]);
        }
        if (n2 <= 2 && this.values.size() + this.errorsPos.size() + this.errorsNeg.size() == 0 && this.valuesFloat.size() > 0 && this.errorsNegFloat.size() + this.errorsPosFloat.size() == 0) {
            this.useFloat = true;
        }
        if (clazz.isAssignableFrom(DefaultDataSet.class) && n2 <= 2 && !this.useErrors && !this.useFloat) {
            dataSet = this.buildDefaultDataSet((String)object, n3);
        } else if (clazz.isAssignableFrom(DefaultErrorDataSet.class) && n2 <= 2 && this.useErrors && !this.useFloat) {
            dataSet = this.buildDefaultErrorDataSet((String)object, n3);
        } else if (clazz.isAssignableFrom(FloatDataSet.class) && n2 <= 2 && !this.useErrors && this.useFloat) {
            dataSet = this.buildDefaultDataSetFloat((String)object, n3);
        } else if (clazz.isAssignableFrom(MultiDimDoubleDataSet.class) && !this.useErrors && !this.useFloat) {
            dataSet = this.buildMultiDimDataSet((String)object, nArray);
        } else if (clazz.isAssignableFrom(DoubleGridDataSet.class) && !this.useErrors && !this.useFloat) {
            dataSet = this.buildGridDataSet((String)object, nArray);
        } else {
            if (EditableDataSet.class.isAssignableFrom(clazz) && !this.useErrors) {
                throw new UnsupportedOperationException("Instantiation of generic editable DataSet not implemented yet");
            }
            throw new UnsupportedOperationException("Return type not supported for DataSet Builder: " + clazz.getCanonicalName());
        }
        this.addMetaData(dataSet);
        this.addDataRanges(dataSet);
        this.addDataLabelStyleMap(dataSet);
        return (T)dataSet;
    }

    private int getResultDimension() {
        int n2 = this.values.keySet().stream().max(Integer::compare).orElse(-1);
        n2 = Math.max(n2, this.valuesFloat.keySet().stream().max(Integer::compare).orElse(-1));
        n2 = Math.max(n2, this.errorsNeg.keySet().stream().max(Integer::compare).orElse(-1));
        n2 = Math.max(n2, this.errorsNegFloat.keySet().stream().max(Integer::compare).orElse(-1));
        n2 = Math.max(n2, this.errorsPos.keySet().stream().max(Integer::compare).orElse(-1));
        n2 = Math.max(n2, this.errorsPosFloat.keySet().stream().max(Integer::compare).orElse(-1));
        n2 = Math.max(n2, this.axisDescriptions.keySet().stream().max(Integer::compare).orElse(-1));
        if (this.dimension == -1) {
            return n2 + 1;
        }
        if (this.dimension <= n2) {
            throw new UnsupportedOperationException("Supplied data dimensions exceed requested number of dimensions");
        }
        return this.dimension;
    }

    private int[] getResultSize(int n2) {
        int[] nArray = new int[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            nArray[i2] = this.getResultSize(n2, i2);
        }
        return nArray;
    }

    private int getResultSize(int n2, int n3) {
        if (this.initialCapacity != null && n3 < this.initialCapacity.length) {
            return this.initialCapacity[n3];
        }
        if (this.initialCapacity != null && this.initialCapacity.length > 0) {
            return this.initialCapacity[this.initialCapacity.length - 1];
        }
        int n4 = 0;
        if (this.values.containsKey(n3)) {
            n4 = Math.max(n4, this.values.get(n3).length);
        }
        if (this.valuesFloat.containsKey(n3)) {
            n4 = Math.max(n4, this.valuesFloat.get(n3).length);
        }
        if (this.errorsNeg.containsKey(n3)) {
            n4 = Math.max(n4, this.errorsNeg.get(n3).length);
        }
        if (this.errorsNegFloat.containsKey(n3)) {
            n4 = Math.max(n4, this.errorsNegFloat.get(n3).length);
        }
        if (this.errorsPos.containsKey(n3)) {
            n4 = Math.max(n4, this.errorsPos.get(n3).length);
        }
        if (this.errorsPosFloat.containsKey(n3)) {
            n4 = Math.max(n4, this.errorsPosFloat.get(n3).length);
        }
        if (n3 == n2 - 1) {
            n4 = Math.max(n4, this.dataLabels.keySet().stream().max(Integer::compare).orElse(-1));
            n4 = Math.max(n4, this.dataStyles.keySet().stream().max(Integer::compare).orElse(-1));
        }
        return n4;
    }

    protected DataSet buildRawDataSet(String string, int n3, int[] nArray) {
        switch (n3) {
            case 0: 
            case 1: 
            case 2: {
                int n4 = 0;
                for (int i2 = 0; i2 < n3; ++i2) {
                    n4 = Math.max(n4, nArray[i2]);
                }
                if (this.values.size() + this.errorsPos.size() + this.errorsNeg.size() == 0 && this.valuesFloat.size() > 0 && this.errorsNegFloat.size() + this.errorsPosFloat.size() == 0) {
                    this.useFloat = true;
                }
                if (this.errorsNeg.size() == 0 && this.errorsPos.size() == 0 && this.errorsNegFloat.size() == 0 && this.errorsPosFloat.size() == 0 && !this.useErrors) {
                    if (this.useFloat) {
                        return this.buildDefaultDataSetFloat(string, n4);
                    }
                    return this.buildDefaultDataSet(string, n4);
                }
                if (this.useFloat) {
                    throw new UnsupportedOperationException("No float error DataSet implemented yet");
                }
                return this.buildDefaultErrorDataSet(string, n4);
            }
        }
        if (this.useFloat) {
            throw new UnsupportedOperationException("Float DataSet Not implemented for nDims > 2");
        }
        if (this.errorsNeg.size() != 0 || this.errorsPos.size() != 0 || this.errorsNegFloat.size() != 0 || this.errorsPosFloat.size() != 0 || this.useErrors) {
            throw new UnsupportedOperationException("Error DataSet Not implemented for nDims > 2");
        }
        if (IntStream.of(nArray).allMatch(n2 -> n2 == nArray[0] || n2 == -1)) {
            return this.buildMultiDimDataSet(string, nArray);
        }
        return this.buildGridDataSet(string, nArray);
    }

    private DataSet buildDefaultDataSet(String string, int n2) {
        double[] dArray = this.getValues(0, n2);
        double[] dArray2 = this.getValues(1, n2);
        return new DefaultDataSet(string, dArray, dArray2, n2, false);
    }

    private DataSet buildDefaultDataSetFloat(String string, int n2) {
        float[] fArray = this.getValuesFloat(0, n2);
        float[] fArray2 = this.getValuesFloat(1, n2);
        return new FloatDataSet(string, fArray, fArray2, n2, false);
    }

    private DataSet buildDefaultErrorDataSet(String string, int n2) {
        double[] dArray = this.getValues(0, n2);
        double[] dArray2 = this.getValues(1, n2);
        if (this.errorsNeg.containsKey(0) || this.errorsPos.containsKey(0) || this.errorsNegFloat.containsKey(0) || this.errorsPosFloat.containsKey(0)) {
            throw new UnsupportedOperationException("DataSetBuilder: X Errors not implemented for 2D DataSetBuilder");
        }
        double[] dArray3 = this.getErrors(1, n2, false);
        double[] dArray4 = this.getErrors(1, n2, true);
        DefaultErrorDataSet defaultErrorDataSet = new DefaultErrorDataSet(string, dArray, dArray2, dArray3, dArray4, n2, false);
        defaultErrorDataSet.setErrorType(1, this.getErrorType(1));
        return defaultErrorDataSet;
    }

    private DataSet buildMultiDimDataSet(String string, int[] nArray) {
        int n2 = nArray.length;
        double[][] dArrayArray = new double[n2][];
        for (int i2 = 0; i2 < n2; ++i2) {
            dArrayArray[i2] = this.getValues(i2, nArray[i2]);
            if (!this.errorsNeg.containsKey(i2) && !this.errorsPos.containsKey(i2) && !this.useErrors) continue;
            throw new UnsupportedOperationException("DataSetBuilder: Errors not implemented for MultiDimDataSet");
        }
        return new MultiDimDoubleDataSet(string, false, dArrayArray);
    }

    private DataSet buildGridDataSet(String string, int[] nArray) {
        int n2 = nArray.length;
        if (nArray[n2 - 1] == 0) {
            return new DoubleGridDataSet(string, n2, new int[n2 - 1]);
        }
        int n3 = 0;
        int n4 = 1;
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            if (nArray[i2] != nArray[nArray.length - 1]) {
                n3 = i2 + 1;
                n4 *= nArray[i2];
                continue;
            }
            if (nArray[i2] == n4) continue;
            throw new IllegalArgumentException("Dimension Mismatch");
        }
        double[][] dArrayArray = new double[n3][];
        double[][] dArrayArray2 = new double[n2 - n3][];
        for (int i3 = 0; i3 < n2; ++i3) {
            if (i3 < n3) {
                dArrayArray[i3] = this.getValues(i3, nArray[i3]);
            } else {
                dArrayArray2[i3 - n3] = this.getValues(i3, nArray[i3]);
            }
            if (!this.errorsNeg.containsKey(i3) && !this.errorsPos.containsKey(i3) && !this.useErrors) continue;
            throw new UnsupportedOperationException("DataSetBuilder: Errors not implemented for MultiDimDataSet");
        }
        return new DoubleGridDataSet(string, false, dArrayArray, (double[][])dArrayArray2);
    }

    private double[] getValues(int n3, int n4) {
        double[] dArray = this.values.get(n3);
        if (dArray == null && this.valuesFloat.containsKey(n3)) {
            float[] fArray = this.valuesFloat.get(n3);
            dArray = IntStream.range(0, n4).mapToDouble(n2 -> n2 < fArray.length ? (double)fArray[n2] : 0.0).toArray();
        } else if (dArray == null) {
            dArray = n3 == 0 ? IntStream.range(0, n4).mapToDouble(n2 -> n2).toArray() : new double[n4];
        } else if (dArray.length != n4) {
            double[] dArray2 = new double[n4];
            System.arraycopy(dArray, 0, dArray2, 0, Math.min(dArray.length, dArray2.length));
            dArray = dArray2;
        }
        return dArray;
    }

    private float[] getValuesFloat(int n2, int n3) {
        float[] fArray;
        block4: {
            block3: {
                fArray = this.valuesFloat.get(n2);
                if (fArray != null || !this.values.containsKey(n2)) break block3;
                double[] dArray = this.values.get(n2);
                fArray = new float[n3];
                for (int i2 = 0; i2 < n3; ++i2) {
                    fArray[i2] = (float)dArray[i2];
                }
                break block4;
            }
            if (fArray != null) break block4;
            fArray = new float[n3];
            if (n2 == 0) {
                fArray = new float[n3];
                for (int i3 = 0; i3 < n3; ++i3) {
                    fArray[i3] = i3;
                }
            }
        }
        return fArray;
    }

    private DataSetError.ErrorType getErrorType(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        if (this.errorsPos.get(n2) == null && this.errorsNeg.get(n2) == null) {
            objectArray2 = this.errorsPosFloat.get(n2);
            objectArray = this.errorsNegFloat.get(n2);
        } else if (this.errorsPosFloat.get(n2) == null && this.errorsNegFloat.get(n2) == null) {
            objectArray2 = this.errorsPos.get(n2);
            objectArray = this.errorsNeg.get(n2);
        } else {
            String string = String.format("ep(double)=%s, en(double)=%s, ep(float)=%s, en(float)=%s", Arrays.toString(this.errorsPos.get(n2)), Arrays.toString(this.errorsNeg.get(n2)), Arrays.toString(this.errorsPosFloat.get(n2)), Arrays.toString(this.errorsNegFloat.get(n2)));
            throw new UnsupportedOperationException("mixed double/float error vectors for dimIndex " + n2 + " not supported: " + string);
        }
        if (objectArray2 != null && objectArray != null) {
            return DataSetError.ErrorType.ASYMMETRIC;
        }
        if (objectArray2 != null || objectArray != null) {
            return DataSetError.ErrorType.SYMMETRIC;
        }
        return DataSetError.ErrorType.NO_ERROR;
    }

    private double[] getErrors(int n3, int n4, boolean bl2) {
        float[] fArray;
        double[] dArray = bl2 ? this.errorsPos.get(n3) : this.errorsNeg.get(n3);
        float[] fArray2 = bl2 ? this.errorsPosFloat.get(n3) : this.errorsNegFloat.get(n3);
        double[] dArray2 = !bl2 ? this.errorsPos.get(n3) : this.errorsNeg.get(n3);
        float[] fArray3 = fArray = !bl2 ? this.errorsPosFloat.get(n3) : this.errorsNegFloat.get(n3);
        if (dArray == null && fArray2 != null) {
            dArray = IntStream.range(0, n4).mapToDouble(n2 -> fArray2[n2]).toArray();
        } else if (dArray == null && dArray2 != null) {
            dArray = dArray2;
        } else if (dArray == null && fArray != null) {
            dArray = IntStream.range(0, n4).mapToDouble(n2 -> fArray[n2]).toArray();
        } else if (dArray == null) {
            dArray = new double[n4];
        }
        return dArray;
    }

    private AxisDescription getAxisDescription(int n2) {
        if (n2 < 0) {
            throw new UnsupportedOperationException("axis dimension cannot be negative]: " + n2);
        }
        return this.axisDescriptions.computeIfAbsent(n2, DefaultAxisDescription::new);
    }

    public DataSetBuilder setAxisMax(int n2, double d2) {
        this.getAxisDescription(n2).setMax(d2);
        return this;
    }

    public DataSetBuilder setAxisMin(int n2, double d2) {
        this.getAxisDescription(n2).setMin(d2);
        return this;
    }

    public DataSetBuilder setAxisName(int n2, String string) {
        this.getAxisDescription(n2).set(string, new String[0]);
        return this;
    }

    public DataSetBuilder setAxisUnit(int n2, String string) {
        this.getAxisDescription(n2).set(this.getAxisDescription(n2).getName(), string);
        return this;
    }

    public DataSetBuilder setDataLabelMap(Map<Integer, String> map) {
        if (map != null && !map.isEmpty()) {
            this.dataLabels.putAll(map);
        }
        return this;
    }

    public DataSetBuilder setDataStyleMap(Map<Integer, String> map) {
        if (map != null && !map.isEmpty()) {
            this.dataStyles.putAll(map);
        }
        return this;
    }

    public DataSetBuilder setMetaErrorList(String ... stringArray) {
        this.errorList.addAll(Arrays.asList(stringArray));
        return this;
    }

    public DataSetBuilder setMetaInfoList(String ... stringArray) {
        this.infoList.addAll(Arrays.asList(stringArray));
        return this;
    }

    public DataSetBuilder setMetaInfoMap(Map<String, String> map) {
        if (map != null && !map.isEmpty()) {
            this.metaInfoMap.putAll(map);
        }
        return this;
    }

    public DataSetBuilder setMetaWarningList(String ... stringArray) {
        this.warningList.addAll(Arrays.asList(stringArray));
        return this;
    }

    public final DataSetBuilder setName(String string) {
        this.name = string;
        return this;
    }

    public DataSetBuilder setNegError(int n2, double[] dArray) {
        double[] dArray2 = new double[dArray.length];
        System.arraycopy(dArray, 0, dArray2, 0, dArray.length);
        return this.setNegErrorNoCopy(n2, dArray2);
    }

    public final DataSetBuilder setNegError(int n2, float[] fArray) {
        float[] fArray2 = new float[fArray.length];
        System.arraycopy(fArray, 0, fArray2, 0, fArray.length);
        return this.setNegErrorNoCopy(n2, fArray2);
    }

    public DataSetBuilder setNegErrorNoCopy(int n2, double[] dArray) {
        this.errorsNeg.put(n2, dArray);
        return this.setEnableErrors(true);
    }

    public DataSetBuilder setNegErrorNoCopy(int n2, float[] fArray) {
        this.errorsNegFloat.put(n2, fArray);
        return this.setEnableErrors(true);
    }

    public final DataSetBuilder setPosError(int n2, double[] dArray) {
        double[] dArray2 = new double[dArray.length];
        System.arraycopy(dArray, 0, dArray2, 0, dArray.length);
        return this.setPosErrorNoCopy(n2, dArray2);
    }

    public final DataSetBuilder setPosError(int n2, float[] fArray) {
        float[] fArray2 = new float[fArray.length];
        System.arraycopy(fArray, 0, fArray2, 0, fArray.length);
        return this.setPosErrorNoCopy(n2, fArray2);
    }

    public final DataSetBuilder setPosErrorNoCopy(int n2, double[] dArray) {
        this.errorsPos.put(n2, dArray);
        return this.setEnableErrors(true);
    }

    public final DataSetBuilder setPosErrorNoCopy(int n2, float[] fArray) {
        this.errorsPosFloat.put(n2, fArray);
        return this.setEnableErrors(true);
    }

    public final DataSetBuilder setValues(int n2, double[] dArray) {
        double[] dArray2 = new double[dArray.length];
        System.arraycopy(dArray, 0, dArray2, 0, dArray.length);
        return this.setValuesNoCopy(n2, dArray2);
    }

    public final DataSetBuilder setValues(int n2, float[] fArray) {
        float[] fArray2 = new float[fArray.length];
        System.arraycopy(fArray, 0, fArray2, 0, fArray.length);
        return this.setValuesNoCopy(n2, fArray2);
    }

    public final DataSetBuilder setValues(int n2, double[][] dArray) {
        AssertUtils.nonEmptyArray("values", (Object[])dArray);
        AssertUtils.nonEmptyArray("values first col", dArray[0]);
        int n3 = dArray.length;
        int n4 = dArray[0].length;
        int n5 = n3 * n4;
        double[] dArray2 = new double[n5];
        for (int i2 = 0; i2 < n3; ++i2) {
            AssertUtils.checkArrayDimension("column length", dArray[i2], n4);
            System.arraycopy(dArray[i2], 0, dArray2, i2 * n4, n4);
        }
        return this.setValuesNoCopy(n2, dArray2);
    }

    public DataSetBuilder setValuesNoCopy(int n2, double[] dArray) {
        this.values.put(n2, dArray);
        return this;
    }

    public DataSetBuilder setValuesNoCopy(int n2, float[] fArray) {
        this.valuesFloat.put(n2, fArray);
        return this;
    }

    public DataSetBuilder setDimension(int n2) {
        this.dimension = n2;
        return this;
    }

    public DataSetBuilder setEnableErrors(boolean bl2) {
        this.useErrors = bl2;
        return this;
    }

    public DataSetBuilder setUseFloat(boolean bl2) {
        this.useFloat = bl2;
        return this;
    }

    public DataSetBuilder setInitalCapacity(int ... nArray) {
        this.initialCapacity = nArray;
        return this;
    }
}

