/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.dataset.spi;

import io.fair_acc.dataset.AxisDescription;
import io.fair_acc.dataset.DataSet;
import io.fair_acc.dataset.events.ChartBits;
import io.fair_acc.dataset.spi.AbstractDataSet;
import io.fair_acc.dataset.spi.DefaultDataSet;
import io.fair_acc.dataset.spi.DoubleErrorDataSet;
import java.util.ArrayDeque;

public class AveragingDataSet
extends AbstractDataSet<AveragingDataSet>
implements DataSet {
    private static final long serialVersionUID = 1L;
    private int averageSize = 1;
    private int fuzzyCount;
    private InternalDataSet dataset;
    private final ArrayDeque<DataSet> deque = new ArrayDeque();

    public AveragingDataSet(String string) {
        this(string, 2, 0);
    }

    public AveragingDataSet(String string, int n2) {
        this(string, n2, 0);
    }

    public AveragingDataSet(String string, int n2, int n3) {
        super(string, n2);
        this.fuzzyCount = n3;
    }

    public void add(DataSet dataSet) {
        if (this.averageSize == 1) {
            this.dataset = new InternalDataSet(dataSet);
        } else if (this.dataset == null || this.deque.isEmpty()) {
            this.dataset = new InternalDataSet(dataSet);
            this.deque.clear();
            this.deque.add(new InternalDataSet(dataSet));
        } else if (this.deque.size() < this.averageSize) {
            this.dataset.opScale(this.deque.size());
            this.dataset.opAdd(dataSet);
            this.deque.add(new InternalDataSet(dataSet));
            this.dataset.opScale(1.0 / (double)this.deque.size());
        } else {
            this.dataset.opScale(this.deque.size());
            this.dataset.opSub(this.deque.pop());
            this.dataset.opAdd(dataSet);
            this.deque.add(new InternalDataSet(dataSet));
            this.dataset.opScale(1.0 / (double)this.deque.size());
        }
        this.dataset.recomputeLimits(0);
        this.dataset.recomputeLimits(1);
        this.fireInvalidated(ChartBits.DataSetDataAdded);
    }

    public void clear() {
        this.deque.clear();
        this.dataset = null;
    }

    public int getAverageCount() {
        if (this.averageSize == 1) {
            return this.dataset == null ? 0 : 1;
        }
        return this.deque.size();
    }

    public int getAverageSize() {
        return this.averageSize;
    }

    @Override
    public int getDataCount() {
        return this.dataset == null ? 0 : this.dataset.getDataCount();
    }

    public int getFuzzyCount() {
        return this.fuzzyCount;
    }

    @Override
    public String getStyle(int n2) {
        if (this.dataset == null) {
            return "";
        }
        return this.dataset.getStyle(n2);
    }

    @Override
    public final double get(int n2, int n3) {
        if (this.dataset == null) {
            return Double.NaN;
        }
        return this.dataset.get(n2, n3);
    }

    public void setAverageSize(int n2) {
        if (n2 < 1) {
            return;
        }
        if (this.averageSize != n2) {
            this.deque.clear();
            this.dataset = null;
        }
        this.averageSize = n2;
    }

    public void setFuzzyCount(int n2) {
        this.fuzzyCount = n2;
    }

    @Override
    public double getValue(int n2, double ... dArray) {
        return this.get(n2, this.getIndex(0, dArray[0]));
    }

    @Override
    public DataSet set(DataSet dataSet, boolean bl2) {
        this.lock().writeLockGuard(() -> dataSet.lock().writeLockGuard(() -> {
            if (dataSet instanceof AveragingDataSet) {
                this.fuzzyCount = ((AveragingDataSet)dataSet).getFuzzyCount();
                this.averageSize = ((AveragingDataSet)dataSet).getAverageSize();
                if (bl2) {
                    this.clear();
                    ((AveragingDataSet)dataSet2).deque.forEach(dataSet -> this.add(new DefaultDataSet((DataSet)dataSet)));
                } else {
                    this.dataset = ((AveragingDataSet)dataSet2).dataset;
                    this.deque.clear();
                    this.deque.addAll(((AveragingDataSet)dataSet2).deque);
                }
                this.getAxisDescriptions().forEach(AxisDescription::clear);
                for (int i2 = 0; i2 < this.getDimension(); ++i2) {
                    this.recomputeLimits(i2);
                }
                return;
            }
            this.clear();
            if (bl2) {
                this.add(new DefaultDataSet(dataSet));
            } else {
                this.add(dataSet);
            }
            this.getAxisDescriptions().forEach(AxisDescription::clear);
            for (int i3 = 0; i3 < this.getDimension(); ++i3) {
                this.recomputeLimits(i3);
            }
        }));
        this.fireInvalidated(ChartBits.DataSetData);
        return this.getThis();
    }

    private class InternalDataSet
    extends DoubleErrorDataSet {
        private static final long serialVersionUID = 1L;

        public InternalDataSet(DataSet dataSet) {
            super(dataSet.getName(), dataSet.getValues(0), dataSet.getValues(1), new double[dataSet.getDataCount()], new double[dataSet.getDataCount()], dataSet.getDataCount(), true);
        }

        public boolean isIncompatible(DataSet dataSet) {
            return Math.abs(super.getDataCount() - dataSet.getDataCount()) > AveragingDataSet.this.fuzzyCount;
        }

        public void opAdd(DataSet dataSet) {
            if (this.isIncompatible(dataSet)) {
                throw new IllegalArgumentException("Datasets do not match");
            }
            this.yValues.size(dataSet.getDataCount());
            for (int i2 = 0; i2 < this.yValues.size(); ++i2) {
                double[] dArray = this.yValues.elements();
                int n2 = i2;
                dArray[n2] = dArray[n2] + dataSet.get(1, i2);
            }
        }

        public void opScale(double d2) {
            int n2 = 0;
            while (n2 < this.yValues.size()) {
                double[] dArray = this.yValues.elements();
                int n3 = n2++;
                dArray[n3] = dArray[n3] * d2;
            }
        }

        public void opSub(DataSet dataSet) {
            if (this.isIncompatible(dataSet)) {
                throw new IllegalArgumentException("Datasets do not match");
            }
            this.yValues.size(dataSet.getDataCount());
            for (int i2 = 0; i2 < this.yValues.size(); ++i2) {
                double[] dArray = this.yValues.elements();
                int n2 = i2;
                dArray[n2] = dArray[n2] - dataSet.get(1, i2);
            }
        }
    }
}

