/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.dataset.locks;

import io.fair_acc.bench.DurationMeasure;
import io.fair_acc.bench.MeasurementRecorder;
import io.fair_acc.dataset.DataSet;
import io.fair_acc.dataset.locks.DataSetLock;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.StampedLock;
import java.util.function.Supplier;

public class DefaultDataSetLock<D extends DataSet>
implements DataSetLock<D> {
    private static final long serialVersionUID = 1L;
    private final transient StampedLock stampedLock = new StampedLock();
    private final AtomicLong lastReadStamp = new AtomicLong(-1L);
    private final AtomicLong lastWriteStamp = new AtomicLong(-1L);
    private final AtomicLong writerLockedByThreadId = new AtomicLong(-1L);
    private final AtomicInteger readerCount = new AtomicInteger(0);
    private final AtomicInteger writerCount = new AtomicInteger(0);
    private final transient D dataSet;
    private DurationMeasure benchReadLock = DurationMeasure.DISABLED;
    private DurationMeasure benchWriteLock = DurationMeasure.DISABLED;

    public DefaultDataSetLock(D d2) {
        this.dataSet = d2;
        if (d2 == null) {
            throw new IllegalArgumentException("dataSet must not be null");
        }
    }

    @Deprecated(since="still under test")
    public D downGradeWriteLock() {
        if (!this.stampedLock.isWriteLocked()) {
            throw new IllegalStateException("cannot down-convert lock - lock is not write locked");
        }
        if (this.getWriterCount() > 1) {
            throw new IllegalStateException("cannot down-convert lock - holding n write locks = " + this.getWriterCount());
        }
        long l2 = this.stampedLock.tryConvertToReadLock(this.lastWriteStamp.get());
        if (l2 == 0L) {
            throw new IllegalStateException("cannot down-convert lock - tryConvertToReadLock return '0'");
        }
        this.readerCount.incrementAndGet();
        this.writerCount.decrementAndGet();
        if (this.lastReadStamp.get() == 0L && this.stampedLock.isReadLocked() && this.readerCount.get() > 1) {
            this.stampedLock.unlockRead(this.lastReadStamp.get());
        }
        this.lastReadStamp.set(l2);
        return this.dataSet;
    }

    public int getReaderCount() {
        return this.readerCount.get();
    }

    public int getWriterCount() {
        return this.writerCount.get();
    }

    @Override
    public D readLock() {
        long l2;
        this.benchReadLock.start();
        if (this.lastReadStamp.get() == -1L && this.readerCount.get() == 0 && this.lastReadStamp.compareAndExchange(-1L, l2 = this.stampedLock.readLock()) != -1L) {
            this.stampedLock.unlockRead(l2);
        }
        this.readerCount.getAndIncrement();
        this.benchReadLock.stop();
        return this.dataSet;
    }

    @Override
    public D readLockGuard(Runnable runnable) {
        this.readLock();
        try {
            runnable.run();
        }
        finally {
            this.readUnLock();
        }
        return this.dataSet;
    }

    @Override
    public <R> R readLockGuard(Supplier<R> supplier) {
        R r2;
        this.readLock();
        try {
            r2 = supplier.get();
        }
        finally {
            this.readUnLock();
        }
        return r2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public D readLockGuardOptimistic(Runnable runnable) {
        long l2 = this.stampedLock.tryOptimisticRead();
        runnable.run();
        if (this.stampedLock.validate(l2)) {
            return this.dataSet;
        }
        this.readLock();
        try {
            runnable.run();
        }
        finally {
            this.readUnLock();
        }
        return this.dataSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <R> R readLockGuardOptimistic(Supplier<R> supplier) {
        R r2 = supplier.get();
        long l2 = this.stampedLock.tryOptimisticRead();
        if (this.stampedLock.validate(l2)) {
            return r2;
        }
        this.readLock();
        try {
            r2 = supplier.get();
        }
        finally {
            this.readUnLock();
        }
        return r2;
    }

    @Override
    public D readUnLock() {
        long l2;
        if (this.readerCount.get() == 1 && this.lastReadStamp.get() != -1L && this.lastReadStamp.compareAndExchange(l2 = this.lastReadStamp.get(), -1L) == l2) {
            this.stampedLock.unlockRead(l2);
        }
        if (this.readerCount.decrementAndGet() < 0) {
            throw new IllegalStateException("read lock/unlock mismatch - already unlocked");
        }
        return this.dataSet;
    }

    @Override
    public D writeLock() {
        this.benchWriteLock.start();
        long l2 = Thread.currentThread().getId();
        if (this.writerLockedByThreadId.get() != l2) {
            long l3;
            while ((l3 = this.stampedLock.writeLock()) == 0L) {
            }
            this.writerLockedByThreadId.set(l2);
            this.lastWriteStamp.set(l3);
        }
        this.writerCount.incrementAndGet();
        this.benchWriteLock.stop();
        return this.dataSet;
    }

    @Override
    public D writeLockGuard(Runnable runnable) {
        this.writeLock();
        try {
            runnable.run();
        }
        finally {
            this.writeUnLock();
        }
        return this.dataSet;
    }

    @Override
    public <R> R writeLockGuard(Supplier<R> supplier) {
        R r2;
        this.writeLock();
        try {
            r2 = supplier.get();
        }
        finally {
            this.writeUnLock();
        }
        return r2;
    }

    @Override
    public D writeUnLock() {
        if (this.writerCount.decrementAndGet() == 0) {
            long l2 = Thread.currentThread().getId();
            if (this.writerLockedByThreadId.get() != l2) {
                throw new IllegalStateException("unlock attempt by tid = " + l2 + " (" + Thread.currentThread() + ") - but locked by " + this.writerLockedByThreadId.get());
            }
            this.writerLockedByThreadId.set(-1L);
            this.stampedLock.unlockWrite(this.lastWriteStamp.getAndSet(-1L));
        }
        return this.dataSet;
    }

    @Override
    public void setRecorder(MeasurementRecorder measurementRecorder) {
        this.benchReadLock = measurementRecorder.newTraceDuration("lock-readLock");
        this.benchWriteLock = measurementRecorder.newTraceDuration("lock-writeLock");
    }
}

