/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.dataset.events;

import io.fair_acc.dataset.events.BitState;
import io.fair_acc.dataset.events.ChartBits;
import io.fair_acc.dataset.events.EventProcessor;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang3.tuple.Pair;

public class ThreadEventProcessor
implements EventProcessor,
Runnable {
    private static final AtomicReference<ThreadEventProcessor> INSTANCE = new AtomicReference();
    private static EventProcessor userInstance;
    private final Object changeLock = new Object();
    private final BitState state = BitState.initDirtyMultiThreaded(this, ChartBits.DataSetMask).addChangeListener((bitState, n2) -> this.notifyChanged());
    private final List<Pair<BitState, Runnable>> actions = new CopyOnWriteArrayList<Pair<BitState, Runnable>>();

    public static EventProcessor getUserInstance() {
        return userInstance != null ? userInstance : ThreadEventProcessor.getInstance();
    }

    public static void setUserInstance(EventProcessor eventProcessor) {
        userInstance = eventProcessor;
    }

    public static ThreadEventProcessor getInstance() {
        ThreadEventProcessor threadEventProcessor = INSTANCE.get();
        if (threadEventProcessor != null) {
            return threadEventProcessor;
        }
        threadEventProcessor = new ThreadEventProcessor();
        if (INSTANCE.compareAndSet(null, threadEventProcessor)) {
            return threadEventProcessor;
        }
        return INSTANCE.get();
    }

    ThreadEventProcessor() {
        Thread thread = new Thread((Runnable)this, "ChartFx event processor");
        thread.setDaemon(true);
        thread.start();
    }

    @Override
    public void run() {
        while (true) {
            boolean bl2;
            boolean bl3 = bl2 = this.state.clear() != 0;
            if (bl2) {
                for (Pair<BitState, Runnable> pair : this.actions) {
                    if (!((BitState)pair.getLeft()).isDirty(ChartBits.DataSetMask)) continue;
                    ((BitState)pair.getLeft()).clear();
                    try {
                        ((Runnable)pair.getRight()).run();
                    }
                    catch (Exception exception) {}
                }
            }
            this.waitForChanges();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyChanged() {
        Object object = this.changeLock;
        synchronized (object) {
            this.changeLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForChanges() {
        Object object = this.changeLock;
        synchronized (object) {
            if (this.state.isClean()) {
                try {
                    this.changeLock.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    public BitState getBitState() {
        return this.state;
    }

    @Override
    public void addAction(BitState bitState, Runnable runnable) {
        bitState.addInvalidateListener(this.state);
        this.actions.add((Pair<BitState, Runnable>)Pair.of((Object)bitState, (Object)runnable));
    }
}

