/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.dataset;

import io.fair_acc.dataset.Formatter;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public class DefaultNumberFormatter
implements Formatter<Number> {
    protected static final int NO_PREFIX_OFFSET = 8;
    protected static final String SI_PREFIX = "yzafpn\u00b5m kMGTPEZY";
    protected static final String SI_PREFIX_TEST = "yzafpnu\u00b5mkKMGTPEZY";
    protected static final int[] SI_PREFIX_EXP = new int[]{-24, -21, -18, -15, -12, -9, -6, -6, -3, 3, 3, 6, 9, 12, 15, 18, 21, 24};
    protected final DecimalFormat[] decimalFormat = new DecimalFormat[]{new DecimalFormat("#.#", DecimalFormatSymbols.getInstance(Locale.UK)), new DecimalFormat("+#.#", DecimalFormatSymbols.getInstance(Locale.UK)), new DecimalFormat(" #.#;-#.#", DecimalFormatSymbols.getInstance(Locale.UK))};
    protected final DecimalFormat[] decimalFormatMaxPrecision = new DecimalFormat[]{new DecimalFormat("#.#", DecimalFormatSymbols.getInstance(Locale.UK)), new DecimalFormat("#.#", DecimalFormatSymbols.getInstance(Locale.UK)), new DecimalFormat("#.#", DecimalFormatSymbols.getInstance(Locale.UK))};
    protected String fixedLengthFormat;
    protected String fixPrecisionFormat;
    protected String fixPrecisionFormatZero;
    private SignConvention signConvention = SignConvention.EMPTY_SIGN;
    private SignConvention signConventionExp = SignConvention.FORCE_SIGN;
    private int numberOfCharacters = 6;
    private int fixedPrecision = 3;
    private FormatMode formatMode = FormatMode.OPTIMAL_WIDTH;

    public DefaultNumberFormatter() {
        for (DecimalFormat decimalFormat : this.decimalFormat) {
            decimalFormat.setMaximumFractionDigits(20);
        }
        this.setNumberOfCharacters(this.numberOfCharacters);
        this.setFixedPrecision(this.fixedPrecision);
    }

    @Override
    @NotNull
    public Number fromString(@NotNull String string) {
        if (FormatMode.METRIC_PREFIX.equals((Object)this.formatMode)) {
            return DefaultNumberFormatter.metricParse(string, false);
        }
        if (FormatMode.BYTE_PREFIX.equals((Object)this.formatMode)) {
            return DefaultNumberFormatter.metricParse(string, true);
        }
        Double d2 = Double.valueOf(string);
        long l2 = d2.longValue();
        if ((double)l2 == d2) {
            return l2;
        }
        return d2;
    }

    @Override
    public final Class<Number> getClassInstance() {
        return Number.class;
    }

    public int getFixedPrecision() {
        return this.fixedPrecision;
    }

    public void setFixedPrecision(int n2) {
        assert (n2 >= 0) : "precision must be larger 0, is: " + n2;
        this.fixPrecisionFormat = "%." + n2 + "f%c";
        this.fixPrecisionFormatZero = "%." + n2 + "f";
        for (DecimalFormat decimalFormat : this.decimalFormatMaxPrecision) {
            decimalFormat.setMaximumFractionDigits(n2);
        }
        this.fixedPrecision = n2;
    }

    public FormatMode getFormatMode() {
        return this.formatMode;
    }

    public void setFormatMode(FormatMode formatMode) {
        this.formatMode = formatMode;
    }

    public int getNumberOfCharacters() {
        return this.numberOfCharacters;
    }

    public void setNumberOfCharacters(int n2) {
        assert (n2 >= 0) : "numberOfCharacters must be larger 0, is: " + n2;
        this.fixedLengthFormat = "%1$" + n2 + "s";
        this.numberOfCharacters = n2;
    }

    public SignConvention getSignConvention() {
        return this.signConvention;
    }

    public void setSignConvention(SignConvention signConvention) {
        this.signConvention = signConvention;
    }

    public SignConvention getSignConventionExp() {
        return this.signConventionExp;
    }

    public void setSignConventionExp(SignConvention signConvention) {
        this.signConventionExp = signConvention;
    }

    @Override
    @NotNull
    public String toString(@NotNull Number number) {
        if (number.doubleValue() == Double.NEGATIVE_INFINITY) {
            return this.formatMode.fixedWidth() ? String.format(this.fixedLengthFormat, "-\u221e") : "-\u221e";
        }
        if (number.doubleValue() == Double.POSITIVE_INFINITY) {
            return this.formatMode.fixedWidth() ? String.format(this.fixedLengthFormat, "+\u221e") : "+\u221e";
        }
        if (Double.isNaN(number.doubleValue())) {
            return this.formatMode.fixedWidth() ? String.format(this.fixedLengthFormat, "NaN") : "NaN";
        }
        switch (this.formatMode) {
            case METRIC_PREFIX: {
                return this.metricFormat(number.doubleValue(), false);
            }
            case BYTE_PREFIX: {
                return this.metricFormat(number.doubleValue(), true);
            }
            case FIXED_WIDTH_EXP: {
                return DefaultNumberFormatter.expFormatFixedWidth(number, this.numberOfCharacters, this.signConvention, this.signConventionExp);
            }
            case OPTIMAL_WIDTH: {
                return this.optimalWidthFormat(number);
            }
            case FIXED_WIDTH_AND_EXP: 
            case FIXED_WIDTH_ONLY: {
                return this.fixedWidthFormat(number);
            }
        }
        return number.toString();
    }

    protected String fixedWidthFormat(@NotNull Number number) {
        if (number.doubleValue() == 0.0) {
            if (Math.copySign(1.0, number.doubleValue()) > 0.0) {
                return String.format(this.fixedLengthFormat, "0");
            }
            return String.format(this.fixedLengthFormat, "-0");
        }
        String string = this.decimalFormat[this.signConvention.index].format(number);
        int n2 = string.length();
        int n3 = string.indexOf(46);
        if (n3 >= 0 && n3 < this.numberOfCharacters) {
            string = string.substring(0, Math.min(this.numberOfCharacters, n2));
            n2 = string.length();
        }
        if (FormatMode.FIXED_WIDTH_ONLY.equals((Object)this.formatMode)) {
            return n2 >= this.numberOfCharacters ? string : String.format(this.fixedLengthFormat, string);
        }
        double d2 = Math.abs(number.doubleValue());
        String string2 = DefaultNumberFormatter.expFormatFixedWidth(number, this.numberOfCharacters, this.signConvention, this.signConventionExp);
        double d3 = Math.pow(10.0, (double)(-this.numberOfCharacters) + 2.0);
        double d4 = Math.pow(10.0, (double)this.numberOfCharacters - 2.0);
        if ((n2 <= string2.length() || n2 <= 5) && d2 > d3 && d2 < d4) {
            return n2 >= this.numberOfCharacters ? string : String.format(this.fixedLengthFormat, string);
        }
        return string2;
    }

    protected String metricFormat(double d2, boolean bl2) {
        if (d2 == 0.0) {
            return String.format(this.fixPrecisionFormatZero, 0.0);
        }
        int n2 = Math.min((int)Math.floor(bl2 ? Math.log10(Math.abs(d2)) / Math.log10(1024.0) : Math.log10(Math.abs(d2)) / 3.0), SI_PREFIX.length() - 8 - 1);
        int n3 = n2 + 8;
        double d3 = d2 / (bl2 ? Math.pow(1024.0, n2) : Math.pow(10.0, (double)n2 * 3.0));
        if (n3 < 0 || n3 >= SI_PREFIX.length()) {
            return String.format("%." + this.fixedPrecision + "fe%d", d3, n2 * 3);
        }
        return String.format(n3 != 8 ? this.fixPrecisionFormat : this.fixPrecisionFormatZero, d3, Character.valueOf(SI_PREFIX.charAt(n3)));
    }

    protected String optimalWidthFormat(@NotNull Number number) {
        if (number.doubleValue() == 0.0) {
            return "0";
        }
        String string = this.decimalFormatMaxPrecision[SignConvention.NONE.index].format(number);
        int n2 = string.length();
        double d2 = Math.abs(number.doubleValue());
        double d3 = Math.pow(10.0, -this.fixedPrecision);
        String string2 = DefaultNumberFormatter.expFormatFixedPrecision(number.doubleValue(), this.fixedPrecision, SignConvention.NONE, this.signConventionExp);
        return n2 < string2.length() && d2 >= d3 ? string : string2;
    }

    protected static String expFormatFixedPrecision(double d2, int n2, SignConvention signConvention, SignConvention signConvention2) {
        int n3 = (int)Math.floor(Math.log10(Math.abs(d2)));
        double d3 = d2 / Math.pow(10.0, n3);
        return String.format(DefaultNumberFormatter.getSignPrefix(signConvention, d3 >= 0.0) + "." + n2 + "fE" + DefaultNumberFormatter.getSignPrefix(signConvention2, n3 >= 0) + "d", d3, n3);
    }

    protected static String expFormatFixedWidth(Number number, int n2, SignConvention signConvention, SignConvention signConvention2) {
        int n3 = (int)Math.floor(Math.log10(Math.abs(number.doubleValue())));
        int n4 = (n3 == 0 ? 0 : (int)Math.floor(Math.log10(Math.abs(n3)))) + 1;
        double d2 = number.doubleValue() / Math.pow(10.0, n3);
        int n5 = (SignConvention.NONE.equals((Object)signConvention) ? 0 : 1) + (SignConvention.NONE.equals((Object)signConvention2) ? 0 : 1);
        int n6 = Math.max(0, n2 - (3 + n4 + n5));
        return String.format(DefaultNumberFormatter.getSignPrefix(signConvention, d2 >= 0.0) + "." + n6 + "fE" + DefaultNumberFormatter.getSignPrefix(signConvention2, n3 >= 0) + "d", d2, n3);
    }

    protected static String getSignPrefix(SignConvention signConvention, boolean bl2) {
        switch (signConvention) {
            case FORCE_SIGN: {
                return "%+";
            }
            case EMPTY_SIGN: {
                return bl2 ? " %" : "%";
            }
        }
        return "%";
    }

    protected static double metricParse(@NotNull String string, boolean bl2) {
        if (StringUtils.containsAny((CharSequence)string, (CharSequence)SI_PREFIX_TEST)) {
            String[] stringArray = StringUtils.splitByCharacterType((String)string);
            assert (stringArray.length > 1) : "malformed string: '" + string + "'";
            String string2 = stringArray[stringArray.length - 1];
            int n2 = SI_PREFIX_TEST.indexOf(string2.charAt(0));
            assert (n2 >= 0) : "could not find matching index for prefix '" + string2.charAt(0) + "'";
            double d2 = bl2 ? Math.pow(1024.0, (double)SI_PREFIX_EXP[n2] / 3.0) : Math.pow(10.0, SI_PREFIX_EXP[n2]);
            double d3 = Double.parseDouble(string.substring(0, string.length() - 1));
            return d3 * d2;
        }
        return Double.parseDouble(string);
    }

    public static enum SignConvention {
        NONE(0),
        FORCE_SIGN(1),
        EMPTY_SIGN(2);

        private final int index;

        private SignConvention(int n3) {
            this.index = n3;
        }
    }

    public static enum FormatMode {
        FIXED_WIDTH_ONLY,
        FIXED_WIDTH_AND_EXP,
        FIXED_WIDTH_EXP,
        OPTIMAL_WIDTH,
        METRIC_PREFIX,
        BYTE_PREFIX,
        JDK;


        boolean fixedWidth() {
            return this == FIXED_WIDTH_ONLY || this == FIXED_WIDTH_AND_EXP || this == FIXED_WIDTH_EXP;
        }
    }
}

