/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.chartfx.viewer;

import io.fair_acc.chartfx.plugins.MouseEventsHelper;
import io.fair_acc.chartfx.ui.BorderedTitledPane;
import io.fair_acc.chartfx.utils.DragResizerUtil;
import io.fair_acc.chartfx.utils.FXUtils;
import io.fair_acc.chartfx.utils.MouseUtils;
import io.fair_acc.chartfx.viewer.DataView;
import io.fair_acc.chartfx.viewer.SquareButton;
import io.fair_acc.dataset.events.BitState;
import io.fair_acc.dataset.events.ChartBits;
import io.fair_acc.dataset.events.EventSource;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Predicate;
import javafx.beans.DefaultProperty;
import javafx.beans.NamedArg;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.geometry.BoundingBox;
import javafx.geometry.Bounds;
import javafx.geometry.Point2D;
import javafx.geometry.Rectangle2D;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.StackPane;
import javafx.stage.Screen;
import javafx.stage.Stage;
import javafx.stage.Window;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DefaultProperty(value="content")
public class DataViewWindow
extends BorderPane
implements EventSource {
    private static final Logger LOGGER = LoggerFactory.getLogger(DataViewWindow.class);
    private final BitState state = BitState.initDirty(this);
    private static final int MIN_DRAG_BORDER_WIDTH = 20;
    private static final String WINDOW_CSS = "DataViewer.css";
    private static final String CSS_WINDOW = "window";
    private static final String CSS_WINDOW_DETACH_ICON = "window-detach-icon";
    private static final String CSS_WINDOW_CLOSE_ICON = "window-close-icon";
    private static final String CSS_WINDOW_MINIMIZE_ICON = "window-minimize-icon2";
    private static final String CSS_WINDOW_RESTORE_ICON = "window-restore-icon";
    private static final String CSS_WINDOW_MAXIMIZE_ICON = "window-maximize-icon";
    private static final String CSS_WINDOW_TITLE_BAR = "window-titlebar";
    private static final String CSS_TITLE_LABEL = "window-titlelabel";
    private final transient AtomicBoolean updatingStage = new AtomicBoolean(false);
    private final StringProperty name = new SimpleStringProperty((Object)this, "name", "");
    private final HBox leftButtons = new HBox();
    private final Label titleLabel = new Label();
    private final HBox rightButtons = new HBox();
    private final HBox windowDecorationBar = new HBox();
    private final BooleanProperty detachableWindow = new SimpleBooleanProperty((Object)this, "detachableWindow", true);
    private final BooleanProperty minimisedWindow = new SimpleBooleanProperty((Object)this, "minimisedWindow", false);
    private final BooleanProperty maximisedWindow = new SimpleBooleanProperty((Object)this, "maximisedWindow", false);
    private final BooleanProperty restoredWindow = new SimpleBooleanProperty((Object)this, "restoredWindow", true);
    private final BooleanProperty closedWindow = new SimpleBooleanProperty((Object)this, "closedWindow", false);
    private final ObjectProperty<WindowState> windowState = new SimpleObjectProperty<WindowState>((Object)this, "windowState", WindowState.WINDOW_RESTORED){

        public void set(WindowState windowState) {
            if (DataViewWindow.this.windowState.get() == windowState) {
                return;
            }
            switch (windowState) {
                case WINDOW_MINIMISED: {
                    DataViewWindow.this.setMinimised(true);
                    DataViewWindow.this.setMaximised(false);
                    DataViewWindow.this.setRestored(false);
                    break;
                }
                case WINDOW_MAXIMISED: {
                    DataViewWindow.this.setMinimised(false);
                    DataViewWindow.this.setMaximised(true);
                    DataViewWindow.this.setRestored(false);
                    break;
                }
                case WINDOW_RESTORED: {
                    DataViewWindow.this.setMinimised(false);
                    DataViewWindow.this.setMaximised(false);
                    DataViewWindow.this.setRestored(true);
                    break;
                }
                case WINDOW_CLOSED: {
                    DataViewWindow.this.setClosed(true);
                    break;
                }
            }
            super.set((Object)windowState);
            DataViewWindow.this.fireInvalidated(ChartBits.DataViewWindow);
        }
    };
    private final BooleanProperty detachedWindow = new SimpleBooleanProperty((Object)this, "detachedWindow", false);
    private final ObjectProperty<WindowDecoration> windowDecoration = new SimpleObjectProperty((Object)this, "windowDecoration");
    private final ObjectProperty<Node> content = new SimpleObjectProperty((Object)this, "content");
    private final Button detachButton = new SquareButton("window-detach-icon");
    private final Button minimizeButton = new SquareButton("window-minimize-icon2");
    private final Button maximizeRestoreButton = new SquareButton("window-maximize-icon");
    private final Button closeButton = new SquareButton("window-close-icon");
    private final ExternalStage dialog = new ExternalStage();
    private transient double xOffset;
    private transient double yOffset;
    private final ObjectProperty<DataView> parentView = new SimpleObjectProperty((Object)this, "parentView");
    private final Predicate<MouseEvent> mouseFilter = MouseEventsHelper::isOnlyPrimaryButtonDown;
    private final ObjectProperty<Cursor> dragCursor = new SimpleObjectProperty((Object)this, "dragCursor", (Object)Cursor.CLOSED_HAND);
    private Cursor originalCursor;
    private final ObjectProperty<Node> graphic = new SimpleObjectProperty((Object)this, "graphic");
    protected final Runnable maximizeButtonAction = () -> {
        if (this.updatingStage.get() || this.getParentView() == null || this.isDetached()) {
            return;
        }
        this.updatingStage.set(true);
        this.fireInvalidated(ChartBits.DataViewWindow);
        if (this.dialog.isShowing()) {
            this.dialog.maximizeRestore(this);
            this.updatingStage.set(false);
            return;
        }
        if (this.getParentView().getMinimisedChildren().contains((Object)this)) {
            this.fireInvalidated(ChartBits.DataViewWindow);
            this.getParentView().getMinimisedChildren().remove((Object)this);
            this.setMinimised(false);
            this.getParentView().getVisibleChildren().add((Object)this);
            this.setWindowState(WindowState.WINDOW_RESTORED);
            this.updatingStage.set(false);
            return;
        }
        if (this.equals(this.getParentView().getMaximizedChild())) {
            this.maximizeRestoreButton.getStyleClass().setAll((Object[])new String[]{CSS_WINDOW_MAXIMIZE_ICON});
            this.getParentView().setMaximizedChild(null);
            this.getParentView().getVisibleChildren().add((Object)this);
            this.setWindowState(WindowState.WINDOW_RESTORED);
            this.updatingStage.set(false);
            return;
        }
        this.maximizeRestoreButton.getStyleClass().setAll((Object[])new String[]{CSS_WINDOW_RESTORE_ICON});
        this.getParentView().getVisibleChildren().remove((Object)this);
        this.getParentView().setMaximizedChild(this);
        this.setWindowState(WindowState.WINDOW_MAXIMISED);
        this.updatingStage.set(false);
    };
    protected final Runnable minimizeButtonAction = () -> {
        if (this.isDetached() || this.isMinimised()) {
            return;
        }
        this.updatingStage.set(true);
        this.fireInvalidated(ChartBits.DataViewWindow);
        if (this.dialog.isShowing()) {
            this.dialog.hide();
            this.maximizeRestoreButton.getStyleClass().setAll((Object[])new String[]{CSS_WINDOW_MAXIMIZE_ICON});
            this.setWindowState(WindowState.WINDOW_MINIMISED);
            return;
        }
        if (this.equals(this.getParentView().getMaximizedChild())) {
            this.maximizeRestoreButton.getStyleClass().setAll((Object[])new String[]{CSS_WINDOW_MAXIMIZE_ICON});
            this.getParentView().setMaximizedChild(null);
            this.getParentView().getVisibleChildren().add((Object)this);
        }
        this.maximizeRestoreButton.getStyleClass().setAll((Object[])new String[]{CSS_WINDOW_MAXIMIZE_ICON});
        this.getParentView().getVisibleChildren().remove((Object)this);
        this.setWindowState(WindowState.WINDOW_MINIMISED);
        this.getParentView().getMinimisedChildren().add((Object)this);
        this.updatingStage.set(false);
    };
    protected Runnable closeButtonAction = () -> {
        if (this.updatingStage.get() || this.isClosed()) {
            return;
        }
        this.updatingStage.set(true);
        this.fireInvalidated(ChartBits.DataViewWindow);
        this.getParentView().getMinimisedChildren().remove((Object)this);
        this.getParentView().getVisibleChildren().remove((Object)this);
        this.getParentView().getVisibleChildren().remove((Object)this);
        this.getParentView().getUndockedChildren().remove((Object)this);
        if (this.equals(this.getParentView().getMaximizedChild())) {
            this.getParentView().setMaximizedChild(null);
        }
        this.setWindowState(WindowState.WINDOW_CLOSED);
        this.updatingStage.set(false);
    };

    public DataViewWindow(@NamedArg(value="name") String string, @NamedArg(value="content") Node node) {
        this(string, node, WindowDecoration.BAR);
    }

    public DataViewWindow(String string, Node node3, WindowDecoration windowDecoration3) {
        if (node3 == null) {
            throw new IllegalArgumentException("content must not be null");
        }
        this.setName(string);
        GridPane.setHgrow((Node)this, (Priority)Priority.ALWAYS);
        GridPane.setVgrow((Node)this, (Priority)Priority.ALWAYS);
        this.getStyleClass().setAll((Object[])new String[]{CSS_WINDOW});
        this.contentProperty().addListener((observableValue, node, node2) -> this.setLocalCenter((Node)node2));
        DragResizerUtil.makeResizable((Node)this);
        this.leftButtons.setPrefWidth(-1.0);
        HBox.setHgrow((Node)this.leftButtons, (Priority)Priority.SOMETIMES);
        Pane pane = new Pane();
        HBox.setHgrow((Node)pane, (Priority)Priority.ALWAYS);
        this.titleLabel.getStyleClass().setAll((Object[])new String[]{CSS_TITLE_LABEL});
        this.titleLabel.textProperty().bindBidirectional((Property)this.nameProperty());
        HBox.setHgrow((Node)this.titleLabel, (Priority)Priority.ALWAYS);
        Pane pane2 = new Pane();
        HBox.setHgrow((Node)pane2, (Priority)Priority.ALWAYS);
        this.rightButtons.setPrefWidth(-1.0);
        HBox.setHgrow((Node)this.rightButtons, (Priority)Priority.SOMETIMES);
        this.windowDecorationBar.getStyleClass().setAll((Object[])new String[]{CSS_WINDOW_TITLE_BAR});
        this.windowDecorationBar.getChildren().addAll((Object[])new Node[]{this.leftButtons, pane, this.titleLabel, pane2, this.rightButtons});
        this.getLeftIcons().add((Object)this.detachButton);
        this.getRightIcons().addAll((Object[])new Node[]{this.minimizeButton, this.maximizeRestoreButton});
        this.minimisedProperty().addListener((observableValue, bl2, bl3) -> {
            if (!this.isDetached()) {
                this.setLocalCenter(Boolean.TRUE.equals(bl3) ? null : this.getContent());
            }
        });
        this.windowDecorationProperty().addListener((observableValue, windowDecoration, windowDecoration2) -> {
            switch (windowDecoration2) {
                case FRAME: 
                case NONE: {
                    this.setTop(null);
                    break;
                }
                case BAR_WO_CLOSE: {
                    this.setTop((Node)this.getWindowDecorationBar());
                    this.removeCloseWindowButton();
                    break;
                }
                default: {
                    this.setTop((Node)this.getWindowDecorationBar());
                    this.addCloseWindowButton();
                }
            }
            this.setLocalCenter(this.getContent());
        });
        this.setWindowDecoration(windowDecoration3);
        this.minimisedWindow.addListener((observableValue, bl2, bl3) -> this.minimizeButtonAction.run());
        this.maximisedWindow.addListener((observableValue, bl2, bl3) -> this.maximizeButtonAction.run());
        this.restoredWindow.addListener((observableValue, bl2, bl3) -> this.maximizeButtonAction.run());
        this.detachedWindow.addListener((observableValue, bl2, bl3) -> {
            if (Boolean.TRUE.equals(bl3)) {
                if (!this.isDetachableWindow()) {
                    return;
                }
                this.dialog.show(this, null);
            } else {
                this.dialog.hide();
            }
        });
        this.closedWindow.addListener((observableValue, bl2, bl3) -> {
            if (Boolean.TRUE.equals(bl3)) {
                this.closeButtonAction.run();
            }
        });
        this.detachButton.setOnAction(actionEvent -> this.setDetached(true));
        this.detachButton.setId("detachButton");
        this.minimizeButton.setOnAction(actionEvent -> this.minimizeButtonAction.run());
        this.minimizeButton.setId("minimizeButton");
        this.maximizeRestoreButton.setOnAction(actionEvent -> this.maximizeButtonAction.run());
        this.maximizeRestoreButton.setId("maximizeRestoreButton");
        this.closeButton.setOnAction(actionEvent -> this.closeButtonAction.run());
        this.closeButton.setId("closeButton");
        this.windowDecorationBar.setOnMouseReleased(this::dragFinish);
        this.windowDecorationBar.setOnMousePressed(this::dragStart);
        this.windowDecorationBar.setOnMouseDragged(this::dragOngoing);
        this.dialog.setOnHiding(windowEvent -> this.dialog.hide(this));
        this.setMaxSize(Double.MAX_VALUE, Double.MAX_VALUE);
        this.setContent(node3);
    }

    public String getUserAgentStylesheet() {
        return Objects.requireNonNull(DataViewWindow.class.getResource(WINDOW_CSS)).toExternalForm();
    }

    public final void addCloseWindowButton() {
        Button button = this.getCloseButton();
        if (!this.getRightIcons().contains((Object)button)) {
            this.getRightIcons().add((Object)button);
        }
    }

    public BooleanProperty closedProperty() {
        return this.closedWindow;
    }

    public ObjectProperty<Node> contentProperty() {
        return this.content;
    }

    public BooleanProperty detachableWindowProperty() {
        return this.detachableWindow;
    }

    public BooleanProperty detachedProperty() {
        return this.detachedWindow;
    }

    public final ObjectProperty<Cursor> dragCursorProperty() {
        return this.dragCursor;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof DataViewWindow)) {
            return false;
        }
        DataViewWindow dataViewWindow = (DataViewWindow)object;
        return Objects.equals(this.graphic, dataViewWindow.graphic) && Objects.equals(this.name, dataViewWindow.name);
    }

    public Button getCloseButton() {
        return this.closeButton;
    }

    public Node getContent() {
        return (Node)this.contentProperty().get();
    }

    public Button getDetachButton() {
        return this.detachButton;
    }

    public ExternalStage getDialog() {
        return this.dialog;
    }

    public final Cursor getDragCursor() {
        return (Cursor)this.dragCursorProperty().get();
    }

    public final Node getGraphic() {
        return (Node)this.graphicProperty().get();
    }

    public ObservableList<Node> getLeftIcons() {
        return this.leftButtons.getChildren();
    }

    public Button getMaximizeRestoreButton() {
        return this.maximizeRestoreButton;
    }

    public Button getMinimizeButton() {
        return this.minimizeButton;
    }

    public final String getName() {
        return (String)this.nameProperty().get();
    }

    public DataView getParentView() {
        return (DataView)((Object)this.parentViewProperty().get());
    }

    public ObservableList<Node> getRightIcons() {
        return this.rightButtons.getChildren();
    }

    public Label getTitleLabel() {
        return this.titleLabel;
    }

    public WindowDecoration getWindowDecoration() {
        return (WindowDecoration)((Object)this.windowDecorationProperty().get());
    }

    public WindowState getWindowState() {
        return (WindowState)((Object)this.windowStateProperty().get());
    }

    public final ObjectProperty<Node> graphicProperty() {
        return this.graphic;
    }

    public int hashCode() {
        return Objects.hash(this.graphic, this.name);
    }

    public boolean isClosed() {
        return this.closedProperty().get();
    }

    public boolean isDetachableWindow() {
        return this.detachableWindowProperty().get();
    }

    public boolean isDetached() {
        return this.detachedProperty().get();
    }

    public boolean isMaximised() {
        return this.maximisedProperty().get();
    }

    public boolean isMinimised() {
        return this.minimisedProperty().get();
    }

    public boolean isRestored() {
        return this.restoredProperty().get();
    }

    public BooleanProperty maximisedProperty() {
        return this.maximisedWindow;
    }

    public BooleanProperty minimisedProperty() {
        return this.minimisedWindow;
    }

    public final StringProperty nameProperty() {
        return this.name;
    }

    public ObjectProperty<DataView> parentViewProperty() {
        return this.parentView;
    }

    public final void removeCloseWindowButton() {
        Button button = this.getCloseButton();
        this.getLeftIcons().remove((Object)button);
        this.getRightIcons().remove((Object)button);
    }

    public BooleanProperty restoredProperty() {
        return this.restoredWindow;
    }

    public void setClosed(boolean bl2) {
        this.closedProperty().set(bl2);
    }

    public final void setContent(Node node) {
        this.contentProperty().set((Object)node);
    }

    public void setDetachableWindow(boolean bl2) {
        this.detachableWindowProperty().set(bl2);
    }

    public void setDetached(boolean bl2) {
        this.detachedProperty().set(bl2);
    }

    public final void setDragCursor(Cursor cursor) {
        this.dragCursorProperty().set((Object)cursor);
    }

    public final void setGraphic(Node node) {
        this.graphicProperty().set((Object)node);
    }

    public void setMaximised(boolean bl2) {
        this.maximisedProperty().set(bl2);
    }

    public void setMinimised(boolean bl2) {
        this.minimisedProperty().set(bl2);
    }

    public final void setName(String string) {
        this.nameProperty().set((Object)string);
    }

    public void setParentView(DataView dataView) {
        this.parentViewProperty().set((Object)dataView);
    }

    public void setRestored(boolean bl2) {
        this.restoredProperty().set(bl2);
    }

    public void setWindowDecoration(WindowDecoration windowDecoration) {
        this.windowDecorationProperty().set((Object)windowDecoration);
    }

    public String toString() {
        return DataViewWindow.class.getSimpleName() + "(\"" + this.getName() + "\")";
    }

    @Override
    public BitState getBitState() {
        return this.state;
    }

    public ObjectProperty<WindowDecoration> windowDecorationProperty() {
        return this.windowDecoration;
    }

    public ObjectProperty<WindowState> windowStateProperty() {
        return this.windowState;
    }

    protected HBox getWindowDecorationBar() {
        return this.windowDecorationBar;
    }

    protected void installCursor() {
        this.originalCursor = this.getCursor();
        if (this.getDragCursor() != null) {
            this.setCursor(this.getDragCursor());
        }
    }

    protected void setLocalCenter(Node node) {
        switch (this.getWindowDecoration()) {
            case FRAME: {
                if (node == null) {
                    this.setCenter(null);
                    break;
                }
                BorderedTitledPane borderedTitledPane = new BorderedTitledPane(this.getName(), node);
                borderedTitledPane.setOnMousePressed(this::dragStart);
                borderedTitledPane.setOnMouseDragged(this::dragOngoing);
                borderedTitledPane.setOnMouseReleased(this::dragFinish);
                this.setCenter((Node)borderedTitledPane);
                break;
            }
            default: {
                this.setCenter(node);
            }
        }
    }

    protected void setWindowState(WindowState windowState) {
        this.windowStateProperty().set((Object)windowState);
    }

    private void dragFinish(MouseEvent mouseEvent) {
        if (this.isMinimised() || this.getParentView() == null || this.getParentView().getMinimisedChildren().contains((Object)this)) {
            return;
        }
        if (!this.mouseFilter.test(mouseEvent)) {
            return;
        }
        this.uninstallCursor();
        if (!this.isDetachableWindow()) {
            return;
        }
        if (this.getScene() == null) {
            return;
        }
        Point2D point2D = new Point2D(mouseEvent.getScreenX(), mouseEvent.getScreenY());
        Window window = this.getScene().getWindow();
        BoundingBox boundingBox = new BoundingBox(window.getX(), window.getY(), window.getWidth(), window.getHeight());
        Bounds bounds = this.localToScreen(WindowDecoration.FRAME.equals((Object)this.getWindowDecoration()) ? this.getBoundsInLocal() : this.getWindowDecorationBar().getBoundsInLocal());
        if (MouseUtils.mouseOutsideBoundaryBoxDistance(bounds, point2D) > 20.0 && MouseUtils.mouseOutsideBoundaryBoxDistance((Bounds)boundingBox, point2D) > 20.0) {
            if (!this.dialog.isShowing()) {
                this.dialog.show(this, mouseEvent);
                return;
            }
            this.dialog.setX(mouseEvent.getScreenX() - this.xOffset);
            this.dialog.setY(mouseEvent.getScreenY() - this.yOffset);
            return;
        }
        if (!this.dialog.isShowing()) {
            return;
        }
        this.dialog.setX(mouseEvent.getScreenX() - this.xOffset);
        this.dialog.setY(mouseEvent.getScreenY() - this.yOffset);
    }

    private void dragOngoing(MouseEvent mouseEvent) {
        if (!this.mouseFilter.test(mouseEvent)) {
            return;
        }
        this.dialog.setX(mouseEvent.getScreenX() - this.xOffset);
        this.dialog.setY(mouseEvent.getScreenY() - this.yOffset);
    }

    private void dragStart(MouseEvent mouseEvent) {
        if (!this.mouseFilter.test(mouseEvent)) {
            return;
        }
        this.installCursor();
        this.xOffset = mouseEvent.getSceneX();
        this.yOffset = mouseEvent.getSceneY();
    }

    private void uninstallCursor() {
        this.setCursor(this.originalCursor);
    }

    public static enum WindowDecoration {
        NONE,
        BAR,
        BAR_WO_CLOSE,
        FRAME;

    }

    public static enum WindowState {
        WINDOW_RESTORED,
        WINDOW_MINIMISED,
        WINDOW_MAXIMISED,
        WINDOW_CLOSED;

    }

    protected static class ExternalStage
    extends Stage {
        private transient double posX = 640.0;
        private transient double posY = 480.0;
        private transient double width = 640.0;
        private transient double height = 480.0;
        private transient boolean maximized;
        private final transient Scene scene = new Scene((Parent)new StackPane(), 640.0, 480.0);

        public ExternalStage() {
            this.setScene(this.scene);
        }

        public void hide(DataViewWindow dataViewWindow) {
            this.titleProperty().unbind();
            this.scene.setRoot((Parent)new StackPane());
            dataViewWindow.setLocalCenter(dataViewWindow.getContent());
            dataViewWindow.getParentView().getUndockedChildren().remove((Object)dataViewWindow);
            dataViewWindow.getParentView().getVisibleChildren().add((Object)dataViewWindow);
            dataViewWindow.fireInvalidated(ChartBits.DataViewWindow);
        }

        public boolean isMaximised() {
            return this.maximized;
        }

        public void maximizeRestore(DataViewWindow dataViewWindow) {
            if (this.maximized) {
                this.setWidth(this.width);
                this.setHeight(this.height);
                this.setX(this.posX);
                this.setY(this.posY);
                this.maximized = false;
                dataViewWindow.setWindowState(WindowState.WINDOW_RESTORED);
                return;
            }
            Rectangle2D rectangle2D = Screen.getPrimary().getVisualBounds();
            this.width = this.getWidth();
            this.height = this.getHeight();
            this.posX = this.getX();
            this.posY = this.getY();
            this.setX(rectangle2D.getMinX());
            this.setY(rectangle2D.getMinY());
            this.setWidth(rectangle2D.getWidth());
            this.setHeight(rectangle2D.getHeight());
            this.maximized = true;
            dataViewWindow.setWindowState(WindowState.WINDOW_MAXIMISED);
        }

        public void show(DataViewWindow dataViewWindow, MouseEvent mouseEvent) {
            if (this.isShowing()) {
                return;
            }
            if (mouseEvent == null) {
                this.setX(dataViewWindow.getScene().getWindow().getX() + 50.0);
                this.setY(dataViewWindow.getScene().getWindow().getY() + 50.0);
            } else {
                this.setX(mouseEvent.getScreenX());
                this.setY(mouseEvent.getScreenY());
            }
            dataViewWindow.fireInvalidated(ChartBits.DataViewWindow);
            this.posX = this.getX();
            this.posY = this.getY();
            this.titleProperty().set((Object)dataViewWindow.getName());
            this.titleProperty().bind((ObservableValue)dataViewWindow.nameProperty());
            this.show();
            if (dataViewWindow.equals(dataViewWindow.getParentView().getMaximizedChild())) {
                dataViewWindow.getParentView().setMaximizedChild(null);
            }
            dataViewWindow.getParentView().getMinimisedChildren().remove((Object)dataViewWindow);
            dataViewWindow.getParentView().getVisibleChildren().remove((Object)dataViewWindow);
            dataViewWindow.getParentView().getUndockedChildren().add((Object)dataViewWindow);
            dataViewWindow.setLocalCenter(null);
            Node node = dataViewWindow.getContent();
            if (node.getParent() instanceof Pane) {
                FXUtils.assertJavaFxThread();
                ((Pane)node.getParent()).getChildren().remove((Object)node);
            }
            if (node instanceof Pane) {
                this.scene.setRoot((Parent)((Pane)node));
            } else {
                this.scene.setRoot((Parent)new StackPane(new Node[]{node}));
            }
            dataViewWindow.setWindowState(WindowState.WINDOW_RESTORED);
            dataViewWindow.setDetached(true);
            dataViewWindow.fireInvalidated(ChartBits.DataViewWindow);
        }

        private String getName() {
            return this.titleProperty().getValue();
        }
    }
}

