/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.chartfx.viewer;

import io.fair_acc.chartfx.ui.TilingPane;
import io.fair_acc.chartfx.viewer.DataViewWindow;
import io.fair_acc.dataset.utils.NoDuplicatesList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.stream.Collectors;
import javafx.beans.DefaultProperty;
import javafx.beans.NamedArg;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ChangeListener;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.layout.FlowPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DefaultProperty(value="visibleChildren")
public class DataView
extends VBox {
    private static final Logger LOGGER = LoggerFactory.getLogger(DataView.class);
    private final StringProperty name = new SimpleStringProperty((Object)this, "name");
    private final ObjectProperty<Node> icon = new SimpleObjectProperty((Object)this, "icon");
    private final boolean standalone;
    private final FlowPane minimisedElements = new FlowPane();
    private final ObjectProperty<Pane> contentPane = new SimpleObjectProperty((Object)this, "contenPane");
    private final ObjectProperty<DataView> activeSubView = new SimpleObjectProperty((Object)this, "activeView");
    private final ObservableList<DataView> subDataViews = FXCollections.observableList(new NoDuplicatesList());
    private final ObservableList<Node> visibleNodes = FXCollections.observableList(new NoDuplicatesList());
    private final ObservableList<DataViewWindow> visibleChildren = FXCollections.observableList(new NoDuplicatesList());
    private final ObservableList<DataViewWindow> minimisedChildren = FXCollections.observableList(new NoDuplicatesList());
    private final ObservableList<DataViewWindow> undockedChildren = FXCollections.observableList(new NoDuplicatesList());
    private final ObjectProperty<DataViewWindow> maximizedChild = new SimpleObjectProperty<DataViewWindow>((Object)this, "maximizedView"){
        private Optional<DataView> lastActiveView;
        {
            this.lastActiveView = Optional.empty();
        }

        public void set(DataViewWindow dataViewWindow) {
            super.set((Object)dataViewWindow);
            if (dataViewWindow == null) {
                if (this.lastActiveView.isPresent()) {
                    DataView.this.setView(this.lastActiveView.get());
                }
                this.lastActiveView = Optional.empty();
            } else {
                if (this.lastActiveView.isEmpty()) {
                    this.lastActiveView = Optional.of((DataView)((Object)DataView.this.activeSubView.get()));
                }
                DataView.this.setNodeLayout(TilingPane.Layout.MAXIMISE);
            }
        }
    };

    public DataView(@NamedArg(value="name") String string, @NamedArg(value="icon") Node node) {
        this(string, node, null, false);
        this.addStandardViews();
    }

    public DataView(@NamedArg(value="name") String string, @NamedArg(value="icon") Node node, @NamedArg(value="pane") Pane pane) {
        this(string, node, pane, true);
    }

    protected DataView(String string, Node node, Pane pane3, boolean bl2) {
        HBox.setHgrow((Node)this, (Priority)Priority.ALWAYS);
        VBox.setVgrow((Node)this, (Priority)Priority.ALWAYS);
        this.standalone = bl2;
        VBox.setVgrow((Node)this.minimisedElements, (Priority)Priority.NEVER);
        HBox.setHgrow((Node)this.minimisedElements, (Priority)Priority.NEVER);
        this.minimisedElements.setPrefWrapLength(0.0);
        ChangeListener changeListener = (observableValue, number, number2) -> this.minimisedElements.setPrefWrapLength(number2.doubleValue());
        this.contentPaneProperty().addListener((observableValue, pane, pane2) -> {
            if (pane != null) {
                pane.widthProperty().removeListener(changeListener);
            }
            if (pane2 != null) {
                pane2.widthProperty().addListener(changeListener);
            }
        });
        this.setFillWidth(true);
        this.setActiveSubView(this);
        this.registerListListener();
        this.activeSubView.addListener((observableValue, dataView, dataView2) -> {
            if (dataView2 == null) {
                this.getChildren().clear();
                return;
            }
            if (!this.getSubDataViews().contains((Object)dataView2)) {
                this.getSubDataViews().add((Object)dataView2);
            }
            if (dataView2.isStandalone()) {
                this.getChildren().setAll((Object[])new Node[]{dataView2});
                return;
            }
            for (DataView dataView3 : this.getSubDataViews()) {
                if (dataView3.isStandalone()) continue;
                dataView3.getContentPane().getChildren().clear();
            }
            if (this.getMaximizedChild() == null) {
                this.getVisibleChildren().forEach(dataViewWindow -> {
                    if (!this.getActiveView().getContentPane().getChildren().contains(dataViewWindow)) {
                        this.getActiveView().getContentPane().getChildren().add(dataViewWindow);
                    }
                });
            } else {
                this.getActiveView().getContentPane().getChildren().setAll((Object[])new Node[]{this.getMaximizedChild()});
            }
            this.getChildren().setAll((Object[])new Node[]{this.getActiveView().getContentPane(), this.minimisedElements});
        });
        this.setName(string == null ? "" : string);
        this.setIcon(node);
        this.setContentPane((Pane)(pane3 == null ? new StackPane() : pane3));
        if (this.standalone) {
            this.getChildren().setAll((Object[])new Node[]{this.getContentPane()});
        }
    }

    public ObjectProperty<DataView> activeSubViewProperty() {
        return this.activeSubView;
    }

    public ObjectProperty<Pane> contentPaneProperty() {
        return this.contentPane;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof DataView)) {
            return false;
        }
        DataView dataView = (DataView)((Object)object);
        return this.getName().equals(dataView.getName());
    }

    public DataView getActiveView() {
        return (DataView)((Object)this.activeSubViewProperty().get());
    }

    public Pane getContentPane() {
        return (Pane)this.contentPaneProperty().get();
    }

    public Node getIcon() {
        return (Node)this.iconProperty().get();
    }

    public final DataViewWindow getMaximizedChild() {
        return (DataViewWindow)this.maximizedChildProperty().get();
    }

    public final ObservableList<DataViewWindow> getMinimisedChildren() {
        return this.minimisedChildren;
    }

    public final Pane getMinimisedElementsPane() {
        return this.minimisedElements;
    }

    public final String getName() {
        return (String)this.nameProperty().get();
    }

    public final ObservableList<DataView> getSubDataViews() {
        return this.subDataViews;
    }

    public final ObservableList<DataViewWindow> getUndockedChildren() {
        return this.undockedChildren;
    }

    public final ObservableList<DataViewWindow> getVisibleChildren() {
        return this.visibleChildren;
    }

    public final ObservableList<Node> getVisibleNodes() {
        return this.visibleNodes;
    }

    public int hashCode() {
        int n2 = 31;
        int n3 = 1;
        n3 = 31 * n3 + (this.name.get() == null ? 0 : ((String)this.name.get()).hashCode());
        return n3;
    }

    public final ObjectProperty<Node> iconProperty() {
        return this.icon;
    }

    public boolean isStandalone() {
        return this.standalone;
    }

    public final ObjectProperty<DataViewWindow> maximizedChildProperty() {
        return this.maximizedChild;
    }

    public final StringProperty nameProperty() {
        return this.name;
    }

    public void setActiveSubView(DataView dataView) {
        this.activeSubViewProperty().set((Object)dataView);
    }

    public final void setContentPane(Pane pane) {
        this.contentPaneProperty().set((Object)pane);
    }

    public final void setIcon(Node node) {
        this.iconProperty().set((Object)node);
    }

    public final void setMaximizedChild(DataViewWindow dataViewWindow) {
        this.maximizedChildProperty().set((Object)dataViewWindow);
    }

    public final void setName(String string) {
        this.nameProperty().set((Object)string);
    }

    public void setNodeLayout(TilingPane.Layout layout) {
        Optional<DataView> optional = this.getSubDataViews().stream().filter(dataView -> dataView.getName().equals(layout.getName())).findFirst();
        if (optional.isPresent()) {
            this.setView(optional.get());
            return;
        }
        LOGGER.atWarn().addArgument((Object)layout).log("could not find view for requested  layout '{}'");
    }

    public void setView(DataView dataView) {
        if (dataView == null || dataView.equals((Object)this.getActiveView())) {
            return;
        }
        this.setActiveSubView(dataView);
    }

    public void setView(String string) {
        if (string == null) {
            LOGGER.atWarn().log("viewerPaneName is null");
            return;
        }
        Optional<DataView> optional = this.getSubDataViews().stream().filter(dataView -> dataView.getName().equals(string)).findFirst();
        if (optional.isEmpty()) {
            LOGGER.atWarn().addArgument(string).log("no DataView for viewerPaneName '{}'");
            return;
        }
        this.setView(optional.get());
    }

    public void sort() {
        if (this.isStandalone() || this.getContentPane() == null || this.getContentPane().getChildren().isEmpty()) {
            return;
        }
        FXCollections.sort((ObservableList)this.getContentPane().getChildren(), Comparator.comparing(node -> node.toString().toLowerCase(Locale.UK)));
    }

    public String toString() {
        return DataView.class.getSimpleName() + "(\"" + this.getName() + "\")";
    }

    protected void addStandardViews() {
        for (TilingPane.Layout layout : TilingPane.Layout.values()) {
            DataView dataView = new DataView(layout.getName(), null, (Pane)new TilingPane(layout), false);
            this.subDataViews.add((Object)dataView);
        }
        this.setNodeLayout(TilingPane.Layout.GRID);
    }

    protected Collection<Node> getWrappedChildren(Collection<Node> collection) {
        ArrayList<Node> arrayList = new ArrayList<Node>();
        for (Node node : collection) {
            if (node instanceof DataViewWindow) {
                arrayList.add(node);
                continue;
            }
            DataViewWindow dataViewWindow = new DataViewWindow("", node);
            dataViewWindow.setParentView(this);
            dataViewWindow.setMinimised(true);
            arrayList.add((Node)dataViewWindow);
        }
        return arrayList;
    }

    protected void registerListListener() {
        this.visibleNodes.addListener(change -> {
            while (change.next()) {
                for (Node node2 : change.getRemoved()) {
                    DataView.removeChildFromList(this.visibleChildren, node2);
                    DataView.removeChildFromList(this.minimisedChildren, node2);
                    DataView.removeChildFromList(this.undockedChildren, node2);
                    if (!node2.equals(this.maximizedChild.get())) continue;
                    this.setMaximizedChild(null);
                }
                change.getAddedSubList().forEach(node -> {
                    HBox.setHgrow((Node)node, (Priority)Priority.ALWAYS);
                    VBox.setVgrow((Node)node, (Priority)Priority.ALWAYS);
                    if (node instanceof DataViewWindow) {
                        if (this.getActiveView().isStandalone()) {
                            return;
                        }
                        if (!this.getActiveView().getContentPane().getChildren().contains(node)) {
                            this.getActiveView().getContentPane().getChildren().add(node);
                        }
                        this.visibleChildren.add((Object)((DataViewWindow)node));
                        return;
                    }
                    DataViewWindow dataViewWindow = new DataViewWindow("", (Node)node);
                    dataViewWindow.setParentView(this);
                    this.visibleChildren.add((Object)dataViewWindow);
                });
            }
        });
        this.visibleChildren.addListener(change -> {
            while (change.next()) {
                if (this.getActiveView() == null) continue;
                if (this.getActiveView().isStandalone()) {
                    return;
                }
                change.getRemoved().forEach(dataViewWindow -> this.getActiveView().getContentPane().getChildren().remove(dataViewWindow));
                change.getAddedSubList().stream().filter(dataViewWindow -> !this.getActiveView().getContentPane().getChildren().contains(dataViewWindow)).forEach(dataViewWindow -> {
                    dataViewWindow.setParentView(this);
                    this.getActiveView().getContentPane().getChildren().add(dataViewWindow);
                });
            }
        });
        this.minimisedChildren.addListener(change -> {
            while (change.next()) {
                this.minimisedElements.getChildren().removeAll((Collection)change.getRemoved());
                change.getAddedSubList().forEach(dataViewWindow -> {
                    dataViewWindow.setParentView(this);
                    if (!dataViewWindow.isMinimised() && dataViewWindow.getWindowState().equals((Object)DataViewWindow.WindowState.WINDOW_RESTORED)) {
                        dataViewWindow.setMinimised(true);
                    }
                });
                this.minimisedElements.getChildren().addAll((Collection)change.getAddedSubList().stream().filter(dataViewWindow -> !this.minimisedElements.getChildren().contains(dataViewWindow)).collect(Collectors.toList()));
            }
        });
        this.undockedChildren.addListener(change -> {
            while (change.next()) {
                this.minimisedElements.getChildren().removeAll((Collection)change.getRemoved());
                this.visibleChildren.removeAll((Collection)change.getRemoved());
                this.minimisedChildren.removeAll((Collection)change.getRemoved());
                change.getRemoved().forEach(dataViewWindow -> dataViewWindow.setDetached(false));
                change.getAddedSubList().forEach(dataViewWindow -> {
                    dataViewWindow.setParentView(this);
                    dataViewWindow.setDetached(true);
                });
            }
        });
        this.contentPane.addListener((observableValue, pane, pane2) -> {
            if (pane2 == null || pane2.equals(pane)) {
                return;
            }
            if (this.isStandalone()) {
                this.getChildren().setAll((Object[])new Node[]{pane2});
            } else {
                this.getChildren().setAll((Object[])new Node[]{pane2, this.minimisedElements});
            }
        });
    }

    private static void removeChildFromList(List<DataViewWindow> list, Node node) {
        Optional<DataViewWindow> optional = list.stream().filter(dataViewWindow -> node.equals(dataViewWindow.getContent())).findFirst();
        if (optional.isPresent()) {
            list.remove(optional.get());
        }
    }
}

