/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.chartfx.utils;

import io.fair_acc.chartfx.Chart;
import io.fair_acc.chartfx.XYChart;
import java.util.LinkedList;
import java.util.List;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.Label;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;

public final class XYChartUtils {
    private XYChartUtils() {
    }

    public static Chart getChart(Node node) {
        Node node2;
        for (node2 = node; node2 != null && !(node2 instanceof Chart); node2 = node2.getParent()) {
        }
        return (Chart)node2;
    }

    public static Region getChartContent(Chart chart) {
        return (Region)chart.lookup(".chart-content");
    }

    public static List<Label> getChildLabels(List<? extends Parent> list) {
        LinkedList<Label> linkedList = new LinkedList<Label>();
        for (Parent parent : list) {
            for (Node node : parent.getChildrenUnmodifiable()) {
                if (!(node instanceof Label)) continue;
                linkedList.add((Label)node);
            }
        }
        return linkedList;
    }

    public static double getHorizontalInsets(Insets insets) {
        return insets.getLeft() + insets.getRight();
    }

    public static Pane getLegend(XYChart xYChart) {
        return (Pane)xYChart.lookup(".chart-legend");
    }

    public static double getLocationX(Node node) {
        return node.getLayoutX() + node.getTranslateX();
    }

    public static double getLocationY(Node node) {
        return node.getLayoutY() + node.getTranslateY();
    }

    public static Node getPlotContent(XYChart xYChart) {
        return xYChart.lookup(".plot-content");
    }

    public static double getVerticalInsets(Insets insets) {
        return insets.getTop() + insets.getBottom();
    }
}

