/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.chartfx.utils;

import ar.com.hjg.pngj.FilterType;
import ar.com.hjg.pngj.ImageInfo;
import ar.com.hjg.pngj.ImageLineHelper;
import ar.com.hjg.pngj.ImageLineInt;
import ar.com.hjg.pngj.PngWriter;
import ar.com.hjg.pngj.chunks.PngChunk;
import ar.com.hjg.pngj.chunks.PngChunkPLTE;
import ar.com.hjg.pngj.chunks.PngChunkTRNS;
import io.fair_acc.chartfx.utils.PaletteQuantizer;
import io.fair_acc.chartfx.utils.PaletteQuantizerNeuQuant;
import io.fair_acc.chartfx.utils.WritableImageCache;
import io.fair_acc.dataset.utils.ArrayCache;
import io.fair_acc.dataset.utils.ByteBufferOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Map;
import java.util.zip.CRC32;
import java.util.zip.Deflater;
import javafx.scene.image.Image;
import javafx.scene.image.PixelReader;
import javafx.scene.image.PixelWriter;
import javafx.scene.image.WritableImage;
import javafx.scene.paint.Color;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class WriteFxImage {
    private static final Logger LOGGER = LoggerFactory.getLogger(WriteFxImage.class);
    private static final int DEFAULT_PALETTE_COLOR_COUNT = 256;
    private static final String IMAGE_PIXEL_READER_NOT_AVAILABLE = "image PixelReader not available";
    private static final String IMAGE_MUST_NOT_BE_NULL = "image must not be null";
    private static final int HEADER_SIZE = 57;
    private static final String INTERNAL_ARRAY_CACHE_NAME = "WriteFxImage-internalArray";
    private static final String INTERNAL_LINE_ARRAY_CACHE_NAME = "WriteFxImage-internalLineArray";

    private WriteFxImage() {
    }

    public static WritableImage clone(Image image) {
        int n2 = (int)image.getHeight();
        int n3 = (int)image.getWidth();
        WritableImage writableImage = WritableImageCache.getInstance().getImage(n3, n2);
        PixelWriter pixelWriter = writableImage.getPixelWriter();
        if (pixelWriter == null) {
            throw new IllegalStateException(IMAGE_PIXEL_READER_NOT_AVAILABLE);
        }
        PixelReader pixelReader = image.getPixelReader();
        if (pixelReader == null) {
            throw new IllegalStateException(IMAGE_PIXEL_READER_NOT_AVAILABLE);
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            for (int i3 = 0; i3 < n3; ++i3) {
                Color color = pixelReader.getColor(i3, i2);
                pixelWriter.setColor(i3, i2, color);
            }
        }
        return writableImage;
    }

    public static void copyImageDataToPixelBuffer(Image image, int[] nArray) {
        int n2;
        if (image == null) {
            throw new IllegalArgumentException("image is null");
        }
        PixelReader pixelReader = image.getPixelReader();
        if (pixelReader == null) {
            throw new IllegalStateException(IMAGE_PIXEL_READER_NOT_AVAILABLE);
        }
        if (nArray == null) {
            throw new IllegalArgumentException("uncompressedImageData is null");
        }
        int n3 = (int)image.getWidth();
        int n4 = n3 * (n2 = (int)image.getHeight());
        if (nArray.length < n4) {
            throw new IllegalArgumentException("uncompressedImageData.length = " + nArray.length + " too small, should be at least" + n4);
        }
        int n5 = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            for (int i3 = 0; i3 < n3; ++i3) {
                nArray[n5++] = pixelReader.getArgb(i3, i2);
            }
        }
    }

    public static ByteBuffer encode(Image image) {
        return WriteFxImage.encode(image, null, true, 1, null);
    }

    public static ByteBuffer encode(Image image, ByteBuffer byteBuffer, boolean bl2, int n2, FilterType filterType) {
        ByteBuffer byteBuffer2;
        if (image == null) {
            throw new IllegalArgumentException(IMAGE_MUST_NOT_BE_NULL);
        }
        PixelReader pixelReader = image.getPixelReader();
        if (pixelReader == null) {
            throw new IllegalStateException(IMAGE_PIXEL_READER_NOT_AVAILABLE);
        }
        int n3 = (int)image.getWidth();
        int n4 = (int)image.getHeight();
        ByteBuffer byteBuffer3 = byteBuffer == null ? ByteBuffer.allocate(WriteFxImage.getCompressedSizeBound(n3, n4, bl2)) : byteBuffer;
        ByteBufferOutputStream byteBufferOutputStream = new ByteBufferOutputStream(byteBuffer3, false);
        try {
            PngWriter pngWriter = new PngWriter(byteBufferOutputStream, new ImageInfo(n3, n4, 8, bl2, false, false));
            pngWriter.getPixelsWriter().setFilterType(filterType == null ? FilterType.FILTER_NONE : filterType);
            pngWriter.setIdatMaxSize(65536);
            pngWriter.setCompLevel(n2);
            ImageLineInt imageLineInt = new ImageLineInt(pngWriter.imgInfo);
            if (bl2) {
                for (var12_15 = 0; var12_15 < n4; ++var12_15) {
                    for (int i2 = 0; i2 < n3; ++i2) {
                        int n5 = pixelReader.getArgb(i2, var12_15);
                        ImageLineHelper.setPixelRGBA8(imageLineInt, i2, n5);
                    }
                    pngWriter.writeRow(imageLineInt, var12_15);
                }
            } else {
                for (var12_15 = 0; var12_15 < n4; ++var12_15) {
                    for (int i3 = 0; i3 < n3; ++i3) {
                        int n6 = pixelReader.getArgb(i3, var12_15);
                        ImageLineHelper.setPixelRGB8(imageLineInt, i3, n6);
                    }
                    pngWriter.writeRow(imageLineInt, var12_15);
                }
            }
            pngWriter.end();
            byteBuffer2 = byteBufferOutputStream.buffer().flip();
        }
        catch (Throwable throwable) {
            try {
                try {
                    byteBufferOutputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException iOException) {
                LOGGER.atError().setCause(iOException).log("buffer couldn't be closes");
                return null;
            }
        }
        byteBufferOutputStream.close();
        return byteBuffer2;
    }

    public static ByteBuffer encodeAlt(Image image, ByteBuffer byteBuffer, boolean bl2, int n2, Map<String, Object> map) {
        if (image == null) {
            throw new IllegalArgumentException(IMAGE_MUST_NOT_BE_NULL);
        }
        PixelReader pixelReader = image.getPixelReader();
        if (pixelReader == null) {
            throw new IllegalStateException(IMAGE_PIXEL_READER_NOT_AVAILABLE);
        }
        int n3 = (int)image.getWidth();
        int n4 = (int)image.getHeight();
        ByteBuffer byteBuffer2 = byteBuffer == null ? ByteBuffer.allocate(WriteFxImage.getCompressedSizeBound(n3, n4, bl2)) : byteBuffer;
        CRC32 cRC32 = new CRC32();
        Deflater deflater = new Deflater(n2);
        WriteFxImage.writeImageHeader(n3, n4, bl2, byteBuffer2, cRC32);
        WriteFxImage.writeImageData(pixelReader, n3, n4, bl2, deflater, byteBuffer2, cRC32);
        WriteFxImage.writeImageFooter(byteBuffer2, cRC32);
        byteBuffer2.flip();
        if (map != null) {
            int n5 = bl2 ? 4 : 3;
            map.put("bufferSize", byteBuffer2.capacity());
            map.put("outputSizeBound", WriteFxImage.getCompressedSizeBound(n3, n4, bl2));
            map.put("compression", (double)deflater.getBytesWritten() / (double)(n3 * n4 * n5));
            map.put("width", n3);
            map.put("height", n4);
            map.put("colorMode", bl2 ? "rgba" : "rgb");
            map.put("compressionLevel", n2);
            map.put("outputSize", byteBuffer2.limit() - byteBuffer2.position());
        }
        return byteBuffer2;
    }

    public static ByteBuffer encodePalette(Image image, ByteBuffer byteBuffer, boolean bl2, int n2, FilterType filterType, PaletteQuantizer ... paletteQuantizerArray) {
        ByteBuffer byteBuffer2;
        if (image == null) {
            throw new IllegalArgumentException(IMAGE_MUST_NOT_BE_NULL);
        }
        int n3 = (int)image.getWidth();
        int n4 = (int)image.getHeight();
        int n5 = n3 * n4;
        int[] nArray = ArrayCache.getCachedIntArray(INTERNAL_ARRAY_CACHE_NAME, n5);
        WriteFxImage.copyImageDataToPixelBuffer(image, nArray);
        PaletteQuantizer paletteQuantizer = paletteQuantizerArray.length > 0 && paletteQuantizerArray[0] != null ? paletteQuantizerArray[0] : WriteFxImage.estimatePalette(nArray, n3, n4, bl2, 256);
        int n6 = 3;
        int n7 = 3 * paletteQuantizer.getColorCount();
        int n8 = WriteFxImage.getCompressedSizeBound(n3, n4, bl2) + n7;
        ByteBuffer byteBuffer3 = byteBuffer == null ? ByteBuffer.allocate(n8) : byteBuffer;
        ByteBufferOutputStream byteBufferOutputStream = new ByteBufferOutputStream(byteBuffer3, false);
        try {
            ImageInfo imageInfo = new ImageInfo(n3, n4, 8, false, false, true);
            PngWriter pngWriter = new PngWriter(byteBufferOutputStream, imageInfo);
            pngWriter.getPixelsWriter().setFilterType(filterType);
            pngWriter.setIdatMaxSize(n8 > 131072 ? 65536 : 32000);
            pngWriter.setCompLevel(n2);
            WriteFxImage.preparePaletteHeader(pngWriter, paletteQuantizer);
            int[] nArray2 = ArrayCache.getCachedIntArray(INTERNAL_LINE_ARRAY_CACHE_NAME, n3);
            ImageLineInt imageLineInt = new ImageLineInt(pngWriter.imgInfo, nArray2);
            if (bl2) {
                var20_23 = 0;
                for (int i2 = 0; i2 < n5; ++i2) {
                    int n9 = i2 % n3;
                    int n10 = nArray[i2];
                    nArray2[n9] = paletteQuantizer.lookup(n10 >> 16 & 0xFF, n10 >> 8 & 0xFF, n10 & 0xFF, n10 >> 24 & 0xFF);
                    if (n9 != n3 - 1) continue;
                    pngWriter.writeRow(imageLineInt, var20_23++);
                }
            } else {
                for (var20_23 = 0; var20_23 < n5; ++var20_23) {
                    int n11 = var20_23 % n3;
                    int n12 = nArray[var20_23];
                    nArray2[n11] = paletteQuantizer.lookup(n12 >> 16 & 0xFF, n12 >> 8 & 0xFF, n12 & 0xFF);
                    if (n11 != n3 - 1) continue;
                    pngWriter.writeRow(imageLineInt);
                }
            }
            pngWriter.end();
            ArrayCache.release(INTERNAL_ARRAY_CACHE_NAME, nArray);
            ArrayCache.release(INTERNAL_LINE_ARRAY_CACHE_NAME, nArray2);
            byteBuffer2 = byteBufferOutputStream.buffer().flip();
        }
        catch (Throwable throwable) {
            try {
                try {
                    byteBufferOutputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException iOException) {
                LOGGER.atError().setCause(iOException).log("buffer couldn't be closed");
                return null;
            }
        }
        byteBufferOutputStream.close();
        return byteBuffer2;
    }

    public static PaletteQuantizer estimatePalette(Image image, boolean bl2, int n4) {
        if (image == null) {
            throw new IllegalArgumentException(IMAGE_MUST_NOT_BE_NULL);
        }
        PixelReader pixelReader = image.getPixelReader();
        if (pixelReader == null) {
            throw new IllegalStateException(IMAGE_PIXEL_READER_NOT_AVAILABLE);
        }
        int n5 = (int)image.getWidth();
        int n6 = (int)image.getHeight();
        PaletteQuantizerNeuQuant paletteQuantizerNeuQuant = new PaletteQuantizerNeuQuant(n5, n6, (n2, n3) -> pixelReader.getArgb(n3, n2));
        paletteQuantizerNeuQuant.setParReserveAlphaColor(bl2);
        paletteQuantizerNeuQuant.setParNcolors(n4);
        paletteQuantizerNeuQuant.run();
        return paletteQuantizerNeuQuant;
    }

    public static PaletteQuantizer estimatePalette(int[] nArray, int n2, int n5, boolean bl2, int n6) {
        if (nArray == null) {
            throw new IllegalArgumentException("pixelArray must not be null");
        }
        if (nArray.length < n2 * n5) {
            throw new IllegalArgumentException("pixelArray.length(" + nArray.length + " must be >= " + n2 * n5 + " = " + n2 + " (width) x" + n5 + " (height)");
        }
        PaletteQuantizerNeuQuant paletteQuantizerNeuQuant = new PaletteQuantizerNeuQuant(n2, n5, (n3, n4) -> nArray[n3 * n2 + n4]);
        paletteQuantizerNeuQuant.setParReserveAlphaColor(bl2);
        paletteQuantizerNeuQuant.setParNcolors(n6);
        paletteQuantizerNeuQuant.run();
        return paletteQuantizerNeuQuant;
    }

    public static int getCompressedSizeBound(int n2, int n3, boolean bl2) {
        int n4 = bl2 ? 4 : 3;
        int n5 = n2 * n3 * n4 + n3 + 57;
        int n6 = n5 + (n5 + 7 >> 3) + (n5 + 63 >> 6) + 5;
        return n6 + 57;
    }

    public static void savePng(Image image, File file) throws IOException {
        try (OutputStream outputStream = Files.newOutputStream(file.toPath(), new OpenOption[0]);){
            ByteBuffer byteBuffer = WriteFxImage.encode(image);
            outputStream.write(byteBuffer.array(), 0, byteBuffer.limit());
        }
    }

    private static void preparePaletteHeader(PngWriter pngWriter, PaletteQuantizer paletteQuantizer) {
        Object object;
        int n2;
        PngChunkPLTE pngChunkPLTE = pngWriter.getMetadata().createPLTEChunk();
        int n3 = paletteQuantizer.getColorCount();
        pngChunkPLTE.setNentries(n3);
        for (n2 = 0; n2 < n3; ++n2) {
            object = paletteQuantizer.getColor(n2);
            pngChunkPLTE.setEntry(n2, object[0], object[1], (int)object[2]);
        }
        n2 = paletteQuantizer.getTransparentIndex();
        if (n2 >= 0) {
            object = new PngChunkTRNS(pngWriter.imgInfo);
            ((PngChunkTRNS)object).setIndexEntryAsTransparent(n2);
            pngWriter.getChunksList().queue((PngChunk)object);
        }
    }

    private static void write(byte[] byArray, ByteBuffer byteBuffer, CRC32 cRC32) {
        byteBuffer.put(byArray);
        cRC32.update(byArray);
    }

    private static void write(int n2, ByteBuffer byteBuffer, CRC32 cRC32) {
        byte[] byArray = new byte[]{(byte)(n2 >> 24 & 0xFF), (byte)(n2 >> 16 & 0xFF), (byte)(n2 >> 8 & 0xFF), (byte)(n2 & 0xFF)};
        WriteFxImage.write(byArray, byteBuffer, cRC32);
    }

    private static void writeImageData(PixelReader pixelReader, int n2, int n3, boolean bl2, Deflater deflater, ByteBuffer byteBuffer, CRC32 cRC32) {
        int n4 = bl2 ? 4 : 3;
        int n5 = n2 * n3 * n4 + n3;
        byte[] byArray = ArrayCache.getCachedByteArray(INTERNAL_ARRAY_CACHE_NAME, n5);
        int n6 = 0;
        if (bl2) {
            for (int i2 = 0; i2 < n3; ++i2) {
                byArray[n6++] = 0;
                for (int i3 = 0; i3 < n2; ++i3) {
                    int n7 = pixelReader.getArgb(i3, i2);
                    byArray[n6++] = (byte)(n7 >> 16 & 0xFF);
                    byArray[n6++] = (byte)(n7 >> 8 & 0xFF);
                    byArray[n6++] = (byte)(n7 & 0xFF);
                    byArray[n6++] = (byte)(n7 >> 24 & 0xFF);
                }
            }
        } else {
            for (int i4 = 0; i4 < n3; ++i4) {
                byArray[n6++] = 0;
                for (int i5 = 0; i5 < n2; ++i5) {
                    int n8 = pixelReader.getArgb(i5, i4);
                    byArray[n6++] = (byte)(n8 >> 16 & 0xFF);
                    byArray[n6++] = (byte)(n8 >> 8 & 0xFF);
                    byArray[n6++] = (byte)(n8 & 0xFF);
                }
            }
        }
        deflater.setInput(byArray);
        byteBuffer.mark();
        byteBuffer.putInt(0);
        byteBuffer.put("IDAT".getBytes());
        deflater.finish();
        deflater.deflate(byteBuffer, 3);
        byteBuffer.limit(byteBuffer.position());
        byteBuffer.reset();
        byteBuffer.putInt(deflater.getTotalOut());
        cRC32.reset();
        cRC32.update(byteBuffer);
        byteBuffer.limit(byteBuffer.capacity());
        byteBuffer.putInt((int)cRC32.getValue());
        ArrayCache.release(INTERNAL_ARRAY_CACHE_NAME, byArray);
    }

    private static void writeImageFooter(ByteBuffer byteBuffer, CRC32 cRC32) {
        byteBuffer.putInt(0);
        cRC32.reset();
        WriteFxImage.write("IEND".getBytes(), byteBuffer, cRC32);
        byteBuffer.putInt((int)cRC32.getValue());
    }

    private static void writeImageHeader(int n2, int n3, boolean bl2, ByteBuffer byteBuffer, CRC32 cRC32) {
        byte[] byArray;
        byteBuffer.put(new byte[]{-119, 80, 78, 71, 13, 10, 26, 10});
        byteBuffer.putInt(13);
        cRC32.reset();
        WriteFxImage.write("IHDR".getBytes(), byteBuffer, cRC32);
        WriteFxImage.write(n2, byteBuffer, cRC32);
        WriteFxImage.write(n3, byteBuffer, cRC32);
        if (bl2) {
            byte[] byArray2 = new byte[5];
            byArray2[0] = 8;
            byArray2[1] = 6;
            byArray2[2] = 0;
            byArray2[3] = 0;
            byArray = byArray2;
            byArray2[4] = 0;
        } else {
            byte[] byArray3 = new byte[5];
            byArray3[0] = 8;
            byArray3[1] = 2;
            byArray3[2] = 0;
            byArray3[3] = 0;
            byArray = byArray3;
            byArray3[4] = 0;
        }
        WriteFxImage.write(byArray, byteBuffer, cRC32);
        byteBuffer.putInt((int)cRC32.getValue());
    }
}

