/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.chartfx.utils;

import io.fair_acc.chartfx.axes.Axis;
import java.util.ArrayList;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;

public class AxisSynchronizer {
    private boolean updating;
    private final ArrayList<Axis> axes = new ArrayList();
    private final ChangeListener<Number> upperBoundChangeListener = this::upperBoundChanged;
    private final ChangeListener<Number> lowerBoundChangeListener = this::lowerBoundChanged;

    public void add(Axis axis) {
        this.axes.add(axis);
        axis.maxProperty().addListener(this.upperBoundChangeListener);
        axis.minProperty().addListener(this.lowerBoundChangeListener);
    }

    private Axis findAxis(ObservableValue<? extends Number> observableValue) {
        for (Axis axis : this.axes) {
            if (observableValue == axis.maxProperty()) {
                return axis;
            }
            if (observableValue != axis.minProperty()) continue;
            return axis;
        }
        return null;
    }

    private void lowerBoundChanged(ObservableValue<? extends Number> observableValue, Number number, Number number2) {
        if (!this.updating) {
            double d2 = number2.doubleValue();
            if (Double.isNaN(d2)) {
                return;
            }
            if (d2 == number.doubleValue()) {
                return;
            }
            this.updating = true;
            Axis axis = this.findAxis(observableValue);
            if (axis == null) {
                this.updating = false;
                return;
            }
            double d3 = axis.getTickUnit();
            for (Axis axis2 : this.axes) {
                if (axis2 != axis) {
                    axis2.setMin(d2);
                    axis2.setAutoRanging(false);
                }
                axis2.setTickUnit(d3);
            }
            this.updating = false;
        }
    }

    public void remove(Axis axis) {
        this.axes.remove(axis);
        axis.maxProperty().removeListener(this.upperBoundChangeListener);
        axis.minProperty().removeListener(this.lowerBoundChangeListener);
        axis.setAutoRanging(true);
    }

    private void upperBoundChanged(ObservableValue<? extends Number> observableValue, Number number, Number number2) {
        if (!this.updating) {
            double d2 = number2.doubleValue();
            if (Double.isNaN(d2)) {
                return;
            }
            if (d2 == number.doubleValue()) {
                return;
            }
            this.updating = true;
            Axis axis = this.findAxis(observableValue);
            if (axis == null) {
                this.updating = false;
                return;
            }
            double d3 = axis.getTickUnit();
            for (Axis axis2 : this.axes) {
                if (axis2 != axis) {
                    axis2.setAutoRanging(false);
                    axis2.setMax(d2);
                }
                axis2.setTickUnit(d3);
            }
            this.updating = false;
        }
    }
}

