/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.chartfx.ui.css;

import io.fair_acc.chartfx.marker.DefaultMarker;
import io.fair_acc.chartfx.marker.Marker;
import io.fair_acc.chartfx.renderer.spi.utils.FillPatternStyleHelper;
import io.fair_acc.chartfx.ui.css.CssPropertyFactory;
import io.fair_acc.chartfx.ui.css.StyleUtil;
import io.fair_acc.chartfx.utils.PropUtil;
import java.util.List;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.ObjectBinding;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.LongProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyLongProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleLongProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import javafx.css.CssMetaData;
import javafx.css.Styleable;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.StrokeLineCap;
import javafx.scene.shape.StrokeLineJoin;

public abstract class DataSetNodeParameter
extends Parent
implements StyleUtil.StyleNode {
    private final LongProperty changeCounter = new SimpleLongProperty(0L);
    private final StringProperty name = new SimpleStringProperty();
    private final IntegerProperty localIndex = new SimpleIntegerProperty();
    private final IntegerProperty globalIndex = new SimpleIntegerProperty();
    private final IntegerProperty colorIndex = (IntegerProperty)this.addOnChange(new SimpleIntegerProperty());
    private final DoubleProperty intensity = (DoubleProperty)this.addOnChange(this.css().createDoubleProperty(this, "intensity", 100.0, new Runnable[0]));
    private final BooleanProperty showInLegend = (BooleanProperty)this.addOnChange(this.css().createBooleanProperty(this, "showInLegend", true, new Runnable[0]));
    private final DoubleProperty hatchShiftByIndex = (DoubleProperty)this.addOnChange(this.css().createDoubleProperty(this, "hatchShiftByIndex", 1.5, new Runnable[0]));
    private final ObjectProperty<DefaultMarker> markerType;
    private final ObjectProperty<Marker> userMarkerType;
    private final ObjectBinding<Marker> actualMarkerType;
    private final DoubleProperty markerLineWidth;
    private final DoubleProperty markerSize;
    private final ObjectProperty<Paint> markerColor;
    protected final ObjectBinding<Paint> intensifiedMarkerColor;
    private final ObjectProperty<Number[]> markerLineDashArray;
    private final ObjectBinding<double[]> markerLineDashes;
    private final DoubleProperty lineWidth;
    private final ObjectProperty<Paint> lineColor;
    protected final ObjectBinding<Paint> intensifiedLineColor;
    private final ObjectBinding<Paint> lineFillPattern;
    private final ObjectProperty<Number[]> lineDashArray;
    private final ObjectBinding<double[]> lineDashes;
    private final DoubleProperty lineMiterLimit;
    private final ObjectProperty<StrokeLineJoin> lineJoin;
    private final ObjectProperty<StrokeLineCap> lineCap;
    private static final CssPropertyFactory<DataSetNodeParameter> CSS = new CssPropertyFactory(Parent.getClassCssMetaData());

    public DataSetNodeParameter() {
        this.addOnChange(this.visibleProperty());
        this.markerType = this.css().createEnumProperty((Styleable)this, "markerType", DefaultMarker.DEFAULT, true, DefaultMarker.class);
        this.userMarkerType = new SimpleObjectProperty(null);
        this.actualMarkerType = this.addOnChange(Bindings.createObjectBinding(() -> this.userMarkerType.get() != null ? (Marker)this.userMarkerType.get() : (Marker)this.markerType.get(), (Observable[])new Observable[]{this.userMarkerType, this.markerType}));
        this.markerLineWidth = (DoubleProperty)this.addOnChange(this.css().createDoubleProperty(this, "markerLineWidth", 0.5, new Runnable[0]));
        this.markerSize = (DoubleProperty)this.addOnChange(this.css().createDoubleProperty(this, "markerSize", 1.5, new Runnable[0]));
        this.markerColor = (ObjectProperty)this.addOnChange((ObservableValue)this.css().createPaintProperty(this, "markerColor", (Paint)Color.BLACK, new Runnable[0]));
        this.intensifiedMarkerColor = this.intensifiedColor((ObservableValue<Paint>)this.markerColor);
        this.markerLineDashArray = (ObjectProperty)this.addOnChange((ObservableValue)this.css().createNumberArrayProperty(this, "markerLineDashArray", null, new Runnable[0]));
        this.markerLineDashes = StyleUtil.toUnboxedDoubleArray(this.markerLineDashArray);
        this.lineWidth = (DoubleProperty)this.addOnChange(this.css().createDoubleProperty(this, "lineWidth", 1.0, new Runnable[0]));
        this.lineColor = (ObjectProperty)this.addOnChange((ObservableValue)this.css().createPaintProperty(this, "lineColor", (Paint)Color.BLACK, new Runnable[0]));
        this.intensifiedLineColor = this.intensifiedColor((ObservableValue<Paint>)this.lineColor);
        this.lineFillPattern = this.hatchFillPattern((ObservableValue<Paint>)this.intensifiedLineColor);
        this.lineDashArray = (ObjectProperty)this.addOnChange((ObservableValue)this.css().createNumberArrayProperty(this, "lineDashArray", null, new Runnable[0]));
        this.lineDashes = StyleUtil.toUnboxedDoubleArray(this.lineDashArray);
        this.lineMiterLimit = (DoubleProperty)this.addOnChange(this.css().createDoubleProperty(this, "lineMiterLimit", 1.0, new Runnable[0]));
        this.lineJoin = (ObjectProperty)this.addOnChange((ObservableValue)this.css().createEnumProperty((Styleable)this, "lineJoin", StrokeLineJoin.BEVEL, true, StrokeLineJoin.class));
        this.lineCap = (ObjectProperty)this.addOnChange((ObservableValue)this.css().createEnumProperty((Styleable)this, "lineCap", StrokeLineCap.BUTT, true, StrokeLineCap.class));
    }

    public Paint getMarkerColor() {
        return (Paint)this.intensifiedMarkerColor.get();
    }

    public Paint getLineColor() {
        return (Paint)this.intensifiedLineColor.get();
    }

    public Marker getMarkerType() {
        return (Marker)this.markerTypeProperty().get();
    }

    public ObjectBinding<Marker> markerTypeProperty() {
        return this.actualMarkerType;
    }

    public void setMarkerType(Marker marker) {
        this.userMarkerType.set((Object)marker);
    }

    public String getName() {
        return (String)this.name.get();
    }

    public StringProperty nameProperty() {
        return this.name;
    }

    public void setName(String string) {
        this.name.set((Object)string);
    }

    public int getLocalIndex() {
        return this.localIndex.get();
    }

    public IntegerProperty localIndexProperty() {
        return this.localIndex;
    }

    public void setLocalIndex(int n2) {
        this.localIndex.set(n2);
    }

    public int getGlobalIndex() {
        return this.globalIndex.get();
    }

    public IntegerProperty globalIndexProperty() {
        return this.globalIndex;
    }

    public void setGlobalIndex(int n2) {
        this.globalIndex.set(n2);
    }

    public int getColorIndex() {
        return this.colorIndex.get();
    }

    public IntegerProperty colorIndexProperty() {
        return this.colorIndex;
    }

    public void setColorIndex(int n2) {
        this.colorIndex.set(n2);
    }

    public double getIntensity() {
        return this.intensity.get();
    }

    public DoubleProperty intensityProperty() {
        return this.intensity;
    }

    public void setIntensity(double d2) {
        this.intensity.set(d2);
    }

    public boolean isShowInLegend() {
        return this.showInLegend.get();
    }

    public BooleanProperty showInLegendProperty() {
        return this.showInLegend;
    }

    public void setShowInLegend(boolean bl2) {
        this.showInLegend.set(bl2);
    }

    public double getHatchShiftByIndex() {
        return this.hatchShiftByIndex.get();
    }

    public DoubleProperty hatchShiftByIndexProperty() {
        return this.hatchShiftByIndex;
    }

    public void setHatchShiftByIndex(double d2) {
        this.hatchShiftByIndex.set(d2);
    }

    @Override
    public long getChangeCounter() {
        return this.changeCounter.get();
    }

    public void setChangeCounter(long l2) {
        this.changeCounter.set(l2);
    }

    public void setMarkerType(DefaultMarker defaultMarker) {
        this.markerType.set((Object)defaultMarker);
    }

    public Marker getUserMarkerType() {
        return (Marker)this.userMarkerType.get();
    }

    public ObjectProperty<Marker> userMarkerTypeProperty() {
        return this.userMarkerType;
    }

    public void setUserMarkerType(Marker marker) {
        this.userMarkerType.set((Object)marker);
    }

    public Marker getActualMarkerType() {
        return (Marker)this.actualMarkerType.get();
    }

    public ObjectBinding<Marker> actualMarkerTypeProperty() {
        return this.actualMarkerType;
    }

    public double getMarkerLineWidth() {
        return this.markerLineWidth.get();
    }

    public DoubleProperty markerLineWidthProperty() {
        return this.markerLineWidth;
    }

    public void setMarkerLineWidth(double d2) {
        this.markerLineWidth.set(d2);
    }

    public double getMarkerSize() {
        return this.markerSize.get();
    }

    public DoubleProperty markerSizeProperty() {
        return this.markerSize;
    }

    public void setMarkerSize(double d2) {
        this.markerSize.set(d2);
    }

    public ObjectProperty<Paint> markerColorProperty() {
        return this.markerColor;
    }

    public void setMarkerColor(Paint paint) {
        this.markerColor.set((Object)paint);
    }

    public Paint getIntensifiedMarkerColor() {
        return (Paint)this.intensifiedMarkerColor.get();
    }

    public ObjectBinding<Paint> intensifiedMarkerColorProperty() {
        return this.intensifiedMarkerColor;
    }

    public Number[] getMarkerLineDashArray() {
        return (Number[])this.markerLineDashArray.get();
    }

    public ObjectProperty<Number[]> markerLineDashArrayProperty() {
        return this.markerLineDashArray;
    }

    public void setMarkerLineDashArray(Number[] numberArray) {
        this.markerLineDashArray.set((Object)numberArray);
    }

    public double[] getMarkerLineDashes() {
        return (double[])this.markerLineDashes.get();
    }

    public ObjectBinding<double[]> markerLineDashesProperty() {
        return this.markerLineDashes;
    }

    public double getLineWidth() {
        return this.lineWidth.get();
    }

    public DoubleProperty lineWidthProperty() {
        return this.lineWidth;
    }

    public void setLineWidth(double d2) {
        this.lineWidth.set(d2);
    }

    public ObjectProperty<Paint> lineColorProperty() {
        return this.lineColor;
    }

    public void setLineColor(Paint paint) {
        this.lineColor.set((Object)paint);
    }

    public Paint getIntensifiedLineColor() {
        return (Paint)this.intensifiedLineColor.get();
    }

    public ObjectBinding<Paint> intensifiedLineColorProperty() {
        return this.intensifiedLineColor;
    }

    public Paint getLineFillPattern() {
        return (Paint)this.lineFillPattern.get();
    }

    public ObjectBinding<Paint> lineFillPatternProperty() {
        return this.lineFillPattern;
    }

    public Number[] getLineDashArray() {
        return (Number[])this.lineDashArray.get();
    }

    public ObjectProperty<Number[]> lineDashArrayProperty() {
        return this.lineDashArray;
    }

    public void setLineDashArray(Number[] numberArray) {
        this.lineDashArray.set((Object)numberArray);
    }

    public double[] getLineDashes() {
        return (double[])this.lineDashes.get();
    }

    public ObjectBinding<double[]> lineDashesProperty() {
        return this.lineDashes;
    }

    public double getLineMiterLimit() {
        return this.lineMiterLimit.get();
    }

    public DoubleProperty lineMiterLimitProperty() {
        return this.lineMiterLimit;
    }

    public void setLineMiterLimit(double d2) {
        this.lineMiterLimit.set(d2);
    }

    public StrokeLineJoin getLineJoin() {
        return (StrokeLineJoin)this.lineJoin.get();
    }

    public ObjectProperty<StrokeLineJoin> lineJoinProperty() {
        return this.lineJoin;
    }

    public void setLineJoin(StrokeLineJoin strokeLineJoin) {
        this.lineJoin.set((Object)strokeLineJoin);
    }

    public StrokeLineCap getLineCap() {
        return (StrokeLineCap)this.lineCap.get();
    }

    public ObjectProperty<StrokeLineCap> lineCapProperty() {
        return this.lineCap;
    }

    public void setLineCap(StrokeLineCap strokeLineCap) {
        this.lineCap.set((Object)strokeLineCap);
    }

    public void applyLineStrokeStyle(GraphicsContext graphicsContext) {
        graphicsContext.setMiterLimit(this.getLineMiterLimit());
        graphicsContext.setLineJoin(this.getLineJoin());
        graphicsContext.setLineCap(this.getLineCap());
        graphicsContext.setLineWidth(this.getLineWidth());
        graphicsContext.setLineDashes(this.getLineDashes());
        graphicsContext.setStroke(this.getLineColor());
    }

    protected ObjectBinding<Paint> intensifiedColor(ObservableValue<Paint> observableValue) {
        return Bindings.createObjectBinding(() -> this.getIntensifiedColor((Paint)observableValue.getValue()), (Observable[])new Observable[]{observableValue, this.intensity});
    }

    protected ObjectBinding<Paint> hatchFillPattern(ObservableValue<Paint> observableValue) {
        return Bindings.createObjectBinding(() -> {
            Paint paint = (Paint)observableValue.getValue();
            if (paint instanceof Color) {
                paint = ((Color)paint).brighter();
            }
            double d2 = this.getHatchShiftByIndex() * (double)(this.getGlobalIndex() + 1);
            return FillPatternStyleHelper.getDefaultHatch(paint, d2);
        }, (Observable[])new Observable[]{observableValue, this.globalIndex, this.hatchShiftByIndex});
    }

    protected Paint getIntensifiedColor(Paint paint) {
        if (this.getIntensity() >= 100.0 || !(paint instanceof Color)) {
            return paint;
        }
        if (this.getIntensity() <= 0.0) {
            return Color.TRANSPARENT;
        }
        double d2 = this.getIntensity() / 100.0;
        return ((Color)paint).deriveColor(0.0, d2, 1.0, d2);
    }

    @Override
    public ReadOnlyLongProperty changeCounterProperty() {
        return this.changeCounter;
    }

    protected void incrementChangeCounter() {
        this.changeCounter.set(this.changeCounter.get() + 1L);
    }

    protected <T extends ObservableValue<?>> T addOnChange(T t2) {
        PropUtil.runOnChange(this::incrementChangeCounter, t2);
        return t2;
    }

    public Node getStyleableNode() {
        return this;
    }

    protected CssPropertyFactory<DataSetNodeParameter> css() {
        return CSS;
    }

    public List<CssMetaData<? extends Styleable, ?>> getCssMetaData() {
        return this.css().getCssMetaData();
    }
}

