/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.chartfx.ui.css;

import io.fair_acc.chartfx.ui.geometry.Side;
import io.fair_acc.chartfx.ui.layout.ChartPane;
import io.fair_acc.dataset.utils.AssertUtils;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.WeakHashMap;
import java.util.function.BinaryOperator;
import java.util.function.DoubleBinaryOperator;
import java.util.function.Function;
import java.util.function.IntBinaryOperator;
import java.util.function.LongBinaryOperator;
import javafx.beans.property.Property;
import javafx.css.CssMetaData;
import javafx.css.PseudoClass;
import javafx.css.SimpleStyleableBooleanProperty;
import javafx.css.SimpleStyleableDoubleProperty;
import javafx.css.SimpleStyleableFloatProperty;
import javafx.css.SimpleStyleableIntegerProperty;
import javafx.css.SimpleStyleableLongProperty;
import javafx.css.SimpleStyleableObjectProperty;
import javafx.css.SimpleStyleableStringProperty;
import javafx.css.StyleConverter;
import javafx.css.Styleable;
import javafx.css.StyleableBooleanProperty;
import javafx.css.StyleableDoubleProperty;
import javafx.css.StyleableFloatProperty;
import javafx.css.StyleableIntegerProperty;
import javafx.css.StyleableLongProperty;
import javafx.css.StyleableObjectProperty;
import javafx.css.StyleableProperty;
import javafx.css.StyleableStringProperty;
import javafx.css.converter.SizeConverter;
import javafx.scene.Node;
import javafx.scene.paint.Paint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CssPropertyFactory<S extends Styleable> {
    private static final Logger LOGGER = LoggerFactory.getLogger(CssPropertyFactory.class);
    protected final List<CssMetaData<? extends Styleable, ?>> metaData;
    protected final List<CssMetaData<? extends Styleable, ?>> unmodifiableList;
    protected final Map<String, CssMetaData<S, ?>> metaDataSet = new HashMap();
    protected final Map<String, PseudoClass> pseudoClasses = new HashMap<String, PseudoClass>();
    protected final Map<Styleable, List<String>> propertyNames = new WeakHashMap<Styleable, List<String>>();

    public CssPropertyFactory() {
        this(null);
    }

    public CssPropertyFactory(List<CssMetaData<? extends Styleable, ?>> list) {
        this.metaData = list != null ? new ArrayList(list) : new ArrayList();
        this.unmodifiableList = Collections.unmodifiableList(this.metaData);
    }

    public static List<Field> getAllFields(List<Field> list, Class<?> clazz) {
        list.addAll(Arrays.asList(clazz.getDeclaredFields()));
        if (clazz.getSuperclass() != null) {
            CssPropertyFactory.getAllFields(list, clazz.getSuperclass());
        }
        return list;
    }

    public static Field getField(Class<?> clazz, String string) {
        List<Field> list = CssPropertyFactory.getAllFields(new LinkedList<Field>(), clazz);
        Optional<Field> optional = list.stream().filter(field -> field.getName().equals(string)).findFirst();
        optional.ifPresent(field -> field.setAccessible(true));
        return optional.orElse(null);
    }

    public final List<CssMetaData<? extends Styleable, ?>> getCssMetaData() {
        return this.unmodifiableList;
    }

    public final List<CssMetaData<? extends Styleable, ?>> getCssMetaDataModifyable() {
        return this.metaData;
    }

    public final StyleableDoubleProperty createDoubleProperty(S s2, String string, double d2, boolean bl2, DoubleBinaryOperator doubleBinaryOperator, Runnable ... runnableArray) {
        return new StylishDoubleProperty((Styleable)s2, string, d2, bl2, doubleBinaryOperator, runnableArray);
    }

    public final StyleableDoubleProperty createDoubleProperty(S s2, String string, double d2, Runnable ... runnableArray) {
        return this.createDoubleProperty(s2, string, d2, true, null, runnableArray);
    }

    public final StyleableIntegerProperty createIntegerProperty(S s2, String string, int n2, boolean bl2, IntBinaryOperator intBinaryOperator, Runnable ... runnableArray) {
        return new StylishIntegerProperty((Styleable)s2, string, n2, bl2, intBinaryOperator, runnableArray);
    }

    public final StyleableIntegerProperty createIntegerProperty(S s2, String string, int n2, Runnable ... runnableArray) {
        return this.createIntegerProperty(s2, string, n2, true, null, runnableArray);
    }

    public final StyleableLongProperty createLongProperty(S s2, String string, long l2, boolean bl2, LongBinaryOperator longBinaryOperator, Runnable ... runnableArray) {
        return new StylishLongProperty((Styleable)s2, string, l2, bl2, longBinaryOperator, runnableArray);
    }

    public final StyleableLongProperty createLongProperty(S s2, String string, long l2, Runnable ... runnableArray) {
        return this.createLongProperty(s2, string, l2, true, null, runnableArray);
    }

    public final StyleableFloatProperty createFloatProperty(S s2, String string, float f2, boolean bl2, BinaryOperator<Float> binaryOperator, Runnable ... runnableArray) {
        return new StylishFloatProperty((Styleable)s2, string, f2, bl2, binaryOperator, runnableArray);
    }

    public final StyleableFloatProperty createFloatProperty(S s2, String string, float f2, Runnable ... runnableArray) {
        return this.createFloatProperty(s2, string, f2, true, null, runnableArray);
    }

    public final StyleableBooleanProperty createBooleanProperty(S s2, String string, boolean bl2, boolean bl3, BinaryOperator<Boolean> binaryOperator, Runnable ... runnableArray) {
        return new StylishBooleanProperty((Styleable)s2, string, bl2, bl3, binaryOperator, runnableArray);
    }

    public final StyleableBooleanProperty createBooleanProperty(S s2, String string, boolean bl2, Runnable ... runnableArray) {
        return this.createBooleanProperty(s2, string, bl2, true, null, runnableArray);
    }

    public final <T> StyleableObjectProperty<T> createObjectProperty(S s2, String string, T t2, boolean bl2, StyleConverter<?, T> styleConverter, BinaryOperator<T> binaryOperator, Runnable ... runnableArray) {
        return new StylishObjectProperty<T>((Styleable)s2, string, t2, bl2, styleConverter, binaryOperator, runnableArray);
    }

    public final <T> StyleableObjectProperty<T> createObjectProperty(S s2, String string, T t2, StyleConverter<?, T> styleConverter, Runnable ... runnableArray) {
        return this.createObjectProperty(s2, string, t2, true, styleConverter, null, runnableArray);
    }

    public final StyleableStringProperty createStringProperty(S s2, String string, String string2, boolean bl2, BinaryOperator<String> binaryOperator, Runnable ... runnableArray) {
        return new StylishStringProperty((Styleable)s2, string, string2, bl2, binaryOperator, runnableArray);
    }

    public final StyleableStringProperty createStringProperty(S s2, String string, String string2, Runnable ... runnableArray) {
        return this.createStringProperty(s2, string, string2, true, null, runnableArray);
    }

    public final StyleableObjectProperty<Side> createSideProperty(S s2, Side side3, Runnable ... runnableArray) {
        StyleConverter styleConverter = StyleConverter.getEnumConverter(Side.class);
        BinaryOperator binaryOperator = (side, side2) -> {
            AssertUtils.notNull("Side must not be null", side2);
            Node node = s2.getStyleableNode();
            if (node == null && s2 instanceof Node) {
                node = (Node)s2;
            }
            AssertUtils.notNull("Bean does not specify a styleable node", node);
            ChartPane.setSide(node, side2);
            return side2;
        };
        binaryOperator.apply(null, side3);
        return this.createObjectProperty(s2, "side", side3, false, styleConverter, binaryOperator, runnableArray);
    }

    public final StyleableObjectProperty<Paint> createPaintProperty(S s2, String string, Paint paint, Runnable ... runnableArray) {
        return this.createObjectProperty(s2, string, paint, true, StyleConverter.getPaintConverter(), null, new Runnable[0]);
    }

    public final StyleableObjectProperty<Number[]> createNumberArrayProperty(S s2, String string, Number[] numberArray, Runnable ... runnableArray) {
        return this.createObjectProperty(s2, string, (Object)numberArray, true, (StyleConverter)SizeConverter.SequenceConverter.getInstance(), null, new Runnable[0]);
    }

    public <T extends Enum<T>> StyleableObjectProperty<T> createEnumProperty(Styleable styleable, String string, T t2, boolean bl2, Class<T> clazz) {
        return new StylishEnumProperty(this, styleable, string, t2, bl2, clazz, null, new Runnable[0]);
    }

    public <T extends Enum<T>> StyleableObjectProperty<T> createEnumPropertyWithPseudoclasses(Styleable styleable, String string, T t2, boolean bl2, Class<T> clazz, BinaryOperator<T> binaryOperator, Runnable ... runnableArray) {
        BinaryOperator binaryOperator2 = (enum_, enum_2) -> {
            if (enum_ != null) {
                ((Node)styleable).pseudoClassStateChanged(this.pseudoClasses.get(enum_.toString().toLowerCase().replace('_', '-')), false);
            }
            if (enum_2 != null) {
                ((Node)styleable).pseudoClassStateChanged(this.pseudoClasses.get(enum_2.toString().toLowerCase().replace('_', '-')), true);
            }
            if (binaryOperator != null) {
                return (Enum)binaryOperator.apply(enum_, enum_2);
            }
            return enum_2;
        };
        StylishEnumProperty stylishEnumProperty = new StylishEnumProperty(this, styleable, string, t2, bl2, clazz, binaryOperator2, runnableArray);
        ((Node)styleable).pseudoClassStateChanged(this.pseudoClasses.get(t2.toString().toLowerCase().replace('_', '-')), true);
        return stylishEnumProperty;
    }

    public <T extends Enum<T>> StyleableObjectProperty<T> createEnumPropertyWithPseudoclasses(Styleable styleable, String string, T t2, Class<T> clazz, Runnable ... runnableArray) {
        return this.createEnumPropertyWithPseudoclasses(styleable, string, t2, true, clazz, null, runnableArray);
    }

    private void checkPropertyConsistency(Styleable styleable2, String string, Runnable ... runnableArray) {
        if (styleable2 == null) {
            throw new IllegalArgumentException("styleableBean is null");
        }
        Class<?> clazz = styleable2.getClass();
        List<String> list = this.propertyNames.get(styleable2);
        if (list != null && list.contains(string)) {
            throw new IllegalArgumentException("class " + clazz.getName() + " contains duplicate CSS property '" + string + "'");
        }
        this.propertyNames.computeIfAbsent(styleable2, styleable -> new ArrayList()).add(string);
        Field field = CssPropertyFactory.getField(clazz, string);
        if (field == null) {
            throw new IllegalArgumentException("class " + clazz.getName() + " does not assign CSS property '" + string + "' to class field with the same name");
        }
        if (runnableArray.length > 2) {
            throw new IllegalArgumentException("config error in class " + clazz.getName() + " for CSS property '" + string + "' : only 2 (post- and pre invalidation) actions allowed, but " + runnableArray.length + " actions are supplied");
        }
    }

    protected String getCssPropertyName(String string) {
        return "-fx-" + string.replaceAll("([A-Z])", "-$1").toLowerCase();
    }

    public class StylishDoubleProperty
    extends SimpleStyleableDoubleProperty {
        protected final Runnable preInvalidateAction;
        protected final Runnable postInvalidateAction;
        protected final DoubleBinaryOperator filter;

        public StylishDoubleProperty(Styleable styleable, String string, double d2, boolean bl2, DoubleBinaryOperator doubleBinaryOperator, Runnable ... runnableArray) {
            super(CssPropertyFactory.this.metaDataSet.computeIfAbsent(CssPropertyFactory.this.getCssPropertyName(string), string2 -> {
                CssPropertyFactory cssPropertyFactory2 = CssPropertyFactory.this;
                Objects.requireNonNull(cssPropertyFactory2);
                return cssPropertyFactory2.new SimpleCssMetaData<Double>(styleable, string, (String)string2, (StyleConverter<?, Double>)StyleConverter.getSizeConverter(), d2, bl2, (List<CssMetaData<Styleable, ?>>)null);
            }), (Object)styleable, string, Double.valueOf(d2));
            CssPropertyFactory.this.checkPropertyConsistency(styleable, string, runnableArray);
            this.filter = doubleBinaryOperator;
            this.postInvalidateAction = runnableArray.length > 0 ? runnableArray[0] : null;
            this.preInvalidateAction = runnableArray.length > 1 ? runnableArray[1] : null;
        }

        public void set(double d2) {
            if (this.preInvalidateAction != null) {
                this.preInvalidateAction.run();
            }
            if (this.filter == null) {
                super.set(d2);
            } else {
                super.set(this.filter.applyAsDouble(this.get(), d2));
            }
            if (this.postInvalidateAction != null) {
                this.postInvalidateAction.run();
            }
        }
    }

    public class StylishIntegerProperty
    extends SimpleStyleableIntegerProperty {
        protected final Runnable preInvalidateAction;
        protected final Runnable postInvalidateAction;
        protected final IntBinaryOperator filter;

        public StylishIntegerProperty(Styleable styleable, String string, int n2, boolean bl2, IntBinaryOperator intBinaryOperator, Runnable ... runnableArray) {
            super(CssPropertyFactory.this.metaDataSet.computeIfAbsent(CssPropertyFactory.this.getCssPropertyName(string), string2 -> {
                CssPropertyFactory cssPropertyFactory2 = CssPropertyFactory.this;
                Objects.requireNonNull(cssPropertyFactory2);
                return cssPropertyFactory2.new SimpleCssMetaData<Integer>(styleable, string, (String)string2, (StyleConverter<?, Integer>)StyleConverter.getSizeConverter(), n2, bl2, (List<CssMetaData<Styleable, ?>>)null);
            }), (Object)styleable, string, Integer.valueOf(n2));
            CssPropertyFactory.this.checkPropertyConsistency(styleable, string, runnableArray);
            this.filter = intBinaryOperator;
            this.postInvalidateAction = runnableArray.length > 0 ? runnableArray[0] : null;
            this.preInvalidateAction = runnableArray.length > 1 ? runnableArray[1] : null;
        }

        public void set(int n2) {
            if (this.preInvalidateAction != null) {
                this.preInvalidateAction.run();
            }
            if (this.filter == null) {
                super.set(n2);
            } else {
                super.set(this.filter.applyAsInt(this.get(), n2));
            }
            if (this.postInvalidateAction != null) {
                this.postInvalidateAction.run();
            }
        }
    }

    public class StylishLongProperty
    extends SimpleStyleableLongProperty {
        protected final Runnable preInvalidateAction;
        protected final Runnable postInvalidateAction;
        protected final LongBinaryOperator filter;

        public StylishLongProperty(Styleable styleable, String string, long l2, boolean bl2, LongBinaryOperator longBinaryOperator, Runnable ... runnableArray) {
            super(CssPropertyFactory.this.metaDataSet.computeIfAbsent(CssPropertyFactory.this.getCssPropertyName(string), string2 -> {
                CssPropertyFactory cssPropertyFactory2 = CssPropertyFactory.this;
                Objects.requireNonNull(cssPropertyFactory2);
                return cssPropertyFactory2.new SimpleCssMetaData<Long>(styleable, string, (String)string2, (StyleConverter<?, Long>)StyleConverter.getSizeConverter(), l2, bl2, (List<CssMetaData<Styleable, ?>>)null);
            }), (Object)styleable, string, Long.valueOf(l2));
            CssPropertyFactory.this.checkPropertyConsistency(styleable, string, runnableArray);
            this.filter = longBinaryOperator;
            this.postInvalidateAction = runnableArray.length > 0 ? runnableArray[0] : null;
            this.preInvalidateAction = runnableArray.length > 1 ? runnableArray[1] : null;
        }

        public void set(long l2) {
            if (this.preInvalidateAction != null) {
                this.preInvalidateAction.run();
            }
            if (this.filter == null) {
                super.set(l2);
            } else {
                super.set(this.filter.applyAsLong(this.get(), l2));
            }
            if (this.postInvalidateAction != null) {
                this.postInvalidateAction.run();
            }
        }
    }

    public class StylishFloatProperty
    extends SimpleStyleableFloatProperty {
        protected final Runnable preInvalidateAction;
        protected final Runnable postInvalidateAction;
        protected final BinaryOperator<Float> filter;

        public StylishFloatProperty(Styleable styleable, String string, float f2, boolean bl2, BinaryOperator<Float> binaryOperator, Runnable ... runnableArray) {
            super(CssPropertyFactory.this.metaDataSet.computeIfAbsent(CssPropertyFactory.this.getCssPropertyName(string), string2 -> {
                CssPropertyFactory cssPropertyFactory2 = CssPropertyFactory.this;
                Objects.requireNonNull(cssPropertyFactory2);
                return cssPropertyFactory2.new SimpleCssMetaData<Float>(styleable, string, (String)string2, (StyleConverter<?, Float>)StyleConverter.getSizeConverter(), Float.valueOf(f2), bl2, (List<CssMetaData<Styleable, ?>>)null);
            }), (Object)styleable, string, Float.valueOf(f2));
            CssPropertyFactory.this.checkPropertyConsistency(styleable, string, runnableArray);
            this.filter = binaryOperator;
            this.postInvalidateAction = runnableArray.length > 0 ? runnableArray[0] : null;
            this.preInvalidateAction = runnableArray.length > 1 ? runnableArray[1] : null;
        }

        public void set(float f2) {
            if (this.preInvalidateAction != null) {
                this.preInvalidateAction.run();
            }
            if (this.filter == null) {
                super.set(f2);
            } else {
                super.set(((Float)this.filter.apply(Float.valueOf(this.get()), Float.valueOf(f2))).floatValue());
            }
            if (this.postInvalidateAction != null) {
                this.postInvalidateAction.run();
            }
        }
    }

    public class StylishBooleanProperty
    extends SimpleStyleableBooleanProperty {
        protected final Runnable preInvalidateAction;
        protected final Runnable postInvalidateAction;
        protected final BinaryOperator<Boolean> filter;

        public StylishBooleanProperty(Styleable styleable, String string, boolean bl2, boolean bl3, BinaryOperator<Boolean> binaryOperator, Runnable ... runnableArray) {
            super(CssPropertyFactory.this.metaDataSet.computeIfAbsent(CssPropertyFactory.this.getCssPropertyName(string), string2 -> {
                CssPropertyFactory cssPropertyFactory2 = CssPropertyFactory.this;
                Objects.requireNonNull(cssPropertyFactory2);
                return cssPropertyFactory2.new SimpleCssMetaData<Boolean>(styleable, string, (String)string2, (StyleConverter<?, Boolean>)StyleConverter.getBooleanConverter(), bl2, bl3, (List<CssMetaData<Styleable, ?>>)null);
            }), (Object)styleable, string, bl2);
            this.filter = binaryOperator;
            this.postInvalidateAction = runnableArray.length > 0 ? runnableArray[0] : null;
            this.preInvalidateAction = runnableArray.length > 1 ? runnableArray[1] : null;
        }

        public void set(boolean bl2) {
            if (this.preInvalidateAction != null) {
                this.preInvalidateAction.run();
            }
            if (this.filter == null) {
                super.set(bl2);
            } else {
                super.set(((Boolean)this.filter.apply(this.get(), bl2)).booleanValue());
            }
            if (this.postInvalidateAction != null) {
                this.postInvalidateAction.run();
            }
        }
    }

    public class StylishObjectProperty<T>
    extends SimpleStyleableObjectProperty<T> {
        protected final Runnable preInvalidateAction;
        protected final Runnable postInvalidateAction;
        protected final BinaryOperator<T> filter;

        public StylishObjectProperty(Styleable styleable, String string, T t2, boolean bl2, StyleConverter<?, T> styleConverter, BinaryOperator<T> binaryOperator, Runnable ... runnableArray) {
            super(CssPropertyFactory.this.metaDataSet.computeIfAbsent(CssPropertyFactory.this.getCssPropertyName(string), string2 -> {
                CssPropertyFactory cssPropertyFactory2 = CssPropertyFactory.this;
                Objects.requireNonNull(cssPropertyFactory2);
                return cssPropertyFactory2.new SimpleCssMetaData<Object>(styleable, string, (String)string2, (StyleConverter<?, Object>)styleConverter, t2, bl2, (List<CssMetaData<Styleable, ?>>)null);
            }), (Object)styleable, string, t2);
            CssPropertyFactory.this.checkPropertyConsistency(styleable, string, runnableArray);
            this.filter = binaryOperator;
            this.postInvalidateAction = runnableArray.length > 0 ? runnableArray[0] : null;
            this.preInvalidateAction = runnableArray.length > 1 ? runnableArray[1] : null;
        }

        public void set(T t2) {
            if (this.preInvalidateAction != null) {
                this.preInvalidateAction.run();
            }
            if (this.filter == null) {
                super.set(t2);
            } else {
                super.set(this.filter.apply(this.get(), t2));
            }
            if (this.postInvalidateAction != null) {
                this.postInvalidateAction.run();
            }
        }
    }

    public class StylishStringProperty
    extends SimpleStyleableStringProperty {
        protected final Runnable preInvalidateAction;
        protected final Runnable postInvalidateAction;
        protected final BinaryOperator<String> filter;

        public StylishStringProperty(Styleable styleable, String string, String string2, boolean bl2, BinaryOperator<String> binaryOperator, Runnable ... runnableArray) {
            super(CssPropertyFactory.this.metaDataSet.computeIfAbsent(CssPropertyFactory.this.getCssPropertyName(string), string3 -> {
                CssPropertyFactory cssPropertyFactory2 = CssPropertyFactory.this;
                Objects.requireNonNull(cssPropertyFactory2);
                return cssPropertyFactory2.new SimpleCssMetaData<String>(styleable, string, (String)string3, (StyleConverter<?, String>)StyleConverter.getStringConverter(), string2, bl2, (List<CssMetaData<Styleable, ?>>)null);
            }), (Object)styleable, string, string2);
            CssPropertyFactory.this.checkPropertyConsistency(styleable, string, runnableArray);
            this.filter = binaryOperator;
            this.postInvalidateAction = runnableArray.length > 0 ? runnableArray[0] : null;
            this.preInvalidateAction = runnableArray.length > 1 ? runnableArray[1] : null;
        }

        public void set(String string) {
            if (this.preInvalidateAction != null) {
                this.preInvalidateAction.run();
            }
            if (this.filter == null) {
                super.set(string);
            } else {
                super.set((String)this.filter.apply(this.get(), string));
            }
            if (this.postInvalidateAction != null) {
                this.postInvalidateAction.run();
            }
        }
    }

    public static class StylishEnumProperty<T extends Enum<T>>
    extends SimpleStyleableObjectProperty<T> {
        protected final Runnable preInvalidateAction;
        protected final Runnable postInvalidateAction;
        protected final BinaryOperator<T> filter;
        final /* synthetic */ CssPropertyFactory this$0;

        public StylishEnumProperty(Styleable styleable, String string, T t2, boolean bl2, Class<T> clazz, BinaryOperator<T> binaryOperator, Runnable ... runnableArray) {
            this.this$0 = var1_1;
            super(var1_1.metaDataSet.computeIfAbsent(var1_1.getCssPropertyName(string), string2 -> {
                CssPropertyFactory cssPropertyFactory2 = var1_1;
                Objects.requireNonNull(cssPropertyFactory2);
                SimpleCssMetaData<Enum> simpleCssMetaData = cssPropertyFactory2.new SimpleCssMetaData<Enum>(styleable, string, (String)string2, (StyleConverter<?, Enum>)StyleConverter.getEnumConverter((Class)clazz), (Enum)t2, bl2, (List<CssMetaData<Styleable, ?>>)null);
                for (Enum enum_2 : (Enum[])clazz.getEnumConstants()) {
                    String string3 = enum_2.toString().toLowerCase().replace('_', '-');
                    cssPropertyFactory.pseudoClasses.computeIfAbsent(string3, PseudoClass::getPseudoClass);
                }
                return simpleCssMetaData;
            }), (Object)styleable, string, t2);
            var1_1.checkPropertyConsistency(styleable, string, runnableArray);
            this.filter = binaryOperator;
            this.postInvalidateAction = runnableArray.length > 0 ? runnableArray[0] : null;
            this.preInvalidateAction = runnableArray.length > 1 ? runnableArray[1] : null;
        }

        public void set(T t2) {
            if (this.preInvalidateAction != null) {
                this.preInvalidateAction.run();
            }
            if (this.filter == null) {
                super.set(t2);
            } else {
                super.set((Object)((Enum)this.filter.apply((Enum)this.get(), t2)));
            }
            if (this.postInvalidateAction != null) {
                this.postInvalidateAction.run();
            }
        }
    }

    public class SimpleCssMetaData<T>
    extends CssMetaData<S, T> {
        private final Function<S, StyleableProperty<T>> function;

        protected SimpleCssMetaData(Styleable styleable2, String string, String string2, StyleConverter<?, T> styleConverter, T t2, boolean bl2, List<CssMetaData<? extends Styleable, ?>> list) {
            super(string2, styleConverter, t2, bl2, list);
            if (styleable2 == null) {
                throw new IllegalArgumentException("styleableBean for property '" + string + "' is null");
            }
            Field field = CssPropertyFactory.getField(styleable2.getClass(), string);
            if (field == null) {
                throw new IllegalArgumentException("styleableBean = " + styleable2.getClass().getName() + " FX propertyName = '" + string + "' - field is null");
            }
            this.function = styleable -> {
                try {
                    return (StyleableProperty)field.get(styleable);
                }
                catch (IllegalAccessException illegalAccessException) {
                    LOGGER.atError().setCause(illegalAccessException).addArgument(styleable.getClass().getName()).addArgument(field).addArgument(string).log("class {} field {} propertyName {}");
                    throw new IllegalStateException("styleableBean FX propertyName = '" + string + "'  - could not get field object");
                }
            };
            CssPropertyFactory.this.metaData.add(this);
        }

        public boolean isSettable(S s2) {
            StyleableProperty<T> styleableProperty = this.getStyleableProperty(s2);
            if (styleableProperty instanceof Property) {
                return !((Property)styleableProperty).isBound();
            }
            return styleableProperty != null;
        }

        public StyleableProperty<T> getStyleableProperty(S s2) {
            return this.function.apply(s2);
        }
    }
}

