/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.chartfx.ui.css;

import javafx.css.PseudoClass;
import javafx.scene.Node;

public enum ColorPalette {
    DEFAULT,
    MISC("misc"),
    ADOBE("adobe"),
    DELL("dell"),
    EQUIDISTANT("equidistant"),
    TUNEVIEWER("tuneviewer"),
    MATLAB_LIGHT("matlab-light"),
    MATLAB_DARK("matlab-dark"),
    MODENA("modena"),
    ATLANTAFX("atlantafx");

    private final PseudoClass pseudoClass;
    private static final ColorPalette[] values;

    private ColorPalette() {
        this.pseudoClass = null;
    }

    private ColorPalette(String string2) {
        this.pseudoClass = PseudoClass.getPseudoClass((String)("palette-" + string2));
    }

    public PseudoClass getPseudoClass() {
        return this.pseudoClass;
    }

    public void applyPseudoClasses(Node node) {
        for (ColorPalette colorPalette : values) {
            node.pseudoClassStateChanged(colorPalette.getPseudoClass(), this == colorPalette);
        }
    }

    static {
        values = ColorPalette.values();
    }
}

