/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.chartfx.ui;

import io.fair_acc.chartfx.Chart;
import io.fair_acc.chartfx.ui.ToolBarShapeHelper;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.value.ChangeListener;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.geometry.Side;
import javafx.scene.Node;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.FlowPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;

public class ToolBarFlowPane
extends FlowPane {
    private static final int DEFAULT_TOOLBAR_HEIGHT = 28;
    private static final double CORNER_SPACE_PADDING_FACTOR = 1.8;
    private Color defaultColour = Color.web((String)"#f4f4f4", (double)0.85).deriveColor(0.0, 1.0, 0.94, 1.0);
    private Color selectedColour = Color.web((String)"#f4f4f4", (double)0.85).deriveColor(0.0, 1.0, 0.92, 1.0);
    private Insets toolBarPadding = new Insets(1.0, 12.5, 5.0, 12.5);
    private final DoubleProperty cornerRadius = new SimpleDoubleProperty((Object)this, "cornerRadius", 25.0);
    private final Chart chart;

    public ToolBarFlowPane(Chart chart) {
        this.chart = chart;
        this.setId(((Object)((Object)this)).getClass().getSimpleName() + "(Chart)");
        StackPane.setAlignment((Node)this, (Pos)Pos.TOP_CENTER);
        this.setPrefHeight(-1.0);
        this.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)this.defaultColour, CornerRadii.EMPTY, Insets.EMPTY)}));
        this.setMinHeight(0.0);
        this.setShape(ToolBarShapeHelper.getToolBarShape(this.getWidth(), this.getHeight(), this.cornerRadius.get()));
        this.setAlignment(Pos.TOP_CENTER);
        this.setMinWidth(0.0);
        this.setPadding(this.calculateInsets());
        HBox.setHgrow((Node)this, (Priority)Priority.NEVER);
        ChangeListener changeListener = (observableValue, number, number2) -> {
            if (number2.equals(number)) {
                return;
            }
            this.adjustToolBarWidth();
        };
        this.widthProperty().addListener(changeListener);
        this.heightProperty().addListener(changeListener);
        chart.getCanvas().widthProperty().addListener(changeListener);
        this.cornerRadius.addListener(changeListener);
    }

    private void adjustToolBarWidth() {
        double d2 = 0.6 * this.chart.getWidth();
        double d3 = 0.0;
        for (Node node : this.getChildren()) {
            d3 += node.prefWidth(28.0);
        }
        double d4 = Math.min(d2, Math.max(d3 += 4.0 * this.cornerRadius.get(), 50.0));
        this.setPrefWrapLength(d4);
        this.setMaxWidth(d4);
        this.setWidth(d2);
        int n2 = (int)Math.max(this.getHeight(), Math.max(this.getBoundsInParent().getHeight(), this.getBoundsInLocal().getHeight()));
        this.setMinHeight(n2);
        this.setShape(ToolBarShapeHelper.getToolBarShape(d4, n2, this.cornerRadius.get()));
    }

    protected Insets calculateInsets() {
        double d2 = 1.8 * this.cornerRadius.get();
        double d3 = Math.max(d2, this.toolBarPadding.getRight());
        double d4 = Math.max(d2, this.toolBarPadding.getLeft());
        return new Insets(this.toolBarPadding.getTop(), d3, this.toolBarPadding.getBottom(), d4);
    }

    public DoubleProperty cornerRadiusProperty() {
        return this.cornerRadius;
    }

    public Color getToolBarDefaultColor() {
        return this.defaultColour;
    }

    public Insets getToolBarInsets() {
        return this.toolBarPadding;
    }

    public Color getToolBarSelectedColor() {
        return this.selectedColour;
    }

    public void registerListener() {
        this.getChildren().addListener(change -> this.adjustToolBarWidth());
        this.setOnMouseClicked(mouseEvent -> {
            if (this.chart.toolBarPinnedProperty().isBound()) {
                return;
            }
            this.chart.setToolBarPinned(!this.chart.isToolBarPinned());
        });
        this.chart.toolBarPinnedProperty().addListener((observableValue, bl2, bl3) -> {
            if (bl3.booleanValue()) {
                this.chart.getMenuPane().setPinnedSide(Side.TOP);
                this.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)this.selectedColour, CornerRadii.EMPTY, Insets.EMPTY)}));
            } else {
                this.chart.getMenuPane().setPinnedSide(null);
                this.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)this.defaultColour, CornerRadii.EMPTY, Insets.EMPTY)}));
            }
            this.chart.invalidate();
        });
    }

    public void setToolBarDefaultColor(Color color) {
        this.defaultColour = color;
    }

    public void setToolBarInsets(Insets insets) {
        this.toolBarPadding = insets;
        this.setPadding(this.toolBarPadding);
    }

    public void setToolBarSelectedColor(Color color) {
        this.selectedColour = color;
    }
}

