/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.chartfx.ui;

import java.util.ArrayList;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.scene.Node;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import org.kordamp.ikonli.javafx.FontIcon;

public class TilingPane
extends GridPane {
    protected static final String FONT_AWESOME = "FontAwesome";
    protected static final int FONT_SIZE = 20;
    private final ObjectProperty<Layout> layout = new SimpleObjectProperty<Layout>((Object)this, "layout", Layout.GRID){

        public void set(Layout layout) {
            if (layout == null) {
                throw new IllegalArgumentException("layout must not be null");
            }
            super.set((Object)layout);
        }
    };

    public TilingPane() {
        this(Layout.GRID);
    }

    public TilingPane(Layout layout) {
        this(layout, null);
    }

    public TilingPane(Layout layout3, Node ... nodeArray) {
        this.layout.set((Object)layout3);
        VBox.setVgrow((Node)this, (Priority)Priority.ALWAYS);
        this.getChildren().addListener(change -> {
            while (change.next()) {
                this.layoutNormal();
            }
        });
        this.layout.addListener((observableValue, layout, layout2) -> this.layoutNormal());
        if (nodeArray != null) {
            this.getChildren().addAll((Object[])nodeArray);
        }
    }

    public Layout getLayout() {
        return (Layout)((Object)this.layoutProperty().get());
    }

    public ObjectProperty<Layout> layoutProperty() {
        return this.layout;
    }

    public void setLayout(Layout layout) {
        this.layoutProperty().set((Object)layout);
    }

    public String toString() {
        return TilingPane.class.getSimpleName() + "('" + this.getLayout() + "0')";
    }

    protected int getColumnsCount() {
        int n2 = this.getChildren().size();
        if (n2 == 0) {
            return 1;
        }
        switch (this.getLayout()) {
            case HBOX: {
                return n2;
            }
            case MAXIMISE: 
            case VBOX: {
                return 1;
            }
        }
        if (n2 < 4) {
            return 2;
        }
        return (int)Math.ceil(Math.sqrt(n2));
    }

    protected void layoutNormal() {
        int n2;
        if (this.getChildren().isEmpty()) {
            return;
        }
        int n3 = this.getColumnsCount();
        if (this.getColumnConstraints().size() != n3) {
            ArrayList<ColumnConstraints> arrayList = new ArrayList<ColumnConstraints>();
            for (n2 = 0; n2 < n3; ++n2) {
                ColumnConstraints columnConstraints = new ColumnConstraints();
                columnConstraints.setPercentWidth(100.0 / (double)n3);
                columnConstraints.setFillWidth(true);
                arrayList.add(columnConstraints);
            }
            this.getColumnConstraints().setAll(arrayList);
        }
        int n4 = 0;
        n2 = 0;
        int n5 = 0;
        int n6 = this.getChildren().size();
        int n7 = Math.max(1, n3 / (n6 - n5));
        for (Node node : this.getChildren()) {
            GridPane.setFillWidth((Node)node, (Boolean)true);
            GridPane.setFillHeight((Node)node, (Boolean)true);
            GridPane.setColumnIndex((Node)node, (Integer)n2);
            GridPane.setRowIndex((Node)node, (Integer)n4);
            if (n2 == 0 && n6 - n5 < n3) {
                n7 = Math.max(1, n3 / (n6 - n5));
            }
            if (n6 - n5 == 1 && n2 < n3) {
                n7 = n3 - n2;
            }
            GridPane.setColumnSpan((Node)node, (Integer)n7);
            if ((n2 += n7) >= n3) {
                n2 = 0;
                ++n4;
            }
            ++n5;
        }
    }

    public static enum Layout {
        HBOX("HBox", "fas-arrows-alt-h:20"),
        VBOX("VBox", "fas-arrows-alt-v:20"),
        GRID("Grid", "fas-th:20"),
        MAXIMISE("Maximise", "fas-window-maximize:20");

        private final String name;
        private final String iconCode;

        private Layout(String string2, String string3) {
            this.name = string2;
            this.iconCode = string3;
        }

        public Node getIcon() {
            return new FontIcon(this.iconCode);
        }

        public String getName() {
            return this.name;
        }
    }
}

