/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.chartfx.ui;

import io.fair_acc.chartfx.ui.SidesPane;
import io.fair_acc.chartfx.ui.geometry.Side;
import java.security.InvalidParameterException;
import javafx.animation.Animation;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.InvalidationListener;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WritableValue;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.canvas.Canvas;
import javafx.scene.control.Control;
import javafx.scene.control.SkinBase;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.Region;
import javafx.scene.shape.Rectangle;
import javafx.util.Duration;

public class SidesPaneSkin
extends SkinBase<SidesPane> {
    private final BorderPane borderPane = new BorderPane();
    private final EventHandler<MouseEvent> exitedHandler;
    private boolean mousePressed;
    private final DoubleProperty[] visibility = new SimpleDoubleProperty[Side.values().length];
    private final Timeline[] showTimeline = new Timeline[Side.values().length];
    private final Timeline[] hideTimeline = new Timeline[Side.values().length];

    public SidesPaneSkin(SidesPane sidesPane) {
        super((Control)sidesPane);
        this.exitedHandler = mouseEvent -> {
            if (this.isMouseEnabled() && !this.mousePressed) {
                for (Side side : Side.values()) {
                    if (((SidesPane)this.getSkinnable()).isPinned(side).booleanValue()) continue;
                    this.hide(side);
                }
            }
        };
        this.getChildren().add((Object)this.borderPane);
        this.updateBorderPane();
        InvalidationListener invalidationListener = observable -> this.updateBorderPane();
        sidesPane.contentProperty().addListener(invalidationListener);
        sidesPane.topProperty().addListener(invalidationListener);
        sidesPane.rightProperty().addListener(invalidationListener);
        sidesPane.bottomProperty().addListener(invalidationListener);
        sidesPane.leftProperty().addListener(invalidationListener);
        sidesPane.addEventFilter(MouseEvent.MOUSE_MOVED, mouseEvent -> {
            if (this.isMouseEnabled()) {
                Side side = this.getSide((MouseEvent)mouseEvent);
                if (side != null) {
                    this.show(side);
                } else if (this.isMouseMovedOutsideSides((MouseEvent)mouseEvent)) {
                    for (Side side2 : Side.values()) {
                        if (((SidesPane)this.getSkinnable()).isPinned(side2).booleanValue()) continue;
                        this.hide(side2);
                    }
                }
            }
        });
        sidesPane.addEventFilter(MouseEvent.MOUSE_EXITED, this.exitedHandler);
        sidesPane.addEventFilter(MouseEvent.MOUSE_PRESSED, mouseEvent -> {
            this.mousePressed = true;
        });
        sidesPane.addEventFilter(MouseEvent.MOUSE_RELEASED, mouseEvent -> {
            Side side;
            this.mousePressed = false;
            if (this.isMouseEnabled() && (side = this.getSide((MouseEvent)mouseEvent)) != null) {
                this.show(side);
            }
        });
        for (Side side : Side.values()) {
            this.visibility[side.ordinal()] = new SimpleDoubleProperty(0.0);
            this.visibility[side.ordinal()].addListener(observable -> ((SidesPane)this.getSkinnable()).requestLayout());
        }
        for (Side side : Side.values()) {
            if (!((SidesPane)this.getSkinnable()).isPinned(side).booleanValue()) continue;
            this.show(side);
        }
        sidesPane.pinnedSideProperty().addListener(change -> {
            for (Side side : Side.values()) {
                if (((SidesPane)this.getSkinnable()).isPinned(side).booleanValue()) {
                    this.show(side);
                    continue;
                }
                this.hide(side);
            }
        });
        Rectangle rectangle = new Rectangle();
        rectangle.setX(0.0);
        rectangle.setY(0.0);
        rectangle.widthProperty().bind((ObservableValue)((SidesPane)this.getSkinnable()).widthProperty());
        rectangle.heightProperty().bind((ObservableValue)((SidesPane)this.getSkinnable()).heightProperty());
        ((SidesPane)this.getSkinnable()).setClip((Node)rectangle);
    }

    private Side getSide(MouseEvent mouseEvent) {
        if (this.borderPane.getBoundsInLocal().contains(mouseEvent.getX(), mouseEvent.getY())) {
            double d2 = ((SidesPane)this.getSkinnable()).getTriggerDistance();
            if (mouseEvent.getX() <= d2 && ((SidesPane)this.getSkinnable()).getLeft() != null) {
                return Side.LEFT;
            }
            if (mouseEvent.getX() > ((SidesPane)this.getSkinnable()).getWidth() - d2 && ((SidesPane)this.getSkinnable()).getRight() != null) {
                return Side.RIGHT;
            }
            if (mouseEvent.getY() <= d2 && ((SidesPane)this.getSkinnable()).getTop() != null) {
                return Side.TOP;
            }
            if (mouseEvent.getY() > ((SidesPane)this.getSkinnable()).getHeight() - d2 && ((SidesPane)this.getSkinnable()).getBottom() != null) {
                return Side.BOTTOM;
            }
        }
        return null;
    }

    private void hide(Side side) {
        boolean bl2;
        if (this.showTimeline[side.ordinal()] != null) {
            this.showTimeline[side.ordinal()].stop();
        }
        if (this.hideTimeline[side.ordinal()] != null && this.hideTimeline[side.ordinal()].getStatus() == Animation.Status.RUNNING) {
            return;
        }
        boolean bl3 = bl2 = this.visibility[side.ordinal()].get() > 0.0;
        if (!bl2) {
            return;
        }
        KeyValue[] keyValueArray = new KeyValue[Side.values().length];
        keyValueArray[side.ordinal()] = new KeyValue((WritableValue)this.visibility[side.ordinal()], (Object)0);
        Duration duration = ((SidesPane)this.getSkinnable()).getAnimationDelay() != null ? ((SidesPane)this.getSkinnable()).getAnimationDelay() : Duration.millis((double)300.0);
        Duration duration2 = ((SidesPane)this.getSkinnable()).getAnimationDuration() != null ? ((SidesPane)this.getSkinnable()).getAnimationDuration() : Duration.millis((double)200.0);
        KeyFrame keyFrame = new KeyFrame(duration2, keyValueArray);
        this.hideTimeline[side.ordinal()] = new Timeline(new KeyFrame[]{keyFrame});
        this.hideTimeline[side.ordinal()].setDelay(duration);
        this.hideTimeline[side.ordinal()].play();
    }

    private boolean isMouseEnabled() {
        return ((SidesPane)this.getSkinnable()).getTriggerDistance() > 0.0;
    }

    private boolean isMouseMovedOutsideSides(MouseEvent mouseEvent) {
        return !(((SidesPane)this.getSkinnable()).getLeft() != null && ((SidesPane)this.getSkinnable()).getLeft().getBoundsInParent().contains(mouseEvent.getX(), mouseEvent.getY()) || ((SidesPane)this.getSkinnable()).getTop() != null && ((SidesPane)this.getSkinnable()).getTop().getBoundsInParent().contains(mouseEvent.getX(), mouseEvent.getY()) || ((SidesPane)this.getSkinnable()).getRight() != null && ((SidesPane)this.getSkinnable()).getRight().getBoundsInParent().contains(mouseEvent.getX(), mouseEvent.getY()) || ((SidesPane)this.getSkinnable()).getBottom() != null && ((SidesPane)this.getSkinnable()).getBottom().getBoundsInParent().contains(mouseEvent.getX(), mouseEvent.getY()));
    }

    protected void layoutChildren(double d2, double d3, double d4, double d5) {
        Node node;
        Node node2;
        double d6;
        Node node3;
        double d7;
        super.layoutChildren(d2, d3, d4, d5);
        Node node4 = ((SidesPane)this.getSkinnable()).getBottom();
        if (node4 != null) {
            double d8 = ((SidesPane)this.getSkinnable()).prefHeightBottomProperty().get();
            if (node4.prefHeight(-1.0) > 0.0) {
                ((SidesPane)this.getSkinnable()).prefHeightBottomProperty().set(Math.max(node4.prefHeight(-1.0), d8));
            }
            d7 = d8 * this.visibility[Side.BOTTOM.ordinal()].get();
            node4.setVisible(this.visibility[Side.BOTTOM.ordinal()].get() > 0.0);
            SidesPaneSkin.setPrefHeight(node4, d7);
        }
        if ((node3 = ((SidesPane)this.getSkinnable()).getLeft()) != null) {
            double d9 = ((SidesPane)this.getSkinnable()).prefWidthLeftProperty().get();
            if (node3.prefWidth(-1.0) > 0.0) {
                ((SidesPane)this.getSkinnable()).prefWidthLeftProperty().set(Math.max(node3.prefWidth(-1.0), d9));
            }
            d6 = d9 * this.visibility[Side.LEFT.ordinal()].get();
            node3.setVisible(this.visibility[Side.LEFT.ordinal()].get() > 0.0);
            SidesPaneSkin.setPrefWidth(node3, d6);
        }
        if ((node2 = ((SidesPane)this.getSkinnable()).getRight()) != null) {
            d7 = ((SidesPane)this.getSkinnable()).prefWidthRightProperty().get();
            if (node2.prefWidth(-1.0) > 0.0) {
                ((SidesPane)this.getSkinnable()).prefWidthRightProperty().set(Math.max(node2.prefWidth(-1.0), d7));
            }
            double d10 = d7 * this.visibility[Side.RIGHT.ordinal()].get();
            node2.setVisible(this.visibility[Side.RIGHT.ordinal()].get() > 0.0);
            SidesPaneSkin.setPrefWidth(node2, d10);
        }
        if ((node = ((SidesPane)this.getSkinnable()).getTop()) != null) {
            d6 = ((SidesPane)this.getSkinnable()).prefHeightTopProperty().get();
            if (node.prefHeight(-1.0) > 0.0) {
                ((SidesPane)this.getSkinnable()).prefHeightTopProperty().set(Math.max(node.prefHeight(-1.0), d6));
            }
            double d11 = d6 * this.visibility[Side.TOP.ordinal()].get();
            node.setVisible(this.visibility[Side.TOP.ordinal()].get() > 0.0);
            node.setClip((Node)new Rectangle(d4, d11));
            SidesPaneSkin.setPrefHeight(node, d11);
        }
    }

    private void show(Side side) {
        if (this.hideTimeline[side.ordinal()] != null) {
            this.hideTimeline[side.ordinal()].stop();
        }
        if (this.showTimeline[side.ordinal()] != null && this.showTimeline[side.ordinal()].getStatus() == Animation.Status.RUNNING) {
            return;
        }
        KeyValue[] keyValueArray = new KeyValue[Side.values().length];
        keyValueArray[side.ordinal()] = new KeyValue((WritableValue)this.visibility[side.ordinal()], (Object)1);
        Duration duration = ((SidesPane)this.getSkinnable()).getAnimationDelay() != null ? ((SidesPane)this.getSkinnable()).getAnimationDelay() : Duration.millis((double)300.0);
        Duration duration2 = ((SidesPane)this.getSkinnable()).getAnimationDuration() != null ? ((SidesPane)this.getSkinnable()).getAnimationDuration() : Duration.millis((double)200.0);
        KeyFrame keyFrame = new KeyFrame(duration2, keyValueArray);
        this.showTimeline[side.ordinal()] = new Timeline(new KeyFrame[]{keyFrame});
        this.showTimeline[side.ordinal()].setDelay(duration);
        this.showTimeline[side.ordinal()].play();
    }

    private void updateBorderPane() {
        this.borderPane.getChildren().clear();
        if (((SidesPane)this.getSkinnable()).getContent() != null) {
            this.borderPane.setCenter(((SidesPane)this.getSkinnable()).getContent());
        }
        if (((SidesPane)this.getSkinnable()).getTop() != null) {
            this.borderPane.setTop(((SidesPane)this.getSkinnable()).getTop());
            ((SidesPane)this.getSkinnable()).getTop().setManaged(true);
            ((SidesPane)this.getSkinnable()).getTop().removeEventFilter(MouseEvent.MOUSE_EXITED, this.exitedHandler);
            ((SidesPane)this.getSkinnable()).getTop().addEventFilter(MouseEvent.MOUSE_EXITED, this.exitedHandler);
        }
        if (((SidesPane)this.getSkinnable()).getRight() != null) {
            this.borderPane.setRight(((SidesPane)this.getSkinnable()).getRight());
            ((SidesPane)this.getSkinnable()).getRight().setManaged(true);
            ((SidesPane)this.getSkinnable()).getRight().removeEventFilter(MouseEvent.MOUSE_EXITED, this.exitedHandler);
            ((SidesPane)this.getSkinnable()).getRight().addEventFilter(MouseEvent.MOUSE_EXITED, this.exitedHandler);
        }
        if (((SidesPane)this.getSkinnable()).getBottom() != null) {
            this.borderPane.setBottom(((SidesPane)this.getSkinnable()).getBottom());
            ((SidesPane)this.getSkinnable()).getBottom().setManaged(true);
            ((SidesPane)this.getSkinnable()).getBottom().removeEventFilter(MouseEvent.MOUSE_EXITED, this.exitedHandler);
            ((SidesPane)this.getSkinnable()).getBottom().addEventFilter(MouseEvent.MOUSE_EXITED, this.exitedHandler);
        }
        if (((SidesPane)this.getSkinnable()).getLeft() != null) {
            this.borderPane.setLeft(((SidesPane)this.getSkinnable()).getLeft());
            ((SidesPane)this.getSkinnable()).getLeft().setManaged(true);
            ((SidesPane)this.getSkinnable()).getLeft().removeEventFilter(MouseEvent.MOUSE_EXITED, this.exitedHandler);
            ((SidesPane)this.getSkinnable()).getLeft().addEventFilter(MouseEvent.MOUSE_EXITED, this.exitedHandler);
        }
    }

    private static void setPrefHeight(Node node, double d2) {
        if (node instanceof Region) {
            ((Region)node).setPrefHeight(d2);
            return;
        }
        if (node instanceof Canvas) {
            ((Canvas)node).setHeight(d2);
            return;
        }
        throw new InvalidParameterException("no prefHeight for class type:" + node.getClass().getCanonicalName());
    }

    private static void setPrefWidth(Node node, double d2) {
        if (node instanceof Region) {
            ((Region)node).setPrefWidth(d2);
            return;
        }
        if (node instanceof Canvas) {
            ((Canvas)node).setWidth(d2);
            return;
        }
        throw new InvalidParameterException("no prefWidth for class type:" + node.getClass().getCanonicalName());
    }
}

