/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.chartfx.ui;

import io.fair_acc.chartfx.utils.SimplePerformanceMeter;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.Tooltip;
import javafx.scene.control.TreeItem;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;
import org.controlsfx.control.BreadCrumbBar;
import org.kordamp.ikonli.javafx.FontIcon;

public class ProfilerInfoBox
extends BreadCrumbBar<VBox> {
    private static final int DEFAULT_DEBUG_UPDATE_RATE = 100;
    private static final double LEVEL_WARNING = 50.0;
    private static final double LEVEL_ERROR = 30.0;
    private static final String FONT_MONO_SPACE = "Monospaced";
    private static final String FONT_AWESOME = "FontAwesome";
    private static final int FONT_SIZE = 9;
    private final FontIcon chevronIcon = new FontIcon("fa-thermometer-quarter:18");
    private final ObjectProperty<DebugLevel> debugLevel = new SimpleObjectProperty((Object)this, "debugLevel", (Object)DebugLevel.NONE);
    private final TreeItem<VBox> treeRoot;

    public ProfilerInfoBox() {
        this(100);
    }

    public ProfilerInfoBox(int n2) {
        SimplePerformanceMeter simplePerformanceMeter = new SimplePerformanceMeter(n2);
        this.setCrumbFactory(treeItem -> new CustomBreadCrumbButton((Node)treeItem.getValue()));
        this.setAutoNavigationEnabled(false);
        Label label = new Label(null, (Node)this.chevronIcon);
        label.setPadding(new Insets(3.0, 0.0, 4.0, 0.0));
        VBox.setVgrow((Node)label, (Priority)Priority.ALWAYS);
        CustomLabel customLabel = new CustomLabel();
        customLabel.setTooltip(new Tooltip("internal JavaFX tick frame-rate (aka. pulse, usually around 60 FPS)"));
        customLabel.textProperty().bind((ObservableValue)simplePerformanceMeter.fxFrameRateProperty().asString("FX %4.1f FPS"));
        CustomLabel customLabel2 = new CustomLabel();
        customLabel2.setTooltip(new Tooltip("(visible) frame update (usually <= 25 FPS"));
        customLabel2.textProperty().bind((ObservableValue)simplePerformanceMeter.actualFrameRateProperty().asString("actual %4.1f FPS"));
        CustomLabel customLabel3 = new CustomLabel();
        customLabel3.setTooltip(new Tooltip("CPU load of this process"));
        customLabel3.textProperty().bind((ObservableValue)simplePerformanceMeter.averageProcessCpuLoadProperty().asString("Process %5.1f %%"));
        CustomLabel customLabel4 = new CustomLabel();
        customLabel4.setTooltip(new Tooltip("CPU system load (100% <-> 1 core fully loaded)"));
        customLabel4.textProperty().bind((ObservableValue)simplePerformanceMeter.systemCpuLoadProperty().asString("System %5.1f %%"));
        simplePerformanceMeter.fxFrameRateProperty().addListener((observableValue, number, number2) -> {
            if (number2.doubleValue() < 30.0) {
                this.chevronIcon.setFill((Paint)Color.RED);
            } else if (number2.doubleValue() < 50.0) {
                this.chevronIcon.setFill((Paint)Color.DARKORANGE);
            } else {
                this.chevronIcon.setFill((Paint)Color.BLACK);
            }
        });
        CustomLabel customLabel5 = new CustomLabel(System.getProperty("java.vm.name") + " " + System.getProperty("java.version"));
        CustomLabel customLabel6 = new CustomLabel("JavaFX: " + System.getProperty("javafx.runtime.version"));
        this.treeRoot = new TreeItem((Object)new VBox(new Node[]{label}));
        ((VBox)this.treeRoot.getValue()).setId("ProfilerInfoBox-treeRoot");
        TreeItem treeItem2 = new TreeItem((Object)new VBox(new Node[]{customLabel, customLabel2}));
        ((VBox)treeItem2.getValue()).setId("ProfilerInfoBox-fpsItem");
        TreeItem treeItem3 = new TreeItem((Object)new VBox(new Node[]{customLabel3, customLabel4, simplePerformanceMeter}));
        ((VBox)treeItem3.getValue()).setId("ProfilerInfoBox-cpuItem");
        TreeItem treeItem4 = new TreeItem((Object)new VBox(new Node[]{customLabel5, customLabel6}));
        ((VBox)treeItem4.getValue()).setId("ProfilerInfoBox-versionItem");
        this.treeRoot.getChildren().add((Object)treeItem2);
        treeItem2.getChildren().add((Object)treeItem3);
        treeItem3.getChildren().add((Object)treeItem4);
        this.setOnCrumbAction(this.updateSelectedCrumbActionListener());
        this.debugLevelProperty().addListener(this.updateSelectedCrumbLevelListener((TreeItem<VBox>)treeItem2, (TreeItem<VBox>)treeItem3, (TreeItem<VBox>)treeItem4));
        this.setSelectedCrumb(this.treeRoot);
    }

    public ObjectProperty<DebugLevel> debugLevelProperty() {
        return this.debugLevel;
    }

    public DebugLevel getDebugLevel() {
        return (DebugLevel)((Object)this.debugLevelProperty().get());
    }

    public TreeItem<VBox> getTreeRoot() {
        return this.treeRoot;
    }

    public ProfilerInfoBox setDebugLevel(DebugLevel debugLevel) {
        this.debugLevelProperty().set((Object)debugLevel);
        return this;
    }

    private EventHandler<BreadCrumbBar.BreadCrumbActionEvent<VBox>> updateSelectedCrumbActionListener() {
        return breadCrumbActionEvent -> {
            if (breadCrumbActionEvent.getSelectedCrumb().equals(this.getSelectedCrumb()) && !breadCrumbActionEvent.getSelectedCrumb().getChildren().isEmpty()) {
                this.setSelectedCrumb((TreeItem)breadCrumbActionEvent.getSelectedCrumb().getChildren().get(0));
            } else {
                this.setSelectedCrumb(breadCrumbActionEvent.getSelectedCrumb());
            }
        };
    }

    private ChangeListener<? super DebugLevel> updateSelectedCrumbLevelListener(TreeItem<VBox> treeItem, TreeItem<VBox> treeItem2, TreeItem<VBox> treeItem3) {
        return (observableValue, debugLevel, debugLevel2) -> {
            switch (debugLevel2) {
                case FRAMES_PER_SECOND: {
                    this.setSelectedCrumb(treeItem);
                    break;
                }
                case CPU_LOAD: {
                    this.setSelectedCrumb(treeItem2);
                    break;
                }
                case VERSION: {
                    this.setSelectedCrumb(treeItem3);
                    break;
                }
                default: {
                    this.setSelectedCrumb(this.treeRoot);
                }
            }
        };
    }

    public static enum DebugLevel {
        NONE,
        FRAMES_PER_SECOND,
        CPU_LOAD,
        VERSION;

    }

    protected static class CustomLabel
    extends Label {
        public CustomLabel() {
            this(null);
        }

        public CustomLabel(String string) {
            super(string);
            this.setPadding(Insets.EMPTY);
            this.setFont(Font.font((String)ProfilerInfoBox.FONT_MONO_SPACE, (double)9.0));
        }
    }

    protected static class CustomBreadCrumbButton
    extends BreadCrumbBar.BreadCrumbButton {
        public CustomBreadCrumbButton(Node node) {
            super(null, node);
            this.setId(node.getId());
            this.setPadding(new Insets(0.0, this.getArrowWidth(), 0.0, this.getArrowWidth()));
        }
    }
}

