/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.chartfx.renderer.spi.hexagon;

import io.fair_acc.chartfx.renderer.spi.hexagon.GridDrawer;
import io.fair_acc.chartfx.renderer.spi.hexagon.GridPosition;
import io.fair_acc.chartfx.renderer.spi.hexagon.Hexagon;
import io.fair_acc.chartfx.renderer.spi.hexagon.HexagonCallback;
import io.fair_acc.chartfx.renderer.spi.hexagon.IHexagonCreator;
import io.fair_acc.chartfx.renderer.spi.hexagon.IPathInfoSupplier;
import io.fair_acc.chartfx.renderer.spi.hexagon.MapGenerator;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javafx.event.EventHandler;
import javafx.scene.Group;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.image.Image;
import javafx.scene.input.MouseEvent;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;

public class HexagonMap {
    public final int hexagonSize;
    public int graphicsXpadding = 0;
    public int graphicsYpadding = 0;
    private MapGenerator mapGenerator;
    public boolean renderCoordinates = false;
    private final GridDrawer gridDrawer = new GridDrawer(this);
    private final Map<GridPosition, Hexagon> hexagons = new HashMap<GridPosition, Hexagon>();
    public List<HexagonCallback> onHexClickedCallback = new LinkedList<HexagonCallback>();
    public List<HexagonCallback> onHexEnteredCallback = new LinkedList<HexagonCallback>();
    public List<HexagonCallback> onHexExitCallback = new LinkedList<HexagonCallback>();

    public HexagonMap(int n2) {
        this.hexagonSize = n2;
    }

    public HexagonMap(int n4, Image image, int n5) {
        this.hexagonSize = n4;
        this.mapGenerator = new MapGenerator(this, image, n5);
        this.mapGenerator.generate((n2, n3, color, hexagonMap) -> {
            Hexagon hexagon = new Hexagon(n2, n3);
            hexagon.setBackgroundColor(color);
            hexagonMap.addHexagon(hexagon);
        });
    }

    public HexagonMap(int n2, Image image, int n3, IHexagonCreator iHexagonCreator) {
        this.hexagonSize = n2;
        this.mapGenerator = new MapGenerator(this, image, n3);
        this.mapGenerator.generate(iHexagonCreator);
    }

    public Hexagon addHexagon(Hexagon hexagon) {
        hexagon.setMap(this);
        this.hexagons.put(hexagon.position, hexagon);
        return hexagon;
    }

    public Collection<Hexagon> getAllHexagons() {
        return this.hexagons.values();
    }

    public int getGraphicsHexagonHeight() {
        return this.hexagonSize * 2;
    }

    private double getGraphicsHexagonWidth() {
        return Math.sqrt(3.0) / 2.0 * (double)this.hexagonSize * 2.0;
    }

    public double getGraphicsHorizontalDistanceBetweenHexagons() {
        return this.getGraphicsHexagonWidth();
    }

    public double getGraphicsverticalDistanceBetweenHexagons() {
        return 0.75 * (double)this.hexagonSize * 2.0;
    }

    public Hexagon getHexagon(GridPosition gridPosition) {
        return this.getHexagon(gridPosition.q, gridPosition.r);
    }

    public Hexagon getHexagon(int n2, int n3) {
        GridPosition gridPosition = new GridPosition(n2, n3);
        Hexagon hexagon = this.hexagons.get(gridPosition);
        return hexagon;
    }

    public Hexagon getHexagonByCube(int n2, int n3, int n4) {
        return this.getHexagon(n2, n4);
    }

    public Hexagon getHexagonContainingPixel(int n2, int n3) {
        return this.getHexagon(GridDrawer.pixelToPosition(n2, n3, this.getGraphicsHexagonHeight(), this.graphicsXpadding, this.graphicsYpadding));
    }

    public Optional<Double> getImageMapHorizontalRelation() {
        return this.mapGenerator == null ? Optional.empty() : this.mapGenerator.getHorizontalRelation();
    }

    public Optional<Double> getImageMapVerticalRelation() {
        return this.mapGenerator == null ? Optional.empty() : this.mapGenerator.getVerticalRelation();
    }

    public double getPaddingX() {
        return this.graphicsXpadding;
    }

    public double getPaddingY() {
        return this.graphicsYpadding;
    }

    public void registerCanvasMouseLiner(final Canvas canvas) {
        canvas.addEventFilter(MouseEvent.MOUSE_MOVED, (EventHandler)new EventHandler<MouseEvent>(){
            private Hexagon oldHexagon = null;

            public void handle(MouseEvent mouseEvent) {
                int n2;
                GraphicsContext graphicsContext = canvas.getGraphicsContext2D();
                int n3 = (int)mouseEvent.getX();
                Hexagon hexagon = HexagonMap.this.getHexagonContainingPixel(n3, n2 = (int)mouseEvent.getY());
                if (hexagon != null) {
                    if (this.oldHexagon != null) {
                        graphicsContext.save();
                        graphicsContext.setFill(this.oldHexagon.getFill());
                        graphicsContext.setStroke(this.oldHexagon.getStroke());
                        this.oldHexagon.drawHexagon(graphicsContext);
                        graphicsContext.restore();
                    }
                } else {
                    if (this.oldHexagon != null) {
                        graphicsContext.save();
                        graphicsContext.setFill(this.oldHexagon.getFill());
                        graphicsContext.setStroke(this.oldHexagon.getStroke());
                        this.oldHexagon.drawHexagon(graphicsContext);
                        graphicsContext.restore();
                    }
                    this.oldHexagon = null;
                    return;
                }
                this.oldHexagon = hexagon;
                graphicsContext.save();
                graphicsContext.setFill((Paint)Color.YELLOW.darker());
                graphicsContext.setStroke(hexagon.getStroke());
                hexagon.drawHexagon(graphicsContext);
                graphicsContext.restore();
            }
        });
    }

    public void removeHexagon(Hexagon hexagon) {
        hexagon.setMap(null);
        this.hexagons.remove(hexagon.position);
    }

    public void render(Canvas canvas) {
        this.gridDrawer.draw(canvas);
    }

    public void render(Group group) {
        this.gridDrawer.draw(group);
    }

    public void renderContour(Canvas canvas) {
        this.gridDrawer.drawContour(canvas);
    }

    public void setOnHexagonClickedCallback(HexagonCallback hexagonCallback) {
        this.onHexClickedCallback.add(hexagonCallback);
    }

    public void setOnHexagonEnteredCallback(HexagonCallback hexagonCallback) {
        this.onHexEnteredCallback.add(hexagonCallback);
    }

    public void setOnHexagonExitCallback(HexagonCallback hexagonCallback) {
        this.onHexExitCallback.add(hexagonCallback);
    }

    public void setPadding(int n2, int n3) {
        this.graphicsXpadding = n2;
        this.graphicsYpadding = n3;
        for (Hexagon hexagon : this.getAllHexagons()) {
            hexagon.getPoints().removeAll((Collection)hexagon.getPoints());
            hexagon.init();
        }
    }

    public void setRenderCoordinates(boolean bl2) {
        this.renderCoordinates = bl2;
    }

    public void setRenderFont(Font font) {
        this.gridDrawer.setFont(font);
    }

    public static enum Direction {
        NORTHWEST,
        NORTHEAST,
        EAST,
        SOUTHEAST,
        SOUTHWEST,
        WEST;

    }

    static class DefaultPathInfoSupplier
    implements IPathInfoSupplier {
        DefaultPathInfoSupplier() {
        }

        @Override
        public int getMovementCost(Hexagon hexagon, Hexagon hexagon2) {
            return 1;
        }

        @Override
        public boolean isBlockingPath(Hexagon hexagon) {
            return hexagon == null || hexagon.isBlockingPath();
        }
    }
}

