/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.chartfx.renderer.spi.hexagon;

import io.fair_acc.chartfx.renderer.spi.hexagon.GridCalculationsHelper;
import io.fair_acc.chartfx.renderer.spi.hexagon.GridPosition;
import io.fair_acc.chartfx.renderer.spi.hexagon.HexagonMap;
import io.fair_acc.chartfx.renderer.spi.hexagon.IPathInfoSupplier;
import io.fair_acc.chartfx.renderer.spi.hexagon.NoPathFoundException;
import java.util.ArrayList;
import java.util.List;
import javafx.application.Platform;
import javafx.collections.ObservableList;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Polygon;
import javafx.scene.text.Text;

public class Hexagon
extends Polygon {
    private static final double[] sinAngle = new double[]{0.5 * Math.sqrt(3.0), 0.5 * Math.sqrt(3.0), 0.0, -0.5 * Math.sqrt(3.0), -0.5 * Math.sqrt(3.0), 0.0, 0.5 * Math.sqrt(3.0)};
    private static final double[] cosAngle = new double[]{0.5, -0.5, -1.0, -0.5, 0.5, 1.0, 0.5};
    public final GridPosition position;
    private HexagonMap map;
    private boolean isVisualObstacle;
    private boolean isBlockingPath;
    public int aStarGscore;
    public int aStarFscore;
    public Hexagon aStarCameFrom;
    private int graphicsXoffset;
    private int graphicsYoffset;

    public Hexagon(int n2, int n3) {
        this.position = new GridPosition(n2, n3);
        this.setStroke((Paint)Color.DARKGRAY);
        this.setFill((Paint)Color.GREY);
    }

    private double[] calculatePolygonPoints() {
        this.checkMap();
        int n2 = this.map.hexagonSize * 2;
        double d2 = Math.sqrt(3.0) / 2.0 * (double)n2;
        this.graphicsXoffset = (int)(d2 * (double)this.position.q + 0.5 * d2 * (double)this.position.r);
        this.graphicsYoffset = (int)(0.75 * (double)n2 * (double)this.position.r);
        this.graphicsXoffset += this.map.graphicsXpadding;
        this.graphicsYoffset += this.map.graphicsYpadding;
        double[] dArray = new double[12];
        for (int i2 = 0; i2 < 6; ++i2) {
            dArray[i2 * 2] = (double)this.graphicsXoffset + (double)this.map.hexagonSize * sinAngle[i2];
            dArray[i2 * 2 + 1] = (double)this.graphicsYoffset + (double)this.map.hexagonSize * cosAngle[i2];
        }
        return dArray;
    }

    private void checkMap() {
        if (this.map == null) {
            throw new IllegalStateException("Hexagon must be added to a HexagonMap before this operation. See addHexagon()");
        }
    }

    public void draw(GraphicsContext graphicsContext) {
        graphicsContext.save();
        graphicsContext.setStroke(this.getStroke());
        graphicsContext.setLineWidth(this.getStrokeWidth());
        graphicsContext.setFill(this.getFill());
        this.drawHexagon(graphicsContext);
        graphicsContext.restore();
    }

    public void drawContour(GraphicsContext graphicsContext) {
        graphicsContext.save();
        graphicsContext.setStroke(this.getStroke());
        graphicsContext.setLineWidth(this.getStrokeWidth());
        graphicsContext.setFill(this.getFill());
        if (this.map == null) {
            this.drawHexagon(graphicsContext, HexagonMap.Direction.values());
            graphicsContext.restore();
        }
        ArrayList<HexagonMap.Direction> arrayList = new ArrayList<HexagonMap.Direction>();
        for (HexagonMap.Direction direction : HexagonMap.Direction.values()) {
            Paint paint;
            Hexagon hexagon = this.getNeighbour(direction);
            if (hexagon == null || (paint = hexagon.getStroke()) == null || this.myColourCompare(paint, this.getStroke(), 0.2)) continue;
            arrayList.add(direction);
        }
        this.drawHexagon(graphicsContext, arrayList.toArray(new HexagonMap.Direction[0]));
        graphicsContext.restore();
    }

    public void drawHexagon(GraphicsContext graphicsContext) {
        ObservableList observableList = this.getPoints();
        int n2 = observableList.size() / 2;
        double[] dArray = new double[n2];
        double[] dArray2 = new double[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            dArray[i2] = 0.5 + (double)Math.round((Double)observableList.get(2 * i2));
            dArray2[i2] = 0.5 + (double)Math.round((Double)observableList.get(2 * i2 + 1));
        }
        graphicsContext.fillPolygon(dArray, dArray2, n2);
        graphicsContext.strokePolygon(dArray, dArray2, n2);
    }

    public void drawHexagon(GraphicsContext graphicsContext, HexagonMap.Direction ... directionArray) {
        ObservableList observableList = this.getPoints();
        int n2 = observableList.size() / 2;
        double[] dArray = new double[n2];
        double[] dArray2 = new double[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            dArray[i2] = 0.5 + (double)Math.round((Double)observableList.get(2 * i2));
            dArray2[i2] = 0.5 + (double)Math.round((Double)observableList.get(2 * i2 + 1));
        }
        graphicsContext.fillPolygon(dArray, dArray2, n2);
        block9: for (HexagonMap.Direction direction : directionArray) {
            switch (direction) {
                case EAST: {
                    graphicsContext.strokeLine(dArray[0], dArray2[0], dArray[1], dArray2[1]);
                    continue block9;
                }
                case NORTHEAST: {
                    graphicsContext.strokeLine(dArray[1], dArray2[1], dArray[2], dArray2[2]);
                    continue block9;
                }
                case NORTHWEST: {
                    graphicsContext.strokeLine(dArray[2], dArray2[2], dArray[3], dArray2[3]);
                    continue block9;
                }
                case WEST: {
                    graphicsContext.strokeLine(dArray[3], dArray2[3], dArray[4], dArray2[4]);
                    continue block9;
                }
                case SOUTHWEST: {
                    graphicsContext.strokeLine(dArray[4], dArray2[4], dArray[5], dArray2[5]);
                    continue block9;
                }
                case SOUTHEAST: {
                    graphicsContext.strokeLine(dArray[5], dArray2[5], dArray[0], dArray2[0]);
                    continue block9;
                }
            }
        }
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!object.getClass().equals(((Object)((Object)this)).getClass())) {
            return false;
        }
        Hexagon hexagon = (Hexagon)((Object)object);
        return hexagon.getQ() == this.getQ() && hexagon.getR() == this.getR();
    }

    public HexagonMap.Direction getDirectionTo(Hexagon hexagon) {
        return this.position.getDirectionTo(hexagon.position);
    }

    public int getDistance(Hexagon hexagon) {
        return this.position.getDistance(hexagon.position);
    }

    public int getGraphicsXoffset() {
        if (this.graphicsXoffset == 0) {
            this.calculatePolygonPoints();
        }
        return this.graphicsXoffset;
    }

    public int getGraphicsYoffset() {
        if (this.graphicsYoffset == 0) {
            this.calculatePolygonPoints();
        }
        return this.graphicsYoffset;
    }

    public List<Hexagon> getHexagonsInRingArea(int n2) {
        this.checkMap();
        return GridCalculationsHelper.getHexagonsInRingArea(this, n2, this.map);
    }

    public List<Hexagon> getHexagonsOnRingEdge(int n2) {
        this.checkMap();
        return GridCalculationsHelper.getHexagonsOnRingEdge(this, n2, this.map);
    }

    public List<Hexagon> getLine(Hexagon hexagon, Hexagon hexagon2) {
        this.checkMap();
        return GridCalculationsHelper.getLine(hexagon.position, hexagon2.position, this.map);
    }

    public Hexagon getNeighbour(HexagonMap.Direction direction) {
        this.checkMap();
        GridPosition gridPosition = this.position.getNeighborPosition(direction);
        return this.map.getHexagon(gridPosition);
    }

    public List<Hexagon> getNeighbours() {
        ArrayList<Hexagon> arrayList = new ArrayList<Hexagon>();
        for (int i2 = 0; i2 < 6; ++i2) {
            Hexagon hexagon = this.getNeighbour(GridPosition.getDirectionFromNumber(i2));
            if (hexagon == null) continue;
            arrayList.add(hexagon);
        }
        return arrayList;
    }

    public List<Hexagon> getPathTo(Hexagon hexagon) throws NoPathFoundException {
        this.checkMap();
        return GridCalculationsHelper.getPathBetween(this, hexagon, new HexagonMap.DefaultPathInfoSupplier());
    }

    public List<Hexagon> getPathTo(Hexagon hexagon, IPathInfoSupplier iPathInfoSupplier) throws NoPathFoundException {
        this.checkMap();
        return GridCalculationsHelper.getPathBetween(this, hexagon, iPathInfoSupplier);
    }

    public int getQ() {
        return this.position.q;
    }

    public int getR() {
        return this.position.r;
    }

    public List<Hexagon> getVisibleHexes(int n2) {
        this.checkMap();
        return GridCalculationsHelper.getVisibleHexes(this, n2, this.map);
    }

    public int hashCode() {
        int n2 = 7;
        n2 = 31 * n2 + this.getQ();
        n2 = 31 * n2 + this.getR();
        return n2;
    }

    public void init() {
        for (double d2 : this.calculatePolygonPoints()) {
            this.getPoints().add((Object)d2);
        }
    }

    public boolean isBlockingPath() {
        return this.isBlockingPath;
    }

    public boolean isVisualObstacle() {
        return this.isVisualObstacle;
    }

    private boolean myColourCompare(Paint paint, Paint paint2, double d2) {
        if (!(paint instanceof Color) || !(paint2 instanceof Color)) {
            return false;
        }
        Color color = (Color)paint;
        Color color2 = (Color)paint2;
        return !(Math.abs(color.getRed() - color2.getRed()) > d2 || Math.abs(color.getGreen() - color2.getGreen()) > d2 || Math.abs(color.getBlue() - color2.getBlue()) > d2 || Math.abs(color.getOpacity() - color2.getOpacity()) > d2);
    }

    public void renderCoordinates(GraphicsContext graphicsContext) {
        Text text = new Text(this.position.getCoordinates());
        if (this.map != null) {
            // empty if block
        }
        double d2 = text.getBoundsInLocal().getWidth();
        double d3 = text.getBoundsInLocal().getHeight();
        double d4 = (double)this.getGraphicsXoffset() - d2 / 2.0;
        double d5 = (double)this.getGraphicsYoffset() + d3 / 4.0;
        text.setX(d4);
        text.setY(d5);
        graphicsContext.strokeText(this.position.getCoordinates(), d4, d5);
    }

    public void setBackgroundColor(Color color) {
        Platform.runLater((Runnable)new UIupdater(this, color));
    }

    public void setIsBlockingPath(boolean bl2) {
        this.isBlockingPath = bl2;
    }

    public void setIsVisualObstacle(boolean bl2) {
        this.isVisualObstacle = bl2;
    }

    public void setMap(HexagonMap hexagonMap) {
        this.map = hexagonMap;
        if (hexagonMap != null) {
            this.init();
        }
    }

    public String toString() {
        return "Hexagon q:" + this.position.q + " r:" + this.position.r;
    }

    static class UIupdater
    implements Runnable {
        private final Hexagon h;
        private final Color c;

        UIupdater(Hexagon hexagon, Color color) {
            this.h = hexagon;
            this.c = color;
        }

        @Override
        public void run() {
            this.h.setFill((Paint)this.c);
        }
    }
}

